/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.remote.RemoteKeyIdMode;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfigMultiTenantUtils;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;

public class RemoteStoreConfig
extends ExternalResourceConfig {
    private String storeName;
    private String storeLabel;
    private String tokenPolicy;
    private String baseUrl;
    private String baseUrlFaultCheck;
    private boolean multitenant;
    private String baseUrlMultitenantDefaultString;
    private String baseUrlMultitenantPlaceholder;
    private String baseUrlMultitenantTenantString;
    private RemoteKeyIdMode idMode;
    private String parameterName;
    private String keyAlgorithm = "RSA";
    private String responseJsonPath;
    private String responseJsonPathFaultCheck;
    private Map<String, String> metadati = new HashMap<String, String>();

    public RemoteStoreConfig(String storeName) {
        this.storeName = storeName;
        this.storeLabel = storeName;
    }

    public RemoteStoreConfig newInstanceMultitenant(String tenant) throws UtilsException {
        if (!this.multitenant) {
            throw new UtilsException("Multi-tenant disabled");
        }
        RemoteStoreConfig cloned = new RemoteStoreConfig(this.storeName);
        cloned.storeLabel = this.storeLabel != null ? this.storeLabel : this.storeName;
        cloned.tokenPolicy = this.tokenPolicy != null ? this.tokenPolicy : null;
        String string = cloned.baseUrl = this.baseUrl != null ? this.baseUrl : null;
        if (cloned.baseUrl != null && this.baseUrlMultitenantDefaultString != null && this.baseUrlMultitenantPlaceholder != null && this.baseUrlMultitenantTenantString != null) {
            String newString = this.baseUrlMultitenantTenantString.replace(this.baseUrlMultitenantPlaceholder, tenant);
            cloned.baseUrl = cloned.baseUrl.replace(this.baseUrlMultitenantDefaultString, newString);
        } else {
            cloned.baseUrl = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantBaseUrl, tenant, cloned.baseUrl);
        }
        cloned.baseUrlFaultCheck = this.baseUrlFaultCheck != null ? this.baseUrlFaultCheck : null;
        cloned.baseUrlFaultCheck = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantBaseUrlFaultCheck, tenant, cloned.baseUrlFaultCheck);
        cloned.metadati = RemoteStoreConfigMultiTenantUtils.newMapInstance(this.metadati);
        cloned.metadati = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantMetadati, tenant, cloned.metadati);
        cloned.idMode = this.idMode;
        cloned.parameterName = this.parameterName != null ? this.parameterName : null;
        cloned.keyAlgorithm = this.keyAlgorithm != null ? this.keyAlgorithm : "RSA";
        this.newInstanceMultitenant(cloned, tenant);
        return cloned;
    }

    private void newInstanceMultitenant(RemoteStoreConfig cloned, String tenant) {
        cloned.readTimeout = this.readTimeout;
        cloned.connectTimeout = this.connectTimeout;
        if (this.returnCode != null) {
            cloned.returnCode = new ArrayList();
            for (Integer intValue : this.returnCode) {
                if (intValue == null) continue;
                cloned.returnCode.add(intValue);
            }
        }
        cloned.basicUsername = this.basicUsername != null ? this.basicUsername : null;
        cloned.basicPassword = this.basicPassword != null ? this.basicPassword : null;
        cloned.hostnameVerifier = this.hostnameVerifier;
        cloned.trustAllCerts = this.trustAllCerts;
        cloned.trustStore = this.trustStore;
        cloned.crlStore = this.crlStore;
        cloned.keyStore = this.keyStore;
        cloned.keyAlias = this.keyAlias != null ? this.keyAlias : null;
        cloned.keyPassword = this.keyPassword != null ? this.keyPassword : null;
        cloned.forwardProxyUrl = this.forwardProxyUrl != null ? this.forwardProxyUrl : null;
        cloned.forwardProxyHeader = this.forwardProxyHeader != null ? this.forwardProxyHeader : null;
        cloned.forwardProxyQueryParameter = this.forwardProxyQueryParameter != null ? this.forwardProxyQueryParameter : null;
        cloned.forwardProxyBase64 = this.forwardProxyBase64;
        cloned.headers = RemoteStoreConfigMultiTenantUtils.newMapInstance(this.headers);
        cloned.queryParameters = RemoteStoreConfigMultiTenantUtils.newMapInstance(this.queryParameters);
        cloned.basicUsername = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantBasicUsername, tenant, cloned.basicUsername);
        cloned.basicPassword = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantBasicPassword, tenant, cloned.basicPassword);
        cloned.headers = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantHeaders, tenant, cloned.headers);
        cloned.queryParameters = RemoteStoreConfigMultiTenantUtils.getMultitenant(this.multiTenantQueryParameters, tenant, cloned.queryParameters);
        cloned.multitenant = true;
        cloned.httpLibrary = this.httpLibrary;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getStoreLabel() {
        return this.storeLabel;
    }

    public void setStoreLabel(String storeLabel) {
        this.storeLabel = storeLabel;
    }

    public String getTokenPolicy() {
        return this.tokenPolicy;
    }

    public void setTokenPolicy(String tokenPolicy) {
        this.tokenPolicy = tokenPolicy;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public RemoteKeyIdMode getIdMode() {
        return this.idMode;
    }

    public void setIdMode(RemoteKeyIdMode idMode) {
        this.idMode = idMode;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public boolean isMultitenant() {
        return this.multitenant;
    }

    public void setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
    }

    public String getBaseUrlMultitenantDefaultString() {
        return this.baseUrlMultitenantDefaultString;
    }

    public void setBaseUrlMultitenantDefaultString(String baseUrlMultitenantDefaultString) {
        this.baseUrlMultitenantDefaultString = baseUrlMultitenantDefaultString;
    }

    public String getBaseUrlMultitenantPlaceholder() {
        return this.baseUrlMultitenantPlaceholder;
    }

    public void setBaseUrlMultitenantPlaceholder(String baseUrlMultitenantPlaceholder) {
        this.baseUrlMultitenantPlaceholder = baseUrlMultitenantPlaceholder;
    }

    public String getBaseUrlMultitenantTenantString() {
        return this.baseUrlMultitenantTenantString;
    }

    public void setBaseUrlMultitenantTenantString(String baseUrlMultitenantTenantString) {
        this.baseUrlMultitenantTenantString = baseUrlMultitenantTenantString;
    }

    public String getBaseUrlFaultCheck() {
        return this.baseUrlFaultCheck;
    }

    public void setBaseUrlFaultCheck(String baseUrlFaultCheck) {
        this.baseUrlFaultCheck = baseUrlFaultCheck;
    }

    public String getResponseJsonPath() {
        return this.responseJsonPath;
    }

    public void setResponseJsonPath(String responseJsonPath) {
        this.responseJsonPath = responseJsonPath;
    }

    public String getResponseJsonPathFaultCheck() {
        return this.responseJsonPathFaultCheck;
    }

    public void setResponseJsonPathFaultCheck(String responseJsonPathFaultCheck) {
        this.responseJsonPathFaultCheck = responseJsonPathFaultCheck;
    }

    public Map<String, String> getMetadati() {
        return this.metadati;
    }

    public void setMetadati(Map<String, String> metadati) {
        this.metadati = metadati;
    }
}

