/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.test;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyUtils;
import org.openspcoop2.utils.certificate.PEMArchive;
import org.openspcoop2.utils.certificate.test.KeystoreTest;

public class PrivatePublicKeyTest {
    private static final String RSA = "RSA";
    private static final String EC = "EC";
    private static final String ECDSA = "ECDSA";
    private static final String RSASSA_PSS = "RSASSA-PSS";
    private static final String PKCS8 = "PKCS#8";
    private static final String X509 = "X.509";
    private static final String PASSWORD = "123456";
    private static final String PRIVATE_KEY_NON_LETTA = "PrivateKey non letta";
    private static final String PUBLIC_KEY_NON_LETTA = "PublicKey non letta";
    private static final String COMPARE_PRIVATE_KEY = " -- compare con getPrivateKey";
    private static final String COMPARE_PEM_ARCHIVE = " -- compare con PEMArchive";

    public static void main(String[] args) throws Exception {
        PrivatePublicKeyTest.testPrivateKeyPkcs1PEM();
        PrivatePublicKeyTest.testPrivateKeyPkcs1DER();
        PrivatePublicKeyTest.testPrivateKeyPkcs1EncryptedPEM();
        PrivatePublicKeyTest.testPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testPrivateKeyPkcs8DER();
        PrivatePublicKeyTest.testPrivateKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testPrivateKeyPkcs8EncryptedDER();
        PrivatePublicKeyTest.testPublicKeyPEM();
        PrivatePublicKeyTest.testPublicKeyDER();
        PrivatePublicKeyTest.testCertificatePEM();
        PrivatePublicKeyTest.testCertificateDER();
        PrivatePublicKeyTest.testPrivatePublicKeyPkcs1PEM();
        PrivatePublicKeyTest.testPublicPrivateKeyPkcs1PEM();
        PrivatePublicKeyTest.testPrivatePublicKeyPkcs1EncryptedPEM();
        PrivatePublicKeyTest.testPublicPrivateKeyPkcs1EncryptedPEM();
        PrivatePublicKeyTest.testPrivatePublicKeyPkcs8PEM();
        PrivatePublicKeyTest.testPublicPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testPrivatePublicKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testPublicPrivateKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testPrivateCertificatePkcs1PEM();
        PrivatePublicKeyTest.testCertificatePrivateKeyPkcs1PEM();
        PrivatePublicKeyTest.testPrivateCertificatesPkcs8PEM();
        PrivatePublicKeyTest.testCertificatesPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testEcPrivateKeySec1PEM();
        PrivatePublicKeyTest.testEcPrivateKeySec1DER();
        PrivatePublicKeyTest.testEcPrivateKeySec1EncryptedPEM();
        PrivatePublicKeyTest.testEcPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testEcPrivateKeyPkcs8DER();
        PrivatePublicKeyTest.testEcPrivateKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testEcPrivateKeyPkcs8EncryptedDER();
        PrivatePublicKeyTest.testEcPublicKeyPEM();
        PrivatePublicKeyTest.testEcPublicKeyDER();
        PrivatePublicKeyTest.testEcPrivatePublicKeySec1PEM();
        PrivatePublicKeyTest.testEcPublicPrivateKeySec1PEM();
        PrivatePublicKeyTest.testEcPrivatePublicKeySec1EncryptedPEM();
        PrivatePublicKeyTest.testEcPublicPrivateKeySec1EncryptedPEM();
        PrivatePublicKeyTest.testEcPrivatePublicKeyPkcs8PEM();
        PrivatePublicKeyTest.testEcPublicPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testEcPrivatePublicKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testEcPublicPrivateKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testRsaPssPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testRsaPssPrivateKeyPkcs8DER();
        PrivatePublicKeyTest.testRsaPssPrivateKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testRsaPssPrivateKeyPkcs8EncryptedDER();
        PrivatePublicKeyTest.testRsaPssPublicKeyPEM();
        PrivatePublicKeyTest.testRsaPssPublicKeyDER();
        PrivatePublicKeyTest.testRsaPssPrivatePublicKeyPkcs8PEM();
        PrivatePublicKeyTest.testRsaPssPublicPrivateKeyPkcs8PEM();
        PrivatePublicKeyTest.testRsaPssPrivatePublicKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.testRsaPssPublicPrivateKeyPkcs8EncryptedPEM();
        PrivatePublicKeyTest.print("\n\nTestsuite finita");
    }

    private static void initBC() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
    }

    private static void releaseBC() {
        Security.removeProvider("BC");
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    private static void check(String atteso, String trovato) throws UtilsException {
        if (!atteso.equals(trovato)) {
            throw new UtilsException("Atteso algoritmo '" + atteso + "', trovato '" + trovato + "'");
        }
    }

    private static void checkEc(String trovato) throws UtilsException {
        if (!EC.equals(trovato) && !ECDSA.equals(trovato)) {
            throw new UtilsException("Atteso algoritmo 'EC' o 'ECDSA', trovato '" + trovato + "'");
        }
    }

    private static void checkPrivateKey(PrivateKey pKey, PrivateKey pKey2, boolean debug) throws UtilsException {
        if (!pKey.equals(pKey2)) {
            throw new UtilsException("PrivateKey lette differenti");
        }
        if (!Arrays.equals(pKey.getEncoded(), pKey2.getEncoded())) {
            PrivatePublicKeyTest.print("P1: " + new String(pKey.getEncoded()));
            PrivatePublicKeyTest.print("P2: " + new String(pKey2.getEncoded()));
            throw new UtilsException("PrivateKey lette differenti (encoded)");
        }
        if (!pKey.getFormat().equals(pKey2.getFormat())) {
            throw new UtilsException("PrivateKey lette differenti (format)");
        }
        if (!pKey.getAlgorithm().equals(pKey2.getAlgorithm())) {
            throw new UtilsException("PrivateKey lette differenti (algorithm)");
        }
        if (debug) {
            PrivatePublicKeyTest.print("Read chiave privata con algoritmo '" + pKey.getAlgorithm() + "'");
        }
    }

    private static void checkPrivateKey(PrivateKey pKey, byte[] privateKey, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, null, pem);
    }

    private static void checkPrivateKey(PrivateKey pKey, byte[] privateKey, String password, boolean pem) throws UtilsException {
        PEMArchive pemArchive;
        PrivateKey pKeyConPassword2;
        PrivatePublicKeyTest.print(COMPARE_PRIVATE_KEY);
        if (pKey == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSA, pKey.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKey.getFormat());
        if (password == null) {
            PrivateKey pKey2 = KeyUtils.getInstance().getPrivateKey(privateKey);
            if (pKey2 == null) {
                throw new UtilsException(PRIVATE_KEY_NON_LETTA);
            }
            PrivatePublicKeyTest.check(RSA, pKey2.getAlgorithm());
            PrivatePublicKeyTest.check(PKCS8, pKey2.getFormat());
            PrivatePublicKeyTest.checkPrivateKey(pKey, pKey2, false);
        }
        if ((pKeyConPassword2 = KeyUtils.getInstance().getPrivateKey(privateKey, password)) == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSA, pKeyConPassword2.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKeyConPassword2.getFormat());
        PrivatePublicKeyTest.checkPrivateKey(pKey, pKeyConPassword2, true);
        if (!pem) {
            return;
        }
        PrivatePublicKeyTest.print(COMPARE_PEM_ARCHIVE);
        if (password == null) {
            pemArchive = new PEMArchive(privateKey);
            PrivateKey pKey2 = pemArchive.getPrivateKey();
            if (pKey2 == null) {
                throw new UtilsException(PRIVATE_KEY_NON_LETTA);
            }
            PrivatePublicKeyTest.check(RSA, pKey2.getAlgorithm());
            PrivatePublicKeyTest.check(PKCS8, pKey2.getFormat());
            PrivatePublicKeyTest.checkPrivateKey(pKey, pKey2, false);
        }
        if ((pKeyConPassword2 = (pemArchive = new PEMArchive(privateKey, password)).getPrivateKey()) == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSA, pKeyConPassword2.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKeyConPassword2.getFormat());
        PrivatePublicKeyTest.checkPrivateKey(pKey, pKeyConPassword2, true);
    }

    private static void checkPublicKey(PublicKey pKey, byte[] publicKey, boolean pem, boolean certificate) throws UtilsException {
        PrivatePublicKeyTest.checkPublicKey(pKey, publicKey, null, pem, certificate);
    }

    private static void checkPublicKey(PublicKey pKey, byte[] publicKey, String password, boolean pem, boolean certificate) throws UtilsException {
        PrivatePublicKeyTest.print(COMPARE_PRIVATE_KEY);
        if (pKey == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSA, pKey.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey.getFormat());
        PublicKey pKey2 = KeyUtils.getInstance().getPublicKey(publicKey);
        if (pKey2 == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSA, pKey2.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey2.getFormat());
        PrivatePublicKeyTest.checkPublicKey(pKey, pKey2, true);
        if (!pem) {
            return;
        }
        PrivatePublicKeyTest.print(COMPARE_PEM_ARCHIVE);
        PEMArchive pemArchive = password == null ? new PEMArchive(new String(publicKey)) : new PEMArchive(new String(publicKey), password);
        pKey2 = certificate ? pemArchive.getCertificates().get(0).getCertificate().getPublicKey() : pemArchive.getPublicKey();
        if (pKey2 == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSA, pKey2.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey2.getFormat());
        PrivatePublicKeyTest.checkPublicKey(pKey, pKey2, true);
    }

    private static void checkPublicKey(PublicKey pKey, PublicKey pKey2, boolean debug) throws UtilsException {
        if (!pKey.equals(pKey2)) {
            throw new UtilsException("PrivateKey lette differenti");
        }
        if (!Arrays.equals(pKey.getEncoded(), pKey2.getEncoded())) {
            PrivatePublicKeyTest.print("P1: " + new String(pKey.getEncoded()));
            PrivatePublicKeyTest.print("P2: " + new String(pKey2.getEncoded()));
            throw new UtilsException("PrivateKey lette differenti (encoded)");
        }
        if (!pKey.getFormat().equals(pKey2.getFormat())) {
            throw new UtilsException("PrivateKey lette differenti (format)");
        }
        if (!pKey.getAlgorithm().equals(pKey2.getAlgorithm())) {
            throw new UtilsException("PrivateKey lette differenti (algorithm)");
        }
        if (debug) {
            PrivatePublicKeyTest.print("Read chiave pubblica con algoritmo '" + pKey.getAlgorithm() + "'");
        }
    }

    private static void checkPrivateKeyEc(PrivateKey pKey, byte[] privateKey, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, null, pem);
    }

    private static void checkPrivateKeyEc(PrivateKey pKey, byte[] privateKey, String password, boolean pem) throws UtilsException {
        PEMArchive pemArchive;
        PrivateKey pKeyConPassword2;
        PrivatePublicKeyTest.print(COMPARE_PRIVATE_KEY);
        if (pKey == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.checkEc(pKey.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKey.getFormat());
        if (password == null) {
            PrivateKey pKey2 = KeyUtils.getInstance(EC).getPrivateKey(privateKey);
            if (pKey2 == null) {
                throw new UtilsException(PRIVATE_KEY_NON_LETTA);
            }
            PrivatePublicKeyTest.checkEc(pKey2.getAlgorithm());
            PrivatePublicKeyTest.check(PKCS8, pKey2.getFormat());
            PrivatePublicKeyTest.checkPrivateKey(pKey, pKey2, false);
        }
        if ((pKeyConPassword2 = KeyUtils.getInstance(EC).getPrivateKey(privateKey, password)) == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.checkEc(pKeyConPassword2.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKeyConPassword2.getFormat());
        PrivatePublicKeyTest.checkPrivateKey(pKey, pKeyConPassword2, true);
        if (!pem) {
            return;
        }
        PrivatePublicKeyTest.print(COMPARE_PEM_ARCHIVE);
        if (password == null) {
            pemArchive = new PEMArchive(privateKey, EC, null);
            PrivateKey pKey2 = pemArchive.getPrivateKey();
            if (pKey2 == null) {
                throw new UtilsException(PRIVATE_KEY_NON_LETTA);
            }
            PrivatePublicKeyTest.checkEc(pKey2.getAlgorithm());
            PrivatePublicKeyTest.check(PKCS8, pKey2.getFormat());
            PrivatePublicKeyTest.checkPrivateKey(pKey, pKey2, false);
        }
        if ((pKeyConPassword2 = (pemArchive = new PEMArchive(privateKey, EC, password)).getPrivateKey()) == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.checkEc(pKeyConPassword2.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKeyConPassword2.getFormat());
        PrivatePublicKeyTest.checkPrivateKey(pKey, pKeyConPassword2, true);
    }

    private static void checkPublicKeyEc(PublicKey pKey, byte[] publicKey, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.checkPublicKeyEc(pKey, publicKey, null, pem);
    }

    private static void checkPublicKeyEc(PublicKey pKey, byte[] publicKey, String password, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.print(" -- compare con getPublicKey");
        if (pKey == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.checkEc(pKey.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey.getFormat());
        PublicKey pKey2 = KeyUtils.getInstance(EC).getPublicKey(publicKey);
        if (pKey2 == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.checkEc(pKey2.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey2.getFormat());
        PrivatePublicKeyTest.checkPublicKey(pKey, pKey2, true);
        if (!pem) {
            return;
        }
        PrivatePublicKeyTest.print(COMPARE_PEM_ARCHIVE);
        PEMArchive pemArchive = new PEMArchive(new String(publicKey), EC, password);
        pKey2 = pemArchive.getPublicKey();
        if (pKey2 == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.checkEc(pKey2.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey2.getFormat());
        PrivatePublicKeyTest.checkPublicKey(pKey, pKey2, true);
    }

    private static void checkPrivateKeyRsaPss(PrivateKey pKey, byte[] privateKey, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.checkPrivateKeyRsaPss(pKey, privateKey, null, pem);
    }

    private static void checkPrivateKeyRsaPss(PrivateKey pKey, byte[] privateKey, String password, boolean pem) throws UtilsException {
        PEMArchive pemArchive;
        PrivateKey pKeyConPassword2;
        PrivatePublicKeyTest.print(COMPARE_PRIVATE_KEY);
        if (pKey == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSASSA_PSS, pKey.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKey.getFormat());
        if (password == null) {
            PrivateKey pKey2 = KeyUtils.getInstance(RSASSA_PSS).getPrivateKey(privateKey);
            if (pKey2 == null) {
                throw new UtilsException(PRIVATE_KEY_NON_LETTA);
            }
            PrivatePublicKeyTest.check(RSASSA_PSS, pKey2.getAlgorithm());
            PrivatePublicKeyTest.check(PKCS8, pKey2.getFormat());
            PrivatePublicKeyTest.checkPrivateKey(pKey, pKey2, false);
        }
        if ((pKeyConPassword2 = KeyUtils.getInstance(RSASSA_PSS).getPrivateKey(privateKey, password)) == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSASSA_PSS, pKeyConPassword2.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKeyConPassword2.getFormat());
        PrivatePublicKeyTest.checkPrivateKey(pKey, pKeyConPassword2, true);
        if (!pem) {
            return;
        }
        PrivatePublicKeyTest.print(COMPARE_PEM_ARCHIVE);
        if (password == null) {
            pemArchive = new PEMArchive(privateKey);
            PrivateKey pKey2 = pemArchive.getPrivateKey();
            if (pKey2 == null) {
                throw new UtilsException(PRIVATE_KEY_NON_LETTA);
            }
            PrivatePublicKeyTest.check(RSASSA_PSS, pKey2.getAlgorithm());
            PrivatePublicKeyTest.check(PKCS8, pKey2.getFormat());
            PrivatePublicKeyTest.checkPrivateKey(pKey, pKey2, false);
        }
        if ((pKeyConPassword2 = (pemArchive = new PEMArchive(privateKey, password)).getPrivateKey()) == null) {
            throw new UtilsException(PRIVATE_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSASSA_PSS, pKeyConPassword2.getAlgorithm());
        PrivatePublicKeyTest.check(PKCS8, pKeyConPassword2.getFormat());
        PrivatePublicKeyTest.checkPrivateKey(pKey, pKeyConPassword2, true);
    }

    private static void checkPublicKeyRsaPss(PublicKey pKey, byte[] publicKey, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.checkPublicKeyRsaPss(pKey, publicKey, null, pem);
    }

    private static void checkPublicKeyRsaPss(PublicKey pKey, byte[] publicKey, String password, boolean pem) throws UtilsException {
        PrivatePublicKeyTest.print(" -- compare con getPublicKey");
        if (pKey == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSASSA_PSS, pKey.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey.getFormat());
        PublicKey pKey2 = KeyUtils.getInstance(RSASSA_PSS).getPublicKey(publicKey);
        if (pKey2 == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSASSA_PSS, pKey2.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey2.getFormat());
        PrivatePublicKeyTest.checkPublicKey(pKey, pKey2, true);
        if (!pem) {
            return;
        }
        PrivatePublicKeyTest.print(COMPARE_PEM_ARCHIVE);
        PEMArchive pemArchive = password == null ? new PEMArchive(new String(publicKey)) : new PEMArchive(new String(publicKey), password);
        pKey2 = pemArchive.getPublicKey();
        if (pKey2 == null) {
            throw new UtilsException(PUBLIC_KEY_NON_LETTA);
        }
        PrivatePublicKeyTest.check(RSASSA_PSS, pKey2.getAlgorithm());
        PrivatePublicKeyTest.check(X509, pKey2.getFormat());
        PrivatePublicKeyTest.checkPublicKey(pKey, pKey2, true);
    }

    public static void testPrivateKeyPkcs1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS1PrivateKeyPEMFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateKeyPkcs1DER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs1 DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS8PrivateKeyDERFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateKeyPkcs1EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs1 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1_encrypted.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS1EncryptedPrivateKeyPEMFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS8PrivateKeyPEMFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateKeyPkcs8DER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs8 DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS8PrivateKeyDERFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8_encrypted.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS8EncryptedPrivateKeyPEMFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateKeyPkcs8EncryptedDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key pkcs8 encrypted DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8_encrypted.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance().readPKCS8EncryptedPrivateKeyDERFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(pKey, privateKey, PASSWORD, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPublicKeyPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= public key PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.publicKey.pem"));
            PublicKey pKey = KeyUtils.getInstance().readPublicKeyPEMFormat(publicKey);
            PrivatePublicKeyTest.checkPublicKey(pKey, publicKey, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPublicKeyDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= public key DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.publicKey.der"));
            PublicKey pKey = KeyUtils.getInstance().readPublicKeyDERFormat(publicKey);
            PrivatePublicKeyTest.checkPublicKey(pKey, publicKey, false, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testCertificatePEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= certificate PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/govway_test.pem"));
            PublicKey pKey = KeyUtils.getInstance().readCertificate(publicKey);
            PrivatePublicKeyTest.checkPublicKey(pKey, publicKey, true, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testCertificateDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= certificate DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/govway_test.cer"));
            PublicKey pKey = KeyUtils.getInstance().readCertificate(publicKey);
            PrivatePublicKeyTest.checkPublicKey(pKey, publicKey, false, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivatePublicKeyPkcs1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private public key pkcs1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS1PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPublicPrivateKeyPkcs1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= public private key pkcs1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS1PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivatePublicKeyPkcs1EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private public key pkcs1 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1_encrypted.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS1EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, PASSWORD, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPublicPrivateKeyPkcs1EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= public private key pkcs1 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1_encrypted.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS1EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, PASSWORD, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivatePublicKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private public key pkcs8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPublicPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= public private key pkcs8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivatePublicKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private public key pkcs8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8_encrypted.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS8EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, PASSWORD, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPublicPrivateKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= public private key pkcs8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8_encrypted.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS8EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance().readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, PASSWORD, true, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateCertificatePkcs1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key e certificate pkcs1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1.privateCertificate.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS1PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readCertificate(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testCertificatePrivateKeyPkcs1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= certificate e private key pkcs1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs1.certificatePrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS1PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readCertificate(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testPrivateCertificatesPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= private key e certificates pkcs8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8.privateCertificates.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readCertificate(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testCertificatesPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= certificates e private key pkcs8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsa.pkcs8.certificatesPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance().readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKey(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance().readCertificate(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKey(publicKey, privatePublicKey, true, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeySec1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key SEC1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readPKCS1PrivateKeyPEMFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeySec1DER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key SEC1 DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readSEC1PrivateKeyDERFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeySec1EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key SEC1 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1_encrypted.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readPKCS1EncryptedPrivateKeyPEMFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key PKCS8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readPKCS8PrivateKeyPEMFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeyPkcs8DER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key PKCS8 DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readPKCS8PrivateKeyDERFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key PKCS8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8_encrypted.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readPKCS8EncryptedPrivateKeyPEMFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivateKeyPkcs8EncryptedDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private key PKCS8 encrypted DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8_encrypted.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance(EC).readPKCS8EncryptedPrivateKeyDERFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(pKey, privateKey, PASSWORD, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPublicKeyPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC public key PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.publicKey.pem"));
            PublicKey pKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(publicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(pKey, publicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPublicKeyDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC public key DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.publicKey.der"));
            PublicKey pKey = KeyUtils.getInstance(EC).readPublicKeyDERFormat(publicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(pKey, publicKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivatePublicKeySec1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private public key SEC1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS1PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPublicPrivateKeySec1PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC public private key SEC1 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS1PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivatePublicKeySec1EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private public key SEC1 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1_encrypted.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS1EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPublicPrivateKeySec1EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC public private key SEC1 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.sec1_encrypted.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS1EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivatePublicKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private public key PKCS8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPublicPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC public private key PKCS8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPrivatePublicKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC private public key PKCS8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8_encrypted.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS8EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testEcPublicPrivateKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= EC public private key PKCS8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.ec.pkcs8_encrypted.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(EC).readPKCS8EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyEc(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance(EC).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyEc(publicKey, privatePublicKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS private key PKCS8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8PrivateKeyPEMFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(pKey, privateKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPrivateKeyPkcs8DER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS private key PKCS8 DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8PrivateKeyDERFormat(privateKey);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(pKey, privateKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPrivateKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS private key PKCS8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8_encrypted.privateKey.pem"));
            PrivateKey pKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8EncryptedPrivateKeyPEMFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(pKey, privateKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPrivateKeyPkcs8EncryptedDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS private key PKCS8 encrypted DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privateKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8_encrypted.privateKey.der"));
            PrivateKey pKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8EncryptedPrivateKeyDERFormat(privateKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(pKey, privateKey, PASSWORD, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPublicKeyPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS public key PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.publicKey.pem"));
            PublicKey pKey = KeyUtils.getInstance(RSASSA_PSS).readPublicKeyPEMFormat(publicKey);
            PrivatePublicKeyTest.checkPublicKeyRsaPss(pKey, publicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPublicKeyDER() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS public key DER ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] publicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.publicKey.der"));
            PublicKey pKey = KeyUtils.getInstance(RSASSA_PSS).readPublicKeyDERFormat(publicKey);
            PrivatePublicKeyTest.checkPublicKeyRsaPss(pKey, publicKey, false);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPrivatePublicKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS private public key PKCS8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance(RSASSA_PSS).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyRsaPss(publicKey, privatePublicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPublicPrivateKeyPkcs8PEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS public private key PKCS8 PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8PrivateKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(privateKey, privatePublicKey, true);
            PublicKey publicKey = KeyUtils.getInstance(RSASSA_PSS).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyRsaPss(publicKey, privatePublicKey, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPrivatePublicKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS private public key PKCS8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8_encrypted.privatePublicKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance(RSASSA_PSS).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyRsaPss(publicKey, privatePublicKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }

    public static void testRsaPssPublicPrivateKeyPkcs8EncryptedPEM() throws UtilsException {
        PrivatePublicKeyTest.print("========================= RSA-PSS public private key PKCS8 encrypted PEM ==============================");
        PrivatePublicKeyTest.initBC();
        try {
            byte[] privatePublicKey = Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/client-test.rsapss.pkcs8_encrypted.publicPrivateKey.pem"));
            PrivateKey privateKey = KeyUtils.getInstance(RSASSA_PSS).readPKCS8EncryptedPrivateKeyPEMFormat(privatePublicKey, PASSWORD);
            PrivatePublicKeyTest.checkPrivateKeyRsaPss(privateKey, privatePublicKey, PASSWORD, true);
            PublicKey publicKey = KeyUtils.getInstance(RSASSA_PSS).readPublicKeyPEMFormat(privatePublicKey);
            PrivatePublicKeyTest.checkPublicKeyRsaPss(publicKey, privatePublicKey, PASSWORD, true);
        }
        finally {
            PrivatePublicKeyTest.releaseBC();
        }
    }
}

