/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt.test;

import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.OldMD5Crypt;

public class OldMD5Test {
    public static void main(String[] args) throws Exception {
        OldMD5Test.test();
    }

    public static void test() throws Exception {
        String passwordEncrypted;
        OldMD5Crypt passwordEngine = CryptFactory.getOldMD5Crypt();
        boolean verifica = passwordEngine.check("123456", passwordEncrypted = "$1$il$SPDpFtwmXna8U/e.t9IuP.");
        if (!verifica) {
            throw new Exception("Verifica password di default fallita");
        }
        verifica = passwordEngine.check("1234567", passwordEncrypted);
        if (verifica) {
            throw new Exception("Attesa verifica fallita per password di default");
        }
        passwordEncrypted = "$1$4hG9hTWx$getysg42XDQzoOmMswdX51";
        verifica = passwordEngine.check("123456", passwordEncrypted);
        if (!verifica) {
            throw new Exception("Verifica password 'openssl' fallita");
        }
        verifica = passwordEngine.check("1234567", passwordEncrypted);
        if (verifica) {
            throw new Exception("Attesa verifica fallita per password 'openssl'");
        }
        String password = "Pr@va.diUn@altroDiverso";
        passwordEncrypted = passwordEngine.crypt(password);
        verifica = passwordEngine.check(password, passwordEncrypted);
        if (!verifica) {
            throw new Exception("Verifica password '" + password + "' fallita");
        }
        verifica = passwordEngine.check(password + "7", passwordEncrypted);
        if (verifica) {
            throw new Exception("Attesa verifica fallita per password '" + password + "7'");
        }
        verifica = passwordEngine.check(password + "ERR", passwordEncrypted);
        if (verifica) {
            throw new Exception("Attesa verifica fallita per password '" + password + "ERR'");
        }
        System.out.println("OK");
    }
}

