/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateEngineType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.UnitaTemporale;

public class DateUtils {
    private static volatile boolean dateTimeAllowLowerCaseTZ = false;
    private static volatile boolean dateTimeAllowSpaceSeparator = false;
    private static final String RFC3339_56_ERROR = "' has wrong format (see RFC 3339, section 5.6): ";
    private static final String UNCORRECT_FORMAT = "Uncorrect format";
    private static final String DATETIME_PATTERN_SEPARATOR = "tT ";
    private static final String DATETIME_PATTERN_TIMEZONE = "zZ";
    private static final String DATETIME_PATTERN = "^\\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(0?[1-9]|[12][0-9]|3[01])[tT ]\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?([zZ]|[+-]\\d{2}:\\d{2})$";
    private static final String FULL_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_PATTERN = "^\\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(0?[1-9]|[12][0-9]|3[01])$";
    private static final String FULL_TIME_FORMAT_SECONDS = "HH:mm:ss.SSS";
    private static final String FULL_TIME_FORMAT_WITHOUT_SECONDS = "HH:mm:ss";
    private static final String FULL_TIME_FORMAT_OFFSET = "HH:mm";
    private static final String TIME_PATTERN = "^\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?([zZ]|[+-]\\d{2}:\\d{2})$";
    private static DateEngineType DEFAULT_DATA_ENGINE_TYPE = DateEngineType.JAVA_TIME;
    public static final String SIMPLE_DATE_FORMAT_MS = "yyyy-MM-dd_HH:mm:ss.SSS";
    public static final String SIMPLE_DATE_FORMAT_MS_ISO_8601_TZ = "yyyy-MM-dd_HH:mm:ss.SSSX";
    public static final String SIMPLE_DATE_FORMAT_SECOND = "yyyy-MM-dd_HH:mm:ss";
    public static final String SIMPLE_DATE_FORMAT_SECOND_ISO_8601_TZ = "yyyy-MM-dd_HH:mm:ssX";
    public static final String SIMPLE_DATE_FORMAT_MINUTE = "yyyy-MM-dd_HH:mm";
    public static final String SIMPLE_DATE_FORMAT_MINUTE_ISO_8601_TZ = "yyyy-MM-dd_HH:mmX";
    public static final String SIMPLE_DATE_FORMAT_HOUR = "yyyy-MM-dd_HH";
    public static final String SIMPLE_DATE_FORMAT_HOUR_ISO_8601_TZ = "yyyy-MM-dd_HHX";
    public static final String SIMPLE_DATE_FORMAT_DAY = "yyyy-MM-dd";
    public static final String SIMPLE_DATE_FORMAT_DAY_ISO_8601_TZ = "yyyy-MM-ddX";
    private static Map<String, java.time.format.DateTimeFormatter> mapFormatToDateTimeFormatter = new HashMap<String, java.time.format.DateTimeFormatter>();
    private static ZoneId zoneId = ZoneId.systemDefault();
    private static Map<String, DateTimeFormatter> mapFormatToJodaDateTimeFormatter = new HashMap<String, DateTimeFormatter>();
    private static DateTimeZone dtz = DateTimeZone.getDefault();

    public static java.util.Date convertToLeftInterval(java.util.Date date, UnitaTemporale unitaTemporale) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        switch (unitaTemporale) {
            case SECONDI: {
                calendar.set(14, 0);
                break;
            }
            case MINUTI: {
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case ORARIO: {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case GIORNALIERO: {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case SETTIMANALE: {
                while (2 != calendar.get(7)) {
                    calendar.add(7, -1);
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case MENSILE: {
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        }
        return calendar.getTime();
    }

    public static java.util.Date convertToRightInterval(java.util.Date date, UnitaTemporale unitaTemporale) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        switch (unitaTemporale) {
            case SECONDI: {
                calendar.set(14, 999);
                break;
            }
            case MINUTI: {
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case ORARIO: {
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case GIORNALIERO: {
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case SETTIMANALE: {
                while (1 != calendar.get(7)) {
                    calendar.add(7, 1);
                }
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case MENSILE: {
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                int lastDayActualMonth = calendar.getActualMaximum(5);
                calendar.set(5, lastDayActualMonth);
            }
        }
        return calendar.getTime();
    }

    public static java.util.Date incrementDate(java.util.Date date, UnitaTemporale unitaTemporale, int increment) {
        if (increment == 0) {
            return date;
        }
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        switch (unitaTemporale) {
            case SECONDI: {
                calendar.add(13, increment);
                break;
            }
            case MINUTI: {
                calendar.add(12, increment);
                break;
            }
            case ORARIO: {
                calendar.add(11, increment);
                break;
            }
            case GIORNALIERO: {
                calendar.add(6, increment);
                break;
            }
            case SETTIMANALE: {
                calendar.add(6, increment * 7);
                break;
            }
            case MENSILE: {
                calendar.add(2, increment);
                int lastDayActualMonth = calendar.getActualMaximum(5);
                calendar.set(5, lastDayActualMonth);
            }
        }
        return calendar.getTime();
    }

    public static java.util.Date incrementDate1Millisecond(java.util.Date date) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        calendar.add(14, 1);
        return calendar.getTime();
    }

    public java.util.Date decrementDate1Millisecond(java.util.Date date) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static java.util.Date incredementDate1MsIf999(java.util.Date date) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        int ms = calendar.get(14);
        if (ms >= 999) {
            calendar.add(14, 1);
            return calendar.getTime();
        }
        return date;
    }

    public static boolean isDateTimeAllowLowerCaseTZ() {
        return dateTimeAllowLowerCaseTZ;
    }

    public static void setDateTimeAllowLowerCaseTZ(boolean dateTimeAllowLowerCaseTZ) {
        DateUtils.dateTimeAllowLowerCaseTZ = dateTimeAllowLowerCaseTZ;
    }

    public static boolean isDateTimeAllowSpaceSeparator() {
        return dateTimeAllowSpaceSeparator;
    }

    public static void setDateTimeAllowSpaceSeparator(boolean dateTimeAllowSpaceSeparator) {
        DateUtils.dateTimeAllowSpaceSeparator = dateTimeAllowSpaceSeparator;
    }

    private static String buildDateTimeSeparatorPattern(boolean dateTimeAllowLowerCase, boolean dateTimeAllowSpaceSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append("T");
        if (dateTimeAllowLowerCase) {
            sb.append("t");
        }
        if (dateTimeAllowSpaceSeparator) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String buildTimeZonePattern(boolean dateTimeAllowLowerCase) {
        StringBuilder sb = new StringBuilder();
        sb.append("Z");
        if (dateTimeAllowLowerCase) {
            sb.append("z");
        }
        return sb.toString();
    }

    public static void validateDateTimeAsRFC3339Sec56(String dateTime) throws UtilsException {
        DateUtils.validateDateTimeAsRFC3339Sec56(dateTime, dateTimeAllowLowerCaseTZ, dateTimeAllowSpaceSeparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateDateTimeAsRFC3339Sec56(String dateTime, boolean allowLowerCaseTZ, boolean allowSpaceSeparator) throws UtilsException {
        String fullDate = null;
        String fullTime = null;
        try {
            String separator = null;
            if (!dateTime.contains("T")) {
                if (allowLowerCaseTZ && dateTime.contains("t")) {
                    separator = "t";
                } else {
                    if (!allowSpaceSeparator || !dateTime.contains(" ")) throw new UtilsException("Expected 'T' separator");
                    separator = " ";
                }
            } else {
                separator = "T";
            }
            String[] split = dateTime.split(separator);
            if (split == null || split.length != 2) {
                throw new UtilsException("Expected 'full-date T full-time' format");
            }
            String dateTimePattern = DATETIME_PATTERN.replace(DATETIME_PATTERN_SEPARATOR, DateUtils.buildDateTimeSeparatorPattern(allowLowerCaseTZ, allowSpaceSeparator));
            if (!DateUtils.isMatchEngine(dateTime, dateTimePattern = dateTimePattern.replace(DATETIME_PATTERN_TIMEZONE, DateUtils.buildTimeZonePattern(allowLowerCaseTZ)))) {
                throw new UtilsException(UNCORRECT_FORMAT);
            }
            fullDate = split[0];
            fullTime = split[1];
        }
        catch (Exception e) {
            throw new UtilsException("Found dateTime '" + dateTime + RFC3339_56_ERROR + e.getMessage(), e);
        }
        DateUtils.validateDateAsRFC3339Sec56(fullDate);
        DateUtils.validateTimeAsRFC3339Sec56(fullTime);
    }

    public static void validateDateAsRFC3339Sec56(String fullDate) throws UtilsException {
        try {
            if (fullDate == null || "".equals(fullDate)) {
                throw new UtilsException("undefined");
            }
            if (!DateUtils.isMatchEngine(fullDate, DATE_PATTERN)) {
                throw new UtilsException(UNCORRECT_FORMAT);
            }
            DateUtils.validateDateAsRFC3339Sec56WithSimpleDateFormat(fullDate);
        }
        catch (Exception e) {
            throw new UtilsException("Found date '" + fullDate + RFC3339_56_ERROR + e.getMessage(), e);
        }
    }

    private static void validateDateAsRFC3339Sec56WithSimpleDateFormat(String fullDate) throws UtilsException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date d = sdf.parse(fullDate);
            d.toString();
        }
        catch (Exception e) {
            throw new UtilsException("uncorrect format: " + e.getMessage(), e);
        }
    }

    public static void validateTimeAsRFC3339Sec56(String fullTime) throws UtilsException {
        DateUtils.validateTimeAsRFC3339Sec56(fullTime, dateTimeAllowLowerCaseTZ);
    }

    public static void validateTimeAsRFC3339Sec56(String fullTime, boolean allowLowerCaseTZ) throws UtilsException {
        try {
            if (fullTime == null || "".equals(fullTime)) {
                throw new UtilsException("undefined");
            }
            if (fullTime.length() < 9) {
                throw new UtilsException("too short");
            }
            String timePattern = TIME_PATTERN.replace(DATETIME_PATTERN_TIMEZONE, DateUtils.buildTimeZonePattern(allowLowerCaseTZ));
            if (!DateUtils.isMatchEngine(fullTime, timePattern)) {
                throw new UtilsException(UNCORRECT_FORMAT);
            }
            String partialTime = DateUtils.validateTimeAsRFC3339Sec56PartialTime(fullTime);
            if (partialTime == null || "".equals(partialTime)) {
                throw new UtilsException("undefined partial time");
            }
            DateUtils.validateTimeAsRFC3339Sec56WithSimpleDateFormaPartialTime(partialTime);
        }
        catch (Exception e) {
            throw new UtilsException("Found time '" + fullTime + RFC3339_56_ERROR + e.getMessage(), e);
        }
    }

    private static String validateTimeAsRFC3339Sec56PartialTime(String fullTime) throws UtilsException {
        String partialTime = null;
        if (fullTime.endsWith("Z") || fullTime.endsWith("z")) {
            partialTime = fullTime.substring(0, fullTime.length() - 1);
        } else {
            if (!fullTime.contains("+") && !fullTime.contains("-")) {
                throw new UtilsException("expected '(\"+\" / \"-\") or \"Z\" time-offset character");
            }
            String offset = null;
            String[] splitFullTime = null;
            splitFullTime = fullTime.contains("+") ? fullTime.split("\\+") : fullTime.split("-");
            if (splitFullTime == null || splitFullTime.length != 2) {
                throw new UtilsException("expected partial-time time-offset");
            }
            partialTime = splitFullTime[0];
            offset = splitFullTime[1];
            if (offset == null || "".equals(fullTime)) {
                throw new UtilsException("undefined offset time");
            }
            DateUtils.validateTimeAsRFC3339Sec56WithSimpleDateFormatOffset(offset);
        }
        return partialTime;
    }

    private static void validateTimeAsRFC3339Sec56WithSimpleDateFormatOffset(String offset) throws UtilsException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FULL_TIME_FORMAT_OFFSET);
            java.util.Date d = sdf.parse(offset);
            d.toString();
        }
        catch (Exception e) {
            throw new UtilsException("uncorrect offset format: " + e.getMessage(), e);
        }
    }

    private static void validateTimeAsRFC3339Sec56WithSimpleDateFormaPartialTime(String partialTime) throws UtilsException {
        try {
            SimpleDateFormat sdf = null;
            sdf = partialTime.contains(".") ? new SimpleDateFormat(FULL_TIME_FORMAT_SECONDS) : new SimpleDateFormat(FULL_TIME_FORMAT_WITHOUT_SECONDS);
            java.util.Date d = sdf.parse(partialTime);
            d.toString();
        }
        catch (Exception e) {
            throw new UtilsException("uncorrect offset format: " + e.getMessage(), e);
        }
    }

    private static boolean isMatchEngine(String contenuto, String pattern) throws UtilsException {
        if (pattern == null || pattern.length() == 0) {
            throw new UtilsException("Pattern di ricerca non fornito");
        }
        if (contenuto == null || contenuto.length() == 0) {
            throw new UtilsException("Contenuto su cui effettuare una ricerca non fornita");
        }
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(contenuto);
            return matcher.matches();
        }
        catch (Exception e) {
            throw new UtilsException("isMatch contenuto[" + contenuto + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static DateEngineType getDEFAULT_DATA_ENGINE_TYPE() {
        return DEFAULT_DATA_ENGINE_TYPE;
    }

    public static void setDEFAULT_DATA_ENGINE_TYPE(DateEngineType dEFAULT_DATA_ENGINE_TYPE) {
        DEFAULT_DATA_ENGINE_TYPE = dEFAULT_DATA_ENGINE_TYPE;
    }

    public static SimpleDateFormat getSimpleDateFormatMs() {
        return DateUtils.getDefaultDateTimeFormatterMs();
    }

    public static SimpleDateFormat getOldSimpleDateFormatMs() {
        return new SimpleDateFormat(SIMPLE_DATE_FORMAT_MS);
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterMs() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_MS);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterMs() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_MS);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterMs(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_MS, false);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterMs() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_MS, false);
    }

    public static SimpleDateFormat getSimpleDateFormatMs_ISO_8601_TZ() {
        return DateUtils.getDefaultDateTimeFormatterMs_ISO_8601_TZ();
    }

    public static SimpleDateFormat getOldSimpleDateFormatMs_ISO_8601_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT_MS_ISO_8601_TZ);
        sdf.setCalendar(Calendar.getInstance());
        return sdf;
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterMs_ISO_8601_TZ() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_MS_ISO_8601_TZ);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterMs_ISO_8601_TZ() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_MS_ISO_8601_TZ);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterMs_ISO_8601_TZ(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_MS_ISO_8601_TZ, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterMs_ISO_8601_TZ() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_MS_ISO_8601_TZ, true);
    }

    public static SimpleDateFormat getSimpleDateFormatSecond() {
        return DateUtils.getDefaultDateTimeFormatterSecond();
    }

    public static SimpleDateFormat getOldSimpleDateFormatSecond() {
        return new SimpleDateFormat(SIMPLE_DATE_FORMAT_SECOND);
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterSecond() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_SECOND);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterSecond() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_SECOND);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterSecond(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_SECOND, false);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterSecond() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_SECOND, false);
    }

    public static SimpleDateFormat getSimpleDateFormatSecond_ISO_8601_TZ() {
        return DateUtils.getDefaultDateTimeFormatterSecond_ISO_8601_TZ();
    }

    public static SimpleDateFormat getOldSimpleDateFormatSecond_ISO_8601_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT_SECOND_ISO_8601_TZ);
        sdf.setCalendar(Calendar.getInstance());
        return sdf;
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterSecond_ISO_8601_TZ() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_SECOND_ISO_8601_TZ);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterSecond_ISO_8601_TZ() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_SECOND_ISO_8601_TZ);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterSecond_ISO_8601_TZ(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_SECOND_ISO_8601_TZ, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterSecond_ISO_8601_TZ() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_SECOND_ISO_8601_TZ, true);
    }

    public static SimpleDateFormat getSimpleDateFormatMinute() {
        return DateUtils.getDefaultDateTimeFormatterMinute();
    }

    public static SimpleDateFormat getOldSimpleDateFormatMinute() {
        return new SimpleDateFormat(SIMPLE_DATE_FORMAT_MINUTE);
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterMinute() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_MINUTE);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterMinute() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_MINUTE);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterMinute(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_MINUTE, false);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterMinute() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_MINUTE, false);
    }

    public static SimpleDateFormat getSimpleDateFormatMinute_ISO_8601_TZ() {
        return DateUtils.getDefaultDateTimeFormatterMinute_ISO_8601_TZ();
    }

    public static SimpleDateFormat getOldSimpleDateFormatMinute_ISO_8601_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT_MINUTE_ISO_8601_TZ);
        sdf.setCalendar(Calendar.getInstance());
        return sdf;
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterMinute_ISO_8601_TZ() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_MINUTE_ISO_8601_TZ);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterMinute_ISO_8601_TZ() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_MINUTE_ISO_8601_TZ);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterMinute_ISO_8601_TZ(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_MINUTE_ISO_8601_TZ, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterMinute_ISO_8601_TZ() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_MINUTE_ISO_8601_TZ, true);
    }

    public static SimpleDateFormat getSimpleDateFormatHour() {
        return DateUtils.getDefaultDateTimeFormatterHour();
    }

    public static SimpleDateFormat getOldSimpleDateFormatHour() {
        return new SimpleDateFormat(SIMPLE_DATE_FORMAT_HOUR);
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterHour() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_HOUR);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterHour() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_HOUR);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterHour(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_HOUR, false);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterHour() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_HOUR, false);
    }

    public static SimpleDateFormat getSimpleDateFormatHour_ISO_8601_TZ() {
        return DateUtils.getDefaultDateTimeFormatterHour_ISO_8601_TZ();
    }

    public static SimpleDateFormat getOldSimpleDateFormatHour_ISO_8601_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT_HOUR_ISO_8601_TZ);
        sdf.setCalendar(Calendar.getInstance());
        return sdf;
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterHour_ISO_8601_TZ() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_HOUR_ISO_8601_TZ);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterHour_ISO_8601_TZ() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_HOUR_ISO_8601_TZ);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterHour_ISO_8601_TZ(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), SIMPLE_DATE_FORMAT_HOUR_ISO_8601_TZ, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterHour_ISO_8601_TZ() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), SIMPLE_DATE_FORMAT_HOUR_ISO_8601_TZ, true);
    }

    public static SimpleDateFormat getSimpleDateFormatDay() {
        return DateUtils.getDefaultDateTimeFormatterDay();
    }

    public static SimpleDateFormat getOldSimpleDateFormatDay() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterDay() {
        return DateUtils.getDateTimeFormatter("yyyy-MM-dd");
    }

    public static DateTimeFormatter getJodaDateTimeFormatterDay() {
        return DateUtils.getJodaDateTimeFormatter("yyyy-MM-dd");
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterDay(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateType(), "yyyy-MM-dd", false);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterDay() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateType(), "yyyy-MM-dd", false);
    }

    public static SimpleDateFormat getSimpleDateFormatDay_ISO_8601_TZ() {
        return DateUtils.getDefaultDateTimeFormatterDay_ISO_8601_TZ();
    }

    public static SimpleDateFormat getOldSimpleDateFormatDay_ISO_8601_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT_DAY_ISO_8601_TZ);
        sdf.setCalendar(Calendar.getInstance());
        return sdf;
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatterDay_ISO_8601_TZ() {
        return DateUtils.getDateTimeFormatter(SIMPLE_DATE_FORMAT_DAY_ISO_8601_TZ);
    }

    public static DateTimeFormatter getJodaDateTimeFormatterDay_ISO_8601_TZ() {
        return DateUtils.getJodaDateTimeFormatter(SIMPLE_DATE_FORMAT_DAY_ISO_8601_TZ);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatterDay_ISO_8601_TZ(DateEngineType type) {
        return new DateTimeFormatterWrapper(type.toDateType(), SIMPLE_DATE_FORMAT_DAY_ISO_8601_TZ, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatterDay_ISO_8601_TZ() {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateType(), SIMPLE_DATE_FORMAT_DAY_ISO_8601_TZ, true);
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        return DateUtils.getDefaultDateTimeFormatter(format);
    }

    public static SimpleDateFormat getOldSimpleDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static DateTimeFormatterWrapper getDateTimeFormatter(DateEngineType type, String format) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), format, false);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatter(String format) {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), format, false);
    }

    public static DateTimeFormatterWrapper getDateFormatter(DateEngineType type, String format) {
        return new DateTimeFormatterWrapper(type.toDateType(), format, false);
    }

    public static DateTimeFormatterWrapper getDefaultDateFormatter(String format) {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateType(), format, false);
    }

    public static DateTimeFormatterWrapper getTimeFormatter(DateEngineType type, String format) {
        return new DateTimeFormatterWrapper(type.toTimeType(), format, false);
    }

    public static DateTimeFormatterWrapper getDefaultTimeFormatter(String format) {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toTimeType(), format, false);
    }

    public static SimpleDateFormat getSimpleDateFormat_ISO_8601_TZ(String format) {
        return DateUtils.getDefaultDateTimeFormatter_ISO_8601_TZ(format);
    }

    public static SimpleDateFormat getOldSimpleDateFormat_ISO_8601_TZ(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setCalendar(Calendar.getInstance());
        return sdf;
    }

    public static DateTimeFormatterWrapper getDateTimeFormatter_ISO_8601_TZ(DateEngineType type, String format) {
        return new DateTimeFormatterWrapper(type.toDateTimeType(), format, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateTimeFormatter_ISO_8601_TZ(String format) {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateTimeType(), format, true);
    }

    public static DateTimeFormatterWrapper getDateFormatter_ISO_8601_TZ(DateEngineType type, String format) {
        return new DateTimeFormatterWrapper(type.toDateType(), format, true);
    }

    public static DateTimeFormatterWrapper getDefaultDateFormatter_ISO_8601_TZ(String format) {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toDateType(), format, true);
    }

    public static DateTimeFormatterWrapper getTimeFormatter_ISO_8601_TZ(DateEngineType type, String format) {
        return new DateTimeFormatterWrapper(type.toTimeType(), format, true);
    }

    public static DateTimeFormatterWrapper getDefaultTimeFormatter_ISO_8601_TZ(String format) {
        return new DateTimeFormatterWrapper(DEFAULT_DATA_ENGINE_TYPE.toTimeType(), format, true);
    }

    public static java.util.Date parseDate(String dateParam) throws ParseException {
        return DateUtils.parseDateRFC3339_sec5_6(dateParam);
    }

    public static java.util.Date parseDateRFC3339_sec5_6(String dateParam) throws ParseException {
        String date = dateParam;
        boolean withTimeZone = false;
        if (date.length() > SIMPLE_DATE_FORMAT_SECOND.length()) {
            String check = date.substring(SIMPLE_DATE_FORMAT_SECOND.length());
            boolean bl = withTimeZone = check.endsWith("Z") || check.contains("+") || check.contains("-");
        }
        if (date.contains("T")) {
            if ((date = date.replace("T", "_")).contains(".")) {
                if (withTimeZone) {
                    return DateUtils.getSimpleDateFormatMs_ISO_8601_TZ().parse(date);
                }
                return DateUtils.getSimpleDateFormatMs().parse(date);
            }
            if (date.contains(":")) {
                String[] split = date.split(":");
                if (split.length > 1) {
                    if (withTimeZone) {
                        return DateUtils.getSimpleDateFormatSecond_ISO_8601_TZ().parse(date);
                    }
                    return DateUtils.getSimpleDateFormatSecond().parse(date);
                }
                if (withTimeZone) {
                    return DateUtils.getSimpleDateFormatMinute_ISO_8601_TZ().parse(date);
                }
                return DateUtils.getSimpleDateFormatMinute().parse(date);
            }
            if (withTimeZone) {
                return DateUtils.getSimpleDateFormatHour_ISO_8601_TZ().parse(date);
            }
            return DateUtils.getSimpleDateFormatHour().parse(date);
        }
        if (withTimeZone) {
            return DateUtils.getSimpleDateFormatDay_ISO_8601_TZ().parse(date);
        }
        return DateUtils.getSimpleDateFormatDay().parse(date);
    }

    public static java.time.LocalDateTime parseToLocalDateTime(String format, String source) {
        Object sCorrect;
        if ("yyyyMMddHHmmssSSS".equals(format) && ((String)(sCorrect = source)).length() > 4) {
            sCorrect = source.substring(0, 4) + " " + source.substring(4, source.length());
            return java.time.LocalDateTime.parse((CharSequence)sCorrect, DateUtils.getDateTimeFormatter("yyyy MMddHHmmssSSS"));
        }
        return java.time.LocalDateTime.parse(source, DateUtils.getDateTimeFormatter(format));
    }

    public static LocalDate parseToLocalDate(String format, String source) {
        return LocalDate.parse(source, DateUtils.getDateTimeFormatter(format));
    }

    public static java.time.LocalTime parseToLocalTime(String format, String source) {
        return java.time.LocalTime.parse(source, DateUtils.getDateTimeFormatter(format));
    }

    private static synchronized void initDateTimeFormatter(String format) {
        if (!mapFormatToDateTimeFormatter.containsKey(format)) {
            mapFormatToDateTimeFormatter.put(format, java.time.format.DateTimeFormatter.ofPattern(format));
        }
    }

    public static java.time.format.DateTimeFormatter getDateTimeFormatter(String format) {
        if (!mapFormatToDateTimeFormatter.containsKey(format)) {
            DateUtils.initDateTimeFormatter(format);
        }
        return mapFormatToDateTimeFormatter.get(format);
    }

    public static LocalDate convertToLocalDateViaInstant(java.util.Date dateToConvert) {
        return DateUtils.convertToLocalDateViaInstant(dateToConvert, zoneId);
    }

    public static LocalDate convertToLocalDateViaInstant(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return dateToConvert.toInstant().atZone(zoneIdParam).toLocalDate();
    }

    public static LocalDate convertToLocalDateViaMilisecond(java.util.Date dateToConvert) {
        return DateUtils.convertToLocalDateViaMilisecond(dateToConvert, zoneId);
    }

    public static LocalDate convertToLocalDateViaMilisecond(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return Instant.ofEpochMilli(dateToConvert.getTime()).atZone(zoneIdParam).toLocalDate();
    }

    public static java.util.Date convertToDateViaSqlDate(LocalDate dateToConvert) {
        return Date.valueOf(dateToConvert);
    }

    public static java.util.Date convertToDateViaInstant(LocalDate dateToConvert) {
        return DateUtils.convertToDateViaInstant(dateToConvert, zoneId);
    }

    public static java.util.Date convertToDateViaInstant(LocalDate dateToConvert, ZoneId zoneIdParam) {
        return java.util.Date.from(dateToConvert.atStartOfDay().atZone(zoneIdParam).toInstant());
    }

    public static java.time.LocalTime convertToLocalTimeViaInstant(java.util.Date dateToConvert) {
        return DateUtils.convertToLocalTimeViaInstant(dateToConvert, zoneId);
    }

    public static java.time.LocalTime convertToLocalTimeViaInstant(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return dateToConvert.toInstant().atZone(zoneIdParam).toLocalTime();
    }

    public static java.time.LocalTime convertToLocalTimeViaMilisecond(java.util.Date dateToConvert) {
        return DateUtils.convertToLocalTimeViaMilisecond(dateToConvert, zoneId);
    }

    public static java.time.LocalTime convertToLocalTimeViaMilisecond(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return Instant.ofEpochMilli(dateToConvert.getTime()).atZone(zoneIdParam).toLocalTime();
    }

    public static java.util.Date convertToDateViaInstant(java.time.LocalTime dateToConvert) {
        return DateUtils.convertToDateViaInstant(dateToConvert, zoneId);
    }

    public static java.util.Date convertToDateViaInstant(java.time.LocalTime dateToConvert, ZoneId zoneIdParam) {
        return java.util.Date.from(dateToConvert.atDate(LocalDate.now()).atZone(zoneIdParam).toInstant());
    }

    public static ZonedDateTime convertToZonedDateTimeViaInstant(java.util.Date dateToConvert) {
        return DateUtils.convertToZonedDateTimeViaInstant(dateToConvert, zoneId);
    }

    public static ZonedDateTime convertToZonedDateTimeViaInstant(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return dateToConvert.toInstant().atZone(zoneIdParam);
    }

    public static java.time.LocalDateTime convertToLocalDateTimeViaInstant(java.util.Date dateToConvert) {
        return DateUtils.convertToLocalDateTimeViaInstant(dateToConvert, zoneId);
    }

    public static java.time.LocalDateTime convertToLocalDateTimeViaInstant(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return DateUtils.convertToZonedDateTimeViaInstant(dateToConvert, zoneIdParam).toLocalDateTime();
    }

    public static ZonedDateTime convertToZonedDateTimeViaMilisecond(java.util.Date dateToConvert) {
        return DateUtils.convertToZonedDateTimeViaMilisecond(dateToConvert, zoneId);
    }

    public static ZonedDateTime convertToZonedDateTimeViaMilisecond(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return Instant.ofEpochMilli(dateToConvert.getTime()).atZone(zoneIdParam);
    }

    public static java.time.LocalDateTime convertToLocalDateTimeViaMilisecond(java.util.Date dateToConvert) {
        return DateUtils.convertToLocalDateTimeViaMilisecond(dateToConvert, zoneId);
    }

    public static java.time.LocalDateTime convertToLocalDateTimeViaMilisecond(java.util.Date dateToConvert, ZoneId zoneIdParam) {
        return DateUtils.convertToZonedDateTimeViaMilisecond(dateToConvert, zoneIdParam).toLocalDateTime();
    }

    public static java.time.LocalDateTime convertToLocalDateTimeViaSqlTimestamp(java.util.Date dateToConvert) {
        return new Timestamp(dateToConvert.getTime()).toLocalDateTime();
    }

    public static java.util.Date convertToDateViaSqlTimestamp(java.time.LocalDateTime dateToConvert) {
        return Timestamp.valueOf(dateToConvert);
    }

    public static java.util.Date convertToDateViaInstant(java.time.LocalDateTime dateToConvert) {
        return DateUtils.convertToDateViaInstant(dateToConvert, zoneId);
    }

    public static java.util.Date convertToDateViaInstant(java.time.LocalDateTime dateToConvert, ZoneId zoneIdParam) {
        return java.util.Date.from(dateToConvert.atZone(zoneIdParam).toInstant());
    }

    public static java.util.Date convertToDateViaInstant(ZonedDateTime dateToConvert) {
        return DateUtils.convertToDateViaInstant(dateToConvert, zoneId);
    }

    public static java.util.Date convertToDateViaInstant(ZonedDateTime dateToConvert, ZoneId zoneIdParam) {
        return java.util.Date.from(dateToConvert.toInstant());
    }

    public static DateTime parseToJodaDateTime(String format, String source) {
        return DateUtils.getJodaDateTimeFormatter(format).parseDateTime(source);
    }

    public static LocalDateTime parseToJodaLocalDateTime(String format, String source) {
        return DateUtils.parseToJodaDateTime(format, source).toLocalDateTime();
    }

    public static org.joda.time.LocalDate parseToJodaLocalDate(String format, String source) {
        return DateUtils.parseToJodaDateTime(format, source).toLocalDate();
    }

    public static LocalTime parseToJodaLocalTime(String format, String source) {
        return DateUtils.parseToJodaDateTime(format, source).toLocalTime();
    }

    private static String normalizeTimeZoneFormatForJoda(String formato) {
        return formato.contains("X") ? formato.replaceAll("X", "Z") : formato;
    }

    private static synchronized void initJodaDateTimeFormatter(String format) {
        if (!mapFormatToJodaDateTimeFormatter.containsKey(format)) {
            mapFormatToJodaDateTimeFormatter.put(format, DateTimeFormat.forPattern((String)DateUtils.normalizeTimeZoneFormatForJoda(format)));
        }
    }

    public static DateTimeFormatter getJodaDateTimeFormatter(String format) {
        if (!mapFormatToJodaDateTimeFormatter.containsKey(format)) {
            DateUtils.initJodaDateTimeFormatter(format);
        }
        return mapFormatToJodaDateTimeFormatter.get(format);
    }

    public static org.joda.time.LocalDate convertToJodaLocalDate(java.util.Date dateToConvert) {
        return DateUtils.convertToJodaLocalDate(dateToConvert, dtz);
    }

    public static org.joda.time.LocalDate convertToJodaLocalDate(java.util.Date dateToConvert, DateTimeZone dtzParam) {
        return new org.joda.time.LocalDate(dateToConvert.getTime(), dtzParam);
    }

    public static LocalTime convertToJodaLocalTime(java.util.Date dateToConvert) {
        return DateUtils.convertToJodaLocalTime(dateToConvert, dtz);
    }

    public static LocalTime convertToJodaLocalTime(java.util.Date dateToConvert, DateTimeZone dtzParam) {
        return new LocalTime(dateToConvert.getTime(), dtzParam);
    }

    public static LocalDateTime convertToJodaLocalDateTime(java.util.Date dateToConvert) {
        return DateUtils.convertToJodaLocalDateTime(dateToConvert, dtz);
    }

    public static LocalDateTime convertToJodaLocalDateTime(java.util.Date dateToConvert, DateTimeZone dtzParam) {
        return new LocalDateTime(dateToConvert.getTime(), dtzParam);
    }

    public static DateTime convertToJodaDateTime(java.util.Date dateToConvert) {
        return DateUtils.convertToJodaDateTime(dateToConvert, dtz);
    }

    public static DateTime convertToJodaDateTime(java.util.Date dateToConvert, DateTimeZone dtzParam) {
        return new DateTime(dateToConvert.getTime(), dtzParam);
    }

    public static java.util.Date convertToDate(org.joda.time.LocalDate dateToConvert) {
        return dateToConvert.toDate();
    }

    public static java.util.Date convertToDate(LocalTime dateToConvert) {
        return dateToConvert.toDateTimeToday().toDate();
    }

    public static java.util.Date convertToDate(LocalDateTime dateToConvert) {
        return dateToConvert.toDate();
    }

    public static java.util.Date convertToDate(DateTime dateToConvert) {
        return dateToConvert.toDate();
    }
}

