/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.IDate;

public class NTPDate
implements IDate {
    private static InetAddress server = null;
    private static NTPUDPClient udpClient = null;
    private static int defaultTimeout = -1;
    private static Map<String, Date> time = null;
    private static boolean cacheEnabled = true;
    private static int cacheRefresh = 100;
    private static Semaphore semaphore = new Semaphore("NTPDate");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getDateCached() throws Exception {
        if (!cacheEnabled) {
            TimeInfo tInfo = udpClient.getTime(server);
            return tInfo.getMessage().getReceiveTimeStamp().getDate();
        }
        String key = "" + System.currentTimeMillis() / (long)cacheRefresh;
        if (time.containsKey(key)) {
            return time.get(key);
        }
        SemaphoreLock lock = semaphore.acquire("getDateCached");
        try {
            if (time.containsKey(key)) {
                Date date = time.get(key);
                return date;
            }
            TimeInfo tInfo = udpClient.getTime(server);
            Date d = tInfo.getMessage().getReceiveTimeStamp().getDate();
            time.clear();
            time.put(key, d);
            Date date = d;
            return date;
        }
        finally {
            semaphore.release(lock, "getDateCached");
        }
    }

    @Override
    public void init(Properties properties) throws UtilsException {
        NTPDate._init(properties);
    }

    private static void _init(Properties properties) throws UtilsException {
        if (udpClient == null) {
            NTPDate._initSync(properties);
        }
    }

    private static synchronized void _initSync(Properties properties) throws UtilsException {
        if (udpClient != null) {
            return;
        }
        try {
            String cacheRefreshS;
            String cacheS;
            String ipaddressS;
            udpClient = new NTPUDPClient();
            String timeoutS = properties.getProperty("ntp.timeout");
            if (timeoutS != null) {
                try {
                    defaultTimeout = Integer.parseInt(timeoutS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.ntp.timeout value non valido: " + e.getMessage(), e);
                }
            }
            if (defaultTimeout != -1) {
                udpClient.setDefaultTimeout(Duration.ofMillis(defaultTimeout));
            }
            if ((ipaddressS = properties.getProperty("ntp.server")) == null) {
                throw new Exception("org.openspcoop.pdd.date.property.ntp.server value non definito");
            }
            if (ipaddressS != null) {
                try {
                    server = InetAddress.getByName(ipaddressS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.ntp.server value non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheS = properties.getProperty("ntp.cache.enable")) != null) {
                try {
                    cacheEnabled = Boolean.parseBoolean(cacheS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.ntp.cache.enable non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheRefreshS = properties.getProperty("ntp.cache.refresh")) != null) {
                try {
                    int value = Integer.parseInt(cacheRefreshS);
                    if (value > 1000) {
                        throw new Exception("Valore deve essere minore di 1000");
                    }
                    cacheRefresh = 1000 / value;
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.ntp.cache.refresh non valido: " + e.getMessage(), e);
                }
            }
            udpClient.open();
            time = new ConcurrentHashMap<String, Date>();
        }
        catch (Exception e) {
            udpClient = null;
            throw new UtilsException("Inizializzazione NTP Client (properties) non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws UtilsException {
        try {
            if (udpClient != null) {
                udpClient.close();
            }
        }
        catch (Exception e) {
            throw new UtilsException("Chiusura NTP Client non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Date getDate() throws UtilsException {
        try {
            if (udpClient == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return NTPDate.getDateCached();
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public long getTimeMillis() throws UtilsException {
        try {
            if (udpClient == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return NTPDate.getDateCached().getTime();
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public Timestamp getTimestamp() throws UtilsException {
        try {
            if (udpClient == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return new Timestamp(NTPDate.getDateCached().getTime());
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public Calendar getCalendar() throws UtilsException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.getDate());
        return c;
    }
}

