/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.net.time.TimeTCPClient;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.IDate;

public class TCPTimeDate
implements IDate {
    private static InetAddress server = null;
    private static int port = 37;
    private static int defaultTimeout = -1;
    private static Map<String, Date> time = null;
    private static boolean cacheEnabled = true;
    private static int cacheRefresh = 100;
    private static Semaphore semaphore = new Semaphore("TCPTimeDate");

    private static TimeTCPClient getTCPClient() throws Exception {
        if (server == null) {
            throw new Exception("Inizializzazione non effettuata, invocare metodo init");
        }
        TimeTCPClient tcpClient = new TimeTCPClient();
        if (defaultTimeout != -1) {
            tcpClient.setDefaultTimeout(defaultTimeout);
        }
        tcpClient.connect(server, port);
        return tcpClient;
    }

    /*
     * Exception decompiling
     */
    private static Date getDateCached() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void init(Properties properties) throws UtilsException {
        try {
            String cacheRefreshS;
            String cacheS;
            String ipaddressS;
            String timeoutS = properties.getProperty("time.timeout");
            if (timeoutS != null) {
                try {
                    defaultTimeout = Integer.parseInt(timeoutS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.timeout value non valido: " + e.getMessage(), e);
                }
            }
            String portaS = properties.getProperty("time.porta");
            port = 37;
            if (timeoutS != null) {
                try {
                    port = Integer.parseInt(portaS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.porta value non valido: " + e.getMessage(), e);
                }
            }
            if ((ipaddressS = properties.getProperty("time.server")) == null) {
                throw new Exception("org.openspcoop.pdd.date.property.time.server value non definito");
            }
            if (ipaddressS != null) {
                try {
                    server = InetAddress.getByName(ipaddressS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.server value non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheS = properties.getProperty("time.cache.enable")) != null) {
                try {
                    cacheEnabled = Boolean.parseBoolean(cacheS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.cache.enable non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheRefreshS = properties.getProperty("time.cache.refresh")) != null) {
                try {
                    int value = Integer.parseInt(cacheRefreshS);
                    if (value > 1000) {
                        throw new Exception("Valore deve essere minore di 1000");
                    }
                    cacheRefresh = 1000 / value;
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.cache.refresh non valido: " + e.getMessage(), e);
                }
            }
            time = new ConcurrentHashMap<String, Date>();
        }
        catch (Exception e) {
            server = null;
            throw new UtilsException("Inizializzazione TimeTCP Client (properties) non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws UtilsException {
    }

    @Override
    public Date getDate() throws UtilsException {
        try {
            if (server == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return TCPTimeDate.getDateCached();
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public long getTimeMillis() throws UtilsException {
        try {
            if (server == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return TCPTimeDate.getDateCached().getTime();
        }
        catch (Exception e) {
            throw new UtilsException("getTimeMillis error: " + e.getMessage(), e);
        }
    }

    @Override
    public Timestamp getTimestamp() throws UtilsException {
        try {
            if (server == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return new Timestamp(TCPTimeDate.getDateCached().getTime());
        }
        catch (Exception e) {
            throw new UtilsException("getTimestamp error: " + e.getMessage(), e);
        }
    }

    @Override
    public Calendar getCalendar() throws UtilsException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.getDate());
        return c;
    }
}

