/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.dch;

import jakarta.activation.DataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamDataSource
implements DataSource {
    private String name;
    private String contentType;
    private byte[] bytes;

    public InputStreamDataSource(String name, String contentType, InputStream inputStream) throws IOException {
        int read;
        this.name = name;
        this.contentType = contentType;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[256];
        while ((read = inputStream.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        baos.flush();
        baos.close();
        this.bytes = baos.toByteArray();
    }

    public InputStreamDataSource(String name, String contentType, byte[] b) throws IOException {
        this.name = name;
        this.contentType = contentType;
        this.bytes = b;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Cannot write to this read-only resource");
    }
}

