/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.dch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.dch.DataContentHandlerManager;
import org.openspcoop2.utils.resources.Charset;
import org.slf4j.Logger;

public class MailcapActivationReader {
    private static Map<String, String> mimeTypes = new HashMap<String, String>();
    private static final String MAILCAP = "/META-INF/mailcap";
    private static boolean debug = true;

    private MailcapActivationReader() {
    }

    private static void logInfo(Logger log, String msg) {
        log.info(msg);
    }

    private static void logError(Logger log, String msg) {
        log.error(msg);
    }

    public static void setDebug(boolean debug) {
        MailcapActivationReader.debug = debug;
    }

    public static void initDataContentHandler(Logger log, boolean forceLoadMailcap) throws UtilsException {
        InputStream is = null;
        try {
            DataContentHandlerManager dchManager = new DataContentHandlerManager(log);
            List<String> typesRegistrati = dchManager.readMimeTypesRegistrati(true);
            URL urlDebug = MailcapActivationReader.class.getResource(MAILCAP);
            MailcapActivationReader.logInfo(log, "Posizione '/META-INF/mailcap' in classloader: " + String.valueOf(urlDebug));
            is = MailcapActivationReader.class.getResourceAsStream(MAILCAP);
            if (debug) {
                String s = Utilities.getAsString(is, Charset.UTF_8.getValue());
                is.close();
                MailcapActivationReader.logInfo(log, "Contenuto '/META-INF/mailcap': " + s);
                is = new ByteArrayInputStream(s.getBytes());
            }
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<Object> en = prop.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                MailcapActivationReader.checkType(key, prop, typesRegistrati, log, forceLoadMailcap, dchManager);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static void checkType(String key, Properties prop, List<String> typesRegistrati, Logger log, boolean forceLoadMailcap, DataContentHandlerManager dchManager) throws UtilsException, IOException {
        int index = key.indexOf(";;");
        if (index == -1) {
            throw new UtilsException("Entry " + key + (String)prop.get(key) + " definita con un formato scorretto [;;] (vedi jakarta.activation.MailcapCommandMap api)");
        }
        String keyMime = key.substring(0, index);
        keyMime = keyMime.trim();
        String value = (String)prop.get(key);
        index = value.indexOf("=");
        if (index == -1) {
            throw new UtilsException("Entry " + key + (String)prop.get(key) + " definita con un formato scorretto [=] (vedi jakarta.activation.MailcapCommandMap api)");
        }
        value = value.substring(index + 1, value.length());
        value = value.trim();
        mimeTypes.put(keyMime, value);
        if (!typesRegistrati.contains(keyMime)) {
            if (forceLoadMailcap) {
                MailcapActivationReader.logInfo(log, "DataContentHandler per mime-type " + keyMime + " non risulta registrato, caricamento in corso ...");
                URL url = MailcapActivationReader.class.getResource(MAILCAP);
                MailcapActivationReader.logInfo(log, "Posizione 'forceLoadMailcap' '/META-INF/mailcap' in classloader: " + String.valueOf(url));
                byte[] mailcap = Utilities.getAsByteArray(url);
                if (debug) {
                    MailcapActivationReader.logInfo(log, "Contenuto 'forceLoadMailcap' '/META-INF/mailcap': " + new String(mailcap));
                }
                dchManager.addMimeTypesIntoMailcap(mailcap);
            } else {
                MailcapActivationReader.logError(log, "DataContentHandler per mime-type " + keyMime + " non risulta registrato");
            }
        }
        MailcapActivationReader.logInfo(log, "Caricato nel core di OpenSPCoop (!!differente dal MailcapEngine!!) DataContentHandler per mime-type " + keyMime + " gestito tramite la classe " + value);
    }

    public static boolean existsDataContentHandler(String mimeType) {
        return mimeTypes.containsKey(mimeType);
    }
}

