/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.id.IUniqueIdentifier;
import org.openspcoop2.utils.id.IUniqueIdentifierGenerator;
import org.openspcoop2.utils.id.UniqueIdentifierException;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class UniqueIdentifierManager {
    private static boolean useThreadLocal = false;
    private static String className_threadLocal = null;
    private static Object[] args_threadLocal = null;
    private static final ThreadLocal<IUniqueIdentifierGenerator> uniqueIdentifierGenerator_threadLocal = new ThreadLocal<IUniqueIdentifierGenerator>(){

        @Override
        protected IUniqueIdentifierGenerator initialValue() {
            try {
                IUniqueIdentifierGenerator uniqueIdentifierGenerator = (IUniqueIdentifierGenerator)Loader.getInstance().newInstance(className_threadLocal);
                uniqueIdentifierGenerator.init(args_threadLocal);
                return uniqueIdentifierGenerator;
            }
            catch (Exception e) {
                throw new RuntimeException("Riscontrato errore durante il caricamento del manager specificato [class:" + className_threadLocal + "]: " + e.getMessage(), e);
            }
        }
    };
    private static IUniqueIdentifierGenerator uniqueIdentifierGenerator_staticInstance;
    private static boolean bufferSupported_staticInstance;
    private static volatile boolean generazioneUIDDisabilitata;

    public static boolean isGenerazioneUIDDisabilitata() {
        return generazioneUIDDisabilitata;
    }

    public static void disabilitaGenerazioneUID() {
        generazioneUIDDisabilitata = true;
    }

    public static boolean isInitialized() {
        if (!generazioneUIDDisabilitata) {
            if (useThreadLocal) {
                return className_threadLocal != null;
            }
            return uniqueIdentifierGenerator_staticInstance != null;
        }
        return false;
    }

    public static synchronized void inizializzaUniqueIdentifierManager(boolean useThreadLocal, String className, Object ... o) throws UniqueIdentifierException {
        UniqueIdentifierManager.inizializzaUniqueIdentifierManager(false, useThreadLocal, className, o);
    }

    public static synchronized void inizializzaUniqueIdentifierManager(boolean forceInitManager, boolean useThreadLocal, String className, Object ... o) throws UniqueIdentifierException {
        UniqueIdentifierManager.useThreadLocal = useThreadLocal;
        if (useThreadLocal) {
            if (className_threadLocal == null || forceInitManager) {
                className_threadLocal = className;
                args_threadLocal = o;
                try {
                    IUniqueIdentifierGenerator uniqueIdentifierGenerator = (IUniqueIdentifierGenerator)Loader.getInstance().newInstance(className);
                    bufferSupported_staticInstance = uniqueIdentifierGenerator.isBufferSupperted();
                }
                catch (Exception e) {
                    throw new RuntimeException("Riscontrato errore durante il caricamento del manager specificato [class:" + className_threadLocal + "]: " + e.getMessage(), e);
                }
            }
        } else if (uniqueIdentifierGenerator_staticInstance == null || forceInitManager) {
            try {
                uniqueIdentifierGenerator_staticInstance = (IUniqueIdentifierGenerator)Loader.getInstance().newInstance(className);
                uniqueIdentifierGenerator_staticInstance.init(o);
                bufferSupported_staticInstance = uniqueIdentifierGenerator_staticInstance.isBufferSupperted();
            }
            catch (Exception e) {
                throw new UniqueIdentifierException("Riscontrato errore durante il caricamento del manager specificato [class:" + className + "]: " + e.getMessage(), e);
            }
        }
    }

    public static boolean isBufferSupported() {
        return bufferSupported_staticInstance;
    }

    public static IUniqueIdentifier newUniqueIdentifier() throws UniqueIdentifierException {
        if (generazioneUIDDisabilitata) {
            return null;
        }
        try {
            if (useThreadLocal) {
                return uniqueIdentifierGenerator_threadLocal.get().newID();
            }
            if (uniqueIdentifierGenerator_staticInstance == null) {
                Logger log = LoggerWrapperFactory.getLogger(UniqueIdentifierManager.class);
                log.error("UniqueIdentifierManager non inizializzato");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager(false, "org.openspcoop.utils.id.ClusterIdentifier", new Object[0]);
            }
            return uniqueIdentifierGenerator_staticInstance.newID();
        }
        catch (Exception e) {
            throw new UniqueIdentifierException("UniqueIdentifierManager.newID() non riuscita", e);
        }
    }

    public static IUniqueIdentifier newUniqueIdentifier(boolean useBuffer) throws UniqueIdentifierException {
        if (generazioneUIDDisabilitata) {
            return null;
        }
        try {
            if (useThreadLocal) {
                return uniqueIdentifierGenerator_threadLocal.get().newID(useBuffer);
            }
            if (uniqueIdentifierGenerator_staticInstance == null) {
                Logger log = LoggerWrapperFactory.getLogger(UniqueIdentifierManager.class);
                log.error("UniqueIdentifierManager non inizializzato");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager(false, "org.openspcoop.utils.id.ClusterIdentifier", new Object[0]);
            }
            return uniqueIdentifierGenerator_staticInstance.newID(useBuffer);
        }
        catch (Exception e) {
            throw new UniqueIdentifierException("UniqueIdentifierManager.newID(useBuffer) non riuscita", e);
        }
    }

    public static IUniqueIdentifier convertFromString(String value) throws UniqueIdentifierException {
        if (generazioneUIDDisabilitata) {
            return null;
        }
        try {
            if (useThreadLocal) {
                return uniqueIdentifierGenerator_threadLocal.get().convertFromString(value);
            }
            if (uniqueIdentifierGenerator_staticInstance == null) {
                Logger log = LoggerWrapperFactory.getLogger(UniqueIdentifierManager.class);
                log.error("UniqueIdentifierManager non inizializzato");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager(false, "org.openspcoop.utils.id.ClusterIdentifier", new Object[0]);
            }
            return uniqueIdentifierGenerator_staticInstance.convertFromString(value);
        }
        catch (Exception e) {
            throw new UniqueIdentifierException("UniqueIdentifierManager.convertFromString() non riuscita", e);
        }
    }

    public static void removeThreadLocal() throws UniqueIdentifierException {
        if (useThreadLocal) {
            uniqueIdentifierGenerator_threadLocal.remove();
        }
    }

    static {
        generazioneUIDDisabilitata = false;
    }
}

