/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.id.IUniqueIdentifier;
import org.openspcoop2.utils.id.UniqueIdentifierException;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.resources.AbstractBaseThread;
import org.slf4j.Logger;

public class UniversallyUniqueIdentifierProducer
extends AbstractBaseThread {
    private static UniversallyUniqueIdentifierProducer staticInstance;
    private ArrayBlockingQueue<IUniqueIdentifier> idsQueue;
    private Logger log;

    public static synchronized void initialize(int buffer, Logger log) {
        if (staticInstance == null) {
            staticInstance = new UniversallyUniqueIdentifierProducer(buffer, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UniversallyUniqueIdentifierProducer getInstance() {
        if (staticInstance != null) return staticInstance;
        Class<UniversallyUniqueIdentifierProducer> clazz = UniversallyUniqueIdentifierProducer.class;
        synchronized (UniversallyUniqueIdentifierProducer.class) {
            if (staticInstance != null) return staticInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    private UniversallyUniqueIdentifierProducer(int buffer, Logger log) {
        this.setTimeout(-1);
        this.idsQueue = new ArrayBlockingQueue(buffer);
        this.log = log;
        String msg = "Started UUID producer with buffer size: " + buffer;
        this.log.info(msg);
    }

    public IUniqueIdentifier newUniqueIdentifier() throws UniqueIdentifierException {
        try {
            return this.idsQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UniqueIdentifierException(e);
        }
        catch (Exception e) {
            throw new UniqueIdentifierException(e);
        }
    }

    @Override
    protected void process() {
        try {
            IUniqueIdentifier newUUID = UniqueIdentifierManager.newUniqueIdentifier(false);
            while (!this.isStop()) {
                try {
                    boolean insert = this.idsQueue.offer(newUUID, 1000L, TimeUnit.MILLISECONDS);
                    if (!insert) continue;
                    break;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.log.error("UniversallyUniqueIdentifierProducer - generation failed: " + t.getMessage(), (Throwable)t);
            Utilities.sleep(5000L);
        }
    }
}

