/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.apache.serial;

import java.io.Serializable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.apache.AbstractStringIdentifierGenerator;
import org.openspcoop2.utils.id.apache.serial.MaxReachedException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class AlphanumericGenerator
extends AbstractStringIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060120L;
    private volatile boolean wrapping = true;
    private char[] count = null;
    private volatile char START_CHAR = (char)97;
    private volatile char END_CHAR = (char)122;
    private volatile boolean upperChar = true;
    private volatile boolean lowerChar = true;
    private volatile char START_DIGIT = (char)48;
    private boolean nonAncoraUtilizzato = true;
    private volatile char END_DIGIT = (char)57;

    public void setStartChar(char startChar) throws UtilsException {
        try {
            if (!RegularExpressionEngine.isMatch("" + startChar, "^[a-z]$")) {
                throw new UtilsException("Deve essere fornito una lettera [a-z]");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        if (startChar > this.END_CHAR) {
            throw new UtilsException("Deve essere fornito una lettera di posizione minore dell'attuale carattere di fine: [" + this.END_CHAR + "]");
        }
        this.START_CHAR = startChar;
    }

    public void setEndChar(char endChar) throws UtilsException {
        try {
            if (!RegularExpressionEngine.isMatch("" + endChar, "^[a-z]$")) {
                throw new UtilsException("Deve essere fornito una lettera [a-z]");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        if (endChar < this.START_CHAR) {
            throw new UtilsException("Deve essere fornito una lettera di posizione maggiore dell'attuale carattere di inizio: [" + this.START_CHAR + "]");
        }
        this.END_CHAR = endChar;
    }

    public void setUpperChar(boolean upperChar) throws UtilsException {
        if (!upperChar && !this.lowerChar) {
            throw new UtilsException("Almeno una combinazione tra maiuscolo e minuscolo deve essere permessa");
        }
        this.upperChar = upperChar;
    }

    public void setLowerChar(boolean lowerChar) throws UtilsException {
        if (!lowerChar && !this.upperChar) {
            throw new UtilsException("Almeno una combinazione tra maiuscolo e minuscolo deve essere permessa");
        }
        this.lowerChar = lowerChar;
    }

    public void setStartDigit(char startDigit) throws UtilsException {
        if (!Character.isDigit(startDigit)) {
            throw new UtilsException("Deve essere fornito un numero");
        }
        if (startDigit > this.END_DIGIT) {
            throw new UtilsException("Deve essere fornito un numero di posizione minore dell'attuale numero di fine: [" + this.END_DIGIT + "]");
        }
        this.START_DIGIT = startDigit;
        if (this.nonAncoraUtilizzato) {
            for (int i = 0; i < this.count.length; ++i) {
                this.count[i] = this.START_DIGIT;
            }
        }
    }

    public void setEndDigit(char endDigit) throws UtilsException {
        if (!Character.isDigit(endDigit)) {
            throw new UtilsException("Deve essere fornito un numero");
        }
        if (endDigit < this.START_DIGIT) {
            throw new UtilsException("Deve essere fornito un numero di posizione maggiore dell'attuale numero di inizio: [" + this.START_DIGIT + "]");
        }
        this.END_DIGIT = endDigit;
    }

    public void setStartEndChar(char startChar, char endChar) throws UtilsException {
        if (startChar > endChar) {
            throw new UtilsException("Deve essere fornito un valore di start minore del valore di end]");
        }
        char oldStart = this.START_CHAR;
        char oldEnd = this.END_CHAR;
        try {
            this.START_CHAR = startChar;
            this.END_CHAR = endChar;
            this.setStartChar(startChar);
            this.setEndChar(endChar);
        }
        catch (Exception e) {
            this.START_CHAR = oldStart;
            this.END_CHAR = oldEnd;
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void setStartEndDigit(char startDigit, char endDigit) throws UtilsException {
        if (startDigit > endDigit) {
            throw new UtilsException("Deve essere fornito un valore di start minore del valore di end]");
        }
        char oldStart = this.START_DIGIT;
        char oldEnd = this.END_DIGIT;
        try {
            this.START_DIGIT = startDigit;
            this.END_DIGIT = endDigit;
            this.setStartDigit(startDigit);
            this.setEndDigit(endDigit);
        }
        catch (Exception e) {
            this.START_DIGIT = oldStart;
            this.END_DIGIT = oldEnd;
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public AlphanumericGenerator(boolean wrap) {
        this(wrap, 15);
    }

    public AlphanumericGenerator(boolean wrap, int size) {
        this.wrapping = wrap;
        if (size < 1) {
            throw new IllegalArgumentException("The size must be at least one");
        }
        this.count = new char[size];
        for (int i = 0; i < size; ++i) {
            this.count[i] = this.START_DIGIT;
        }
    }

    public AlphanumericGenerator(boolean wrap, String initialValue) {
        this.wrapping = wrap;
        this.count = initialValue.toCharArray();
        this.nonAncoraUtilizzato = false;
        char upperStartChar = ("" + this.START_CHAR).toUpperCase().charAt(0);
        char lowerStartChar = ("" + this.START_CHAR).toLowerCase().charAt(0);
        char upperEndChar = ("" + this.END_CHAR).toUpperCase().charAt(0);
        char lowerEndChar = ("" + this.END_CHAR).toLowerCase().charAt(0);
        for (int i = 0; i < this.count.length; ++i) {
            char ch = this.count[i];
            if (ch >= this.START_DIGIT && ch <= this.END_DIGIT || this.lowerChar && ch >= lowerStartChar && ch <= lowerEndChar || this.upperChar && ch >= upperStartChar && ch <= upperEndChar) continue;
            throw new IllegalArgumentException("character " + this.count[i] + " is not valid");
        }
    }

    @Override
    public long maxLength() {
        return this.count.length;
    }

    @Override
    public long minLength() {
        return this.count.length;
    }

    public boolean isWrap() {
        return this.wrapping;
    }

    public void setWrap(boolean wrap) {
        this.wrapping = wrap;
    }

    public int getSize() {
        return this.count.length;
    }

    @Override
    public synchronized String nextStringIdentifier() throws MaxReachedException {
        this.nonAncoraUtilizzato = false;
        char upperStartChar = ("" + this.START_CHAR).toUpperCase().charAt(0);
        char lowerStartChar = ("" + this.START_CHAR).toLowerCase().charAt(0);
        char upperEndChar = ("" + this.END_CHAR).toUpperCase().charAt(0);
        char lowerEndChar = ("" + this.END_CHAR).toLowerCase().charAt(0);
        for (int i = this.count.length - 1; i >= 0; --i) {
            if (this.count[i] == this.END_DIGIT) {
                this.count[i] = this.lowerChar ? lowerStartChar : upperStartChar;
                i = -1;
                continue;
            }
            if (this.lowerChar && this.count[i] == lowerEndChar) {
                if (i == 0 && !this.wrapping && !this.upperChar) {
                    throw new MaxReachedException("The maximum number of identifiers has been reached");
                }
                if (this.upperChar) {
                    this.count[i] = upperStartChar;
                    i = -1;
                    continue;
                }
                this.count[i] = this.START_DIGIT;
                continue;
            }
            if (this.upperChar && this.count[i] == upperEndChar) {
                if (i == 0 && !this.wrapping) {
                    throw new MaxReachedException("The maximum number of identifiers has been reached");
                }
                this.count[i] = this.START_DIGIT;
                continue;
            }
            int n = i;
            this.count[n] = (char)(this.count[n] + '\u0001');
            i = -1;
        }
        return new String(this.count);
    }
}

