/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.serial;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.ApacheGeneratorConfiguration;
import org.openspcoop2.utils.id.ApacheIdentifierGenerator;
import org.openspcoop2.utils.id.apache.serial.EnumTypeGenerator;
import org.openspcoop2.utils.id.apache.serial.MaxReachedException;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorBuffer;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class IDSerialGenerator_alphanumeric {
    private static SecureRandom _rnd = null;

    private static synchronized void initRandom() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
    }

    private static Random getRandom() {
        if (_rnd == null) {
            IDSerialGenerator_alphanumeric.initRandom();
        }
        return _rnd;
    }

    public static String generate(Connection conDB, TipiDatabase tipoDatabase, IDSerialGeneratorParameter param, Logger log, InfoStatistics infoStatistics) throws UtilsException {
        String msgError;
        String columnProtocollo;
        String columnPrg;
        String columnInfoAssociata;
        ApacheGeneratorConfiguration generatorConfig = new ApacheGeneratorConfiguration();
        generatorConfig.setEnableLowerCaseLetter(true);
        generatorConfig.setEnableUpperCaseLetter(true);
        generatorConfig.setWrap(param.isWrap());
        generatorConfig.setType(EnumTypeGenerator.ALPHANUMERIC);
        long attesaAttivaJDBC = param.getSerializableTimeWaitMs();
        int checkIntervalloJDBC = param.getSerializableNextIntervalTimeMs();
        String protocollo = param.getProtocollo();
        String progressivoTmp = null;
        boolean idBuildOK = false;
        long scadenzaWhile = DateManager.getTimeMillis() + attesaAttivaJDBC;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        int iteration = 0;
        ArrayList<String> messageException = new ArrayList<String>();
        String table = param.getTableName();
        if (table == null) {
            table = param.getInformazioneAssociataAlProgressivo() != null ? "ID_MESSAGGIO_RELATIVO_PRG" : "ID_MESSAGGIO_PRG";
        }
        if ((columnInfoAssociata = param.getColumnRelativeInfo()) == null) {
            columnInfoAssociata = "INFO_ASSOCIATA";
        }
        if ((columnPrg = param.getColumnPrg()) == null) {
            columnPrg = "PROGRESSIVO";
        }
        if ((columnProtocollo = param.getColumnProtocol()) == null) {
            columnProtocollo = "PROTOCOLLO";
        }
        boolean maxValueAndWrapDisabled = false;
        ArrayList<String> valuesGenerated = new ArrayList<String>();
        boolean rowNotExistsAndSerializableLevelNotFound = false;
        while (!(maxValueAndWrapDisabled || rowNotExistsAndSerializableLevelNotFound || idBuildOK || DateManager.getTimeMillis() >= scadenzaWhile)) {
            String valueFromBuffer;
            valuesGenerated = new ArrayList();
            ++iteration;
            if (param.getSizeBuffer() > 1 && (valueFromBuffer = IDSerialGeneratorBuffer.nextValue(IDSerialGenerator_alphanumeric.class, param.getInformazioneAssociataAlProgressivo())) != null) {
                return valueFromBuffer;
            }
            progressivoTmp = null;
            Statement pstmt = null;
            Statement pstmtInsert = null;
            ResultSet rs = null;
            try {
                ISQLQueryObject sqlGet = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                sqlGet.addSelectField(columnPrg);
                sqlGet.addFromTable(table);
                sqlGet.setANDLogicOperator(true);
                sqlGet.addWhereCondition(columnProtocollo + "=?");
                if (param.getInformazioneAssociataAlProgressivo() != null) {
                    sqlGet.addWhereCondition(columnInfoAssociata + "=?");
                }
                sqlGet.setSelectForUpdate(true);
                StringBuilder query = new StringBuilder();
                query.append(sqlGet.createSQLQuery());
                pstmt = conDB.prepareStatement(query.toString());
                pstmt.setString(1, protocollo);
                if (param.getInformazioneAssociataAlProgressivo() != null) {
                    pstmt.setString(2, param.getInformazioneAssociataAlProgressivo());
                }
                if ((rs = pstmt.executeQuery()) == null) {
                    pstmt.close();
                    log.error("Creazione serial non riuscita: ResultSet is null?");
                    throw new UtilsException("Creazione serial non riuscita: ResultSet is null?");
                }
                boolean exist = rs.next();
                if (!exist && !JDBCUtilities.isTransactionIsolationSerializable(conDB.getTransactionIsolation(), tipoDatabase)) {
                    rowNotExistsAndSerializableLevelNotFound = true;
                    continue;
                }
                if (exist) {
                    progressivoTmp = rs.getString(columnPrg);
                    for (int i = 0; i < param.getSizeBuffer(); ++i) {
                        try {
                            ApacheIdentifierGenerator generator = new ApacheIdentifierGenerator();
                            generatorConfig.setInitialStringValue(progressivoTmp);
                            generator.initialize(generatorConfig);
                            progressivoTmp = generator.newID().getAsString();
                            valuesGenerated.add(progressivoTmp);
                            continue;
                        }
                        catch (Exception eMaxRaggiunto) {
                            if (valuesGenerated.size() > 0) break;
                            throw eMaxRaggiunto;
                        }
                    }
                }
                rs.close();
                pstmt.close();
                if (!exist) {
                    ApacheIdentifierGenerator generator = new ApacheIdentifierGenerator();
                    generatorConfig.setSize(param.getSize());
                    generator.initialize(generatorConfig);
                    progressivoTmp = generator.newID().getAsString();
                    StringBuilder queryInsert = new StringBuilder();
                    ISQLQueryObject sqlInsert = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                    sqlInsert.addInsertTable(table);
                    sqlInsert.addInsertField(columnPrg, "?");
                    sqlInsert.addInsertField(columnProtocollo, "?");
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        sqlInsert.addInsertField(columnInfoAssociata, "?");
                    }
                    queryInsert.append(sqlInsert.createSQLInsert());
                    pstmtInsert = conDB.prepareStatement(queryInsert.toString());
                    pstmtInsert.setString(1, progressivoTmp);
                    pstmtInsert.setString(2, protocollo);
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        pstmtInsert.setString(3, param.getInformazioneAssociataAlProgressivo());
                    }
                    pstmtInsert.execute();
                    pstmtInsert.close();
                    valuesGenerated.add(progressivoTmp);
                } else {
                    StringBuilder queryUpdate = new StringBuilder();
                    ISQLQueryObject sqlUpdate = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
                    sqlUpdate.addUpdateTable(table);
                    sqlUpdate.addUpdateField(columnPrg, "?");
                    sqlUpdate.setANDLogicOperator(true);
                    sqlUpdate.addWhereCondition(columnProtocollo + "=?");
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        sqlUpdate.addWhereCondition(columnInfoAssociata + "=?");
                    }
                    queryUpdate.append(sqlUpdate.createSQLUpdate());
                    pstmtInsert = conDB.prepareStatement(queryUpdate.toString());
                    pstmtInsert.setString(1, progressivoTmp);
                    pstmtInsert.setString(2, protocollo);
                    if (param.getInformazioneAssociataAlProgressivo() != null) {
                        pstmtInsert.setString(3, param.getInformazioneAssociataAlProgressivo());
                    }
                    pstmtInsert.execute();
                    pstmtInsert.close();
                }
                conDB.commit();
                idBuildOK = true;
            }
            catch (Throwable e) {
                ps.append("********* Exception Iteration [" + iteration + "] **********\n");
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "NULL-MESSAGE";
                }
                if (messageException.contains(msg)) {
                    ps.append("Message already occurs: " + msg);
                } else {
                    e.printStackTrace(ps);
                    messageException.add(msg);
                }
                ps.append("\n\n");
                if (infoStatistics != null) {
                    infoStatistics.addErrorSerializableAccess(e);
                }
                if (e != null && Utilities.existsInnerException(e, MaxReachedException.class)) {
                    maxValueAndWrapDisabled = true;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtInsert != null) {
                        pstmtInsert.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    conDB.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (idBuildOK) continue;
            try {
                int intervalloDestro = checkIntervalloJDBC;
                if (param.isSerializableNextIntervalTimeMsIncrementMode() && (intervalloDestro += iteration * param.getSerializableNextIntervalTimeMsIncrement()) > param.getMaxSerializableNextIntervalTimeMs()) {
                    intervalloDestro = param.getMaxSerializableNextIntervalTimeMs();
                }
                int sleep = IDSerialGenerator_alphanumeric.getRandom().nextInt(intervalloDestro);
                Utilities.sleep(sleep);
            }
            catch (Exception exception) {}
        }
        try {
            if (ps != null) {
                ps.flush();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception pstmt) {
            // empty catch block
        }
        if (maxValueAndWrapDisabled) {
            msgError = "Max Value of identifier has been reached";
            log.error(msgError + ": " + out.toString());
            throw new UtilsException(msgError);
        }
        if (rowNotExistsAndSerializableLevelNotFound) {
            msgError = "Raw not exists and serializable level is disabled";
            log.error(msgError);
            throw new UtilsException(msgError);
        }
        if (!idBuildOK || progressivoTmp == null) {
            msgError = "Creazione serial non riuscita: l'accesso serializable non ha permesso la creazione del numero sequenziale";
            log.error(msgError + ": " + out.toString());
            throw new UtilsException(msgError);
        }
        String vRet = (String)valuesGenerated.remove(0);
        if (valuesGenerated.size() > 0) {
            IDSerialGeneratorBuffer.putAll(valuesGenerated, IDSerialGenerator_alphanumeric.class, param.getInformazioneAssociataAlProgressivo());
        }
        return vRet;
    }
}

