/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.serial.test;

import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.id.serial.IDSerialGenerator;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorType;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.id.serial.test.ClientTestThread;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.slf4j.Logger;

public class ClientTest {
    private static boolean systemOut = true;
    static int ID_GENERATI_PER_THREAD = 100;
    static int THREADS = 10;
    static boolean DEBUG = false;
    static Logger log = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String sizeBufferParam;
        String timeWait;
        String debugParam;
        String numIdsForThread;
        String numThreads;
        String driverJdbcCustom;
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        File logFile = File.createTempFile("runIdSerialTest_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%m %n");
        log = LoggerWrapperFactory.getLogger(ClientTest.class);
        DateManager.initializeDataManager(SystemDate.class.getName(), new Properties(), log);
        TipiDatabase tipoDatabase = null;
        if (args.length > 0 && !"${tipoDatabase}".equals(args[0].trim())) {
            tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        }
        if (tipoDatabase == null) {
            throw new Exception("TipoDatabase non fornito");
        }
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        int timeWaitMs = 60000;
        int sizeBuffer = 1;
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        if (args.length > 4 && !"${driverJdbc}".equals(driverJdbcCustom = args[4].trim())) {
            driver = driverJdbcCustom;
        }
        if (args.length > 5 && !"${threads}".equals(numThreads = args[5].trim())) {
            try {
                THREADS = Integer.parseInt(numThreads);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'threads' with wrong format (value:" + numThreads + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 6 && !"${idsForThread}".equals(numIdsForThread = args[6].trim())) {
            try {
                ID_GENERATI_PER_THREAD = Integer.parseInt(numIdsForThread);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'idsForThread' with wrong format (value:" + numIdsForThread + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 7 && !"${printDebug}".equals(debugParam = args[7].trim())) {
            try {
                DEBUG = Boolean.parseBoolean(debugParam);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'printDebug' with wrong format (value:" + debugParam + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 8 && !"${timeWaitMs}".equals(timeWait = args[8].trim())) {
            try {
                timeWaitMs = Integer.parseInt(timeWait);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'timeWaitMs' with wrong format (value:" + timeWait + "): " + e.getMessage(), e);
            }
        }
        if (args.length > 9 && !"${sizeBuffer}".equals(sizeBufferParam = args[9].trim())) {
            try {
                sizeBuffer = Integer.parseInt(sizeBufferParam);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'sizeBuffer' with wrong format (value:" + sizeBufferParam + "): " + e.getMessage(), e);
            }
        }
        System.out.println("URL:" + url);
        System.out.println("UserName:" + userName);
        System.out.println("Password:" + password);
        System.out.println("DriverJDBC:" + driver);
        System.out.println("Threads:" + THREADS);
        System.out.println("Id generati per thread:" + ID_GENERATI_PER_THREAD);
        System.out.println("Debug:" + DEBUG);
        System.out.println("TimeWaitMs:" + timeWaitMs);
        System.out.println("SizeBuffer:" + sizeBuffer);
        ClassLoaderUtilities.newInstance(driver);
        Connection con = null;
        ArrayList<Connection> conThreads = new ArrayList<Connection>();
        Statement stmtInsert = null;
        try {
            con = DriverManager.getConnection(url, userName, password);
            InfoStatistics infoStat = new InfoStatistics();
            ClientTest.clear(infoStat, con);
            for (int i = 0; i < THREADS; ++i) {
                conThreads.add(DriverManager.getConnection(url, userName, password));
            }
            IDSerialGenerator serialGenerator = new IDSerialGenerator(infoStat);
            IDSerialGeneratorParameter serialGeneratorParameter = new IDSerialGeneratorParameter("ApplicationContext");
            serialGeneratorParameter.setSerializableTimeWaitMs(timeWaitMs);
            serialGeneratorParameter.setSizeBuffer(sizeBuffer);
            boolean SERIALIZABLE = true;
            boolean READ_COMMITTED = false;
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(false);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 1. Progressivo numerico (SERIALIZABLE)");
            serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 1. Progressivo numerico (READ_COMMITTED)");
            serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(false);
            serialGeneratorParameter.setMaxValue(10L);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 2. Progressivo numerico con max 10 (SERIALIZABLE)");
            boolean foundError = false;
            try {
                serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 2. Progressivo numerico con max 20 (READ_COMMITTED)");
            foundError = false;
            try {
                serialGeneratorParameter.setMaxValue(20L);
                serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(true);
            serialGeneratorParameter.setMaxValue(10L);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 3. Progressivo numerico con max 10 e wrap (SERIALIZABLE)");
            serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 3. Progressivo numerico con max 10 e wrap (READ_COMMITTED)");
            serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(false);
            serialGeneratorParameter.setMaxValue(Long.MAX_VALUE);
            serialGeneratorParameter.setInformazioneAssociataAlProgressivo("Associata");
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 4. Progressivo numerico (InfoAssociata) (SERIALIZABLE)");
            serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 4. Progressivo numerico (InfoAssociata) (READ_COMMITTED)");
            serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(false);
            serialGeneratorParameter.setMaxValue(10L);
            serialGeneratorParameter.setInformazioneAssociataAlProgressivo("Associata");
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 5. Progressivo numerico con max 10 (InfoAssociata) (SERIALIZABLE)");
            foundError = false;
            try {
                serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 5. Progressivo numerico con max 20 (InfoAssociata) (READ_COMMITTED)");
            foundError = false;
            try {
                serialGeneratorParameter.setMaxValue(20L);
                serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(true);
            serialGeneratorParameter.setMaxValue(10L);
            serialGeneratorParameter.setInformazioneAssociataAlProgressivo("Associata");
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 6. Progressivo numerico con max 10 e wrap (SERIALIZABLE)");
            serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 6. Progressivo numerico con max 10 e wrap (READ_COMMITTED)");
            serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, true, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.ALFANUMERICO);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(false);
            serialGeneratorParameter.setSize(1);
            serialGeneratorParameter.setInformazioneAssociataAlProgressivo(null);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 7. Progressivo alfanumerico con size 1 (SERIALIZABLE)");
            foundError = false;
            try {
                serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 7. Progressivo alfanumerico con size 1 (READ_COMMITTED)");
            foundError = false;
            try {
                serialGeneratorParameter.setSize(1);
                serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.ALFANUMERICO);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(true);
            serialGeneratorParameter.setSize(1);
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 8. Progressivo numerico con size 1 e wrap (SERIALIZABLE)");
            serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 8. Progressivo numerico con size 1 e wrap (READ_COMMITTED)");
            serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.ALFANUMERICO);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(false);
            serialGeneratorParameter.setSize(1);
            serialGeneratorParameter.setInformazioneAssociataAlProgressivo("InfoAssociata");
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 9. Progressivo alfanumerico con size 1 (InfoAssociata) (SERIALIZABLE)");
            foundError = false;
            try {
                serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 9. Progressivo alfanumerico con size 1 (InfoAssociata) (READ_COMMITTED)");
            foundError = false;
            try {
                serialGeneratorParameter.setSize(1);
                serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
                ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            }
            catch (Exception e) {
                foundError = true;
                ClientTest.info(log, systemOut, "Errore Atteso: " + e.getMessage());
            }
            if (!foundError) {
                throw new Exception("Atteso errore di max value, errore non rilevato");
            }
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            ClientTest.clear(infoStat, con);
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.ALFANUMERICO);
            serialGenerator.clearBuffer(serialGeneratorParameter);
            serialGeneratorParameter.setWrap(true);
            serialGeneratorParameter.setSize(1);
            serialGeneratorParameter.setInformazioneAssociataAlProgressivo("InfoAssociata");
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 10. Progressivo numerico con size 1 e wrap (InfoAssociata) (SERIALIZABLE)");
            serialGeneratorParameter.setSerializableLevel(SERIALIZABLE);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
            ClientTestThread.reset();
            infoStat.clear();
            ClientTest.info(log, systemOut, "\n\n==========================================");
            ClientTest.info(log, systemOut, "Test 10. Progressivo numerico con size 1 e wrap (InfoAssociata) (READ_COMMITTED)");
            serialGeneratorParameter.setSerializableLevel(READ_COMMITTED);
            ClientTest.test(serialGenerator, serialGeneratorParameter, conThreads, log, false, DEBUG, tipoDatabase);
            ClientTest.printInfos(infoStat);
        }
        finally {
            try {
                stmtInsert.close();
            }
            catch (Exception infoStat) {}
            try {
                con.close();
            }
            catch (Exception infoStat) {}
            for (int i = 0; i < THREADS; ++i) {
                try {
                    ((Connection)conThreads.get(i)).close();
                    continue;
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void info(Logger log, boolean systemOut, String msg) {
        log.info(msg);
        if (systemOut) {
            System.out.println(msg);
        }
    }

    private static void printInfos(InfoStatistics infoStat) {
        ClientTest.info(log, systemOut, "Numero di errori 'access serializable': " + infoStat.getErrorSerializableAccess());
        for (int i = 0; i < infoStat.getExceptionOccurs().size(); ++i) {
            Throwable e = infoStat.getExceptionOccurs().get(i);
            ClientTest.info(log, systemOut, "Errore-" + (i + 1) + " (occurs:" + infoStat.getNumber(e) + "): " + e.getMessage());
        }
    }

    private static void clear(InfoStatistics infoStat, Connection con) throws Exception {
        infoStat.clear();
        String delete = "delete from ID_MESSAGGIO_RELATIVO";
        Statement stmtDelete = con.createStatement();
        stmtDelete.execute(delete);
        stmtDelete.close();
        delete = "delete from ID_MESSAGGIO";
        stmtDelete = con.createStatement();
        stmtDelete.execute(delete);
        stmtDelete.close();
        delete = "delete from ID_MESSAGGIO_PRG";
        stmtDelete = con.createStatement();
        stmtDelete.execute(delete);
        stmtDelete.close();
        delete = "delete from ID_MESSAGGIO_RELATIVO_PRG";
        stmtDelete = con.createStatement();
        stmtDelete.execute(delete);
        stmtDelete.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(IDSerialGenerator serialGenerator, IDSerialGeneratorParameter param, List<Connection> conThreads, Logger log, boolean isNumber, boolean debug, TipiDatabase tipoDatabase) throws Exception {
        Date inizio = DateManager.getDate();
        ExecutorService threadsPool = Executors.newFixedThreadPool(conThreads.size());
        HashMap<CallSite, ClientTestThread> threads = new HashMap<CallSite, ClientTestThread>();
        boolean error = false;
        try {
            for (int i = 0; i < conThreads.size(); ++i) {
                ClientTestThread c = new ClientTestThread(serialGenerator, param, conThreads.get(i), isNumber, i, debug, tipoDatabase);
                threadsPool.execute(c);
                if (debug) {
                    log.info("Lanciato thread " + i);
                }
                threads.put((CallSite)((Object)("Thread-" + i)), c);
            }
            boolean terminated = false;
            while (!terminated) {
                if (debug) {
                    log.info("Attendo terminazione ...");
                }
                boolean tmpTerminated = true;
                for (int i = 0; i < conThreads.size(); ++i) {
                    ClientTestThread c = (ClientTestThread)threads.get("Thread-" + i);
                    if (c.isError()) {
                        error = true;
                    }
                    if (c.isFinished()) continue;
                    tmpTerminated = false;
                    break;
                }
                if (!tmpTerminated) {
                    Utilities.sleep(250L);
                    continue;
                }
                terminated = true;
            }
        }
        finally {
            log.info("Shutdown pool ...");
            threadsPool.shutdown();
            log.info("Shutdown pool ok");
        }
        Date fine = DateManager.getDate();
        long diff = fine.getTime() - inizio.getTime();
        log.info("Tempo impiegato: " + Utilities.convertSystemTimeIntoStringMillisecondi(diff, true));
        for (int i = 0; i < conThreads.size(); ++i) {
            ClientTestThread c = (ClientTestThread)threads.get("Thread-" + i);
            if (c.getValoriGenerati().size() > 0) {
                log.info("[Thread-" + i + "] ha generato " + c.getValoriGenerati().size() + " id. Ultimo: " + c.getValoriGenerati().get(c.getValoriGenerati().size() - 1));
            } else {
                log.info("[Thread-" + i + "] non ha generato id.");
            }
            if (!debug) continue;
            log.info("[Thread-" + i + "] ids generati: " + c.getValoriGenerati().toString());
        }
        log.info("Duplicati rilevati: " + ClientTestThread.isValoriDuplicati());
        log.info("Identificativi distinti complessivi generati: " + ClientTestThread.count());
        Collections.sort(ClientTestThread.getValoriDistintiGenerati());
        log.info("Identificativi: " + String.valueOf(ClientTestThread.getValoriDistintiGenerati()));
        if (error) {
            throw new Exception("Error occurs in threads");
        }
    }
}

