/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier.unblocked;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.utils.io.notifier.StreamingHandler;
import org.openspcoop2.utils.io.notifier.unblocked.AbstractStreamingHandler;
import org.openspcoop2.utils.io.notifier.unblocked.ResultStreamingHandler;
import org.slf4j.Logger;

public class PipedInputOutputStreamHandler
implements StreamingHandler {
    private AbstractStreamingHandler streamingHandler;
    private Future<ResultStreamingHandler> submitThreadExecution;
    private boolean retrieveResult = false;
    private ResultStreamingHandler resultThreadExecution;
    private String errorMessageThreadExecution;
    private Throwable exceptionThreadExecution;
    private Logger log;
    private ExecutorService executor;
    private boolean closed;
    private String idStreamingHandler;

    public PipedInputOutputStreamHandler(String id, AbstractStreamingHandler streamingHandler, Logger log) {
        this.log = log;
        this.streamingHandler = streamingHandler;
        this.idStreamingHandler = id;
        this.executor = Executors.newSingleThreadExecutor();
        this.submitThreadExecution = this.executor.submit(this.streamingHandler);
    }

    private void logError(String msg, Exception e) {
        this.log.error(msg, (Throwable)e);
    }

    @Override
    public String getID() {
        return this.idStreamingHandler;
    }

    @Override
    public void feed(byte b) throws IOException {
        byte[] buffer = new byte[1];
        this.feed(buffer);
    }

    @Override
    public void feed(byte[] b) throws IOException {
        try {
            if (!this.closed) {
                if (this.streamingHandler.isPrematureEnd()) {
                    this.end();
                } else {
                    this.streamingHandler.write(b);
                }
            }
        }
        catch (Throwable e) {
            this.log.error("[" + this.idStreamingHandler + "] feed error", e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void end() throws IOException {
        this.closeResources();
    }

    @Override
    public void closeResources() throws IOException {
        IOException ioException = null;
        if (!this.closed) {
            try {
                this.streamingHandler.close();
                this.executor.shutdown();
                this.awaitTermination();
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.log.error("[" + this.idStreamingHandler + "] end error", e);
                ioException = new IOException(e.getMessage());
            }
        }
        this.retrieveResult();
        this.releaseResource();
        if (ioException != null) {
            throw ioException;
        }
    }

    private void awaitTermination() {
        try {
            if (!this.executor.awaitTermination(20L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException pCaught) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void retrieveResult() {
        if (!this.retrieveResult) {
            try {
                if (this.submitThreadExecution != null) {
                    this.resultThreadExecution = this.submitThreadExecution.get();
                }
                this.errorMessageThreadExecution = this.streamingHandler.getError();
                this.exceptionThreadExecution = this.streamingHandler.getException();
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.errorMessageThreadExecution = e.getMessage();
                this.exceptionThreadExecution = e;
                this.log.error("[" + this.idStreamingHandler + "] end error", e);
            }
            finally {
                this.retrieveResult = true;
            }
        }
    }

    private void releaseResource() throws IOException {
        try {
            if (!this.closed) {
                this.streamingHandler.close();
                this.streamingHandler = null;
                this.submitThreadExecution = null;
                this.closed = true;
            }
        }
        catch (Exception e) {
            this.logError("[" + this.idStreamingHandler + "] closeResources error", e);
            throw new IOException(e.getMessage());
        }
    }

    private void finalizeResult() throws IOException {
        if (!this.closed) {
            this.closeResources();
        }
    }

    public ResultStreamingHandler getResult() throws IOException {
        this.finalizeResult();
        return this.resultThreadExecution;
    }

    public String getError() throws IOException {
        this.finalizeResult();
        return this.errorMessageThreadExecution;
    }

    public Throwable getException() throws IOException {
        this.finalizeResult();
        return this.exceptionThreadExecution;
    }
}

