/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier.unblocked;

import java.io.IOException;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedBytesStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedUnblockedStream;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class PipedUnblockedStreamFactory {
    public static final int SIZE_BUFFER = 65536;
    private static boolean usePipedBytesStreamImpl = true;
    private static boolean usePipedByteArrayOutputStreamImpl = false;
    private static String classNameImpl = null;

    private PipedUnblockedStreamFactory() {
    }

    public static void setImplementation(String className) {
        if (PipedBytesStream.class.getName().equals(className)) {
            usePipedBytesStreamImpl = true;
            usePipedByteArrayOutputStreamImpl = false;
            classNameImpl = null;
        } else if (PipedUnblockedStream.class.getName().equals(className)) {
            usePipedBytesStreamImpl = false;
            usePipedByteArrayOutputStreamImpl = true;
            classNameImpl = null;
        } else {
            usePipedBytesStreamImpl = false;
            usePipedByteArrayOutputStreamImpl = false;
            classNameImpl = className;
        }
    }

    public static IPipedUnblockedStream newPipedUnblockedStream(Logger log, long sizeBuffer, int timeoutMs, String source) throws IOException {
        try {
            IPipedUnblockedStream pipe = null;
            pipe = usePipedBytesStreamImpl ? new PipedBytesStream() : (usePipedByteArrayOutputStreamImpl ? new PipedUnblockedStream() : (IPipedUnblockedStream)new Loader().newInstance(classNameImpl));
            ((IPipedUnblockedStream)pipe).init(log, sizeBuffer, timeoutMs, source);
            return pipe;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }
}

