/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.AbstractNoReturnGeneratedKeyGenerator;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.DefaultKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;

public class HyperSQLKeyGenerator
extends AbstractNoReturnGeneratedKeyGenerator {
    public HyperSQLKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        super(connection, type);
    }

    @Override
    public String getSequenceQuery() throws KeyGeneratorException {
        Object sequence = null;
        Object table = null;
        switch (this.type.getType()) {
            case DEFAULT: {
                sequence = ((DefaultKeyGeneratorObject)this.type).getPrefix() + "_id_seq";
                table = ((DefaultKeyGeneratorObject)this.type).getTable() + "_init_seq";
                break;
            }
            case CUSTOM: {
                CustomKeyGeneratorObject c = (CustomKeyGeneratorObject)this.type;
                if (c.existsCustomTableObjectsForDatabaseType(TipiDatabase.HSQL)) {
                    sequence = c.getCustomTableObjectsForDatabaseType(TipiDatabase.HSQL).getSequenceName();
                    table = c.getCustomTableObjectsForDatabaseType(TipiDatabase.HSQL).getTableNameForInitSequence();
                    break;
                }
                sequence = c.getDefaultTableObjects().getSequenceName();
                table = c.getDefaultTableObjects().getTableNameForInitSequence();
                break;
            }
            default: {
                throw new KeyGeneratorException("Tipo di KeyGeneratorObjects non gestito: " + String.valueOf(this.type));
            }
        }
        return "SELECT NEXT VALUE FOR  " + (String)sequence + "  as nextval from " + (String)table;
    }
}

