/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class JDBCUtilities {
    private static final int SQL_SERVER_TRANSACTION_SNAPSHOT = 4096;

    private JDBCUtilities() {
    }

    public static void closePreparedStatement(Map<String, PreparedStatement> tablePstmt, Logger log) {
        if (tablePstmt != null && !tablePstmt.isEmpty()) {
            ArrayList<String> listKeys = new ArrayList<String>();
            for (String key : tablePstmt.keySet()) {
                listKeys.add(key);
            }
            Collections.sort(listKeys);
            for (int i = 0; i < listKeys.size(); ++i) {
                String key;
                key = (String)listKeys.get(i);
                PreparedStatement pstmt = tablePstmt.get(key);
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    String msg = "Utilities.closePreparedStatement error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + String.valueOf(e);
                    log.debug(msg, (Throwable)e);
                }
                tablePstmt.remove(key);
            }
        }
    }

    public static void executePreparedStatement(Map<String, PreparedStatement> tablePstmt) throws UtilsException {
        if (tablePstmt != null && !tablePstmt.isEmpty()) {
            ArrayList<String> listKeys = new ArrayList<String>();
            for (String key : tablePstmt.keySet()) {
                listKeys.add(key);
            }
            Collections.sort(listKeys);
            for (int i = 0; i < listKeys.size(); ++i) {
                String key;
                key = (String)listKeys.get(i);
                PreparedStatement pstmt = tablePstmt.get(key);
                try {
                    pstmt.execute();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.executePreparedStatement error: Riscontrato errore durante l'esecuzione della PreparedStatement [" + key + "]: " + String.valueOf(e), e);
                }
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.executePreparedStatement error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + String.valueOf(e), e);
                }
                tablePstmt.remove(key);
            }
        }
    }

    public static void addPreparedStatement(Map<String, PreparedStatement> pstmtSorgente, Map<String, PreparedStatement> pstmtDestinazione, Logger log) throws UtilsException {
        if (log != null) {
            // empty if block
        }
        if (pstmtSorgente != null && !pstmtSorgente.isEmpty()) {
            for (String key : pstmtSorgente.keySet()) {
                if (!pstmtDestinazione.containsKey(key)) {
                    pstmtDestinazione.put(key, pstmtSorgente.get(key));
                    continue;
                }
                try {
                    PreparedStatement pstmt = pstmtSorgente.get(key);
                    pstmt.close();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.closePreparedStatementGiaPresente error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + String.valueOf(e), e);
                }
            }
        }
    }

    public static void setSQLStringValue(PreparedStatement pstmt, int index, String value) throws SQLException {
        if (value != null && !"".equals(value)) {
            pstmt.setString(index, value);
        } else {
            pstmt.setString(index, null);
        }
    }

    public static boolean isTransactionIsolationNone(int transactionIsolationLevel) {
        return transactionIsolationLevel == 0;
    }

    public static boolean isTransactionIsolationReadUncommitted(int transactionIsolationLevel) {
        return transactionIsolationLevel == 1;
    }

    public static boolean isTransactionIsolationReadCommitted(int transactionIsolationLevel) {
        return transactionIsolationLevel == 2;
    }

    public static boolean isTransactionIsolationRepeatableRead(int transactionIsolationLevel) {
        return transactionIsolationLevel == 4;
    }

    public static boolean isTransactionIsolationSerializable(int transactionIsolationLevel) {
        return transactionIsolationLevel == 8;
    }

    public static boolean isTransactionIsolationSqlServerSnapshot(int transactionIsolationLevel) {
        return transactionIsolationLevel == 4096;
    }

    public static boolean isTransactionIsolationSerializable(int transactionIsolationLevel, TipiDatabase tipoDatabase) {
        if (tipoDatabase != null && TipiDatabase.SQLSERVER.equals((Object)tipoDatabase)) {
            return JDBCUtilities.isTransactionIsolationSqlServerSnapshot(transactionIsolationLevel);
        }
        return JDBCUtilities.isTransactionIsolationSerializable(transactionIsolationLevel);
    }

    public static void setTransactionIsolationSerializable(String tipoDatabase, Connection connection) throws SQLException {
        JDBCUtilities.setTransactionIsolationSerializable(TipiDatabase.toEnumConstant(tipoDatabase), connection);
    }

    public static void setTransactionIsolationSerializable(TipiDatabase tipoDatabase, Connection connection) throws SQLException {
        if (tipoDatabase != null && TipiDatabase.SQLSERVER.equals((Object)tipoDatabase)) {
            connection.setTransactionIsolation(4096);
        } else {
            connection.setTransactionIsolation(8);
        }
    }

    public static void addInformazioniDatabaseFromMetaData(Connection c, StringBuilder bf) throws SQLException {
        DatabaseMetaData dbMetaDati = c.getMetaData();
        if (dbMetaDati != null) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            try {
                String productName = dbMetaDati.getDatabaseProductName();
                bf.append("DatabaseProductName: " + productName);
                bf.append("\n");
            }
            catch (SQLException productName) {
                // empty catch block
            }
            try {
                String productVersion = dbMetaDati.getDatabaseProductVersion();
                bf.append("DatabaseProductVersion: " + productVersion);
                bf.append("\n");
            }
            catch (SQLException productVersion) {
                // empty catch block
            }
            try {
                int v = dbMetaDati.getDatabaseMajorVersion();
                bf.append("DatabaseMajorVersion: " + v);
                bf.append("\n");
            }
            catch (SQLException v) {
                // empty catch block
            }
            try {
                int v = dbMetaDati.getDatabaseMinorVersion();
                bf.append("DatabaseMinorVersion: " + v);
                bf.append("\n");
            }
            catch (SQLException v) {
                // empty catch block
            }
            JDBCUtilities.addInformazioniDatabaseFromMetaDataDriver(dbMetaDati, bf);
            try {
                String username = dbMetaDati.getUserName();
                bf.append("Username: " + username);
                bf.append("\n");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JDBCUtilities.addInformazioniDatabaseFromMetaDataCatalog(dbMetaDati, bf);
        }
    }

    private static void addInformazioniDatabaseFromMetaDataDriver(DatabaseMetaData dbMetaDati, StringBuilder bf) throws SQLException {
        try {
            String driverName = dbMetaDati.getDriverName();
            bf.append("DriverName: " + driverName);
            bf.append("\n");
        }
        catch (SQLException driverName) {
            // empty catch block
        }
        try {
            String productVersion = dbMetaDati.getDriverVersion();
            bf.append("DriverVersion: " + productVersion);
            bf.append("\n");
        }
        catch (SQLException productVersion) {
            // empty catch block
        }
        int v = dbMetaDati.getDriverMajorVersion();
        bf.append("DriverMajorVersion: " + v);
        bf.append("\n");
        v = dbMetaDati.getDriverMinorVersion();
        bf.append("DriverMinorVersion: " + v);
        bf.append("\n");
        try {
            v = dbMetaDati.getJDBCMajorVersion();
            bf.append("JDBCMajorVersion: " + v);
            bf.append("\n");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            v = dbMetaDati.getJDBCMinorVersion();
            bf.append("JDBCMinorVersion: " + v);
            bf.append("\n");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void addInformazioniDatabaseFromMetaDataCatalog(DatabaseMetaData dbMetaDati, StringBuilder bf) throws SQLException {
        try {
            ResultSet catalogs = dbMetaDati.getCatalogs();
            int size = 0;
            while (catalogs.next()) {
                ++size;
            }
            catalogs = dbMetaDati.getCatalogs();
            int index = 0;
            while (catalogs.next()) {
                if (size == 1) {
                    bf.append("Catalog: " + catalogs.getString(1));
                } else {
                    bf.append("Catalogs[" + index + "]: " + catalogs.getString(1));
                }
                bf.append("\n");
                ++index;
            }
            catalogs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResources(ResultSet rs, PreparedStatement stm) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeResources(ResultSet rs, Statement stm) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeResources(PreparedStatement stm) {
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeResources(Statement stm) {
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeConnection(Logger log, Connection connectionDB, boolean checkAutocommit, boolean checkIsClosed) throws SQLException {
        if (connectionDB != null) {
            if (checkAutocommit) {
                JDBCUtilities.checkAutocommit(log, connectionDB);
            }
            if (checkIsClosed) {
                JDBCUtilities.checkIsClosed(log, connectionDB);
            } else {
                connectionDB.close();
            }
        }
    }

    private static void checkAutocommit(Logger log, Connection connectionDB) throws SQLException {
        if (!connectionDB.getAutoCommit()) {
            String msg = "Connection detected in transaction mode";
            if (log == null) {
                log = LoggerWrapperFactory.getLogger(JDBCUtilities.class);
            }
            log.error(msg, (Throwable)new UtilsException(msg));
            connectionDB.setAutoCommit(true);
        }
    }

    private static void checkIsClosed(Logger log, Connection connectionDB) throws SQLException {
        if (connectionDB.isClosed()) {
            String msg = "Connection already closed detected";
            if (log == null) {
                log = LoggerWrapperFactory.getLogger(JDBCUtilities.class);
            }
            log.error(msg, (Throwable)new UtilsException(msg));
        } else {
            connectionDB.close();
        }
    }
}

