/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json._StructureNode;
import org.slf4j.Logger;

public abstract class AbstractUtils {
    private boolean prettyPrint;
    public static final String CAST_PREFIX = "cast(";
    public static final String CAST_SUFFIX_AS_INT = " as int)";
    public static final String CAST_SUFFIX_AS_LONG = " as long)";
    public static final String CAST_SUFFIX_AS_FLOAT = " as float)";
    public static final String CAST_SUFFIX_AS_DOUBLE = " as double)";
    public static final String CAST_SUFFIX_AS_BOOLEAN = " as boolean)";
    private static final String CAST_ARRAY_OPTIONAL_EMPTY_RESULT = "cast( as string array)";
    public static final String CAST_PREFIX_ARRAY = "cast([";
    public static final String CAST_SUFFIX_AS_STRING_ARRAY = "] as string array)";
    private static final String SPECIAL_KEY_CONVERT_TO_ARRAY = "___CONVERT_TO_ARRAY__";
    private static final String ALREADY_ARRAY_TYPE_ERROR = "already array type";
    private static final String SPECIAL_KEY_ORDER_ELEMENTS_PREFIX = "___REORDER__";
    private static final String SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR = ",";

    protected abstract void _initMapper();

    protected abstract void _initWriter(boolean var1);

    protected abstract ObjectMapper _getObjectMapper();

    protected abstract ObjectWriter _getObjectWriter(boolean var1);

    protected AbstractUtils(boolean prettyPrint) {
        this._initMapper();
        this.prettyPrint = prettyPrint;
        this._initWriter(this.prettyPrint);
    }

    public JsonNode getAsNode(String jsonString) throws UtilsException {
        try {
            return this._getObjectMapper().readTree(jsonString);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public JsonNode getAsNode(byte[] jsonBytes) throws UtilsException {
        try {
            return this._getObjectMapper().readTree(jsonBytes);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public JsonNode getAsNode(InputStream jsonStream) throws UtilsException {
        try {
            return this._getObjectMapper().readTree(jsonStream);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public JsonNode getAsNode(Reader jsonReader) throws UtilsException {
        try {
            return this._getObjectMapper().readTree(jsonReader);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public JsonNode getAsNode(Map<?, ?> map) throws UtilsException {
        try {
            return this._getObjectMapper().valueToTree(map);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public <T> T getAsObject(String jsonString, Class<T> c) throws UtilsException {
        try {
            return (T)this._getObjectMapper().readValue(jsonString, c);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public <T> T getAsObject(byte[] jsonBytes, Class<T> c) throws UtilsException {
        try {
            return (T)this._getObjectMapper().readValue(jsonBytes, c);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public <T> T getAsObject(InputStream jsonStream, Class<T> c) throws UtilsException {
        try {
            return (T)this._getObjectMapper().readValue(jsonStream, c);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public <T> T getAsObject(Reader jsonReader, Class<T> c) throws UtilsException {
        try {
            return (T)this._getObjectMapper().readValue(jsonReader, c);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public ObjectNode newObjectNode() throws UtilsException {
        try {
            return this._getObjectMapper().createObjectNode();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public ArrayNode newArrayNode() throws UtilsException {
        try {
            return this._getObjectMapper().createArrayNode();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public DateFormat getDateFormat() throws UtilsException {
        try {
            return this._getObjectMapper().getDateFormat();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] toByteArray(JsonNode doc) throws UtilsException {
        try {
            return this._getObjectWriter(this.prettyPrint).writeValueAsBytes((Object)doc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] toByteArray(Map<String, Object> doc) throws UtilsException {
        try {
            return this._getObjectWriter(this.prettyPrint).writeValueAsBytes(doc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String toString(JsonNode doc) throws UtilsException {
        try {
            return this._getObjectWriter(this.prettyPrint).writeValueAsString((Object)doc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String toString(Map<String, Object> doc) throws UtilsException {
        try {
            return this._getObjectWriter(this.prettyPrint).writeValueAsString(doc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void writeTo(JsonNode doc, OutputStream os) throws UtilsException {
        try {
            this._getObjectWriter(this.prettyPrint).writeValue(os, (Object)doc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void writeTo(Object object, OutputStream os) throws UtilsException {
        try {
            this._getObjectWriter(this.prettyPrint).writeValue(os, object);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected boolean isValid(byte[] jsonBytes) {
        try {
            this.getAsNode(jsonBytes);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected boolean isValid(String jsonString) {
        try {
            this.getAsNode(jsonString);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Map<String, Serializable> convertToSimpleMap(JsonNode node) {
        return this.convertToSimpleMap(node, true, false, true, false, ".");
    }

    public Map<String, Serializable> convertToSimpleMap(JsonNode node, String separator) {
        return this.convertToSimpleMap(node, true, false, true, false, separator);
    }

    public Map<String, Serializable> convertToSimpleMap(JsonNode node, boolean analyzeArrayNode, boolean analyzeAsStringArrayNode, boolean analyzeObjectNode, boolean analyzeAsStringObjectNode, String separator) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        this._convertToSimpleMap(null, node, null, map, analyzeArrayNode, analyzeAsStringArrayNode, analyzeObjectNode, analyzeAsStringObjectNode, separator);
        return map;
    }

    private void _convertToSimpleMap(String name, JsonNode node, String prefix, Map<String, Serializable> map, boolean analyzeArrayNode, boolean analyzeAsStringArrayNode, boolean analyzeObjectNode, boolean analyzeAsStringObjectNode, String separator) {
        Object newPrefix = "";
        if (prefix != null) {
            newPrefix = prefix + separator;
        }
        if (node instanceof ObjectNode) {
            Iterator iterator = node.fieldNames();
            while (iterator.hasNext()) {
                String text;
                String field = (String)iterator.next();
                JsonNode child = node.get(field);
                if (child instanceof ArrayNode) {
                    if (analyzeArrayNode) {
                        ArrayNode array = (ArrayNode)child;
                        if (array.size() <= 0) continue;
                        ArrayList<String> lString = new ArrayList<String>();
                        for (int i = 0; i < array.size(); ++i) {
                            JsonNode arrayChildNode = array.get(i);
                            if (arrayChildNode instanceof ArrayNode || arrayChildNode instanceof ObjectNode) {
                                String prefixRecursive = (String)newPrefix + AbstractUtils.normalizeKey(field) + "[" + i + "]";
                                this._convertToSimpleMap(field, arrayChildNode, prefixRecursive, map, analyzeArrayNode, analyzeAsStringArrayNode, analyzeObjectNode, analyzeAsStringObjectNode, separator);
                                continue;
                            }
                            String text2 = arrayChildNode.asText();
                            if (text2 == null || text2.isEmpty()) continue;
                            lString.add(text2);
                        }
                        if (lString.isEmpty()) continue;
                        map.put((String)newPrefix + field, lString);
                        continue;
                    }
                    if (!analyzeAsStringArrayNode || (text = child.asText()) == null || text.isEmpty()) continue;
                    map.put((String)newPrefix + field, (Serializable)((Object)text));
                    continue;
                }
                if (child instanceof ObjectNode) {
                    if (analyzeObjectNode) {
                        ObjectNode object = (ObjectNode)child;
                        String prefixRecursive = (String)newPrefix + AbstractUtils.normalizeKey(field);
                        this._convertToSimpleMap(field, (JsonNode)object, prefixRecursive, map, analyzeArrayNode, analyzeAsStringArrayNode, analyzeObjectNode, analyzeAsStringObjectNode, separator);
                        continue;
                    }
                    if (!analyzeAsStringObjectNode || (text = child.asText()) == null || text.isEmpty()) continue;
                    map.put((String)newPrefix + field, (Serializable)((Object)text));
                    continue;
                }
                text = child.asText();
                if (text == null || text.isEmpty()) continue;
                map.put((String)newPrefix + field, (Serializable)((Object)text));
            }
        } else if (node instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)node;
            if (array.size() > 0) {
                ArrayList<String> lString = new ArrayList<String>();
                for (int i = 0; i < array.size(); ++i) {
                    JsonNode arrayChildNode = array.get(i);
                    if (arrayChildNode instanceof ArrayNode || arrayChildNode instanceof ObjectNode) {
                        String prefixRecursive = (String)newPrefix + AbstractUtils.normalizeKey(name) + "[" + i + "]";
                        this._convertToSimpleMap(name, arrayChildNode, prefixRecursive, map, analyzeArrayNode, analyzeAsStringArrayNode, analyzeObjectNode, analyzeAsStringObjectNode, separator);
                        continue;
                    }
                    String text = arrayChildNode.asText();
                    if (text == null || text.isEmpty()) continue;
                    lString.add(text);
                }
                if (!lString.isEmpty()) {
                    map.put(name, lString);
                }
            }
        } else {
            String text = node.asText();
            if (text != null && !text.isEmpty()) {
                map.put(name, (Serializable)((Object)text));
            }
        }
    }

    private static String normalizeKey(String keyParam) {
        String key = keyParam.trim();
        while (key.contains(" ")) {
            key = key.replace(" ", "_");
        }
        return key;
    }

    protected Map<String, Serializable> convertToMapEngine(Logger log, String source, String raw, List<String> claimsToConvert) {
        JsonNode jsonResponse = null;
        try {
            jsonResponse = this.getAsNode(raw);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.convertToMapEngine(log, source, jsonResponse, claimsToConvert);
    }

    protected Map<String, Serializable> convertToMapEngine(Logger log, String source, byte[] raw, List<String> claimsToConvert) {
        JsonNode jsonResponse = null;
        try {
            jsonResponse = this.getAsNode(raw);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.convertToMapEngine(log, source, jsonResponse, claimsToConvert);
    }

    private Map<String, Serializable> convertToMapEngine(Logger log, String source, JsonNode jsonResponse, List<String> claimsToConvert) {
        HashMap<String, Serializable> returnMap;
        block15: {
            returnMap = new HashMap<String, Serializable>();
            try {
                if (!(jsonResponse instanceof ObjectNode)) break block15;
                Iterator iterator = jsonResponse.fieldNames();
                while (iterator.hasNext()) {
                    String field = (String)iterator.next();
                    if (claimsToConvert != null && !claimsToConvert.contains(field)) continue;
                    try {
                        JsonNode selectedClaim = jsonResponse.get(field);
                        if (selectedClaim instanceof ValueNode) {
                            returnMap.put(field, (Serializable)((Object)selectedClaim.asText()));
                            continue;
                        }
                        if (selectedClaim instanceof ArrayNode) {
                            ArrayNode array = (ArrayNode)selectedClaim;
                            if (array.size() <= 0) continue;
                            JsonNode arrayFirstChildNode = array.get(0);
                            if (arrayFirstChildNode instanceof ValueNode) {
                                ArrayList<Serializable> l = new ArrayList<Serializable>();
                                for (int i = 0; i < array.size(); ++i) {
                                    Serializable value;
                                    JsonNode arrayChildNode = array.get(i);
                                    Map<String, Serializable> readClaims = this.convertToSimpleMap(arrayChildNode);
                                    if (readClaims == null || readClaims.size() <= 0) continue;
                                    if (readClaims.size() == 1) {
                                        for (String claim : readClaims.keySet()) {
                                            value = readClaims.get(claim);
                                            l.add(value);
                                        }
                                        continue;
                                    }
                                    for (String claim : readClaims.keySet()) {
                                        value = readClaims.get(claim);
                                        this.addAttributeEngine(returnMap, claim == null ? field : claim, value);
                                    }
                                }
                                if (l.isEmpty()) continue;
                                this.addAttributeEngine(returnMap, field, l);
                                continue;
                            }
                            for (int i = 0; i < array.size(); ++i) {
                                JsonNode arrayChildNode = array.get(i);
                                Map<String, Serializable> readClaims = this.convertToSimpleMap(arrayChildNode);
                                if (readClaims == null || readClaims.size() <= 0) continue;
                                for (String claim : readClaims.keySet()) {
                                    Serializable value = readClaims.get(claim);
                                    this.addAttributeEngine(returnMap, claim, value);
                                }
                            }
                            continue;
                        }
                        Map<String, Serializable> readClaims = this.convertToSimpleMap(selectedClaim);
                        if (readClaims == null || readClaims.size() <= 0) continue;
                        for (String claim : readClaims.keySet()) {
                            Serializable value = readClaims.get(claim);
                            this.addAttributeEngine(returnMap, claim, value);
                        }
                    }
                    catch (Throwable e) {
                        log.error("Convert claim '" + field + "' to map failed (" + source + "): " + e.getMessage(), e);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return returnMap;
    }

    private void addAttributeEngine(Map<String, Serializable> attributes, String claim, Serializable value) {
        if (attributes.containsKey(claim)) {
            for (int j = 1; j < 100; ++j) {
                String newKeyClaim = "_" + claim + "_" + j;
                if (attributes.containsKey(newKeyClaim)) continue;
                attributes.put(newKeyClaim, attributes.get(claim));
                break;
            }
        }
        attributes.put(claim, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putValue(ObjectNode objectNode, String key, String value) throws UtilsException {
        if (value == null) return;
        String checkValue = value.trim();
        if (CAST_ARRAY_OPTIONAL_EMPTY_RESULT.equals(checkValue)) return;
        if (checkValue.startsWith(CAST_PREFIX_ARRAY) && checkValue.endsWith(CAST_SUFFIX_AS_STRING_ARRAY)) {
            String raw = value.trim();
            try {
                raw = value.substring(CAST_PREFIX_ARRAY.length(), value.length() - CAST_SUFFIX_AS_STRING_ARRAY.length());
                String[] tmp = raw.split(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR);
                StringBuilder sb = new StringBuilder();
                if (tmp != null && tmp.length > 0) {
                    for (int i = 0; i < tmp.length; ++i) {
                        String check = tmp[i];
                        if (check != null) {
                            check = check.trim();
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)check)) continue;
                        if (sb.length() > 0) {
                            sb.append(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR);
                        }
                        sb.append("\"").append(check).append("\"");
                    }
                }
                if (sb.length() <= 0) throw new Exception("empty value after parsing");
                String newValue = "[" + sb.toString() + "]";
                JsonNode node = this.getAsNode(newValue);
                objectNode.set(key, node);
                return;
            }
            catch (Throwable t) {
                throw new UtilsException("Cast value '" + raw + "' as string array failed: " + t.getMessage(), t);
            }
        } else if (checkValue.startsWith("[") && checkValue.endsWith("]")) {
            try {
                JsonNode node = this.getAsNode(value);
                objectNode.set(key, node);
                return;
            }
            catch (Throwable t) {
                boolean throwException = true;
                String s = checkValue.substring(1, checkValue.length() - 1);
                if (s != null && StringUtils.isNotEmpty((CharSequence)s)) {
                    String[] tmp = s.split(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR);
                    StringBuilder sb = new StringBuilder();
                    if (tmp != null && tmp.length > 0) {
                        for (int i = 0; i < tmp.length; ++i) {
                            String check = tmp[i];
                            if (check != null) {
                                check = check.trim();
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)check)) continue;
                            if (sb.length() > 0) {
                                sb.append(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR);
                            }
                            sb.append("\"").append(check).append("\"");
                        }
                    }
                    if (sb.length() > 0) {
                        try {
                            String newValue = "[" + sb.toString() + "]";
                            JsonNode node = this.getAsNode(newValue);
                            objectNode.set(key, node);
                            return;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (!throwException) return;
                throw new UtilsException("Process value '" + value + "' as array node failed: " + t.getMessage(), t);
            }
        } else if (checkValue.startsWith("{") && checkValue.endsWith("}")) {
            JsonNode node = this.getAsNode(value);
            objectNode.set(key, node);
            return;
        } else {
            String checkValueLowerCase = checkValue.toLowerCase();
            if (checkValueLowerCase.startsWith(CAST_PREFIX) && checkValueLowerCase.endsWith(CAST_SUFFIX_AS_INT)) {
                String raw = value.trim();
                try {
                    raw = value.substring(CAST_PREFIX.length(), value.length() - CAST_SUFFIX_AS_INT.length());
                    if (raw == null) return;
                    if (!StringUtils.isNotEmpty((CharSequence)(raw = raw.trim()))) return;
                    int v = Integer.valueOf(raw);
                    objectNode.put(key, v);
                    return;
                }
                catch (Throwable t) {
                    throw new UtilsException("Cast value '" + raw + "' as int failed: " + t.getMessage(), t);
                }
            } else if (checkValueLowerCase.startsWith(CAST_PREFIX) && checkValueLowerCase.endsWith(CAST_SUFFIX_AS_LONG)) {
                String raw = value.trim();
                try {
                    raw = value.substring(CAST_PREFIX.length(), value.length() - CAST_SUFFIX_AS_LONG.length());
                    if (raw == null) return;
                    if (!StringUtils.isNotEmpty((CharSequence)(raw = raw.trim()))) return;
                    long v = Long.valueOf(raw);
                    objectNode.put(key, v);
                    return;
                }
                catch (Throwable t) {
                    throw new UtilsException("Cast value '" + raw + "' as long failed: " + t.getMessage(), t);
                }
            } else if (checkValueLowerCase.startsWith(CAST_PREFIX) && checkValueLowerCase.endsWith(CAST_SUFFIX_AS_FLOAT)) {
                String raw = value.trim();
                try {
                    raw = value.substring(CAST_PREFIX.length(), value.length() - CAST_SUFFIX_AS_FLOAT.length());
                    if (raw == null) return;
                    if (!StringUtils.isNotEmpty((CharSequence)(raw = raw.trim()))) return;
                    float v = Float.valueOf(raw).floatValue();
                    objectNode.put(key, v);
                    return;
                }
                catch (Throwable t) {
                    throw new UtilsException("Cast value '" + raw + "' as float failed: " + t.getMessage(), t);
                }
            } else if (checkValueLowerCase.startsWith(CAST_PREFIX) && checkValueLowerCase.endsWith(CAST_SUFFIX_AS_DOUBLE)) {
                String raw = value.trim();
                try {
                    raw = value.substring(CAST_PREFIX.length(), value.length() - CAST_SUFFIX_AS_DOUBLE.length());
                    if (raw == null) return;
                    if (!StringUtils.isNotEmpty((CharSequence)(raw = raw.trim()))) return;
                    double v = Double.valueOf(raw);
                    objectNode.put(key, v);
                    return;
                }
                catch (Throwable t) {
                    throw new UtilsException("Cast value '" + raw + "' as double failed: " + t.getMessage(), t);
                }
            } else if (checkValueLowerCase.startsWith(CAST_PREFIX) && checkValueLowerCase.endsWith(CAST_SUFFIX_AS_BOOLEAN)) {
                String raw = value.trim();
                try {
                    raw = value.substring(CAST_PREFIX.length(), value.length() - CAST_SUFFIX_AS_BOOLEAN.length());
                    if (raw == null) return;
                    if (!StringUtils.isNotEmpty((CharSequence)(raw = raw.trim()))) return;
                    boolean v = Boolean.valueOf(raw);
                    objectNode.put(key, v);
                    return;
                }
                catch (Throwable t) {
                    throw new UtilsException("Cast value '" + raw + "' as boolean failed: " + t.getMessage(), t);
                }
            } else {
                objectNode.put(key, value);
            }
        }
    }

    public void renameFieldByPath(JsonNode oNode, Map<String, String> pathToNewName) throws UtilsException {
        this.renameFieldByPath(oNode, pathToNewName, true);
    }

    public void renameFieldByPath(JsonNode oNode, Map<String, String> pathToNewName, boolean throwNotFound) throws UtilsException {
        this.renameFieldByPath(oNode, pathToNewName, false, throwNotFound);
    }

    public void renameFieldByPath(JsonNode oNode, Map<String, String> pathToNewName, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        if (pathToNewName == null || pathToNewName.isEmpty()) {
            throw new UtilsException("Conversion map undefined");
        }
        for (String path : pathToNewName.keySet()) {
            String newName = pathToNewName.get(path);
            this.renameFieldByPath(oNode, path, newName, forceReorder, throwNotFound);
        }
    }

    public void renameFieldByPath(JsonNode oNode, SortedMap<String> pathToNewName) throws UtilsException {
        this.renameFieldByPath(oNode, pathToNewName, true);
    }

    public void renameFieldByPath(JsonNode oNode, SortedMap<String> pathToNewName, boolean throwNotFound) throws UtilsException {
        this.renameFieldByPath(oNode, pathToNewName, false, throwNotFound);
    }

    public void renameFieldByPath(JsonNode oNode, SortedMap<String> pathToNewName, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        if (pathToNewName == null || pathToNewName.isEmpty()) {
            throw new UtilsException("Conversion map undefined");
        }
        for (String path : pathToNewName.keys()) {
            String newName = pathToNewName.get(path);
            this.renameFieldByPath(oNode, path, newName, forceReorder, throwNotFound);
        }
    }

    public void renameFieldByPath(JsonNode oNode, String path, String newName) throws UtilsException {
        this.renameFieldByPath(oNode, path, newName, true);
    }

    public void renameFieldByPath(JsonNode oNode, String path, String newName, boolean throwNotFound) throws UtilsException {
        this.renameFieldByPath(oNode, path, newName, false, throwNotFound);
    }

    public void renameFieldByPath(JsonNode oNode, String path, String newName, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        boolean esito = true;
        for (int i = 0; esito && i < 1000000; ++i) {
            try {
                this._renameFieldByPath(oNode, path, newName, forceReorder, true);
                esito = true;
                if (!SPECIAL_KEY_CONVERT_TO_ARRAY.equals(newName) && !newName.startsWith(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX)) continue;
                break;
            }
            catch (UtilsException e) {
                if (i == 0 && (SPECIAL_KEY_CONVERT_TO_ARRAY.equals(newName) ? (e.getMessage() == null || !e.getMessage().contains(ALREADY_ARRAY_TYPE_ERROR)) && throwNotFound : (newName.startsWith(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX) ? throwNotFound || e.getMessage() != null && !e.getMessage().contains("not found") : throwNotFound))) {
                    throw e;
                }
                if (i > 0) {
                    return;
                }
                esito = false;
            }
        }
    }

    public void _renameFieldByPath(JsonNode oNode, String path, String newName, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        String[] pathFragment = path.split("\\.");
        if (pathFragment == null || pathFragment.length <= 0) {
            throw new UtilsException("Path undefined");
        }
        if (newName == null) {
            throw new UtilsException("New name undefined");
        }
        if (!oNode.isObject()) {
            throw new UtilsException("Node isn't object");
        }
        _StructureNode s = new _StructureNode();
        s.parentNode = oNode;
        s.nodeForRename = oNode;
        this._renameFieldByPath(s, path, pathFragment, 0, newName, forceReorder, throwNotFound);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _renameFieldByPath(_StructureNode structure, String path, String[] pathFragment, int position, String newName, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        void var13_24;
        JsonNode nodeForRename;
        String name;
        block30: {
            void var13_21;
            List<String> l;
            block29: {
                void var15_31;
                block28: {
                    Object fieldName;
                    ArrayList<Object> nomi;
                    JsonNode parentNode;
                    block26: {
                        block24: {
                            block27: {
                                block25: {
                                    boolean foglia = position == pathFragment.length - 1;
                                    name = pathFragment[position];
                                    parentNode = structure.parentNode;
                                    parentNode = nodeForRename = structure.nodeForRename;
                                    if (((nodeForRename = nodeForRename.get(name)) == null || nodeForRename instanceof MissingNode) && throwNotFound && !"".equals(path)) {
                                        throw new UtilsException("Element '" + name + "' not found (path '" + path + "')");
                                    }
                                    if (!foglia) break block24;
                                    if (!forceReorder) break block25;
                                    nomi = new ArrayList<Object>();
                                    Iterator iterator = ((ObjectNode)parentNode).fieldNames();
                                    if (iterator != null) {
                                        while (iterator.hasNext()) {
                                            fieldName = (String)iterator.next();
                                            nomi.add(fieldName);
                                        }
                                    }
                                    break block26;
                                }
                                if (!newName.startsWith(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX)) break block27;
                                l = this.convertReorderFieldChildrenByPathKeyToList(newName);
                                Object var13_18 = null;
                                if ("".equals(path)) {
                                    ObjectNode objectNode = (ObjectNode)parentNode;
                                } else {
                                    JsonNode jsonNode = ((ObjectNode)parentNode).get(name);
                                }
                                if (var13_21.isArray()) break block28;
                                break block29;
                            }
                            if (!SPECIAL_KEY_CONVERT_TO_ARRAY.equals(newName)) {
                                ((ObjectNode)parentNode).remove(name);
                                ((ObjectNode)parentNode).set(newName, nodeForRename);
                                return;
                            }
                            if (nodeForRename != null && !nodeForRename.isArray()) {
                                ((ObjectNode)parentNode).remove(name);
                                ArrayNode arrayNode = ((ObjectNode)parentNode).arrayNode();
                                arrayNode.add(nodeForRename);
                                ((ObjectNode)parentNode).set(name, (JsonNode)arrayNode);
                                return;
                            }
                            if (!throwNotFound) return;
                            throw new UtilsException("Element '" + name + "' already array type (path '" + path + "')");
                        }
                        if (nodeForRename != null && nodeForRename.isObject() && nodeForRename instanceof ObjectNode) {
                            _StructureNode s = new _StructureNode();
                            s.parentNode = parentNode;
                            s.nodeForRename = nodeForRename;
                            s.parent = name;
                            try {
                                this._renameFieldByPath(s, path, pathFragment, position + 1, newName, forceReorder, throwNotFound);
                                return;
                            }
                            catch (UtilsException utilsException) {
                                if (SPECIAL_KEY_CONVERT_TO_ARRAY.equals(newName)) {
                                    if (utilsException.getMessage() == null) throw utilsException;
                                    if (utilsException.getMessage().contains(ALREADY_ARRAY_TYPE_ERROR)) return;
                                    throw utilsException;
                                }
                                if (!newName.startsWith(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX)) throw utilsException;
                                if (utilsException.getMessage() == null) return;
                                if (utilsException.getMessage().contains("not found")) return;
                                throw utilsException;
                            }
                        }
                        break block30;
                    }
                    fieldName = nomi.iterator();
                    while (fieldName.hasNext()) {
                        String string = (String)fieldName.next();
                        JsonNode n = ((ObjectNode)parentNode).get(string);
                        if (string.equals(name)) {
                            if (SPECIAL_KEY_CONVERT_TO_ARRAY.equals(newName)) {
                                if (!n.isArray()) {
                                    ((ObjectNode)parentNode).remove(string);
                                    ArrayNode arrayNode = ((ObjectNode)parentNode).arrayNode();
                                    arrayNode.add(n);
                                    ((ObjectNode)parentNode).set(string, (JsonNode)arrayNode);
                                    continue;
                                }
                                if (!throwNotFound) continue;
                                throw new UtilsException("Element '" + name + "' already array type (path '" + path + "')");
                            }
                            ((ObjectNode)parentNode).remove(string);
                            ((ObjectNode)parentNode).set(newName, n);
                            continue;
                        }
                        ((ObjectNode)parentNode).remove(string);
                        ((ObjectNode)parentNode).set(string, n);
                    }
                    return;
                }
                ArrayNode array = (ArrayNode)nodeForRename;
                if (array == null) return;
                if (array.size() <= 0) return;
                boolean bl = false;
                while (var15_31 < array.size()) {
                    JsonNode arrayChildNode = array.get((int)var15_31);
                    if (!arrayChildNode.isObject()) throw new UtilsException("Cannot execute reorder in simple object (path '" + path + "') (array position i=" + (int)var15_31 + ")");
                    for (String nameReorder : l) {
                        JsonNode n = arrayChildNode.get(nameReorder);
                        if (n == null || n instanceof MissingNode) continue;
                        ((ObjectNode)arrayChildNode).remove(nameReorder);
                        ((ObjectNode)arrayChildNode).set(nameReorder, n);
                    }
                    ++var15_31;
                }
                return;
            }
            if (!var13_21.isObject()) throw new UtilsException("Cannot execute reorder in simple object (path '" + path + "')");
            Iterator<String> array = l.iterator();
            while (array.hasNext()) {
                String string = array.next();
                JsonNode n = var13_21.get(string);
                if (n == null || n instanceof MissingNode) continue;
                ((ObjectNode)var13_21).remove(string);
                ((ObjectNode)var13_21).set(string, n);
            }
            return;
        }
        if (nodeForRename == null) throw new UtilsException("Element '" + name + "' not found as object/array (path '" + path + "')");
        if (!nodeForRename.isArray()) throw new UtilsException("Element '" + name + "' not found as object/array (path '" + path + "')");
        if (!(nodeForRename instanceof ArrayNode)) throw new UtilsException("Element '" + name + "' not found as object/array (path '" + path + "')");
        ArrayNode array = (ArrayNode)nodeForRename;
        if (array.size() <= 0) return;
        boolean bl = false;
        while (var13_24 < array.size()) {
            block23: {
                JsonNode arrayChildNode = array.get((int)var13_24);
                _StructureNode _StructureNode2 = new _StructureNode();
                _StructureNode2.parentNode = nodeForRename;
                _StructureNode2.nodeForRename = arrayChildNode;
                _StructureNode2.parent = name + "[" + (int)var13_24 + "]";
                try {
                    this._renameFieldByPath(_StructureNode2, path, pathFragment, position + 1, newName, forceReorder, throwNotFound);
                }
                catch (UtilsException e) {
                    if (SPECIAL_KEY_CONVERT_TO_ARRAY.equals(newName)) {
                        if (e.getMessage() == null) throw e;
                        if (!e.getMessage().contains(ALREADY_ARRAY_TYPE_ERROR)) {
                            throw e;
                        }
                    }
                    if (!newName.startsWith(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX)) throw e;
                    if (e.getMessage() == null || e.getMessage().contains("not found")) break block23;
                    throw e;
                }
            }
            ++var13_24;
        }
    }

    public void renameFieldInCamelCase(JsonNode oNode, boolean firstLowerCase) throws UtilsException {
        this.renameFieldInCamelCase(oNode, firstLowerCase, false);
    }

    public void renameFieldInCamelCase(JsonNode oNode, boolean firstLowerCase, boolean forceReorder) throws UtilsException {
        SortedMap<String> mapForRename = new SortedMap<String>();
        if (!oNode.isObject()) {
            throw new UtilsException("Node isn't object");
        }
        AbstractUtils.renameFieldInCamelCase((ObjectNode)oNode, "", mapForRename, firstLowerCase, forceReorder);
        if (!mapForRename.isEmpty()) {
            this.renameFieldByPath(oNode, mapForRename);
        }
    }

    private static void renameFieldInCamelCase(ObjectNode oNode, String prefix, SortedMap<String> mapForRename, boolean firstLowerCase, boolean forceReorder) throws UtilsException {
        Iterator it = oNode.fieldNames();
        if (it != null) {
            while (it.hasNext()) {
                String key;
                String camelCaseName;
                String fieldName = (String)it.next();
                JsonNode node = oNode.get(fieldName);
                if (node != null) {
                    ArrayNode array;
                    if (node.isObject() && node instanceof ObjectNode) {
                        if (StringUtils.isNotEmpty((CharSequence)prefix) && !((String)prefix).endsWith(".")) {
                            prefix = (String)prefix + ".";
                        }
                        AbstractUtils.renameFieldInCamelCase((ObjectNode)node, (String)prefix + fieldName, mapForRename, firstLowerCase, forceReorder);
                    } else if (node.isArray() && node instanceof ArrayNode && (array = (ArrayNode)node).size() > 0) {
                        for (int i = 0; i < array.size(); ++i) {
                            JsonNode arrayChildNode = array.get(i);
                            if (!arrayChildNode.isObject() || !(arrayChildNode instanceof ObjectNode)) continue;
                            if (StringUtils.isNotEmpty((CharSequence)prefix) && !((String)prefix).endsWith(".")) {
                                prefix = (String)prefix + ".";
                            }
                            AbstractUtils.renameFieldInCamelCase((ObjectNode)arrayChildNode, (String)prefix + fieldName, mapForRename, firstLowerCase, forceReorder);
                        }
                    }
                }
                if ((camelCaseName = AbstractUtils.camelCase(fieldName, firstLowerCase)).equals(fieldName) && !forceReorder) continue;
                if (StringUtils.isNotEmpty((CharSequence)prefix) && !((String)prefix).endsWith(".")) {
                    prefix = (String)prefix + ".";
                }
                if (mapForRename.containsKey(key = (String)prefix + fieldName)) continue;
                mapForRename.add(key, camelCaseName);
            }
        }
    }

    public static String camelCase(String fieldName, boolean firstLowerCase) {
        boolean charSpecial;
        boolean firstCase = firstLowerCase ? Character.isUpperCase(fieldName.charAt(0)) : Character.isLowerCase(fieldName.charAt(0));
        boolean bl = charSpecial = fieldName.contains("-") || fieldName.contains("_");
        if (firstCase || charSpecial) {
            Object newName = fieldName;
            if (firstCase) {
                if (firstLowerCase) {
                    newName = fieldName.length() > 1 ? ("" + fieldName.charAt(0)).toLowerCase() + fieldName.substring(1) : fieldName.toLowerCase();
                } else {
                    Object object = newName = fieldName.length() > 1 ? ("" + fieldName.charAt(0)).toUpperCase() + fieldName.substring(1) : fieldName.toUpperCase();
                }
            }
            if (charSpecial) {
                int indexOf = ((String)newName).indexOf("_");
                while (indexOf >= 0 && indexOf + 1 < ((String)newName).length()) {
                    newName = indexOf + 2 < ((String)newName).length() ? ((String)newName).substring(0, indexOf) + ("" + ((String)newName).charAt(indexOf + 1)).toUpperCase() + ((String)newName).substring(indexOf + 2, ((String)newName).length()) : ((String)newName).substring(0, indexOf) + ("" + ((String)newName).charAt(indexOf + 1)).toUpperCase();
                    indexOf = ((String)newName).indexOf("_");
                }
                indexOf = ((String)newName).indexOf("-");
                while (indexOf >= 0 && indexOf + 1 < ((String)newName).length()) {
                    newName = indexOf + 2 < ((String)newName).length() ? ((String)newName).substring(0, indexOf) + ("" + ((String)newName).charAt(indexOf + 1)).toUpperCase() + ((String)newName).substring(indexOf + 2, ((String)newName).length()) : ((String)newName).substring(0, indexOf) + ("" + ((String)newName).charAt(indexOf + 1)).toUpperCase();
                    indexOf = ((String)newName).indexOf("-");
                }
            }
            return newName;
        }
        return fieldName;
    }

    public void convertFieldToArrayByPath(JsonNode oNode, List<String> listPath) throws UtilsException {
        SortedMap<String> pathToNewName = new SortedMap<String>();
        if (listPath != null) {
            for (String path : listPath) {
                pathToNewName.add(path, SPECIAL_KEY_CONVERT_TO_ARRAY);
            }
        }
        this.renameFieldByPath(oNode, pathToNewName, true);
    }

    public void convertFieldToArrayByPath(JsonNode oNode, List<String> listPath, boolean throwNotFound) throws UtilsException {
        SortedMap<String> pathToNewName = new SortedMap<String>();
        if (listPath != null) {
            for (String path : listPath) {
                pathToNewName.add(path, SPECIAL_KEY_CONVERT_TO_ARRAY);
            }
        }
        this.renameFieldByPath(oNode, pathToNewName, throwNotFound);
    }

    public void convertFieldToArrayByPath(JsonNode oNode, List<String> listPath, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        SortedMap<String> pathToNewName = new SortedMap<String>();
        if (listPath != null) {
            for (String path : listPath) {
                pathToNewName.add(path, SPECIAL_KEY_CONVERT_TO_ARRAY);
            }
        }
        this.renameFieldByPath(oNode, pathToNewName, forceReorder, throwNotFound);
    }

    public void convertFieldToArrayByPath(JsonNode oNode, String path) throws UtilsException {
        this.renameFieldByPath(oNode, path, SPECIAL_KEY_CONVERT_TO_ARRAY, true);
    }

    public void convertFieldToArrayByPath(JsonNode oNode, String path, boolean throwNotFound) throws UtilsException {
        this.renameFieldByPath(oNode, path, SPECIAL_KEY_CONVERT_TO_ARRAY, throwNotFound);
    }

    public void convertFieldToArrayByPath(JsonNode oNode, String path, boolean forceReorder, boolean throwNotFound) throws UtilsException {
        this.renameFieldByPath(oNode, path, SPECIAL_KEY_CONVERT_TO_ARRAY, forceReorder, throwNotFound);
    }

    public void reorderFieldChildrenByPath(JsonNode oNode, String path, String ... child) throws UtilsException {
        this.renameFieldByPath(oNode, path, SPECIAL_KEY_ORDER_ELEMENTS_PREFIX + this.toReorderFieldChildrenByPathSuffix(child), true);
    }

    public void reorderFieldChildrenByPath(JsonNode oNode, String path, boolean throwNotFound, String ... child) throws UtilsException {
        String key = SPECIAL_KEY_ORDER_ELEMENTS_PREFIX + this.toReorderFieldChildrenByPathSuffix(child);
        this.renameFieldByPath(oNode, path, key, throwNotFound);
    }

    private String toReorderFieldChildrenByPathSuffix(String ... child) throws UtilsException {
        if (child == null || child.length <= 0) {
            throw new UtilsException("Children undefined");
        }
        StringBuilder sb = new StringBuilder();
        for (String c : child) {
            if (sb.length() > 0) {
                sb.append(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR);
            }
            if (c.contains(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR)) {
                throw new UtilsException("Invalid child name [" + c + "] (contains ',')");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private List<String> convertReorderFieldChildrenByPathKeyToList(String v) throws UtilsException {
        String parsV = v;
        if (parsV.startsWith(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX)) {
            parsV = parsV.substring(SPECIAL_KEY_ORDER_ELEMENTS_PREFIX.length());
        }
        ArrayList<String> l = new ArrayList<String>();
        if (parsV.contains(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR)) {
            String[] tmp = parsV.split(SPECIAL_KEY_ORDER_ELEMENTS_SEPARATOR);
            if (tmp != null && tmp.length > 0) {
                for (String c : tmp) {
                    l.add(c);
                }
            }
        } else {
            l.add(parsV);
        }
        if (l.isEmpty()) {
            throw new UtilsException("Children not found");
        }
        return l;
    }
}

