/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.TimeZone;
import org.openspcoop2.utils.jaxrs.JacksonXmlProviderCustomized;
import org.openspcoop2.utils.json.AbstractUtils;

public class JacksonXmlUtils
extends AbstractUtils {
    private static TimeZone timeZone = TimeZone.getDefault();
    private static JacksonXmlUtils jsonUtils = null;
    private static JacksonXmlUtils jsonUtilsPretty = null;
    private static ObjectMapper mapper;
    private static ObjectWriter writer;
    private static ObjectWriter writerPrettyPrint;

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static void setTimeZone(TimeZone timeZoneParam) {
        timeZone = timeZoneParam;
    }

    public static String getTimeZoneId() {
        return timeZone.getID();
    }

    public static void setTimeZoneById(String timeZoneId) {
        timeZone = TimeZone.getTimeZone(timeZoneId);
    }

    private static synchronized void init(boolean prettyPrint) {
        if (prettyPrint) {
            if (jsonUtilsPretty == null) {
                jsonUtilsPretty = new JacksonXmlUtils(true);
            }
        } else if (jsonUtils == null) {
            jsonUtils = new JacksonXmlUtils(false);
        }
    }

    public static JacksonXmlUtils getInstance() {
        return JacksonXmlUtils.getInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JacksonXmlUtils getInstance(boolean prettyPrint) {
        if (prettyPrint) {
            if (jsonUtilsPretty != null) return jsonUtilsPretty;
            Class<JacksonXmlUtils> clazz = JacksonXmlUtils.class;
            synchronized (JacksonXmlUtils.class) {
                JacksonXmlUtils.init(true);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return jsonUtilsPretty;
            }
        }
        if (jsonUtils != null) return jsonUtils;
        Class<JacksonXmlUtils> clazz = JacksonXmlUtils.class;
        synchronized (JacksonXmlUtils.class) {
            JacksonXmlUtils.init(false);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return jsonUtils;
        }
    }

    private static synchronized void initMapper() {
        if (mapper == null) {
            mapper = JacksonXmlProviderCustomized.getObjectMapper(false, timeZone);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    public static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            JacksonXmlUtils.initMapper();
        }
        return mapper;
    }

    private static synchronized void initWriter() {
        if (mapper == null) {
            JacksonXmlUtils.initMapper();
        }
        if (writer == null) {
            writer = mapper.writer();
        }
    }

    public static ObjectWriter getObjectWriter() {
        if (writer == null) {
            JacksonXmlUtils.initWriter();
        }
        return writer;
    }

    private static synchronized void initWriterPrettyPrint() {
        if (mapper == null) {
            JacksonXmlUtils.initMapper();
        }
        if (writerPrettyPrint == null) {
            writerPrettyPrint = mapper.writer().withDefaultPrettyPrinter();
        }
    }

    public static ObjectWriter getObjectWriterPrettyPrint() {
        if (writerPrettyPrint == null) {
            JacksonXmlUtils.initWriterPrettyPrint();
        }
        return writerPrettyPrint;
    }

    private JacksonXmlUtils(boolean prettyPrint) {
        super(prettyPrint);
    }

    @Override
    protected void _initMapper() {
        JacksonXmlUtils.initMapper();
    }

    @Override
    protected void _initWriter(boolean prettyPrint) {
        if (prettyPrint) {
            JacksonXmlUtils.initWriterPrettyPrint();
        } else {
            JacksonXmlUtils.initWriter();
        }
    }

    @Override
    protected ObjectMapper _getObjectMapper() {
        return JacksonXmlUtils.getObjectMapper();
    }

    @Override
    protected ObjectWriter _getObjectWriter(boolean prettyPrint) {
        if (prettyPrint) {
            return JacksonXmlUtils.getObjectWriterPrettyPrint();
        }
        return JacksonXmlUtils.getObjectWriter();
    }

    public boolean isJson(byte[] jsonBytes) {
        return this.isValid(jsonBytes);
    }

    public boolean isJson(String jsonString) {
        return this.isValid(jsonString);
    }
}

