/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import java.util.HashMap;
import java.util.Map;

public class JsonValidatorAPI {
    private String validatorClass;
    private static Map<ApiName, JsonValidatorAPI> mapApi;

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public void setValidatorClass(String validatorClass) {
        this.validatorClass = validatorClass;
    }

    public static JsonValidatorAPI get(ApiName name) {
        if (mapApi == null) {
            JsonValidatorAPI.initMapApi();
        }
        return mapApi.get((Object)name);
    }

    private static void initMapApi() {
        mapApi = new HashMap<ApiName, JsonValidatorAPI>();
        JsonValidatorAPI networkNtApi = new JsonValidatorAPI();
        networkNtApi.setValidatorClass("org.openspcoop2.utils.json.validation.NetworkNTJsonschemaValidator");
        mapApi.put(ApiName.NETWORK_NT, networkNtApi);
        JsonValidatorAPI fgeApi = new JsonValidatorAPI();
        fgeApi.setValidatorClass("org.openspcoop2.utils.json.validation.FGEJsonschemaValidator");
        mapApi.put(ApiName.FGE, fgeApi);
    }

    public static enum ApiName {
        NETWORK_NT,
        FGE;

    }
}

