/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mail.Mail;
import org.openspcoop2.utils.mail.MailAttach;
import org.openspcoop2.utils.mail.MailBinaryAttach;
import org.openspcoop2.utils.mail.MailTextAttach;
import org.openspcoop2.utils.mail.Sender;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.slf4j.Logger;

public class JakartaMailSender
extends Sender {
    protected JakartaMailSender(Logger log) {
        super(log);
    }

    @Override
    public void send(Mail mail, boolean debug) throws UtilsException {
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            boolean hasAttachments;
            Properties props = new Properties();
            props.put("mail.smtp.host", mail.getServerHost());
            props.put("mail.smtp.port", String.valueOf(mail.getServerPort()));
            props.put("mail.smtp.connectiontimeout", String.valueOf(this.getConnectionTimeout()));
            props.put("mail.smtp.timeout", String.valueOf(this.getReadTimeout()));
            if (mail.isStartTls()) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            if (mail.getSslConfig() != null) {
                props.put("mail.smtp.ssl.enable", "true");
                props.put("mail.smtp.ssl.checkserveridentity", String.valueOf(mail.getSslConfig().isHostnameVerifier()));
                StringBuilder bf = new StringBuilder();
                SSLUtilities.setSSLContextIntoJavaProperties(mail.getSslConfig(), bf);
                if (debug) {
                    this.logDebug(bf.toString());
                }
            }
            Session session = this.initSession(mail, props, debug);
            MimeMessage message = this.buildBaseMessage(mail, session, debug);
            boolean bl = hasAttachments = mail.getBody().getAttachments() != null && !mail.getBody().getAttachments().isEmpty();
            if (hasAttachments) {
                this.addAttachments(mail, tempFiles, message, debug);
            } else {
                message.setText(mail.getBody().getMessage(), "UTF-8");
            }
            this.logDebug("Send [" + mail.getServerHost() + ":" + mail.getServerPort() + "] ...");
            Transport.send((Message)message);
            this.logDebug("Send [" + mail.getServerHost() + ":" + mail.getServerPort() + "] completed");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            for (File f : tempFiles) {
                FileSystemUtilities.deleteFile(f);
            }
        }
    }

    private Session initSession(final Mail mail, Properties props, boolean debug) {
        Session session;
        this.logDebug("Init session username[" + mail.getUsername() + "] ...");
        if (mail.getUsername() != null) {
            props.put("mail.smtp.auth", "true");
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(this){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mail.getUsername(), mail.getPassword());
                }
            });
        } else {
            session = Session.getInstance((Properties)props);
        }
        session.setDebug(debug);
        this.logDebug("Init session username[" + mail.getUsername() + "] completed");
        return session;
    }

    private MimeMessage buildBaseMessage(Mail mail, Session session, boolean debug) throws MessagingException {
        if (debug) {
            this.logDebug("Build message ...");
        }
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(mail.getFrom()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.getTo()));
        if (mail.getCc() != null && !mail.getCc().isEmpty()) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)String.join((CharSequence)",", mail.getCc())));
        }
        message.setSubject(mail.getSubject());
        if (mail.getUserAgent() != null) {
            message.setHeader("User-Agent", mail.getUserAgent());
        }
        if (mail.getMessageIdDomain() != null) {
            message.setHeader("Message-ID", "<" + String.valueOf(UUID.randomUUID()) + "@" + mail.getMessageIdDomain() + ">");
        }
        if (mail.getContentLanguage() != null) {
            message.setHeader("Content-Language", mail.getContentLanguage());
        }
        if (debug) {
            this.logDebug("Build message completed");
        }
        return message;
    }

    private void addAttachments(Mail mail, List<File> tempFiles, MimeMessage message, boolean debug) throws MessagingException, IOException, UtilsException {
        if (debug) {
            this.logDebug("Add attachments ...");
        }
        MimeMultipart multipart = new MimeMultipart();
        if (mail.getBody().getMessage() != null) {
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(mail.getBody().getMessage(), "UTF-8");
            multipart.addBodyPart((BodyPart)textPart);
        }
        for (MailAttach attach : mail.getBody().getAttachments()) {
            File tmpFile;
            MailAttach mailAttach;
            Objects.requireNonNull(attach);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MailTextAttach.class, MailBinaryAttach.class}, (Object)mailAttach, n)) {
                case 0: {
                    MailTextAttach mailTextAttach = (MailTextAttach)mailAttach;
                    tmpFile = FileSystemUtilities.createTempFile("mailTextAttach", ".txt");
                    FileSystemUtilities.writeFile(tmpFile, mailTextAttach.getContent().getBytes());
                    break;
                }
                case 1: {
                    MailBinaryAttach mailBinaryAttach = (MailBinaryAttach)mailAttach;
                    tmpFile = FileSystemUtilities.createTempFile("mailBinaryAttach", ".bin");
                    FileSystemUtilities.writeFile(tmpFile, mailBinaryAttach.getContent());
                    break;
                }
                default: {
                    throw new UtilsException("MailAttach class '" + attach.getClass().getName() + "' unsupported");
                }
            }
            tempFiles.add(tmpFile);
            MimeBodyPart attachmentPart = new MimeBodyPart();
            attachmentPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(tmpFile)));
            attachmentPart.setFileName(attach.getName());
            multipart.addBodyPart((BodyPart)attachmentPart);
        }
        message.setContent((Multipart)multipart);
        if (debug) {
            this.logDebug("Add attachments completed ...");
        }
    }
}

