/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.v3.OAI3Context;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.v3.OpenApi3Validator;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathNotFoundException;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.openapi.OpenapiApiValidatorStructure;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ParseWarningException;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.api.Api;

public class OpenapiApi
extends Api {
    private static final long serialVersionUID = 1L;
    private transient OpenAPI api;
    private transient Map<String, Schema<?>> definitions;
    private String apiRaw;
    private String parseWarningResult;
    private ApiFormats format;
    private OpenapiApiValidatorStructure validationStructure;

    public OpenapiApi(ApiFormats format, OpenAPI swagger, String apiRaw, String parseWarningResult) {
        this.format = format;
        this.api = swagger;
        this.apiRaw = apiRaw;
        this.parseWarningResult = parseWarningResult;
        this.definitions = new HashMap();
    }

    public ApiFormats getFormat() {
        return this.format;
    }

    public OpenAPI getApi() {
        return this.api;
    }

    public String getApiRaw() {
        return this.apiRaw;
    }

    public String getParseWarningResult() {
        return this.parseWarningResult;
    }

    public Map<String, Schema<?>> getDefinitions() {
        return this.definitions;
    }

    public Map<String, Schema<?>> getAllDefinitions() {
        HashMap map = new HashMap();
        map.putAll(this.getDefinitions());
        if (this.api.getComponents() != null && this.api.getComponents().getSchemas() != null) {
            for (String k : this.api.getComponents().getSchemas().keySet()) {
                map.put(k, (Schema)this.api.getComponents().getSchemas().get(k));
            }
        }
        return map;
    }

    public void setDefinitions(Map<String, Schema<?>> definitions) {
        this.definitions = definitions;
    }

    public OpenapiApiValidatorStructure getValidationStructure() {
        return this.validationStructure;
    }

    public void setValidationStructure(OpenapiApiValidatorStructure validationStructure) {
        this.validationStructure = validationStructure;
    }

    @Override
    public void validate() throws ProcessingException, ParseWarningException {
        this.validate(false);
    }

    @Override
    public void validate(boolean validateBodyParameterElement) throws ProcessingException, ParseWarningException {
        this.validate(false, false);
    }

    @Override
    public void validate(boolean usingFromSetProtocolInfo, boolean validateBodyParameterElement) throws ProcessingException, ParseWarningException {
        if (!usingFromSetProtocolInfo && ApiFormats.OPEN_API_3.equals(this.format)) {
            this._validateOpenAPI3();
        }
        super.validate(usingFromSetProtocolInfo, validateBodyParameterElement);
        if (this.parseWarningResult != null && StringUtils.isNotEmpty((CharSequence)this.parseWarningResult)) {
            throw new ParseWarningException("\n" + this.parseWarningResult);
        }
    }

    private void _validateOpenAPI3() throws ProcessingException {
        block16: {
            try {
                YAMLUtils yamlUtils = YAMLUtils.getInstance();
                JSONUtils jsonUtils = JSONUtils.getInstance();
                boolean apiRawIsYaml = yamlUtils.isYaml(this.apiRaw);
                JsonNode schemaNodeRoot = null;
                schemaNodeRoot = apiRawIsYaml ? yamlUtils.getAsNode(this.apiRaw) : jsonUtils.getAsNode(this.apiRaw);
                JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
                List<String> refPath = null;
                try {
                    refPath = engine.getStringMatchPattern(schemaNodeRoot, "$..$ref");
                }
                catch (JsonPathNotFoundException jsonPathNotFoundException) {
                    // empty catch block
                }
                boolean refNonRisolvibili = false;
                if (refPath != null && !refPath.isEmpty()) {
                    for (String refP : refPath) {
                        String ref;
                        if (refP == null || (ref = refP.trim()).startsWith("#")) continue;
                        refNonRisolvibili = true;
                        break;
                    }
                }
                if (refNonRisolvibili) break block16;
                OAI3Context context = null;
                OpenApi3 openApi4j = null;
                try {
                    context = new OAI3Context(new URI("file:/").toURL(), schemaNodeRoot, null);
                    openApi4j = (OpenApi3)TreeUtil.json.convertValue((Object)context.getBaseDocument(), OpenApi3.class);
                    openApi4j.setContext((OAIContext)context);
                }
                catch (Throwable e) {
                    throw new ProcessingException(e.getMessage(), e);
                }
                try {
                    ValidationResults results = OpenApi3Validator.instance().validate(openApi4j);
                    if (!results.isValid()) {
                        throw new ProcessingException(results.toString());
                    }
                }
                catch (ValidationException valExc) {
                    if (valExc.results() != null) {
                        throw new ProcessingException(valExc.results().toString());
                    }
                    throw new ProcessingException(valExc.getMessage());
                }
                catch (ProcessingException pe) {
                    throw pe;
                }
                catch (Throwable e) {
                    e.printStackTrace(System.out);
                    Throwable eAnalyze = Utilities.getInnerNotEmptyMessageException(e);
                    throw new ProcessingException(eAnalyze != null ? eAnalyze.getMessage() : e.getMessage(), e);
                }
            }
            catch (ProcessingException pe) {
                if (this.parseWarningResult != null && StringUtils.isNotEmpty((CharSequence)this.parseWarningResult)) {
                    throw new ProcessingException("\n" + this.parseWarningResult + "\n" + pe.getMessage());
                }
                throw new ProcessingException(pe.getMessage());
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), e);
            }
        }
    }
}

