/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.models.Swagger;
import io.swagger.parser.Swagger20Parser;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ResolverFully;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.openapi.validator.Validator;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerValidatorUtils;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;

public class SwaggerRequestValidatorOpenAPI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JsonNode schemaNodeRoot;
    private OpenapiLibraryValidatorConfig openApi4jConfig;
    private Api api;
    private transient OpenAPI openApiSwagger;
    private transient Semaphore semaphore = new Semaphore("SwaggerRequestValidatorOpenAPI");

    public SwaggerRequestValidatorOpenAPI(JsonNode schemaNodeRoot, OpenapiLibraryValidatorConfig openApi4jConfig, Api api) {
        this.schemaNodeRoot = schemaNodeRoot;
        this.openApi4jConfig = openApi4jConfig;
        this.api = api;
    }

    public OpenAPI getOpenApiSwagger() throws ProcessingException, IOException {
        if (this.openApiSwagger == null) {
            this.init();
        }
        if (this.openApiSwagger == null) {
            throw new ProcessingException("OpenAPI init failed");
        }
        return this.openApiSwagger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws ProcessingException, IOException {
        if (this.openApiSwagger != null) {
            return;
        }
        SemaphoreLock lock = this.semaphore.acquireThrowRuntime("init");
        try {
            SwaggerParseResult result;
            String version = SwaggerValidatorUtils.getSchemaVersion(this.schemaNodeRoot);
            if (SwaggerValidatorUtils.isSchemaV2(version)) {
                Swagger20Parser swaggerParser = new Swagger20Parser();
                SwaggerConverter swaggerConverter = new SwaggerConverter();
                Swagger swagger = swaggerParser.read(this.schemaNodeRoot);
                if (swagger == null) throw new ProcessingException("Unknown error while parsing the Swagger root node.");
                SwaggerDeserializationResult foo = new SwaggerDeserializationResult();
                foo.setMessages(Arrays.asList(new String[0]));
                foo.setSwagger(swagger);
                result = swaggerConverter.convert(foo);
            } else {
                OpenAPIV3Parser v3Parser = new OpenAPIV3Parser();
                result = v3Parser.parseJsonNode(null, this.schemaNodeRoot);
            }
            if (result.getOpenAPI() == null) {
                throw new ProcessingException("Error while parsing the OpenAPI root node: " + String.join((CharSequence)"\n", result.getMessages()));
            }
            HashMap<Object, String> schemaMapSerialized = new HashMap<Object, String>();
            if (!this.openApi4jConfig.isMergeAPISpec() && this.api.getSchemas() != null) {
                for (ApiSchema apiSchema : this.api.getSchemas()) {
                    if (!ApiSchemaType.JSON.equals(apiSchema.getType()) && !ApiSchemaType.YAML.equals(apiSchema.getType())) continue;
                    String schemaBytes = new String(apiSchema.getContent());
                    schemaMapSerialized.put(apiSchema.getName(), schemaBytes);
                    schemaMapSerialized.put("./" + apiSchema.getName(), schemaBytes);
                }
            }
            OpenAPIResolver v3Resolver = new OpenAPIResolver(result.getOpenAPI(), schemaMapSerialized, null, 0);
            result.setOpenAPI(v3Resolver.resolve());
            if (!this.openApi4jConfig.isSwaggerRequestValidator_ResolveFullyApiSpec()) {
                ResolverFully v3ResolverFully = new ResolverFully(false);
                v3ResolverFully.resolveFully(result.getOpenAPI());
            }
            Validator.removeRegexPatternOnStringsOfFormatByte(result.getOpenAPI());
            Validator.removeTypeObjectAssociationWithOneOfAndAnyOfModels(result.getOpenAPI());
            if (this.openApi4jConfig.isValidateAPISpec() && result.getMessages().size() != 0) {
                throw new ProcessingException("OpenAPI3 not valid: " + String.join((CharSequence)"\n", result.getMessages()));
            }
            this.openApiSwagger = result.getOpenAPI();
            return;
        }
        finally {
            this.semaphore.release(lock, "init");
        }
    }
}

