/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator.swagger;

import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.CharMatcher;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Pattern;

public class SwaggerValidatorUtils {
    public static boolean isBase64SchemaFile(Schema<?> schema) {
        return "string".equals(schema.getType()) && "base64".equals(schema.getFormat());
    }

    public static boolean isBinarySchemaFile(Schema<?> schema) {
        return "string".equals(schema.getType()) && "binary".equals(schema.getFormat());
    }

    private static final Optional<String> validateBase64String(String input) {
        Pattern PATTERN = Pattern.compile("==?$");
        CharMatcher NOT_BASE64 = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"+/")).negate();
        if (input.length() % 4 != 0) {
            return Optional.of("err.format.base64.badLength, should be multiple of 4: " + input.length());
        }
        int index = NOT_BASE64.indexIn((CharSequence)PATTERN.matcher(input).replaceFirst(""));
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of("err.format.base64.illegalChars: character '" + Character.toString(input.charAt(index)) + "' index " + index);
    }

    public static final ValidationReport validateBase64Body(Body body, MessageResolver messages, boolean request) {
        try {
            Optional<String> error = SwaggerValidatorUtils.validateBase64String(body.toString(StandardCharsets.UTF_8));
            if (error.isPresent()) {
                return ValidationReport.singleton((ValidationReport.Message)messages.create(request ? "validation.request.body.schema" : "validation.response.body.schema", (request ? "[REQUEST] " : "[RESPONSE] ") + error.get(), new String[0]));
            }
            return ValidationReport.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final ValidationReport validateJsonFormat(Body body, MessageResolver messages, boolean request) {
        try {
            body.toJsonNode();
        }
        catch (IOException e) {
            return ValidationReport.singleton((ValidationReport.Message)messages.create(request ? "validation.request.body.schema.invalidJson" : "validation.response.body.schema.invalidJson", messages.get("validation.schema.invalidJson", new Object[]{e.getMessage()}).getMessage(), new String[0]));
        }
        return ValidationReport.empty();
    }

    public static final String getSchemaVersion(JsonNode node) {
        if (node == null) {
            return null;
        }
        JsonNode version = node.get("openapi");
        if (version != null) {
            return version.toString();
        }
        version = node.get("swagger");
        if (version != null) {
            return version.toString();
        }
        version = node.get("swaggerVersion");
        if (version != null) {
            return version.toString();
        }
        return null;
    }

    public static final boolean isSchemaV1(String version) {
        return version != null && (version.startsWith("\"1") || version.startsWith("1"));
    }

    public static final boolean isSchemaV2(String version) {
        return version != null && (version.startsWith("\"2") || version.startsWith("2"));
    }

    public static final boolean isSchemaV3(String version) {
        return version != null && (version.startsWith("\"3") || version.startsWith("3"));
    }
}

