/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.pdf.PDFSignerInformation;

public class PDFSignature {
    private PDSignatureField signatureField;
    private PDSignature signature;
    private List<PDFSignerInformation> signers = new ArrayList<PDFSignerInformation>();

    public PDFSignature(byte[] pdf, PDSignatureField signatureField, PDSignature signature) throws UtilsException {
        this.signatureField = signatureField;
        this.signature = signature;
        this.init(pdf);
    }

    private void init(byte[] pdf) throws UtilsException {
        try {
            byte[] signatureContent = this.signature.getContents(pdf);
            byte[] signedContent = this.signature.getSignedContent(pdf);
            CMSProcessableByteArray cmsProcessableInputStream = new CMSProcessableByteArray(signedContent);
            CMSSignedData cmsSignedData = new CMSSignedData((CMSProcessable)cmsProcessableInputStream, signatureContent);
            Store certStore = cmsSignedData.getCertificates();
            SignerInformationStore signerInfos = cmsSignedData.getSignerInfos();
            for (SignerInformation signer : signerInfos.getSigners()) {
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                ArrayList<Certificate> certificates = new ArrayList<Certificate>();
                for (X509CertificateHolder certificateHolder : certCollection) {
                    Certificate cer = ArchiveLoader.load(certificateHolder.getEncoded());
                    certificates.add(cer);
                }
                PDFSignerInformation info = new PDFSignerInformation();
                info.setCertificates(certificates);
                info.setSigner(signer);
                this.signers.add(info);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PDSignatureField getSignatureField() {
        return this.signatureField;
    }

    public PDSignature getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.signature.getName();
    }

    public List<PDFSignerInformation> getSigners() {
        return this.signers;
    }
}

