/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.problem;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.rest.problem.AbstractDeserializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;

public class JsonDeserializer
extends AbstractDeserializer {
    private JSONUtils jsonUtils = JSONUtils.getInstance();

    public JsonDeserializer() {
        this(false);
    }

    public JsonDeserializer(boolean generateTypeBlank) {
        super(generateTypeBlank);
    }

    public ProblemRFC7807 fromString(String problemString) throws UtilsException {
        return this.fromString(problemString, false);
    }

    public ProblemRFC7807 fromString(String problemString, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        ObjectNode problemNode = (ObjectNode)this.jsonUtils.getAsNode(problemString);
        ProblemRFC7807 p = new ProblemRFC7807();
        p.setRaw(problemString);
        return this._fromNode(p, problemNode, throwExceptionIfUnsupportedCustomClaim);
    }

    public ProblemRFC7807 fromByteArray(byte[] problemByteArray) throws UtilsException {
        return this.fromByteArray(problemByteArray, false);
    }

    public ProblemRFC7807 fromByteArray(byte[] problemByteArray, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        ObjectNode problemNode = (ObjectNode)this.jsonUtils.getAsNode(problemByteArray);
        ProblemRFC7807 p = new ProblemRFC7807();
        p.setRaw(new String(problemByteArray));
        return this._fromNode(p, problemNode, throwExceptionIfUnsupportedCustomClaim);
    }

    public ProblemRFC7807 fromNode(ObjectNode problemNode) throws UtilsException {
        return this._fromNode(null, problemNode, false);
    }

    public ProblemRFC7807 fromNode(ObjectNode problemNode, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        return this._fromNode(null, problemNode, throwExceptionIfUnsupportedCustomClaim);
    }

    private ProblemRFC7807 _fromNode(ProblemRFC7807 problemParam, ObjectNode problemNode, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        ProblemRFC7807 problem = null;
        problem = problemParam != null ? problemParam : new ProblemRFC7807();
        Iterator it = problemNode.fieldNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            JsonNode value = problemNode.get(name);
            super.set(problem, name, value, throwExceptionIfUnsupportedCustomClaim);
        }
        if (problem.getRaw() == null) {
            problem.setRaw(this.jsonUtils.toString((JsonNode)problemNode));
        }
        return problem;
    }
}

