/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.problem;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSerializer {
    private boolean generateTypeBlank = false;
    private XMLUtils xmlUtils = XMLUtils.getInstance();
    private boolean prettyPrint;

    public XmlSerializer() {
        this(false, false);
    }

    public XmlSerializer(boolean prettyPrint) {
        this(prettyPrint, false);
    }

    public XmlSerializer(boolean prettyPrint, boolean generateTypeBlank) {
        this.generateTypeBlank = generateTypeBlank;
        this.prettyPrint = prettyPrint;
    }

    public boolean isGenerateTypeBlank() {
        return this.generateTypeBlank;
    }

    public void setGenerateTypeBlank(boolean generateTypeBlank) {
        this.generateTypeBlank = generateTypeBlank;
    }

    public String toString(ProblemRFC7807 problem) throws UtilsException {
        return this.toString(problem, false);
    }

    public String toString(ProblemRFC7807 problem, boolean omitXMLDeclaration) throws UtilsException {
        Element xmlProblem = this.toNode(problem);
        if (this.prettyPrint) {
            try {
                return PrettyPrintXMLUtils.prettyPrintWithTrAX(xmlProblem, omitXMLDeclaration);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        try {
            return this.xmlUtils.toString(xmlProblem, omitXMLDeclaration);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] toByteArray(ProblemRFC7807 problem) throws UtilsException {
        return this.toByteArray(problem, false);
    }

    public byte[] toByteArray(ProblemRFC7807 problem, boolean omitXMLDeclaration) throws UtilsException {
        Element xmlProblem = this.toNode(problem);
        if (this.prettyPrint) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrettyPrintXMLUtils.prettyPrintWithTrAX(xmlProblem, (OutputStream)bout, omitXMLDeclaration);
                bout.flush();
                bout.close();
                return bout.toByteArray();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        try {
            return this.xmlUtils.toByteArray(xmlProblem, omitXMLDeclaration);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Element toNode(ProblemRFC7807 problem) throws UtilsException {
        Element child;
        Document document = null;
        try {
            document = this.xmlUtils.newDocument();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        Element xmlProblem = document.createElementNS("urn:ietf:rfc:7807", "problem");
        if (problem.getType() != null) {
            child = document.createElement("type");
            child.setTextContent(problem.getType());
            xmlProblem.appendChild(child);
        } else if (this.generateTypeBlank) {
            child = document.createElement("type");
            child.setTextContent("about:blank");
            xmlProblem.appendChild(child);
        }
        if (problem.getTitle() != null) {
            child = document.createElement("title");
            child.setTextContent(problem.getTitle());
            xmlProblem.appendChild(child);
        }
        if (problem.getStatus() != null) {
            child = document.createElement("status");
            child.setTextContent("" + problem.getStatus());
            xmlProblem.appendChild(child);
        }
        if (problem.getDetail() != null) {
            child = document.createElement("detail");
            child.setTextContent(problem.getDetail());
            xmlProblem.appendChild(child);
        }
        if (problem.getInstance() != null) {
            child = document.createElement("instance");
            child.setTextContent(problem.getInstance());
            xmlProblem.appendChild(child);
        }
        this.processCustom(problem, document, xmlProblem);
        return xmlProblem;
    }

    private void processCustom(ProblemRFC7807 problem, Document document, Element xmlProblem) throws UtilsException {
        if (problem.getCustom() != null && !problem.getCustom().isEmpty()) {
            for (String claimName : problem.getCustom().keySet()) {
                Object o = problem.getCustom().get(claimName);
                if (o == null) continue;
                Element child = document.createElement(claimName);
                if (o instanceof String) {
                    child.setTextContent((String)o);
                } else if (o instanceof Integer) {
                    child.setTextContent(((Integer)o).toString());
                } else if (o instanceof Long) {
                    child.setTextContent(((Long)o).toString());
                } else if (o instanceof Boolean) {
                    child.setTextContent(((Boolean)o).toString());
                } else {
                    throw new UtilsException("Custom claim with type [" + o.getClass().getName() + "] unsupported");
                }
                xmlProblem.appendChild(child);
            }
        }
    }
}

