/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.problem.test;

import org.openspcoop2.utils.rest.problem.JsonDeserializer;
import org.openspcoop2.utils.rest.problem.JsonSerializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807Builder;
import org.openspcoop2.utils.rest.problem.XmlDeserializer;
import org.openspcoop2.utils.rest.problem.XmlSerializer;

public class ProblemTest {
    public static void main(String[] args) throws Exception {
        ProblemTest.test();
    }

    public static void test() throws Exception {
        boolean setType = true;
        ProblemRFC7807Builder builder1 = new ProblemRFC7807Builder(setType);
        ProblemRFC7807Builder builder2 = new ProblemRFC7807Builder(!setType);
        boolean prettyPrint = true;
        boolean generateTypeBlank = true;
        boolean omitXMLDeclaration = true;
        JsonSerializer jsonSerializer = new JsonSerializer(prettyPrint);
        JsonSerializer jsonSerializer_generateTypeBlank = new JsonSerializer(prettyPrint, generateTypeBlank);
        XmlSerializer xmlSerializer = new XmlSerializer(prettyPrint);
        XmlSerializer xmlSerializer_generateTypeBlank = new XmlSerializer(prettyPrint, generateTypeBlank);
        JsonDeserializer jsonDeserializer = new JsonDeserializer();
        XmlDeserializer xmlDeserializer = new XmlDeserializer();
        ProblemRFC7807 problem1 = builder1.buildProblem(400);
        problem1.setDetail("Esempio di dettaglio del problema");
        problem1.setInstance("NomeIdentificativo");
        problem1.getCustom().put("esempio1", "valore di esempio");
        problem1.getCustom().put("esempio2", 423);
        problem1.getCustom().put("esempio3", true);
        String jsonProblem1 = jsonSerializer.toString(problem1);
        System.out.println("JSON Problem1 [" + jsonProblem1 + "]");
        System.out.println("JSON Problem1 ricostruito [" + String.valueOf(jsonDeserializer.fromString(jsonProblem1)) + "]");
        String xmlProblem1 = xmlSerializer.toString(problem1);
        System.out.println("XML Problem1 [" + xmlProblem1 + "]");
        System.out.println("XML Problem1 ricostruito [" + String.valueOf(xmlDeserializer.fromString(xmlProblem1)) + "]");
        ProblemRFC7807 problem2 = builder2.buildProblem(404);
        System.out.println("JSON Problem2 [" + jsonSerializer.toString(problem2) + "]");
        System.out.println("XML Problem2 [" + xmlSerializer.toString(problem2, omitXMLDeclaration) + "]");
        System.out.println("JSON Problem2 typeBlank [" + jsonSerializer_generateTypeBlank.toString(problem2) + "]");
        System.out.println("XML Problem2 typeBlank [" + xmlSerializer_generateTypeBlank.toString(problem2) + "]");
    }
}

