/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.Encrypt;

public class EncryptWrapKey {
    private Key key;
    private Certificate certificate;
    private byte[] wrappedKey;
    private byte[] iv;

    public EncryptWrapKey(Certificate certificate) {
        this.certificate = certificate;
    }

    public EncryptWrapKey(Key key) {
        this.key = key;
    }

    public EncryptWrapKey(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this.key = keystore.getPrivateKey(alias, passwordPrivateKey);
    }

    public EncryptWrapKey(KeyStore keystore, String alias) throws UtilsException {
        this.certificate = keystore.getCertificate(alias);
    }

    public EncryptWrapKey(KeyStore keystore) throws UtilsException {
        this.certificate = keystore.getCertificate();
    }

    protected byte[] process(String data, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        try {
            return this.process(data.getBytes(charsetName), wrappedKeyAlgorithm, contentAlgorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected byte[] process(byte[] data, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        try {
            int symmetricKeySize = 256;
            if (wrappedKeyAlgorithm.contains("128")) {
                symmetricKeySize = 128;
            } else if (wrappedKeyAlgorithm.contains("192")) {
                symmetricKeySize = 192;
            }
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(symmetricKeySize);
            SecretKey secretKey = keyGen.generateKey();
            Cipher cipher = Cipher.getInstance(wrappedKeyAlgorithm);
            if (this.certificate != null) {
                cipher.init(3, this.certificate);
            } else {
                cipher.init(3, this.key);
            }
            this.wrappedKey = cipher.wrap(secretKey);
            Encrypt encrypt = new Encrypt(secretKey);
            encrypt.initIV(contentAlgorithm);
            this.iv = encrypt.getIV();
            return encrypt.encrypt(data, contentAlgorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String getWrappedKeyBase64() {
        return Base64Utilities.encodeAsString(this.wrappedKey);
    }

    public String getWrappedKeyHexBinary() throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.wrappedKey);
    }

    public byte[] getWrappedKey() {
        return this.wrappedKey;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public byte[] getIVBase64() {
        return Base64Utilities.encode(this.iv);
    }

    public String getIVBase64AsString() {
        return Base64Utilities.encodeAsString(this.iv);
    }

    public char[] getIVHexBinary() throws UtilsException {
        return HexBinaryUtilities.encode(this.iv);
    }

    public String getIVHexBinaryAsString() throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.iv);
    }

    public byte[] encrypt(String data, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return this.process(data, charsetName, wrappedKeyAlgorithm, contentAlgorithm);
    }

    public byte[] encrypt(byte[] data, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return this.process(data, wrappedKeyAlgorithm, contentAlgorithm);
    }

    public byte[] encryptBase64(String data, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encode(this.process(data, charsetName, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public byte[] encryptBase64(byte[] data, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encode(this.process(data, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String encryptBase64AsString(String data, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encodeAsString(this.process(data, charsetName, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String encryptBase64AsString(byte[] data, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encodeAsString(this.process(data, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public char[] encryptHexBinary(String data, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encode(this.process(data, charsetName, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public char[] encryptHexBinary(byte[] data, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encode(this.process(data, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String encryptHexBinaryAsString(String data, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.process(data, charsetName, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String encryptHexBinaryAsString(byte[] data, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.process(data, wrappedKeyAlgorithm, contentAlgorithm));
    }
}

