/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.KeyStore;
import java.security.PublicKey;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonProducer;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JwkUtils;
import org.openspcoop2.utils.security.JWEOptions;
import org.openspcoop2.utils.security.JsonUtils;
import org.openspcoop2.utils.security.JwtHeaders;

public class JsonEncrypt {
    private JweEncryptionProvider provider;
    private ContentAlgorithm contentAlgorithm;
    private KeyAlgorithm keyAlgorithm;
    private JWEOptions options;
    private JweHeaders headers;
    private JwtHeaders jwtHeaders;

    public JsonEncrypt(Properties props, JWEOptions options) throws UtilsException {
        this(props, null, options);
    }

    public JsonEncrypt(Properties props, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        try {
            this.headers = new JweHeaders();
            this.options = options;
            String tmp = props.getProperty("rs.security.encryption.zip.algorithm");
            if (tmp != null && "DEF".equalsIgnoreCase(tmp.trim())) {
                this.options.setDeflate(true);
            }
            this.provider = JsonUtils.getJweEncryptionProvider(props);
            if (this.provider == null) {
                KeyAlgorithm keyAlgorithmP = JweUtils.getKeyEncryptionAlgorithm((Properties)props, null);
                this.provider = KeyAlgorithm.DIRECT.equals((Object)keyAlgorithmP) ? JsonUtils.getJweEncryptionProviderFromJWKSymmetric(props, this.headers) : JweUtils.loadEncryptionProvider((Properties)props, (Message)JsonUtils.newMessage(), (JweHeaders)this.headers);
            }
            this.contentAlgorithm = JweUtils.getContentEncryptionAlgorithm((Properties)props, (ContentAlgorithm)ContentAlgorithm.A256GCM);
            this.keyAlgorithm = JweUtils.getKeyEncryptionAlgorithm((Properties)props, null);
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, true, t);
        }
    }

    public JsonEncrypt(KeyStore keystore, String alias, String keyAlgorithm, String contentAlgorithm, JWEOptions options) throws UtilsException {
        this.initTrustStore(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, keyAlgorithm, contentAlgorithm, null, options);
    }

    public JsonEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String keyAlgorithm, String contentAlgorithm, JWEOptions options) throws UtilsException {
        this.initTrustStore(keystore, alias, keyAlgorithm, contentAlgorithm, null, options);
    }

    public JsonEncrypt(KeyStore keystore, String alias, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        this.initTrustStore(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, keyAlgorithm, contentAlgorithm, jwtHeaders, options);
    }

    public JsonEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        this.initTrustStore(keystore, alias, keyAlgorithm, contentAlgorithm, jwtHeaders, options);
    }

    private void initTrustStore(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        try {
            this.options = options;
            this.keyAlgorithm = KeyAlgorithm.getAlgorithm((String)keyAlgorithm);
            this.contentAlgorithm = ContentAlgorithm.getAlgorithm((String)contentAlgorithm);
            String compression = null;
            if (this.options.isDeflate()) {
                compression = "DEF";
            }
            this.provider = JweUtils.createJweEncryptionProvider((PublicKey)keystore.getPublicKey(alias), (KeyAlgorithm)this.keyAlgorithm, (ContentAlgorithm)this.contentAlgorithm, (String)compression);
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, true, t);
        }
    }

    public JsonEncrypt(KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JWEOptions options) throws UtilsException {
        this.initKeystore(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, null, options);
    }

    public JsonEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JWEOptions options) throws UtilsException {
        this.initKeystore(keystore, alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, null, options);
    }

    public JsonEncrypt(KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        this.initKeystore(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, jwtHeaders, options);
    }

    public JsonEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        this.initKeystore(keystore, alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, jwtHeaders, options);
    }

    private void initKeystore(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        try {
            this.options = options;
            this.keyAlgorithm = KeyAlgorithm.getAlgorithm((String)keyAlgorithm);
            this.contentAlgorithm = ContentAlgorithm.getAlgorithm((String)contentAlgorithm);
            String compression = null;
            if (this.options.isDeflate()) {
                compression = "DEF";
            }
            this.provider = KeyAlgorithm.DIRECT.equals((Object)this.keyAlgorithm) ? JweUtils.getDirectKeyJweEncryption((SecretKey)keystore.getSecretKey(alias, passwordPrivateKey), (ContentAlgorithm)this.contentAlgorithm) : JweUtils.createJweEncryptionProvider((SecretKey)keystore.getSecretKey(alias, passwordPrivateKey), (KeyAlgorithm)this.keyAlgorithm, (ContentAlgorithm)this.contentAlgorithm, (String)compression);
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, true, t);
        }
    }

    public JsonEncrypt(JsonWebKeys jsonWebKeys, boolean secretKey, String alias, String keyAlgorithm, String contentAlgorithm, JWEOptions options) throws UtilsException {
        this.initJsonWebKey(JsonUtils.readKey(jsonWebKeys, alias), secretKey, keyAlgorithm, contentAlgorithm, null, options);
    }

    public JsonEncrypt(JsonWebKeys jsonWebKeys, boolean secretKey, String alias, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        this.initJsonWebKey(JsonUtils.readKey(jsonWebKeys, alias), secretKey, keyAlgorithm, contentAlgorithm, jwtHeaders, options);
    }

    public JsonEncrypt(JsonWebKey jsonWebKey, boolean secretKey, String keyAlgorithm, String contentAlgorithm, JWEOptions options) throws UtilsException {
        this.initJsonWebKey(jsonWebKey, secretKey, keyAlgorithm, contentAlgorithm, null, options);
    }

    public JsonEncrypt(JsonWebKey jsonWebKey, boolean secretKey, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        this.initJsonWebKey(jsonWebKey, secretKey, keyAlgorithm, contentAlgorithm, jwtHeaders, options);
    }

    private void initJsonWebKey(JsonWebKey jsonWebKey, boolean secretKey, String keyAlgorithm, String contentAlgorithm, JwtHeaders jwtHeaders, JWEOptions options) throws UtilsException {
        try {
            this.options = options;
            this.keyAlgorithm = KeyAlgorithm.getAlgorithm((String)keyAlgorithm);
            this.contentAlgorithm = ContentAlgorithm.getAlgorithm((String)contentAlgorithm);
            String compression = null;
            if (this.options.isDeflate()) {
                compression = "DEF";
            }
            if (secretKey) {
                if (jsonWebKey.getAlgorithm() == null) {
                    jsonWebKey.setAlgorithm(contentAlgorithm);
                }
                this.provider = KeyAlgorithm.DIRECT.equals((Object)this.keyAlgorithm) ? JweUtils.getDirectKeyJweEncryption((SecretKey)JwkUtils.toSecretKey(jsonWebKey), (ContentAlgorithm)this.contentAlgorithm) : JweUtils.createJweEncryptionProvider((SecretKey)JwkUtils.toSecretKey(jsonWebKey), (KeyAlgorithm)this.keyAlgorithm, (ContentAlgorithm)this.contentAlgorithm, (String)compression);
                if (this.provider == null) {
                    throw new UtilsException("(JsonWebKey) JwsEncryptionProvider init failed; check content algorithm (" + contentAlgorithm + ")");
                }
            } else {
                this.provider = JweUtils.createJweEncryptionProvider((PublicKey)JwkUtils.toPublicKey(jsonWebKey), (KeyAlgorithm)this.keyAlgorithm, (ContentAlgorithm)this.contentAlgorithm, (String)compression);
            }
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, true, t);
        }
    }

    public String encrypt(String jsonString) throws UtilsException {
        try {
            switch (this.options.getSerialization()) {
                case JSON: {
                    return this.encryptJson(jsonString);
                }
                case COMPACT: {
                    return this.encryptCompact(jsonString);
                }
            }
            throw new UtilsException("Unsupported serialization '" + String.valueOf((Object)this.options.getSerialization()) + "'");
        }
        catch (Exception t) {
            throw JsonUtils.convert(this.options.getSerialization(), false, true, t);
        }
    }

    public String encrypt(byte[] json) throws UtilsException {
        try {
            switch (this.options.getSerialization()) {
                case JSON: {
                    return this.encryptJson(json);
                }
                case COMPACT: {
                    return this.encryptCompact(json);
                }
            }
            throw new UtilsException("Unsupported serialization '" + String.valueOf((Object)this.options.getSerialization()) + "'");
        }
        catch (Exception t) {
            throw JsonUtils.convert(this.options.getSerialization(), false, true, t);
        }
    }

    private String encryptCompact(String jsonString) throws Exception {
        return this.encryptCompact(jsonString.getBytes());
    }

    private String encryptCompact(byte[] json) throws Exception {
        JweHeaders headersBuild = null;
        headersBuild = this.keyAlgorithm != null ? new JweHeaders(this.keyAlgorithm, this.contentAlgorithm, this.options.isDeflate()) : new JweHeaders(this.contentAlgorithm, this.options.isDeflate());
        this.fillJwtHeaders(headersBuild, this.keyAlgorithm);
        return this.provider.encrypt(json, headersBuild);
    }

    private String encryptJson(String jsonString) throws Exception {
        return this.encryptJson(jsonString.getBytes());
    }

    private String encryptJson(byte[] json) throws Exception {
        JweHeaders sharedUnprotectedHeaders = null;
        if (this.keyAlgorithm != null) {
            sharedUnprotectedHeaders = new JweHeaders();
            sharedUnprotectedHeaders.setKeyEncryptionAlgorithm(this.keyAlgorithm);
        }
        JweHeaders protectedHeaders = new JweHeaders(this.contentAlgorithm, this.options.isDeflate());
        this.fillJwtHeaders(protectedHeaders, this.keyAlgorithm);
        JweJsonProducer producer = null;
        if (sharedUnprotectedHeaders != null) {
            protectedHeaders.removeProperty("alg");
            producer = new JweJsonProducer(protectedHeaders, sharedUnprotectedHeaders, json);
        } else {
            producer = new JweJsonProducer(protectedHeaders, json);
        }
        return producer.encryptWith(this.provider);
    }

    private void fillJwtHeaders(JweHeaders headers, KeyAlgorithm keyAlgo) throws Exception {
        if (this.headers != null && this.headers.asMap() != null && !this.headers.asMap().isEmpty()) {
            for (String key : this.headers.asMap().keySet()) {
                if (headers.containsHeader(key)) continue;
                headers.setHeader(key, this.headers.getHeader(key));
            }
        }
        if (this.jwtHeaders != null) {
            this.jwtHeaders.fillJwsHeaders((JoseHeaders)headers, false, keyAlgo != null ? keyAlgo.getJwaName() : null);
        }
    }
}

