/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JwkUtils;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.security.HmacJwsSignatureProviderExtended;
import org.openspcoop2.utils.security.JWSOptions;
import org.openspcoop2.utils.security.JsonUtils;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.security.SecretKeyPkcs11;

public class JsonSignature {
    private JwsSignatureProvider provider;
    private JWSOptions options;
    private JwsHeaders headers;
    private JwtHeaders jwtHeaders;

    public JsonSignature(Properties props, JWSOptions options) throws UtilsException {
        this(props, null, options);
    }

    public JsonSignature(Properties props, JwtHeaders jwtHeaders, JWSOptions options) throws UtilsException {
        try {
            block5: {
                this.headers = new JwsHeaders(props);
                this.provider = JsonUtils.getJwsSymmetricProvider(props);
                if (this.provider == null) {
                    try {
                        this.provider = JwsUtils.loadSignatureProvider((Message)JsonUtils.newMessage(), (Properties)props, (JwsHeaders)this.headers);
                    }
                    catch (JwsException jwsExc) {
                        if (jwsExc.getMessage() == null || !jwsExc.getMessage().contains("NO_PROVIDER")) break block5;
                        this.provider = JsonUtils.getJwsAsymmetricProvider(props);
                        if (this.provider != null) break block5;
                        throw jwsExc;
                    }
                }
            }
            this.options = options;
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, true, t);
        }
    }

    public JsonSignature(KeyStore keystore, boolean secretKey, String alias, String passwordPrivateKey, String signatureAlgorithm, JWSOptions options) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), secretKey, alias, passwordPrivateKey, signatureAlgorithm, null, options);
    }

    public JsonSignature(org.openspcoop2.utils.certificate.KeyStore keystore, boolean secretKey, String alias, String passwordPrivateKey, String signatureAlgorithm, JWSOptions options) throws UtilsException {
        this(keystore, secretKey, alias, passwordPrivateKey, signatureAlgorithm, null, options);
    }

    public JsonSignature(KeyStore keystore, boolean secretKey, String alias, String passwordPrivateKey, String signatureAlgorithm, JwtHeaders jwtHeaders, JWSOptions options) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), secretKey, alias, passwordPrivateKey, signatureAlgorithm, jwtHeaders, options);
    }

    public JsonSignature(org.openspcoop2.utils.certificate.KeyStore keystore, boolean secretKey, String alias, String passwordPrivateKey, String signatureAlgorithm, JwtHeaders jwtHeaders, JWSOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            if (secretKey) {
                String tipo = KeystoreType.JCEKS.getLabel();
                SecretKey secret = keystore.getSecretKey(alias, passwordPrivateKey);
                if (KeystoreType.PKCS11.getNome().equalsIgnoreCase(keystore.getKeystoreType())) {
                    tipo = KeystoreType.PKCS11.getLabel();
                    SecretKeyPkcs11 secretKeyPkcs11 = new SecretKeyPkcs11(keystore.getKeystoreProvider(), secret);
                    this.provider = new HmacJwsSignatureProviderExtended(secretKeyPkcs11, algo);
                } else {
                    this.provider = JwsUtils.getHmacSignatureProvider((byte[])secret.getEncoded(), (SignatureAlgorithm)algo);
                }
                if (this.provider == null) {
                    throw new UtilsException("(" + tipo + ") JwsSignatureProvider init failed; check signature algorithm (" + signatureAlgorithm + ")");
                }
            } else {
                PrivateKey pKey = keystore.getPrivateKey(alias, passwordPrivateKey);
                this.provider = JwsUtils.getPrivateKeySignatureProvider((PrivateKey)pKey, (SignatureAlgorithm)algo);
                if (this.provider == null) {
                    this.provider = JsonUtils.getJwsAsymmetricProvider(pKey, algo);
                    if (this.provider == null) {
                        throw new UtilsException("(" + keystore.getKeystore().getType() + ") JwsSignatureProvider init failed; check signature algorithm (" + signatureAlgorithm + ")");
                    }
                }
            }
            this.options = options;
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, true, t);
        }
    }

    public JsonSignature(JsonWebKeys jsonWebKeys, boolean secretKey, String alias, String signatureAlgorithm, JWSOptions options) throws UtilsException {
        this(jsonWebKeys, secretKey, alias, signatureAlgorithm, null, options);
    }

    public JsonSignature(JsonWebKeys jsonWebKeys, boolean secretKey, String alias, String signatureAlgorithm, JwtHeaders jwtHeaders, JWSOptions options) throws UtilsException {
        this(JsonUtils.readKey(jsonWebKeys, alias), secretKey, signatureAlgorithm, jwtHeaders, options);
    }

    public JsonSignature(JsonWebKey jsonWebKey, boolean secretKey, String signatureAlgorithm, JWSOptions options) throws UtilsException {
        this(jsonWebKey, secretKey, signatureAlgorithm, null, options);
    }

    public JsonSignature(JsonWebKey jsonWebKey, boolean secretKey, String signatureAlgorithm, JwtHeaders jwtHeaders, JWSOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            if (secretKey) {
                this.provider = JwsUtils.getSignatureProvider((JsonWebKey)jsonWebKey, (SignatureAlgorithm)algo);
                if (this.provider == null) {
                    throw new UtilsException("(JsonWebKey) JwsSignatureProvider init failed; check signature algorithm (" + signatureAlgorithm + ")");
                }
            } else {
                PrivateKey pKey = JwkUtils.toPrivateKey(jsonWebKey);
                this.provider = JwsUtils.getPrivateKeySignatureProvider((PrivateKey)pKey, (SignatureAlgorithm)algo);
            }
            this.options = options;
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, true, t);
        }
    }

    public JsonSignature(String secret, String signatureAlgorithm, JWSOptions options) throws UtilsException {
        this(secret, signatureAlgorithm, null, options);
    }

    public JsonSignature(String secret, String signatureAlgorithm, JwtHeaders jwtHeaders, JWSOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            this.provider = JwsUtils.getHmacSignatureProvider((byte[])secret.getBytes(), (SignatureAlgorithm)algo);
            if (this.provider == null) {
                throw new UtilsException("(Secret) JwsSignatureProvider init failed; check signature algorithm (" + signatureAlgorithm + ")");
            }
            this.options = options;
            this.jwtHeaders = jwtHeaders;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, true, t);
        }
    }

    public String sign(String jsonString) throws UtilsException {
        try {
            switch (this.options.getSerialization()) {
                case JSON: {
                    return this.signJson(jsonString);
                }
                case COMPACT: {
                    return this.signCompact(jsonString);
                }
            }
            throw new UtilsException("Unsupported serialization '" + String.valueOf((Object)this.options.getSerialization()) + "'");
        }
        catch (Exception t) {
            throw JsonUtils.convert(this.options.getSerialization(), true, true, t);
        }
    }

    private String signCompact(String jsonString) throws Exception {
        JwsHeaders headersInternal = new JwsHeaders(this.provider.getAlgorithm());
        JwsCompactProducer jwsProducer = new JwsCompactProducer(headersInternal, jsonString, this.options.isDetached());
        this.fillJwtHeaders(jwsProducer.getJwsHeaders(), this.provider.getAlgorithm());
        return jwsProducer.signWith(this.provider);
    }

    private String signJson(String jsonString) throws Exception {
        JwsJsonProducer jwsProducer = new JwsJsonProducer(jsonString, false, this.options.isDetached());
        JwsHeaders headersInternal = new JwsHeaders(this.provider.getAlgorithm());
        if (!this.options.isPayloadEncoding()) {
            headersInternal.setPayloadEncodingStatus(Boolean.valueOf(this.options.isPayloadEncoding()));
        }
        this.fillJwtHeaders(headersInternal, this.provider.getAlgorithm());
        return jwsProducer.signWith(this.provider, headersInternal);
    }

    private void fillJwtHeaders(JwsHeaders headers, SignatureAlgorithm signatureAlgo) throws Exception {
        if (this.headers != null && this.headers.asMap() != null && !this.headers.asMap().isEmpty()) {
            for (String key : this.headers.asMap().keySet()) {
                if (headers.containsHeader(key)) continue;
                headers.setHeader(key, this.headers.getHeader(key));
            }
        }
        if (this.jwtHeaders != null) {
            this.jwtHeaders.fillJwsHeaders((JoseHeaders)headers, false, signatureAlgo.getJwaName());
        }
    }
}

