/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.security.HmacJwsSignatureProviderExtended;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.SecretKeyPkcs11;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.IOCSPValidator;

public class JsonUtils {
    private static final String KEYSTORE_PREFIX_FILE = "keystore";
    private static final String JCEKS_SIGNATURE_ALGO_UNDEFINED = "(JCEKS) Signature Algorithm undefined";
    private static final String PKCS11_SIGNATURE_ALGO_UNDEFINED = "(SecretKey PKCS11) Signature Algorithm undefined";
    private static final String SECRET_SIGNATURE_ALGO_UNDEFINED = "(Secret) Signature Algorithm undefined";
    private static final String JCEKS_CONTENT_ALGO_UNDEFINED = "(JCEKS) Content Algorithm undefined";
    public static final boolean SIGNATURE = true;
    public static final boolean ENCRYPT = false;
    public static final boolean DECRYPT = false;
    public static final boolean SENDER = true;
    public static final boolean RECEIVER = false;
    public static final String RSSEC_KEY_STORE_TYPE_SECRET = "secret";

    private JsonUtils() {
    }

    public static Message newMessage() {
        MessageImpl m = new MessageImpl();
        ExchangeImpl ex = new ExchangeImpl();
        m.setExchange((Exchange)ex);
        return m;
    }

    public static UtilsException convert(JOSESerialization serialization, boolean signature, boolean roleSender, Throwable t) {
        StringBuilder bf = new StringBuilder();
        if (serialization != null) {
            bf.append("[").append(serialization.name()).append("] ");
        }
        if (t instanceof JwsException) {
            exc = (JwsException)t;
            if (exc.getError() == null) {
                if (roleSender) {
                    bf.append("Signature failure");
                } else {
                    bf.append("Signature verification failure");
                }
            } else {
                bf.append(exc.getError().name());
            }
            if (exc.getMessage() == null && exc.getCause() == null && exc.getLocalizedMessage() == null) {
                return new UtilsException(bf.toString(), t);
            }
        } else if (t instanceof JweException) {
            exc = (JweException)t;
            if (exc.getError() == null) {
                if (roleSender) {
                    bf.append("Encrypt failure");
                } else {
                    bf.append("Decrypt failure");
                }
            } else {
                bf.append(exc.getError().name());
            }
            if (exc.getMessage() == null && exc.getCause() == null && exc.getLocalizedMessage() == null) {
                return new UtilsException(bf.toString(), t);
            }
        } else if (signature) {
            if (roleSender) {
                bf.append("Signature failure");
            } else {
                bf.append("Signature verification failure");
            }
        } else if (roleSender) {
            bf.append("Encrypt failure");
        } else {
            bf.append("Decrypt failure");
        }
        String msg = Utilities.getInnerNotEmptyMessageException(t).getMessage();
        Throwable innerExc = Utilities.getLastInnerException(t);
        String innerMsg = null;
        if (innerExc != null) {
            innerMsg = innerExc.getMessage();
        }
        Object messaggio = null;
        if (msg != null && !"".equals(msg) && !"null".equals(msg)) {
            messaggio = msg;
            if (!(innerMsg == null || "".equals(innerMsg) || "null".equals(innerMsg) || innerMsg.equals(msg) || ((String)messaggio).contains(innerMsg))) {
                messaggio = (String)messaggio + " ; " + innerMsg;
            }
        } else if (innerMsg != null && !"".equals(innerMsg) && !"null".equals(innerMsg)) {
            messaggio = innerMsg;
        }
        if (messaggio != null) {
            bf.append(": ");
            bf.append((String)messaggio);
        }
        return new UtilsException(bf.toString(), t);
    }

    public static byte[] readKeystoreFromURI(Properties props) throws UtilsException {
        String propertyKeystoreName = "rs.security.keystore.file";
        String path = props.getProperty(propertyKeystoreName);
        byte[] content = null;
        if (path != null && (path.startsWith("http") || path.startsWith("https"))) {
            HttpResponse httpResponse = null;
            String trustStoreProperty = "rs.security.keystore.file.ssl";
            String trustStorePasswordProperty = "rs.security.keystore.password.ssl";
            String trustStoreTypeProperty = "rs.security.keystore.type.ssl";
            String trustStore = props.getProperty(trustStoreProperty);
            String trustStorePassword = props.getProperty(trustStorePasswordProperty);
            String trustStoreType = props.getProperty(trustStoreTypeProperty);
            if (trustStore != null) {
                if (trustStorePassword == null) {
                    throw new UtilsException("TrustStore ssl password undefined");
                }
                if (trustStoreType == null) {
                    throw new UtilsException("TrustStore ssl type undefined");
                }
            }
            if ((httpResponse = path.startsWith("https:") && trustStore == null || path.startsWith("http:") ? HttpUtilities.getHTTPResponse(path, 60000, 10000) : HttpUtilities.getHTTPSResponse(path, 60000, 10000, trustStore, trustStorePassword, trustStoreType)) == null || httpResponse.getContent() == null) {
                throw new UtilsException("Keystore '" + path + "' unavailable");
            }
            if (httpResponse.getResultHTTPOperation() != 200) {
                throw new UtilsException("Retrieve keystore '" + path + "' failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
            }
            content = httpResponse.getContent();
        } else if (path != null && path.startsWith("file")) {
            try {
                File f = new File(new URI(path));
                content = FileSystemUtilities.readBytesFromFile(f);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return content;
    }

    public static File normalizeProperties(Properties props) throws UtilsException {
        String propertyKeystoreName = "rs.security.keystore.file";
        byte[] content = JsonUtils.readKeystoreFromURI(props);
        File fTmp = null;
        if (content != null) {
            String tipo = props.getProperty("rs.security.keystore.type");
            if (tipo == null) {
                tipo = KeystoreType.JKS.getNome();
            }
            try {
                fTmp = FileSystemUtilities.createTempFile(KEYSTORE_PREFIX_FILE, "." + tipo);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
            FileSystemUtilities.writeFile(fTmp, content);
            props.remove(propertyKeystoreName);
            props.put(propertyKeystoreName, fTmp.getAbsolutePath());
        }
        return fTmp;
    }

    public static boolean isDynamicProvider(Properties props) {
        String alias = props.getProperty("rs.security.keystore.alias");
        if ("*".equalsIgnoreCase(alias)) {
            props.remove("rs.security.keystore.alias");
            return true;
        }
        return false;
    }

    public static String readAlias(String jsonString) throws UtilsException {
        if (!jsonString.contains(".")) {
            throw new UtilsException("Invalid format (expected COMPACT)");
        }
        String[] tmp = jsonString.split("\\.");
        byte[] header = Base64Utilities.decode(tmp[0].trim());
        JsonNode node = JSONUtils.getInstance().getAsNode(header).get("kid");
        if (node == null) {
            throw new UtilsException("Claim 'kid' not found");
        }
        String kid = node.asText();
        if (kid == null) {
            throw new UtilsException("Claim 'kid' without value");
        }
        return kid;
    }

    public static JsonWebKey readKey(JsonWebKeys jsonWebKeys, String alias) throws UtilsException {
        if (alias == null) {
            throw new UtilsException("Alias unknonw");
        }
        JsonWebKey jsonWebKey = jsonWebKeys.getKey(alias);
        if (jsonWebKey == null) {
            throw new UtilsException("Key with alias '" + alias + "' unknonw");
        }
        return jsonWebKey;
    }

    public static org.openspcoop2.utils.certificate.KeyStore getKeyStore(Properties props) throws UtilsException {
        return JsonUtils.getKeyStore(true, true, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.openspcoop2.utils.certificate.KeyStore getKeyStore(boolean jksPasswordRequired, boolean pkcs12PasswordRequired, Properties props) throws UtilsException {
        Object oKeystore = props.get("rs.security.keystore");
        if (oKeystore instanceof org.openspcoop2.utils.certificate.KeyStore) {
            return (org.openspcoop2.utils.certificate.KeyStore)oKeystore;
        }
        if (oKeystore instanceof KeyStore) {
            return new org.openspcoop2.utils.certificate.KeyStore((KeyStore)oKeystore);
        }
        String fileK = props.getProperty("rs.security.keystore.file");
        if (fileK != null) {
            String password = props.getProperty("rs.security.keystore.password");
            String type = props.getProperty("rs.security.keystore.type");
            if (password == null || "".equals(password)) {
                boolean required = true;
                if (KeystoreType.JKS.isType(type)) {
                    required = jksPasswordRequired;
                } else if (KeystoreType.PKCS12.isType(type)) {
                    required = pkcs12PasswordRequired;
                }
                if (required) {
                    throw new UtilsException("Keystore password undefined");
                }
            }
            if (type == null || "".equals(type)) {
                type = KeystoreType.JKS.getNome();
            }
            if (KeystoreType.JWK_SET.getNome().equalsIgnoreCase(type) || KeystoreType.PUBLIC_KEY.getNome().equalsIgnoreCase(type) || KeystoreType.KEY_PAIR.getNome().equalsIgnoreCase(type)) {
                return null;
            }
            File file = new File(fileK);
            if (file.exists()) {
                return new org.openspcoop2.utils.certificate.KeyStore(file.getAbsolutePath(), type, password);
            }
            InputStream is = JsonUtils.class.getResourceAsStream(fileK);
            File fTmp = null;
            try {
                if (is != null) {
                    byte[] f = Utilities.getAsByteArray(is);
                    try {
                        fTmp = FileSystemUtilities.createTempFile(KEYSTORE_PREFIX_FILE, ".tmp");
                        FileSystemUtilities.writeFile(fTmp, f);
                        org.openspcoop2.utils.certificate.KeyStore keyStore = new org.openspcoop2.utils.certificate.KeyStore(fTmp.getAbsolutePath(), type, password);
                        return keyStore;
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), e);
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fTmp != null) {
                        Files.delete(fTmp.toPath());
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static Certificate getCertificateKey(Properties props) throws UtilsException {
        return JsonUtils.getCertificateKey(true, true, props);
    }

    public static Certificate getCertificateKey(boolean jksPasswordRequired, boolean pkcs12PasswordRequired, Properties props) throws UtilsException {
        String alias;
        org.openspcoop2.utils.certificate.KeyStore keystore = JsonUtils.getKeyStore(jksPasswordRequired, pkcs12PasswordRequired, props);
        if (keystore != null && (alias = props.getProperty("rs.security.keystore.alias")) != null && !"".equals(alias)) {
            return keystore.getCertificate(alias);
        }
        return null;
    }

    public static SecretKeyPkcs11 getSecretKeyPKCS11(Properties props) throws UtilsException {
        if (props.containsKey("rs.security.keystore.type")) {
            Object oKeystore;
            String type = props.getProperty("rs.security.keystore.type");
            if (KeystoreType.PKCS11.getNome().equalsIgnoreCase(type) && (oKeystore = props.get("rs.security.keystore")) instanceof KeyStore) {
                KeyStore keystorePKCS11 = (KeyStore)oKeystore;
                String alias = props.getProperty("rs.security.keystore.alias");
                if (alias == null || "".equals(alias)) {
                    throw new UtilsException("(Secret-PKCS11) Alias key undefined");
                }
                Key key = null;
                try {
                    key = keystorePKCS11.getKey(alias, null);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), e);
                }
                if (key instanceof SecretKey) {
                    return new SecretKeyPkcs11(keystorePKCS11.getProvider(), (SecretKey)key);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey getSecretKey(Properties props) throws UtilsException {
        if (props.containsKey("rs.security.keystore.type")) {
            String type = props.getProperty("rs.security.keystore.type");
            if (KeystoreType.JCEKS.getNome().equalsIgnoreCase(type)) {
                Object oKeystore = props.get("rs.security.keystore");
                String fileK = props.getProperty("rs.security.keystore.file");
                String password = props.getProperty("rs.security.keystore.password");
                String alias = props.getProperty("rs.security.keystore.alias");
                String passwordKey = props.getProperty("rs.security.key.password");
                if (oKeystore instanceof KeyStore) {
                    KeyStore keystoreJCEKS = (KeyStore)oKeystore;
                    if (alias == null || "".equals(alias)) {
                        throw new UtilsException("(JCEKS) Alias key undefined");
                    }
                    if (passwordKey == null || "".equals(passwordKey)) {
                        throw new UtilsException("(JCEKS) Password key undefined");
                    }
                    try {
                        return (SecretKey)keystoreJCEKS.getKey(alias, passwordKey.toCharArray());
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), e);
                    }
                }
                if (fileK != null) {
                    org.openspcoop2.utils.certificate.KeyStore keystoreJCEKS;
                    block29: {
                        if (password == null || "".equals(password)) {
                            throw new UtilsException("(JCEKS) Keystore password undefined");
                        }
                        File file = new File(fileK);
                        keystoreJCEKS = null;
                        if (file.exists()) {
                            keystoreJCEKS = new org.openspcoop2.utils.certificate.KeyStore(file.getAbsolutePath(), KeystoreType.JCEKS.getNome(), password);
                        } else {
                            InputStream is = JsonUtils.class.getResourceAsStream(fileK);
                            File fTmp = null;
                            try {
                                if (is == null) break block29;
                                byte[] f = Utilities.getAsByteArray(is);
                                try {
                                    fTmp = FileSystemUtilities.createTempFile(KEYSTORE_PREFIX_FILE, ".jceks");
                                    FileSystemUtilities.writeFile(fTmp, f);
                                }
                                catch (Exception e) {
                                    throw new UtilsException(e.getMessage(), e);
                                }
                                keystoreJCEKS = new org.openspcoop2.utils.certificate.KeyStore(fTmp.getAbsolutePath(), KeystoreType.JCEKS.getNome(), password);
                            }
                            finally {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                                catch (Exception exception) {}
                                try {
                                    if (fTmp != null) {
                                        Files.delete(fTmp.toPath());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    if (keystoreJCEKS != null) {
                        if (alias == null || "".equals(alias)) {
                            throw new UtilsException("(JCEKS) Alias key undefined");
                        }
                        if (passwordKey == null || "".equals(passwordKey)) {
                            throw new UtilsException("(JCEKS) Password key undefined");
                        }
                        return keystoreJCEKS.getSecretKey(alias, passwordKey);
                    }
                }
            }
        }
        return null;
    }

    public static String getSecret(Properties props, SignatureAlgorithm algorithm) {
        String type;
        if (props.containsKey("rs.security.keystore.type") && RSSEC_KEY_STORE_TYPE_SECRET.equalsIgnoreCase(type = props.getProperty("rs.security.keystore.type"))) {
            String passwordKey;
            String algo;
            if (algorithm != null) {
                String passwordKey2;
                if (algorithm.name().toLowerCase().startsWith("hs") && (passwordKey2 = props.getProperty("rs.security.key.password")) != null && StringUtils.isNotEmpty((CharSequence)passwordKey2)) {
                    return passwordKey2;
                }
            } else if (props.containsKey("rs.security.signature.algorithm") && (algo = props.getProperty("rs.security.signature.algorithm")) != null && algo.toLowerCase().startsWith("hs") && (passwordKey = props.getProperty("rs.security.key.password")) != null && StringUtils.isNotEmpty((CharSequence)passwordKey)) {
                return passwordKey;
            }
        }
        return null;
    }

    public static JwsSignatureProvider getJwsSymmetricProvider(Properties props) throws UtilsException {
        String algorithm = props.getProperty("rs.security.signature.algorithm");
        return JsonUtils.getJwsSymmetricProvider(props, algorithm);
    }

    public static JwsSignatureProvider getJwsSymmetricProvider(Properties props, String algorithm) throws UtilsException {
        SignatureAlgorithm algo = null;
        if (algorithm == null || "".equals(algorithm)) {
            String type = props.getProperty("rs.security.keystore.type");
            if (KeystoreType.JCEKS.getNome().equalsIgnoreCase(type)) {
                throw new UtilsException(JCEKS_SIGNATURE_ALGO_UNDEFINED);
            }
        } else {
            algo = SignatureAlgorithm.getAlgorithm((String)algorithm);
        }
        return JsonUtils.getJwsSymmetricProvider(props, algo);
    }

    public static JwsSignatureProvider getJwsSymmetricProvider(Properties props, SignatureAlgorithm algorithm) throws UtilsException {
        SecretKeyPkcs11 secretKeyPkcs11 = JsonUtils.getSecretKeyPKCS11(props);
        if (secretKeyPkcs11 != null) {
            if (algorithm == null) {
                throw new UtilsException(PKCS11_SIGNATURE_ALGO_UNDEFINED);
            }
            return new HmacJwsSignatureProviderExtended(secretKeyPkcs11, algorithm);
        }
        SecretKey secretKey = JsonUtils.getSecretKey(props);
        if (secretKey != null) {
            if (algorithm == null) {
                throw new UtilsException(JCEKS_SIGNATURE_ALGO_UNDEFINED);
            }
            byte[] encoded = secretKey.getEncoded();
            JwsSignatureProvider provider = JwsUtils.getHmacSignatureProvider((byte[])encoded, (SignatureAlgorithm)algorithm);
            if (provider == null) {
                throw new UtilsException("(JCEKS) JwsSignatureProvider init failed; check signature algorithm (" + String.valueOf(algorithm) + ")");
            }
            return provider;
        }
        String secret = JsonUtils.getSecret(props, algorithm);
        if (secret != null) {
            if (algorithm == null) {
                throw new UtilsException(SECRET_SIGNATURE_ALGO_UNDEFINED);
            }
            byte[] encoded = secret.getBytes();
            JwsSignatureProvider provider = JwsUtils.getHmacSignatureProvider((byte[])encoded, (SignatureAlgorithm)algorithm);
            if (provider == null) {
                throw new UtilsException("(Secret) JwsSignatureProvider init failed; check signature algorithm (" + String.valueOf(algorithm) + ")");
            }
            return provider;
        }
        return null;
    }

    public static JwsSignatureProvider getJwsAsymmetricProvider(Properties props) throws UtilsException {
        String algorithm = props.getProperty("rs.security.signature.algorithm");
        return JsonUtils.getJwsAsymmetricProvider(props, algorithm);
    }

    public static JwsSignatureProvider getJwsAsymmetricProvider(Properties props, String algorithm) throws UtilsException {
        SignatureAlgorithm algo = null;
        if (algorithm != null && !"".equals(algorithm)) {
            algo = SignatureAlgorithm.getAlgorithm((String)algorithm);
        }
        return JsonUtils.getJwsAsymmetricProvider(props, algo);
    }

    public static JwsSignatureProvider getJwsAsymmetricProvider(Properties props, SignatureAlgorithm algorithm) throws UtilsException {
        String type = props.getProperty("rs.security.keystore.type");
        if (type == null || "".equals(type)) {
            type = "undefined";
        }
        if (algorithm == null) {
            throw new UtilsException("(" + type + ") Signature Algorithm undefined");
        }
        PrivateKey pKey = KeyManagementUtils.loadPrivateKey(null, (Properties)props, (KeyOperation)KeyOperation.SIGN);
        return JsonUtils.getJwsAsymmetricProvider(pKey, algorithm);
    }

    public static JwsSignatureProvider getJwsAsymmetricProvider(PrivateKey pKey, SignatureAlgorithm algorithm) {
        return new PrivateKeyJwsSignatureProvider(pKey, algorithm);
    }

    public static JwsSignatureVerifier getJwsSignatureVerifier(Properties props) throws UtilsException {
        String algorithm = props.getProperty("rs.security.signature.algorithm");
        return JsonUtils.getJwsSignatureVerifier(props, algorithm);
    }

    public static JwsSignatureVerifier getJwsSignatureVerifier(Properties props, String algorithm) throws UtilsException {
        SignatureAlgorithm algo = null;
        if (algorithm == null || "".equals(algorithm)) {
            String type = props.getProperty("rs.security.keystore.type");
            if (KeystoreType.JCEKS.getNome().equalsIgnoreCase(type)) {
                throw new UtilsException(JCEKS_SIGNATURE_ALGO_UNDEFINED);
            }
        } else {
            algo = SignatureAlgorithm.getAlgorithm((String)algorithm);
        }
        return JsonUtils.getJwsSignatureVerifier(props, algo);
    }

    public static JwsSignatureVerifier getJwsSignatureVerifier(Properties props, SignatureAlgorithm algorithm) throws UtilsException {
        SecretKey secretKey = JsonUtils.getSecretKey(props);
        if (secretKey != null) {
            if (algorithm == null) {
                throw new UtilsException(JCEKS_SIGNATURE_ALGO_UNDEFINED);
            }
            JwsSignatureVerifier verifier = JwsUtils.getHmacSignatureVerifier((byte[])secretKey.getEncoded(), (SignatureAlgorithm)algorithm);
            if (verifier == null) {
                throw new UtilsException("(JCEKS) JwsSignatureVerifier init failed; check signature algorithm (" + String.valueOf(algorithm) + ")");
            }
            return verifier;
        }
        String secret = JsonUtils.getSecret(props, algorithm);
        if (secret != null) {
            if (algorithm == null) {
                throw new UtilsException(SECRET_SIGNATURE_ALGO_UNDEFINED);
            }
            byte[] encoded = secret.getBytes();
            JwsSignatureVerifier verifier = JwsUtils.getHmacSignatureVerifier((byte[])encoded, (SignatureAlgorithm)algorithm);
            if (verifier == null) {
                throw new UtilsException("(Secret) JwsSignatureVerifier init failed; check signature algorithm (" + String.valueOf(algorithm) + ")");
            }
            return verifier;
        }
        return null;
    }

    public static JweEncryptionProvider getJweEncryptionProvider(Properties props) throws UtilsException {
        String algorithm = props.getProperty("rs.security.encryption.content.algorithm");
        return JsonUtils.getJweEncryptionProvider(props, algorithm);
    }

    public static JweEncryptionProvider getJweEncryptionProvider(Properties props, String algorithm) throws UtilsException {
        ContentAlgorithm algo = null;
        if (algorithm == null || "".equals(algorithm)) {
            String type = props.getProperty("rs.security.keystore.type");
            if (KeystoreType.JCEKS.getNome().equalsIgnoreCase(type)) {
                throw new UtilsException(JCEKS_CONTENT_ALGO_UNDEFINED);
            }
        } else {
            algo = ContentAlgorithm.getAlgorithm((String)algorithm);
        }
        return JsonUtils.getJweEncryptionProvider(props, algo);
    }

    public static JweEncryptionProvider getJweEncryptionProvider(Properties props, ContentAlgorithm algorithm) throws UtilsException {
        SecretKey secretKey = JsonUtils.getSecretKey(props);
        if (secretKey != null) {
            if (algorithm == null) {
                throw new UtilsException(JCEKS_CONTENT_ALGO_UNDEFINED);
            }
            JweEncryption provider = JweUtils.getDirectKeyJweEncryption((SecretKey)secretKey, (ContentAlgorithm)algorithm);
            if (provider == null) {
                throw new UtilsException("(JCEKS) JweEncryptionProvider init failed; check content algorithm (" + String.valueOf(algorithm) + ")");
            }
            return provider;
        }
        return null;
    }

    public static JweDecryptionProvider getJweDecryptionProvider(Properties props) throws UtilsException {
        String algorithm = props.getProperty("rs.security.encryption.content.algorithm");
        return JsonUtils.getJweDecryptionProvider(props, algorithm);
    }

    public static JweDecryptionProvider getJweDecryptionProvider(Properties props, String algorithm) throws UtilsException {
        ContentAlgorithm algo = null;
        if (algorithm == null || "".equals(algorithm)) {
            String type = props.getProperty("rs.security.keystore.type");
            if (KeystoreType.JCEKS.getNome().equalsIgnoreCase(type)) {
                throw new UtilsException(JCEKS_CONTENT_ALGO_UNDEFINED);
            }
        } else {
            algo = ContentAlgorithm.getAlgorithm((String)algorithm);
        }
        return JsonUtils.getJweDecryptionProvider(props, algo);
    }

    public static JweDecryptionProvider getJweDecryptionProvider(Properties props, ContentAlgorithm algorithm) throws UtilsException {
        SecretKey secretKey = JsonUtils.getSecretKey(props);
        if (secretKey != null) {
            if (algorithm == null) {
                throw new UtilsException(JCEKS_CONTENT_ALGO_UNDEFINED);
            }
            JweDecryption verifier = JweUtils.getDirectKeyJweDecryption((SecretKey)secretKey, (ContentAlgorithm)algorithm);
            if (verifier == null) {
                throw new UtilsException("(JCEKS) JweDecryptionProvider init failed; check content algorithm (" + String.valueOf(algorithm) + ")");
            }
            return verifier;
        }
        return null;
    }

    public static JweDecryptionProvider getJweAsymmetricDecryptionProvider(Properties props) throws UtilsException {
        String contentAlgorithm = props.getProperty("rs.security.encryption.content.algorithm");
        String keyAlgorithm = props.getProperty("rs.security.encryption.key.algorithm");
        return JsonUtils.getJweAsymmetricDecryptionProvider(props, keyAlgorithm, contentAlgorithm);
    }

    public static JweDecryptionProvider getJweAsymmetricDecryptionProvider(Properties props, String keyAlgorithm, String contentAlgorithm) throws UtilsException {
        ContentAlgorithm contentAlgo = null;
        if (contentAlgorithm != null && !"".equals(contentAlgorithm)) {
            contentAlgo = ContentAlgorithm.getAlgorithm((String)contentAlgorithm);
        }
        KeyAlgorithm keyAlgo = null;
        if (keyAlgorithm != null && !"".equals(keyAlgorithm)) {
            keyAlgo = KeyAlgorithm.getAlgorithm((String)keyAlgorithm);
        }
        return JsonUtils.getJweAsymmetricDecryptionProvider(props, keyAlgo, contentAlgo);
    }

    public static JweDecryptionProvider getJweAsymmetricDecryptionProvider(Properties props, KeyAlgorithm keyAlgorithm, ContentAlgorithm contentAlgorithm) throws UtilsException {
        String type = props.getProperty("rs.security.keystore.type");
        if (type == null || "".equals(type)) {
            type = "undefined";
        }
        if (contentAlgorithm == null) {
            throw new UtilsException("(" + type + ") Content Algorithm undefined");
        }
        if (keyAlgorithm == null) {
            throw new UtilsException("(" + type + ") Key Algorithm undefined");
        }
        PrivateKey privateKey = KeyManagementUtils.loadPrivateKey(null, (Properties)props, (KeyOperation)KeyOperation.DECRYPT);
        return JsonUtils.getJweAsymmetricDecryptionProvider(privateKey, keyAlgorithm, contentAlgorithm);
    }

    public static JweDecryptionProvider getJweAsymmetricDecryptionProvider(PrivateKey privateKey, KeyAlgorithm keyAlgorithm, ContentAlgorithm contentAlgorithm) {
        WrappedKeyDecryptionAlgorithm privateKeyDecryptionProvider = new WrappedKeyDecryptionAlgorithm((Key)privateKey, keyAlgorithm, false);
        return JweUtils.createJweDecryptionProvider((KeyDecryptionProvider)privateKeyDecryptionProvider, (ContentAlgorithm)contentAlgorithm);
    }

    public static JweEncryptionProvider getJweEncryptionProviderFromJWKSymmetric(Properties props, JweHeaders headers) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.loadKeyEncryptionProvider((Properties)props, (Message)m, (JweHeaders)headers);
        ContentAlgorithm contentAlgo = JweUtils.getContentEncryptionAlgorithm((Message)m, (Properties)props, null, (ContentAlgorithm)ContentAlgorithm.A128GCM);
        if (m != null) {
            m.put((Object)"rs.security.encryption.content.algorithm", (Object)contentAlgo.getJwaName());
        }
        ContentEncryptionProvider ctEncryptionProvider = null;
        JsonWebKey jwk = JwkUtils.loadJsonWebKey((Message)m, (Properties)props, (KeyOperation)KeyOperation.ENCRYPT);
        if (jwk.getAlgorithm() == null) {
            jwk.setAlgorithm(contentAlgo.getJwaName());
        }
        contentAlgo = JweUtils.getContentEncryptionAlgorithm((Message)m, (Properties)props, (ContentAlgorithm)(jwk.getAlgorithm() != null ? ContentAlgorithm.getAlgorithm((String)jwk.getAlgorithm()) : null), (ContentAlgorithm)contentAlgo);
        ctEncryptionProvider = JweUtils.getContentEncryptionProvider((JsonWebKey)jwk, (ContentAlgorithm)contentAlgo);
        String compression = props.getProperty("rs.security.encryption.zip.algorithm");
        headers = headers != null ? headers : new JweHeaders();
        headers.setKeyEncryptionAlgorithm(keyEncryptionProvider.getAlgorithm());
        headers.setContentEncryptionAlgorithm(contentAlgo);
        if (compression != null) {
            headers.setZipAlgorithm(compression);
        }
        return new JweEncryption(keyEncryptionProvider, ctEncryptionProvider);
    }

    public static JweDecryptionProvider getJweDecryptionProviderFromJWKSymmetric(Properties props, JweHeaders headers) {
        if (headers != null) {
            // empty if block
        }
        Message m = PhaseInterceptorChain.getCurrentMessage();
        JsonWebKey jwk = JwkUtils.loadJsonWebKey((Message)m, (Properties)props, (KeyOperation)KeyOperation.DECRYPT);
        ContentAlgorithm contentAlgo = JweUtils.getContentEncryptionAlgorithm((Message)m, (Properties)props, (ContentAlgorithm)ContentAlgorithm.getAlgorithm((String)jwk.getAlgorithm()), (ContentAlgorithm)ContentAlgorithm.A128GCM);
        if (jwk.getAlgorithm() == null) {
            jwk.setAlgorithm(contentAlgo.getJwaName());
        }
        SecretKey ctDecryptionKey = JweUtils.getContentDecryptionSecretKey((JsonWebKey)jwk, (String)contentAlgo.getJwaName());
        return JweUtils.getDirectKeyJweDecryption((SecretKey)ctDecryptionKey, (ContentAlgorithm)contentAlgo);
    }

    private static String getErrorNonValido(Exception e) {
        return "non valido: " + e.getMessage();
    }

    public static void validate(CertificateInfo certificatoInfo, org.openspcoop2.utils.certificate.KeyStore trustStoreCertificatiX509, CertStore crlX509, IOCSPValidator ocspValidatorX509, String headerName, boolean verifaCA, CertificateValidityCheck validityCheck) throws UtilsException {
        if (trustStoreCertificatiX509 != null) {
            Object prefisso;
            Object object = prefisso = headerName != null ? "Certificato presente nell'header '" + headerName + "' " : "Certificato di firma ";
            if (verifaCA && !certificatoInfo.isVerified(trustStoreCertificatiX509, true)) {
                throw new UtilsException((String)prefisso + "non \u00e8 verificabile rispetto alle CA conosciute");
            }
            if (validityCheck == null || CertificateValidityCheck.ENABLED.equals((Object)validityCheck) || CertificateValidityCheck.IF_NOT_IN_TRUSTSTORE.equals((Object)validityCheck) && !trustStoreCertificatiX509.existsCertificateBySubject(certificatoInfo.getCertificate().getSubjectX500Principal())) {
                try {
                    certificatoInfo.checkValid();
                }
                catch (CertificateExpiredException e) {
                    throw new UtilsException((String)prefisso + "scaduto: " + e.getMessage(), e);
                }
                catch (CertificateNotYetValidException e) {
                    throw new UtilsException((String)prefisso + "non ancora valido: " + e.getMessage(), e);
                }
                catch (Exception e) {
                    throw new UtilsException((String)prefisso + JsonUtils.getErrorNonValido(e), e);
                }
            }
            if (ocspValidatorX509 != null) {
                try {
                    ocspValidatorX509.valid(certificatoInfo.getCertificate());
                }
                catch (Exception e) {
                    throw new UtilsException((String)prefisso + JsonUtils.getErrorNonValido(e), e);
                }
            }
            if (crlX509 != null) {
                try {
                    certificatoInfo.checkValid(crlX509, trustStoreCertificatiX509);
                }
                catch (Exception e) {
                    throw new UtilsException((String)prefisso + JsonUtils.getErrorNonValido(e), e);
                }
            }
        }
    }
}

