/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ProviderUtils {
    private ProviderUtils() {
    }

    public static void addBouncyCastle() {
        ProviderUtils.add((Provider)new BouncyCastleProvider());
    }

    public static void add(Provider provider) {
        Security.addProvider(provider);
    }

    public static void addBouncyCastleAfterSun(boolean overrideIfExists) {
        if (overrideIfExists) {
            ProviderUtils.addOverrideIfExists((Provider)new BouncyCastleProvider(), 2);
        } else {
            ProviderUtils.addIfNotExists((Provider)new BouncyCastleProvider(), 2);
        }
    }

    public static void addIfNotExists(Provider provider, int position) {
        if (Security.getProvider(provider.getName()) == null) {
            Security.insertProviderAt(provider, position);
        }
    }

    public static void addOverrideIfExists(Provider provider, int position) {
        if (Security.getProvider(provider.getName()) != null) {
            List<Provider> l = ProviderUtils.getProviders();
            if (!l.isEmpty() && l.size() > position - 1 && l.get(position - 1).getName().equals(provider.getName())) {
                return;
            }
            Security.removeProvider(provider.getName());
        }
        Security.insertProviderAt(provider, position);
    }

    public static boolean existsBouncyCastle() {
        return ProviderUtils.exists((Provider)new BouncyCastleProvider());
    }

    public static boolean exists(Provider provider) {
        return Security.getProvider(provider.getName()) != null;
    }

    public static boolean existsBouncyCastle(int position) {
        return ProviderUtils.exists((Provider)new BouncyCastleProvider(), position);
    }

    public static boolean exists(Provider provider, int position) {
        List<Provider> l = ProviderUtils.getProviders();
        if (l.isEmpty() || l.size() < position) {
            return false;
        }
        return l.get(position).getName().equals(provider.getName());
    }

    public static void removeBouncyCastle() {
        ProviderUtils.remove((Provider)new BouncyCastleProvider());
    }

    public static void remove(Provider provider) {
        Security.removeProvider(provider.getName());
    }

    public static List<Provider> getProviders() {
        ArrayList<Provider> l = new ArrayList<Provider>();
        Provider[] p = Security.getProviders();
        if (p != null && p.length > 0) {
            l.addAll(Arrays.asList(p));
        }
        return l;
    }

    public static List<String> getProviderNames() {
        ArrayList<String> l = new ArrayList<String>();
        List<Provider> lp = ProviderUtils.getProviders();
        if (!lp.isEmpty()) {
            for (Provider provider : lp) {
                l.add(provider.getName());
            }
        }
        return l;
    }
}

