/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VerifyXmlSignature {
    private org.openspcoop2.utils.certificate.KeyStore keystore;
    private Certificate certificate;
    private KeyInfo keyInfo;
    private Node signatureElement;

    public VerifyXmlSignature(KeyStore keystore) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), null, false);
    }

    public VerifyXmlSignature(KeyStore keystore, String alias) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, false);
    }

    public VerifyXmlSignature(KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), null, addBouncyCastleProvider);
    }

    public VerifyXmlSignature(KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, addBouncyCastleProvider);
    }

    public VerifyXmlSignature(org.openspcoop2.utils.certificate.KeyStore keystore) throws UtilsException {
        this(keystore, null, false);
    }

    public VerifyXmlSignature(org.openspcoop2.utils.certificate.KeyStore keystore, String alias) throws UtilsException {
        this(keystore, alias, false);
    }

    public VerifyXmlSignature(org.openspcoop2.utils.certificate.KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        this(keystore, null, addBouncyCastleProvider);
    }

    public VerifyXmlSignature(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        this.keystore = keystore;
        this.certificate = alias == null ? this.keystore.getCertificate() : this.keystore.getCertificate(alias);
        try {
            if (addBouncyCastleProvider) {
                BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
                Security.addProvider((Provider)bouncyCastleProvider);
            }
            Init.init();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public boolean verify(Document element, boolean clean) throws UtilsException {
        return this._verify(element.getDocumentElement(), clean);
    }

    public boolean verify(Element element, boolean clean) throws UtilsException {
        return this._verify(element, clean);
    }

    private boolean _verify(Element element, boolean clean) throws UtilsException {
        try {
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace(element);
            Object o = xpathEngine.getMatchPattern(element, dnc, "//{http://www.w3.org/2000/09/xmldsig#}Signature", XPathReturnType.NODE);
            if (o == null) {
                throw new Exception("Signature element not found");
            }
            this.signatureElement = (Node)o;
            XMLSignature sigXMLSec = new XMLSignature((Element)this.signatureElement, null);
            boolean valida = sigXMLSec.checkSignatureValue((X509Certificate)this.certificate);
            this.keyInfo = sigXMLSec.getKeyInfo();
            if (clean) {
                this.detach(element);
            }
            return valida;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void detach(Element element) throws UtilsException {
        try {
            if (this.signatureElement == null) {
                throw new Exception("Signature element not found; invoke 'verify' method first");
            }
            element.removeChild(this.signatureElement);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

