/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security.test;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.id.IDUtilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.security.Decrypt;
import org.openspcoop2.utils.security.DecryptOpenSSLPass;
import org.openspcoop2.utils.security.DecryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.Encrypt;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.EncryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class EncryptOpenSSLTest {
    private static final String PASSWORD = "SegretoMoltoLungoE@D1ff1Cil!";
    private static final String TEXT_PLAIN = "Lorem ipsum dolor sit amet, consectetur adipisci elit, sed do eiusmod tempor incidunt ut labore et dolore magna aliqua. \nUt enim ad minim veniam, quis nostrum exercitationem ullamco laboriosam, nisi ut aliquid ex ea commodi consequatur. Duis aute irure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. \nExcepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
    private static final String AES_CBC_PKCS5PADDING = "AES/CBC/PKCS5Padding";
    private static final String FILE_NAME_IN = "testOpenSSL-in";
    private static final String FILE_NAME_OUT = "testOpenSSL-out";
    private static final String ALGO_TEST = "] algo-";
    private static final String END_TEST = " =============";
    private static final String ERROR_PREFIX = "ERRORE!!: ";
    private static final String OPENSSL_OPTION_DECRYPT = "-d";
    private static final String OPENSSL_OPTION_KEY = "-K";
    private static final String OPENSSL_OPTION_IV = "-iv";
    private static final String OPENSSL_OPTION_SALT = "-salt";
    private static final String OPENSSL_OPTION_BASE64 = "-a";
    private static final String OPENSSL_OPTION_PASS = "-pass";
    private static final String OPENSSL_OPTION_PASS_PREFIX = "pass:";
    private static final String OPENSSL_OPTION_PBKDF2 = "-pbkdf2";
    private static final String OPENSSL_OPTION_PBKDF2_ITERATION = "-iter";
    private static final String CIFRATO = "cifrato: ";
    private static final String CIFRATO_IN = "cifrato in: ";
    private static final String VERIFICA_CIFRATURA_OPENSSL_DECIFRATURA_JAVA_OK = "Testo cifrato con openssl e decifrato correttamente con java";
    private static final String VERIFICA_CIFRATURA_JAVA_DECIFRATURA_OPENSSL_OK = "Testo cifrato con java e decodificato correttamente con openssl";
    private static String chiave256 = null;
    private static String chiave192;
    private static String chiave128;
    private static final String OPENSSL_COMMAND = "opensslCmd";

    public static void main(String[] args) throws UtilsException, IOException {
        for (int i = 0; i < 2; ++i) {
            boolean base64 = i == 0;
            EncryptOpenSSLTest.testCifraturaConKey(128, base64);
            EncryptOpenSSLTest.testDecifraturaConKey(128, base64);
            EncryptOpenSSLTest.testCifraturaConKey(192, base64);
            EncryptOpenSSLTest.testDecifraturaConKey(192, base64);
            EncryptOpenSSLTest.testCifraturaConKey(256, base64);
            EncryptOpenSSLTest.testDecifraturaConKey(256, base64);
            EncryptOpenSSLTest.testCifraturaConPassword(256, base64);
            EncryptOpenSSLTest.testDecifraturaConPassword(256, base64);
            for (int j = 0; j < 2; ++j) {
                Integer iteration = j == 0 ? null : Integer.valueOf(65535);
                EncryptOpenSSLTest.testCifraturaConPasswordPBKDF2(128, base64, iteration);
                EncryptOpenSSLTest.testDecifraturaConPasswordPBKDF2(128, base64, iteration);
                EncryptOpenSSLTest.testCifraturaConPasswordPBKDF2(192, base64, iteration);
                EncryptOpenSSLTest.testDecifraturaConPasswordPBKDF2(192, base64, iteration);
                EncryptOpenSSLTest.testCifraturaConPasswordPBKDF2(256, base64, iteration);
                EncryptOpenSSLTest.testDecifraturaConPasswordPBKDF2(256, base64, iteration);
            }
        }
        EncryptOpenSSLTest.logDebug("\n\nTestsuite terminata");
    }

    private static String getErrorTestoDecifrato(String decoded) {
        return "testo decifrato '" + decoded + "' diverso da quello atteso 'Lorem ipsum dolor sit amet, consectetur adipisci elit, sed do eiusmod tempor incidunt ut labore et dolore magna aliqua. \nUt enim ad minim veniam, quis nostrum exercitationem ullamco laboriosam, nisi ut aliquid ex ea commodi consequatur. Duis aute irure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. \nExcepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testCifraturaConKey(int size, boolean base64) throws UtilsException, IOException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        File fIn = File.createTempFile(FILE_NAME_IN, ".dat");
        File fOut = File.createTempFile(FILE_NAME_OUT, ".dat");
        try {
            EncryptOpenSSLTest.logDebug("\n\n========= **encrypt** chiave -K [base64:" + base64 + ALGO_TEST + size + END_TEST);
            String chiave = chiave256;
            if (size == 128) {
                chiave = chiave128;
            } else if (size == 192) {
                chiave = chiave192;
            }
            Encrypt encrypt = new Encrypt(HexBinaryUtilities.decode(chiave), "AES");
            encrypt.initIV(AES_CBC_PKCS5PADDING);
            String iv = encrypt.getIVHexBinaryAsString();
            EncryptOpenSSLTest.logDebug("IV: " + iv);
            if (base64) {
                cipherText = encrypt.encryptBase64AsString(TEXT_PLAIN.getBytes(), AES_CBC_PKCS5PADDING);
                EncryptOpenSSLTest.logDebug(CIFRATO + (String)cipherText);
                FileSystemUtilities.writeFile(fIn, ((String)cipherText + "\n").getBytes());
            } else {
                cipherText = encrypt.encrypt(TEXT_PLAIN.getBytes(), AES_CBC_PKCS5PADDING);
                FileSystemUtilities.writeFile(fIn, (byte[])cipherText);
                EncryptOpenSSLTest.logDebug(CIFRATO_IN + fIn.getAbsolutePath());
            }
            EncryptOpenSSLTest.executeOpensslCommand(base64, "aes-" + size + "-cbc", OPENSSL_OPTION_KEY, chiave, OPENSSL_OPTION_IV, iv, OPENSSL_OPTION_SALT, OPENSSL_OPTION_DECRYPT, OPENSSL_OPTION_BASE64, "-in", fIn.getAbsolutePath(), "-out", fOut.getAbsolutePath());
            String decoded = FileSystemUtilities.readFile(fOut);
            if (!TEXT_PLAIN.equals(decoded)) {
                String msgError = EncryptOpenSSLTest.getErrorTestoDecifrato(decoded);
                EncryptOpenSSLTest.logDebug(ERROR_PREFIX + msgError);
                throw new UtilsException(msgError);
            }
            EncryptOpenSSLTest.logDebug(VERIFICA_CIFRATURA_JAVA_DECIFRATURA_OPENSSL_OK);
        }
        finally {
            Security.removeProvider("BC");
            FileSystemUtilities.deleteFile(fIn);
            FileSystemUtilities.deleteFile(fOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDecifraturaConKey(int size, boolean base64) throws UtilsException, IOException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        File fIn = File.createTempFile(FILE_NAME_IN, ".dat");
        File fOut = File.createTempFile(FILE_NAME_OUT, ".dat");
        try {
            EncryptOpenSSLTest.logDebug("\n\n========= **decrypt** chiave -K [base64:" + base64 + ALGO_TEST + size + END_TEST);
            String chiave = chiave256;
            if (size == 128) {
                chiave = chiave128;
            } else if (size == 192) {
                chiave = chiave192;
            }
            FileSystemUtilities.writeFile(fIn, TEXT_PLAIN.getBytes());
            String iv = "680260f540ba414b7f804782786701f6";
            EncryptOpenSSLTest.executeOpensslCommand(base64, "aes-" + size + "-cbc", OPENSSL_OPTION_KEY, chiave, OPENSSL_OPTION_IV, iv, OPENSSL_OPTION_SALT, OPENSSL_OPTION_BASE64, "-in", fIn.getAbsolutePath(), "-out", fOut.getAbsolutePath());
            Decrypt decrypt = new Decrypt(HexBinaryUtilities.decode(chiave), "AES", HexBinaryUtilities.decode(iv));
            String decoded = null;
            if (base64) {
                cipherText = FileSystemUtilities.readFile(fOut);
                decoded = new String(decrypt.decryptBase64((String)cipherText, AES_CBC_PKCS5PADDING));
            } else {
                cipherText = FileSystemUtilities.readBytesFromFile(fOut);
                decoded = new String(decrypt.decrypt((byte[])cipherText, AES_CBC_PKCS5PADDING));
            }
            if (!TEXT_PLAIN.equals(decoded)) {
                String msgError = EncryptOpenSSLTest.getErrorTestoDecifrato(decoded);
                EncryptOpenSSLTest.logDebug(ERROR_PREFIX + msgError);
                throw new UtilsException(msgError);
            }
            EncryptOpenSSLTest.logDebug(VERIFICA_CIFRATURA_OPENSSL_DECIFRATURA_JAVA_OK);
        }
        finally {
            Security.removeProvider("BC");
            FileSystemUtilities.deleteFile(fIn);
            FileSystemUtilities.deleteFile(fOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testCifraturaConPassword(int size, boolean base64) throws UtilsException, IOException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        File fIn = File.createTempFile(FILE_NAME_IN, ".dat");
        File fOut = File.createTempFile(FILE_NAME_OUT, ".dat");
        try {
            EncryptOpenSSLTest.logDebug("\n\n========= **encrypt** password -pass [base64:" + base64 + ALGO_TEST + size + END_TEST);
            EncryptOpenSSLPass encrypt = new EncryptOpenSSLPass(PASSWORD);
            String iv = encrypt.getIVHexBinaryAsString();
            EncryptOpenSSLTest.logDebug("IV: " + iv);
            if (base64) {
                cipherText = encrypt.encryptBase64AsString(TEXT_PLAIN.getBytes());
                EncryptOpenSSLTest.logDebug(CIFRATO + (String)cipherText);
                FileSystemUtilities.writeFile(fIn, ((String)cipherText + "\n").getBytes());
            } else {
                cipherText = encrypt.encrypt(TEXT_PLAIN.getBytes());
                FileSystemUtilities.writeFile(fIn, (byte[])cipherText);
                EncryptOpenSSLTest.logDebug(CIFRATO_IN + fIn.getAbsolutePath());
            }
            EncryptOpenSSLTest.executeOpensslCommand(base64, "aes-" + size + "-cbc", OPENSSL_OPTION_PASS, "pass:SegretoMoltoLungoE@D1ff1Cil!", OPENSSL_OPTION_SALT, OPENSSL_OPTION_DECRYPT, OPENSSL_OPTION_BASE64, "-in", fIn.getAbsolutePath(), "-out", fOut.getAbsolutePath());
            String decoded = FileSystemUtilities.readFile(fOut);
            if (!TEXT_PLAIN.equals(decoded)) {
                String msgError = EncryptOpenSSLTest.getErrorTestoDecifrato(decoded);
                EncryptOpenSSLTest.logDebug(ERROR_PREFIX + msgError);
                throw new UtilsException(msgError);
            }
            EncryptOpenSSLTest.logDebug(VERIFICA_CIFRATURA_JAVA_DECIFRATURA_OPENSSL_OK);
        }
        finally {
            Security.removeProvider("BC");
            FileSystemUtilities.deleteFile(fIn);
            FileSystemUtilities.deleteFile(fOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDecifraturaConPassword(int size, boolean base64) throws UtilsException, IOException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        File fIn = File.createTempFile(FILE_NAME_IN, ".dat");
        File fOut = File.createTempFile(FILE_NAME_OUT, ".dat");
        try {
            EncryptOpenSSLTest.logDebug("\n\n========= **decrypt** password -pass [base64:" + base64 + ALGO_TEST + size + END_TEST);
            FileSystemUtilities.writeFile(fIn, TEXT_PLAIN.getBytes());
            EncryptOpenSSLTest.executeOpensslCommand(base64, "aes-" + size + "-cbc", OPENSSL_OPTION_PASS, "pass:SegretoMoltoLungoE@D1ff1Cil!", OPENSSL_OPTION_SALT, OPENSSL_OPTION_BASE64, "-in", fIn.getAbsolutePath(), "-out", fOut.getAbsolutePath());
            DecryptOpenSSLPass decrypt = new DecryptOpenSSLPass(PASSWORD);
            String decoded = null;
            if (base64) {
                cipherText = FileSystemUtilities.readFile(fOut);
                decoded = new String(decrypt.decryptBase64((String)cipherText));
            } else {
                cipherText = FileSystemUtilities.readBytesFromFile(fOut);
                decoded = new String(decrypt.decrypt((byte[])cipherText));
            }
            if (!TEXT_PLAIN.equals(decoded)) {
                String msgError = EncryptOpenSSLTest.getErrorTestoDecifrato(decoded);
                EncryptOpenSSLTest.logDebug(ERROR_PREFIX + msgError);
                throw new UtilsException(msgError);
            }
            EncryptOpenSSLTest.logDebug(VERIFICA_CIFRATURA_OPENSSL_DECIFRATURA_JAVA_OK);
        }
        finally {
            Security.removeProvider("BC");
            FileSystemUtilities.deleteFile(fIn);
            FileSystemUtilities.deleteFile(fOut);
        }
    }

    private static EncryptOpenSSLPassPBKDF2 getEncryptOpenSSLPassPBKDF2(int size, Integer iteration) throws UtilsException {
        EncryptOpenSSLPassPBKDF2 encrypt = null;
        encrypt = size == 128 ? (iteration == null ? new EncryptOpenSSLPassPBKDF2(PASSWORD, OpenSSLEncryptionMode.AES_128_CBC) : new EncryptOpenSSLPassPBKDF2(PASSWORD, iteration, OpenSSLEncryptionMode.AES_128_CBC)) : (size == 192 ? (iteration == null ? new EncryptOpenSSLPassPBKDF2(PASSWORD, OpenSSLEncryptionMode.AES_192_CBC) : new EncryptOpenSSLPassPBKDF2(PASSWORD, iteration, OpenSSLEncryptionMode.AES_192_CBC)) : (iteration == null ? new EncryptOpenSSLPassPBKDF2(PASSWORD) : new EncryptOpenSSLPassPBKDF2(PASSWORD, iteration)));
        return encrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testCifraturaConPasswordPBKDF2(int size, boolean base64, Integer iteration) throws UtilsException, IOException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        File fIn = File.createTempFile(FILE_NAME_IN, ".dat");
        File fOut = File.createTempFile(FILE_NAME_OUT, ".dat");
        try {
            String iteratorS = iteration != null && iteration > 0 ? " -iter " + iteration : "";
            EncryptOpenSSLTest.logDebug("\n\n========= **encrypt** password -pass -pbkdf2" + iteratorS + " [base64:" + base64 + ALGO_TEST + size + END_TEST);
            EncryptOpenSSLPassPBKDF2 encrypt = EncryptOpenSSLTest.getEncryptOpenSSLPassPBKDF2(size, iteration);
            String iv = encrypt.getIVHexBinaryAsString();
            EncryptOpenSSLTest.logDebug("IV: " + iv);
            if (base64) {
                cipherText = encrypt.encryptBase64AsString(TEXT_PLAIN.getBytes());
                EncryptOpenSSLTest.logDebug(CIFRATO + (String)cipherText);
                FileSystemUtilities.writeFile(fIn, ((String)cipherText + "\n").getBytes());
            } else {
                cipherText = encrypt.encrypt(TEXT_PLAIN.getBytes());
                FileSystemUtilities.writeFile(fIn, (byte[])cipherText);
                EncryptOpenSSLTest.logDebug(CIFRATO_IN + fIn.getAbsolutePath());
            }
            String pbkdf2 = OPENSSL_OPTION_PBKDF2 + (String)(iteration != null && iteration > 0 ? " -iter " + iteration : "");
            EncryptOpenSSLTest.executeOpensslCommand(base64, "aes-" + size + "-cbc", OPENSSL_OPTION_PASS, "pass:SegretoMoltoLungoE@D1ff1Cil!", pbkdf2, OPENSSL_OPTION_SALT, OPENSSL_OPTION_DECRYPT, OPENSSL_OPTION_BASE64, "-in", fIn.getAbsolutePath(), "-out", fOut.getAbsolutePath());
            String decoded = FileSystemUtilities.readFile(fOut);
            if (!TEXT_PLAIN.equals(decoded)) {
                String msgError = EncryptOpenSSLTest.getErrorTestoDecifrato(decoded);
                EncryptOpenSSLTest.logDebug(ERROR_PREFIX + msgError);
                throw new UtilsException(msgError);
            }
            EncryptOpenSSLTest.logDebug(VERIFICA_CIFRATURA_JAVA_DECIFRATURA_OPENSSL_OK);
        }
        finally {
            Security.removeProvider("BC");
            FileSystemUtilities.deleteFile(fIn);
            FileSystemUtilities.deleteFile(fOut);
        }
    }

    private static DecryptOpenSSLPassPBKDF2 getDecryptOpenSSLPassPBKDF2(int size, Integer iteration) throws UtilsException {
        DecryptOpenSSLPassPBKDF2 decrypt = null;
        decrypt = size == 128 ? (iteration == null ? new DecryptOpenSSLPassPBKDF2(PASSWORD, OpenSSLEncryptionMode.AES_128_CBC) : new DecryptOpenSSLPassPBKDF2(PASSWORD, iteration, OpenSSLEncryptionMode.AES_128_CBC)) : (size == 192 ? (iteration == null ? new DecryptOpenSSLPassPBKDF2(PASSWORD, OpenSSLEncryptionMode.AES_192_CBC) : new DecryptOpenSSLPassPBKDF2(PASSWORD, iteration, OpenSSLEncryptionMode.AES_192_CBC)) : (iteration == null ? new DecryptOpenSSLPassPBKDF2(PASSWORD) : new DecryptOpenSSLPassPBKDF2(PASSWORD, iteration)));
        return decrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDecifraturaConPasswordPBKDF2(int size, boolean base64, Integer iteration) throws UtilsException, IOException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        File fIn = File.createTempFile(FILE_NAME_IN, ".dat");
        File fOut = File.createTempFile(FILE_NAME_OUT, ".dat");
        try {
            String iteratorS = iteration != null && iteration > 0 ? " -iter " + iteration : "";
            EncryptOpenSSLTest.logDebug("\n\n========= **decrypt** password -pass -pbkdf2" + iteratorS + " [base64:" + base64 + ALGO_TEST + size + END_TEST);
            FileSystemUtilities.writeFile(fIn, TEXT_PLAIN.getBytes());
            String pbkdf2 = OPENSSL_OPTION_PBKDF2 + (String)(iteration != null && iteration > 0 ? " -iter " + iteration : "");
            EncryptOpenSSLTest.executeOpensslCommand(base64, "aes-" + size + "-cbc", OPENSSL_OPTION_PASS, "pass:SegretoMoltoLungoE@D1ff1Cil!", pbkdf2, OPENSSL_OPTION_SALT, OPENSSL_OPTION_BASE64, "-in", fIn.getAbsolutePath(), "-out", fOut.getAbsolutePath());
            DecryptOpenSSLPassPBKDF2 decrypt = EncryptOpenSSLTest.getDecryptOpenSSLPassPBKDF2(size, iteration);
            String decoded = null;
            if (base64) {
                cipherText = FileSystemUtilities.readFile(fOut);
                decoded = new String(decrypt.decryptBase64((String)cipherText));
            } else {
                cipherText = FileSystemUtilities.readBytesFromFile(fOut);
                decoded = new String(decrypt.decrypt((byte[])cipherText));
            }
            if (!TEXT_PLAIN.equals(decoded)) {
                String msgError = EncryptOpenSSLTest.getErrorTestoDecifrato(decoded);
                EncryptOpenSSLTest.logDebug(ERROR_PREFIX + msgError);
                throw new UtilsException(msgError);
            }
            EncryptOpenSSLTest.logDebug(VERIFICA_CIFRATURA_OPENSSL_DECIFRATURA_JAVA_OK);
        }
        finally {
            Security.removeProvider("BC");
            FileSystemUtilities.deleteFile(fIn);
            FileSystemUtilities.deleteFile(fOut);
        }
    }

    private static String buildCommand(boolean base64, String ... args) {
        String opensslCommand = System.getProperty(OPENSSL_COMMAND);
        if (opensslCommand == null || StringUtils.isEmpty((CharSequence)opensslCommand)) {
            opensslCommand = "openssl";
        }
        StringBuilder sb = new StringBuilder(opensslCommand);
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (OPENSSL_OPTION_BASE64.equals(args[i]) && !base64) continue;
                sb.append(" ").append(args[i]);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeOpensslCommand(boolean base64, String ... args) throws UtilsException, IOException {
        File fExecute = File.createTempFile("testOpenSSL-exec", ".sh");
        try {
            byte[] s;
            Process process;
            String com = EncryptOpenSSLTest.buildCommand(base64, args);
            EncryptOpenSSLTest.logDebug("Eseguo comando '" + com + "'");
            StringBuilder sbExec = new StringBuilder();
            sbExec.append("#!/bin/bash\n\n").append(com);
            FileSystemUtilities.writeFile(fExecute, sbExec.toString().getBytes());
            if (!fExecute.setExecutable(true)) {
                // empty if block
            }
            if ((process = Runtime.getRuntime().exec(new String[]{fExecute.getAbsolutePath()})).getInputStream() != null && (s = Utilities.getAsByteArray(process.getInputStream(), false)) != null && s.length > 0) {
                EncryptOpenSSLTest.logDebug("INFO: '" + new String(s) + "'");
            }
            if (process.getErrorStream() != null && (s = Utilities.getAsByteArray(process.getErrorStream(), false)) != null && s.length > 0) {
                EncryptOpenSSLTest.logDebug("ERROR: '" + new String(s) + "'");
            }
            process.descendants().forEach(ProcessHandle::destroy);
            process.destroy();
            int exitValue = -1;
            boolean terminated = false;
            while (!terminated) {
                try {
                    Utilities.sleep(500L);
                    exitValue = process.exitValue();
                    terminated = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            EncryptOpenSSLTest.logDebug("terminated: " + terminated);
            EncryptOpenSSLTest.logDebug("exitValue: " + exitValue);
        }
        finally {
            FileSystemUtilities.deleteFile(fExecute);
        }
    }

    private static void logDebug(String msg) {
        System.out.println(msg);
    }

    static {
        try {
            chiave256 = HexBinaryUtilities.encodeAsString(IDUtilities.generateAlphaNumericRandomString(32).getBytes());
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), e);
        }
        chiave192 = null;
        try {
            chiave192 = HexBinaryUtilities.encodeAsString(IDUtilities.generateAlphaNumericRandomString(24).getBytes());
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), e);
        }
        chiave128 = null;
        try {
            chiave128 = HexBinaryUtilities.encodeAsString(IDUtilities.generateAlphaNumericRandomString(16).getBytes());
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), e);
        }
    }
}

