/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.JacksonSimpleBeanPropertyFilter;
import org.openspcoop2.utils.serialization.SerializationConfig;

public class JsonJacksonSerializer
implements ISerializer {
    private static final String DEFAULT = "__default";
    private ObjectWriter writer;

    public JsonJacksonSerializer() {
        this(new SerializationConfig());
    }

    public JsonJacksonSerializer(SerializationConfig config) {
        ObjectMapper mapper = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public String findFilterId(Annotated a) {
                return JsonJacksonSerializer.DEFAULT;
            }
        }, (AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(TypeFactory.defaultInstance())));
        if (config.isSerializeEnumAsString()) {
            mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        }
        mapper.setDateFormat(config.getDf());
        if (config.getIgnoreNullValues() == null || config.getIgnoreNullValues().booleanValue()) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        SimpleFilterProvider filters = new SimpleFilterProvider();
        if (config.getFilter() != null && (config.getFilter().sizeFiltersByName() > 0 || config.getFilter().sizeFiltersByValue() > 0) || config.getExcludes() != null) {
            filters = filters.addFilter(DEFAULT, (SimpleBeanPropertyFilter)new JacksonSimpleBeanPropertyFilter(config, new JsonJacksonSerializer()));
        } else if (config.getIncludes() != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(config.getIncludes());
            filters = filters.addFilter(DEFAULT, SimpleBeanPropertyFilter.filterOutAllExcept(hashSet));
        }
        filters = filters.setFailOnUnknownId(false);
        mapper.setFilterProvider((FilterProvider)filters);
        this.writer = config.isPrettyPrint() ? mapper.writer().withDefaultPrettyPrinter() : mapper.writer();
    }

    @Override
    public String getObject(Object o) throws IOException {
        try {
            return this.writer.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, OutputStream out) throws IOException {
        try {
            this.writer.writeValue(out, o);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, Writer out) throws IOException {
        try {
            this.writer.writeValue(out, o);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

