/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.beans.utils;

import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.cxf.jaxrs.validation.JAXRSParameterNameProvider;
import org.apache.cxf.validation.ValidationConfiguration;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.ProfiloUtils;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemValidation;

public class BaseHelper {
    public static final Map<ProfiloEnum, String> tipoProtocolloFromProfilo = ProfiloUtils.getMapProfiloToProtocollo();
    public static final Map<String, ProfiloEnum> profiloFromTipoProtocollo = ProfiloUtils.getMapProtocolloToProfilo();
    public static boolean validateAfterDeserialize = true;

    public static final <T> T dropnull(ThrowingSupplier<T> r) {
        try {
            return r.get();
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final <T> T evalnull(ThrowingSupplier<T> r) {
        try {
            return r.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final <T> T evalorElse(ThrowingSupplier<T> r, T orElse) {
        T ret = null;
        try {
            ret = r.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret != null) {
            return ret;
        }
        return orElse;
    }

    public static final <T> T supplyOrNotFound(ThrowingSupplier<T> s, String objName) {
        T ret = null;
        try {
            ret = s.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            throw FaultCode.NOT_FOUND.toException(objName + " non presente nel registro.");
        }
        return ret;
    }

    public static final <T> T supplyOrNonValida(ThrowingSupplier<T> s, String objName) {
        T ret = null;
        try {
            ret = s.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(objName + " non presente nel registro.");
        }
        return ret;
    }

    public static final void runNull(ThrowingRunnable r) {
        try {
            r.run();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Optional<T> findFirst(Iterable<? extends T> collection, Predicate<? super T> test) {
        Object value = null;
        if (collection != null) {
            for (T t : collection) {
                value = t;
                if (!test.test(t)) continue;
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }

    public static <T> T findAndRemoveFirst(Iterable<? extends T> collection, Predicate<? super T> test) {
        T value = null;
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            T t = it.next();
            value = t;
            if (!test.test(t)) continue;
            it.remove();
            return value;
        }
        return null;
    }

    public static <T> void throwIfNull(T body) {
        if (body == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
        }
    }

    public static final <T> T fromMap(Map<String, Object> mapObject, Class<T> toClass) throws InstantiationException, IllegalAccessException {
        if (mapObject == null) {
            return null;
        }
        T ret = Utilities.newInstanceThrowInstantiationException(toClass);
        BaseHelper.fillFromMap(mapObject, ret);
        return ret;
    }

    public static final String jsonNameToUpperCC(String key) {
        StringBuilder sb = new StringBuilder();
        Matcher m = Pattern.compile("_(\\w)").matcher(key);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static final <T> T fromJson(Object json, Class<T> c) {
        if (json == null) {
            return null;
        }
        try {
            return JSONUtils.getInstance().getAsObject((InputStream)json, c);
        }
        catch (Exception e) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(e);
        }
    }

    public static final <T> void fillFromMap(Map<String, Object> mapObject, T toFill) throws InstantiationException {
        mapObject.forEach((k, v) -> {
            if (v == null) {
                return;
            }
            try {
                k = BaseHelper.jsonNameToUpperCC(k);
                Class dest = PropertyUtils.getPropertyType((Object)toFill, (String)k);
                Class<?> source = v.getClass();
                if (source == String.class) {
                    String vs = (String)v;
                    if (dest == new byte[0].getClass()) {
                        BeanUtils.setProperty((Object)toFill, (String)k, (Object)Base64Utilities.decode(vs.getBytes()));
                    } else if (dest == String.class) {
                        BeanUtils.setProperty((Object)toFill, (String)k, (Object)vs);
                    } else if (dest.isEnum()) {
                        boolean found = false;
                        T[] constants = dest.getEnumConstants();
                        if (constants == null) {
                            throw new IllegalArgumentException("La classe passata non \u00e8 un'enumerazione");
                        }
                        for (Object e : constants) {
                            if (!String.valueOf(e.toString()).equals(vs.trim())) continue;
                            found = true;
                            BeanUtils.setProperty((Object)toFill, (String)k, e);
                            break;
                        }
                        if (!found) {
                            throw new IllegalArgumentException("Impossibile deserialzzare l'oggetto di valore: " + vs + " e classe destinazione " + dest.toGenericString());
                        }
                    } else if (dest == Integer.class) {
                        BeanUtils.setProperty((Object)toFill, (String)k, (Object)Integer.valueOf(vs));
                    } else if (dest == Object.class) {
                        BeanUtils.setProperty((Object)toFill, (String)k, (Object)vs);
                    }
                } else if (source == LinkedHashMap.class && dest != Object.class) {
                    BeanUtils.setProperty((Object)toFill, (String)k, BaseHelper.fromMap((Map)v, dest));
                } else {
                    BeanUtils.setProperty((Object)toFill, (String)k, (Object)v);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <T> void validateBean(T bean) {
        ValidatorFactory factory;
        Validator validator;
        Set violations;
        if (bean == null) {
            return;
        }
        JAXRSParameterNameProvider parameterNameProvider = new JAXRSParameterNameProvider();
        Configuration factoryCfg = Validation.byDefaultProvider().configure();
        ValidationConfiguration cfg = new ValidationConfiguration((ParameterNameProvider)parameterNameProvider);
        if (cfg != null) {
            factoryCfg.parameterNameProvider(cfg.getParameterNameProvider());
            factoryCfg.messageInterpolator(cfg.getMessageInterpolator());
            factoryCfg.traversableResolver(cfg.getTraversableResolver());
            factoryCfg.constraintValidatorFactory(cfg.getConstraintValidatorFactory());
            for (Map.Entry entry : cfg.getProperties().entrySet()) {
                factoryCfg.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!(violations = (validator = (factory = factoryCfg.buildValidatorFactory()).getValidator()).validate(bean, new Class[0])).isEmpty()) {
            ProblemValidation problem = new ProblemValidation(FaultCode.RICHIESTA_NON_VALIDA.toFault());
            for (ConstraintViolation violation : violations) {
                String msg = bean.getClass().getSimpleName() + "." + String.valueOf(violation.getPropertyPath());
                problem.addInvalidParam(msg, violation.getMessage(), null);
            }
            Response response = Response.status((int)problem.getStatus()).entity((Object)problem).type("application/problem+json").build();
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(response);
        }
    }

    public static <T> T deserialize(Object o, Class<T> dest) {
        T ret = null;
        if (o != null) {
            if (dest.isInstance(o)) {
                ret = dest.cast(o);
            } else {
                try {
                    ret = BaseHelper.fromMap((Map)o, dest);
                }
                catch (Exception e) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile deserializzare l'oggetto " + dest.getName() + ", formato non valido: " + e.getMessage());
                }
            }
        }
        if (validateAfterDeserialize) {
            BaseHelper.validateBean(ret);
        }
        return ret;
    }

    public static <T> Optional<T> deserializeOptional(Object o, Class<T> dest) {
        return Optional.ofNullable(BaseHelper.deserialize(o, dest));
    }

    public static <T> T deserializeDefault(Object o, Class<T> dest) {
        Optional<T> ret = BaseHelper.deserializeOptional(o, dest);
        if (!ret.isPresent() || ret.isPresent() && ret.get() == null) {
            try {
                return Utilities.newInstance(dest);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret.get();
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

