/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransaction;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransactionWithClient;
import org.openspcoop2.utils.logger.beans.context.core.HttpClient;
import org.openspcoop2.utils.logger.beans.context.core.Operation;
import org.openspcoop2.utils.logger.beans.context.core.Request;
import org.openspcoop2.utils.logger.beans.context.core.Service;
import org.openspcoop2.utils.logger.constants.context.FlowMode;
import org.openspcoop2.utils.service.context.ContextThreadLocal;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;

@NoJSR250Annotations
public class ServiceInfoInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ServiceInfoInInterceptor() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        try {
            Object o;
            HashSet sensitiveProtocolHeaders = new HashSet();
            LogEvent event = new DefaultLogEventMapper().map(message, sensitiveProtocolHeaders);
            IContext ctx = ContextThreadLocal.get();
            Map headers = event.getHeaders();
            AbstractTransaction transaction = ctx.getApplicationContext().getTransaction();
            if (event.getServiceName() != null) {
                transaction.setProtocol("SOAP");
                if (transaction.getService() == null) {
                    transaction.setService(new Service());
                }
                transaction.getService().setName(event.getServiceName().getLocalPart());
            } else {
                transaction.setProtocol("REST");
            }
            if (transaction.getOperation() == null) {
                transaction.setOperation(new Operation());
            }
            transaction.getOperation().setMode(FlowMode.INPUT_OUTPUT);
            transaction.getOperation().setName(event.getOperationName());
            AbstractTransactionWithClient transactionWithClient = null;
            if (transaction instanceof AbstractTransactionWithClient) {
                transactionWithClient = (AbstractTransactionWithClient)transaction;
                if (transactionWithClient.getClient() == null) {
                    transactionWithClient.setClient(new HttpClient());
                }
                transactionWithClient.getClient().setInvocationEndpoint(event.getAddress());
                transactionWithClient.getClient().setPrincipal(event.getPrincipal());
                if (event.getPortName() != null) {
                    transactionWithClient.getClient().setInterfaceName(event.getPortName().getLocalPart());
                }
                if (transactionWithClient.getClient() instanceof HttpClient) {
                    ((HttpClient)transactionWithClient.getClient()).setTransportRequestMethod(HttpRequestMethod.valueOf(event.getHttpMethod().toUpperCase()));
                    if (headers != null && headers.size() > 0) {
                        ((HttpClient)transactionWithClient.getClient()).setTransportClientAddress(ServiceInfoInInterceptor.getIPClientAddressFromHeader(headers));
                    }
                }
                if (transactionWithClient.getRequest() == null) {
                    transactionWithClient.setRequest(new Request());
                }
                if (transactionWithClient.getRequest().getDate() == null) {
                    transactionWithClient.getRequest().setDate(new Date());
                }
            }
            if ((o = message.get((Object)"HTTP.REQUEST")) != null && o instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)o;
                if (transactionWithClient != null) {
                    ((HttpClient)transactionWithClient.getClient()).setSocketClientAddress(httpServletRequest.getRemoteAddr());
                    int contentLength = httpServletRequest.getContentLength();
                    if (contentLength >= 0) {
                        transactionWithClient.getRequest().setSize(Long.valueOf(contentLength));
                    }
                }
            }
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(ServiceInfoInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }

    private static String getIPClientAddressFromHeader(Map<String, String> req) throws UtilsException {
        List<String> headers = HttpUtilities.getClientAddressHeaders();
        if (headers.size() > 0) {
            for (String header : headers) {
                String transportAddr = TransportUtils.getObjectAsString(req, header);
                if (transportAddr == null) continue;
                return transportAddr;
            }
        }
        return null;
    }
}

