/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.DayFormatEnum;
import org.openspcoop2.utils.sql.EscapeSQLConfiguration;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class OracleQueryObject
extends SQLQueryObjectCore {
    public OracleQueryObject(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public ISQLQueryObject addOrderBy(String orderByNomeField) throws SQLQueryObjectException {
        if (this.offset < 0 && this.limit >= 0) {
            super.setOffset(0);
        }
        return super.addOrderBy(orderByNomeField);
    }

    @Override
    public void setLimit(int limit) throws SQLQueryObjectException {
        if (this.offset < 0 && !this.orderBy.isEmpty()) {
            this.offset = 0;
        }
        super.setLimit(limit);
    }

    @Override
    public String getDefaultAliasTableKeyword() {
        return this.getSupportedAliasesTable().get(0);
    }

    @Override
    public List<String> getSupportedAliasesTable() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(" ");
        return lista;
    }

    @Override
    public String getSelectTimestampConstantField(Date date) throws SQLQueryObjectException {
        DateTimeFormatterWrapper sqlDateformat = DateUtils.getDefaultDateTimeFormatter("yyyy-MM-dd HH:mm:ss.SSS");
        return "TO_TIMESTAMP('" + sqlDateformat.format(date) + "', 'YYYY-MM-DD HH24:MI:SS.FF3')";
    }

    @Override
    public String getUnixTimestampConversion(String column) {
        String timeZone = null;
        timeZone = TimeZone.getDefault().getID();
        return "((((cast(" + column + " as date) - to_date('19700101','YYYYMMDD')) * 86400 * 1000) + to_number(to_char(" + column + ",'FF3'))) - ( (EXTRACT (timezone_hour from FROM_TZ (" + column + ",(TZ_OFFSET('" + timeZone + "'))))) *60*60*1000 ) )";
    }

    @Override
    public String getDiffUnixTimestamp(String columnMax, String columnMin) {
        return "((extract( day from  (" + columnMax + " - " + columnMin + "))*24*60*60*1000)+(extract( hour from (" + columnMax + " - " + columnMin + "))*60*60*1000)+(extract( minute from (" + columnMax + " - " + columnMin + "))*60*1000)+round(extract( second from (" + columnMax + " - " + columnMin + "))*1000))";
    }

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "avg(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "sum(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(ISQLQueryObject subSelect) throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append(" ( ");
        bf.append(subSelect.createSQLQuery());
        bf.append(" ) ");
        this.addFromTable(bf.toString());
        return this;
    }

    @Override
    protected EscapeSQLConfiguration getEscapeSQLConfiguration() {
        EscapeSQLConfiguration config = new EscapeSQLConfiguration();
        config.addCharacter('_');
        config.addCharacter('%');
        config.addCharacter('\\');
        config.setUseEscapeClausole(true);
        config.setEscape('\\');
        config.addCharacterWithOtherEscapeChar('\'', '\'');
        return config;
    }

    @Override
    public ISQLQueryObject addSelectForceIndex(String nomeTabella, String indexName) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabela is null or empty string");
        }
        if (indexName == null || "".equals(indexName)) {
            throw new SQLQueryObjectException("Nome indice is null or empty string");
        }
        String forceIndex = "/*+ index(" + nomeTabella + " " + indexName + ") */";
        if (this.forceIndexTableNames.contains(forceIndex)) {
            throw new SQLQueryObjectException("Forzatura all'utilizzo dell'indice (" + forceIndex + ") gia inserito tra le forzature");
        }
        this.forceIndexTableNames.add(forceIndex);
        return this;
    }

    @Override
    public String getExtractDayFormatFromTimestampFieldPrefix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        if (DayFormatEnum.FULL_DAY_NAME.equals((Object)dayFormat)) {
            return "TRIM(BOTH FROM TO_CHAR(";
        }
        return super.getExtractDayFormatFromTimestampFieldPrefix(dayFormat);
    }

    @Override
    public String getExtractDayFormatFromTimestampFieldSuffix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (DayFormatEnum.FULL_DAY_NAME.equals((Object)dayFormat)) {
            return super.getExtractDayFormatFromTimestampFieldSuffix(dayFormat) + ")";
        }
        return super.getExtractDayFormatFromTimestampFieldSuffix(dayFormat);
    }

    @Override
    public ISQLQueryObject addWhereIsEmptyCondition(String field) throws SQLQueryObjectException {
        return this.addWhereIsNullCondition(field);
    }

    @Override
    public ISQLQueryObject addWhereIsNotEmptyCondition(String field) throws SQLQueryObjectException {
        return this.addWhereIsNotNullCondition(field);
    }

    @Override
    public String createSQLQuery() throws SQLQueryObjectException {
        return this.createSQLQuery(false);
    }

    private String createSQLQuery(boolean union) throws SQLQueryObjectException {
        this.precheckBuildQuery();
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT ");
        if (this.offset < 0 && this.limit < 0) {
            Iterator itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
        }
        if (this.isSelectDistinct()) {
            bf.append(" DISTINCT ");
        }
        this.addSQLQuerySelectField(bf);
        bf.append(this.getSQL(false, false, false, union));
        return bf.toString();
    }

    private void addSQLQuerySelectField(StringBuilder bf) {
        if (this.fields.isEmpty()) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                String field = (String)it.next();
                if (this.offset >= 0) {
                    field = this.normalizeField(field, false);
                }
                bf.append(field);
            }
        }
    }

    @Override
    public String createSQLDeleteEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false, false, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update, boolean conditions, boolean union) throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(update, delete, union);
        }
        if (!update && !conditions) {
            bf.append(" FROM ");
            if (this.offset >= 0 && !delete) {
                String field;
                boolean sortTypeAsc;
                if (!this.isSelectDistinct()) {
                    boolean first;
                    Iterator it;
                    bf.append(" ( SELECT ");
                    itForceIndex = this.forceIndexTableNames.iterator();
                    while (itForceIndex.hasNext()) {
                        bf.append(" " + (String)itForceIndex.next() + " ");
                    }
                    if (this.fields.isEmpty()) {
                        it = this.tableNames.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            t = (String)it.next();
                            bf.append(t + ".*");
                        }
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            f = (String)it.next();
                            bf.append(f);
                        }
                    }
                    bf.append(" , ROW_NUMBER() OVER ( ORDER BY ");
                    if (this.orderBy.isEmpty()) {
                        throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
                    }
                    if (!this.orderBy.isEmpty()) {
                        it = this.orderBy.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            String condizione = (String)it.next();
                            if (this.alias.containsKey(condizione)) {
                                bf.append((String)this.alias.get(condizione));
                            } else {
                                bf.append(condizione);
                            }
                            sortTypeAsc = this.sortTypeAsc;
                            if (this.orderBySortType.containsKey(condizione)) {
                                sortTypeAsc = (Boolean)this.orderBySortType.get(condizione);
                            }
                            if (sortTypeAsc) {
                                bf.append(" ASC ");
                                continue;
                            }
                            bf.append(" DESC ");
                        }
                    }
                    bf.append(" ) AS rowNumber ");
                    bf.append(" FROM ");
                    if (this.tables.isEmpty()) {
                        throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                    }
                    it = this.tables.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append((String)it.next());
                    }
                    if (!this.conditions.isEmpty()) {
                        bf.append(" WHERE ");
                        if (this.notBeforeConditions) {
                            bf.append(" NOT ( ");
                        }
                        for (int i = 0; i < this.conditions.size(); ++i) {
                            if (i > 0) {
                                if (this.andLogicOperator) {
                                    bf.append(" AND ");
                                } else {
                                    bf.append(" OR ");
                                }
                            }
                            String cond = (String)this.conditions.get(i);
                            bf.append(cond);
                        }
                        if (this.notBeforeConditions) {
                            bf.append(" )");
                        }
                    }
                    if (!this.getGroupByConditions().isEmpty() && !delete) {
                        bf.append(" GROUP BY ");
                        Iterator<String> it2 = this.getGroupByConditions().iterator();
                        first = true;
                        while (it2.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            bf.append(it2.next());
                        }
                    }
                } else {
                    boolean first;
                    Iterator it;
                    bf.append(" ( SELECT ");
                    itForceIndex = this.forceIndexTableNames.iterator();
                    while (itForceIndex.hasNext()) {
                        bf.append(" " + (String)itForceIndex.next() + " ");
                    }
                    if (this.fields.isEmpty()) {
                        it = this.tableNames.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            t = (String)it.next();
                            bf.append(t + ".*");
                        }
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            field = (String)it.next();
                            field = this.normalizeField(field, false);
                            bf.append(field);
                        }
                    }
                    bf.append(" , ROWNUM AS rowNumber");
                    bf.append(" FROM ");
                    bf.append(" ( SELECT DISTINCT ");
                    if (this.fields.isEmpty()) {
                        bf.append("*");
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            f = (String)it.next();
                            bf.append(f);
                        }
                    }
                    bf.append(" FROM ");
                    if (this.tables.isEmpty()) {
                        throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                    }
                    it = this.tables.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append((String)it.next());
                    }
                    bf.append(" ");
                    if (!this.conditions.isEmpty()) {
                        bf.append(" WHERE ");
                        if (this.notBeforeConditions) {
                            bf.append(" NOT ( ");
                        }
                        for (int i = 0; i < this.conditions.size(); ++i) {
                            if (i > 0) {
                                if (this.andLogicOperator) {
                                    bf.append(" AND ");
                                } else {
                                    bf.append(" OR ");
                                }
                            }
                            String cond = (String)this.conditions.get(i);
                            bf.append(cond);
                        }
                        if (this.notBeforeConditions) {
                            bf.append(" )");
                        }
                    }
                    if (!this.getGroupByConditions().isEmpty() && !delete) {
                        bf.append(" GROUP BY ");
                        Iterator<String> it3 = this.getGroupByConditions().iterator();
                        first = true;
                        while (it3.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            bf.append(it3.next());
                        }
                    }
                    if (this.orderBy.isEmpty()) {
                        throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
                    }
                    if (!this.orderBy.isEmpty()) {
                        bf.append(" ORDER BY ");
                        Iterator it4 = this.orderBy.iterator();
                        first = true;
                        while (it4.hasNext()) {
                            String column = (String)it4.next();
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            bf.append(column);
                            sortTypeAsc = this.sortTypeAsc;
                            if (this.orderBySortType.containsKey(column)) {
                                sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                            }
                            if (sortTypeAsc) {
                                bf.append(" ASC ");
                                continue;
                            }
                            bf.append(" DESC ");
                        }
                    }
                    bf.append(" ) ");
                }
                bf.append(" ) WHERE ( ");
                if (this.offset >= 0) {
                    bf.append(" rowNumber > ");
                    bf.append(this.offset);
                }
                if (this.limit >= 0) {
                    if (this.offset >= 0) {
                        bf.append(" AND");
                    }
                    bf.append(" rowNumber <=  ");
                    if (this.offset >= 0) {
                        bf.append(this.offset + this.limit);
                    } else {
                        bf.append(this.limit);
                    }
                }
                bf.append(" )");
                if (!union && !this.orderBy.isEmpty()) {
                    bf.append(" ORDER BY ");
                    Iterator it = this.orderBy.iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        String originalField = (String)it.next();
                        field = this.normalizeField(originalField);
                        bf.append(field);
                        sortTypeAsc = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(originalField)) {
                            sortTypeAsc = (Boolean)this.orderBySortType.get(originalField);
                        }
                        if (sortTypeAsc) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
            } else {
                if (this.tables.isEmpty()) {
                    throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                }
                if (delete && this.tables.size() > 2) {
                    throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
                }
                Iterator it = this.tables.iterator();
                boolean first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (!this.conditions.isEmpty()) {
                    bf.append(" WHERE ");
                    if (this.notBeforeConditions) {
                        bf.append("NOT (");
                    }
                    for (int i = 0; i < this.conditions.size(); ++i) {
                        if (i > 0) {
                            if (this.andLogicOperator) {
                                bf.append(" AND ");
                            } else {
                                bf.append(" OR ");
                            }
                        }
                        bf.append((String)this.conditions.get(i));
                    }
                    if (this.notBeforeConditions) {
                        bf.append(")");
                    }
                }
                if (this.limit >= 0) {
                    if (this.conditions.isEmpty()) {
                        bf.append(" WHERE ");
                    } else {
                        bf.append(" AND ");
                    }
                    bf.append(" ( rownum <= ");
                    bf.append(this.limit);
                    bf.append(" ) ");
                }
                if (!this.getGroupByConditions().isEmpty() && !delete) {
                    bf.append(" GROUP BY ");
                    Iterator<String> it5 = this.getGroupByConditions().iterator();
                    first = true;
                    while (it5.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(it5.next());
                    }
                }
                if (!(union || this.orderBy.isEmpty() || delete)) {
                    bf.append(" ORDER BY ");
                    Iterator it6 = this.orderBy.iterator();
                    first = true;
                    while (it6.hasNext()) {
                        String column = (String)it6.next();
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(column);
                        boolean sortTypeAsc = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(column)) {
                            sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                        }
                        if (sortTypeAsc) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
                if (this.selectForUpdate) {
                    bf.append(" FOR UPDATE ");
                }
            }
        } else if (!this.conditions.isEmpty()) {
            if (!conditions) {
                bf.append(" WHERE ");
            }
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        String f;
        boolean first;
        Iterator it;
        Iterator itForceIndex;
        this.checkUnionField(false, sqlQueryObject);
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(false, false, true);
        }
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT ");
        if (this.offset < 0) {
            itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
            if (this.fields.isEmpty()) {
                bf.append("* ");
            } else {
                it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    f = (String)it.next();
                    bf.append(f);
                }
                bf.append(" ");
            }
        } else {
            bf.append("* ");
        }
        bf.append(" FROM ");
        if (this.offset >= 0) {
            int i;
            bf.append(" ( SELECT ");
            itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
            if (this.fields.isEmpty()) {
                it = this.tableNames.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String t = (String)it.next();
                    bf.append(t + ".*");
                }
            } else {
                it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    f = (String)it.next();
                    bf.append(f);
                }
            }
            bf.append(" , ROW_NUMBER() OVER ( ORDER BY ");
            if (this.orderBy.isEmpty()) {
                throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
            }
            if (!this.orderBy.isEmpty()) {
                it = this.orderBy.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String condizione = (String)it.next();
                    if (this.alias.containsKey(condizione)) {
                        bf.append((String)this.alias.get(condizione));
                    } else {
                        bf.append(condizione);
                    }
                    boolean sortTypeAsc = this.sortTypeAsc;
                    if (this.orderBySortType.containsKey(condizione)) {
                        sortTypeAsc = (Boolean)this.orderBySortType.get(condizione);
                    }
                    if (sortTypeAsc) {
                        bf.append(" ASC ");
                        continue;
                    }
                    bf.append(" DESC ");
                }
            }
            bf.append(" ) AS rowNumber ");
            bf.append(" FROM ( ");
            for (i = 0; i < sqlQueryObject.length; ++i) {
                if (((OracleQueryObject)sqlQueryObject[i]).selectForUpdate) {
                    try {
                        ((OracleQueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                    }
                    catch (Exception e) {
                        throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                    }
                }
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(((OracleQueryObject)sqlQueryObject[i]).createSQLQuery(true));
                bf.append(") ");
            }
            bf.append(" ) ");
            if (!this.conditions.isEmpty()) {
                bf.append(" WHERE ");
                if (this.notBeforeConditions) {
                    bf.append(" NOT ( ");
                }
                for (i = 0; i < this.conditions.size(); ++i) {
                    if (i > 0) {
                        if (this.andLogicOperator) {
                            bf.append(" AND ");
                        } else {
                            bf.append(" OR ");
                        }
                    }
                    String cond = (String)this.conditions.get(i);
                    bf.append(cond);
                }
                if (this.notBeforeConditions) {
                    bf.append(" )");
                }
            }
            if (!this.getGroupByConditions().isEmpty()) {
                bf.append(" GROUP BY ");
                Iterator<String> it2 = this.getGroupByConditions().iterator();
                first = true;
                while (it2.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(it2.next());
                }
            }
            bf.append(" ) WHERE ( ");
            if (this.offset >= 0) {
                bf.append(" rowNumber > ");
                bf.append(this.offset);
            }
            if (this.limit >= 0) {
                if (this.offset >= 0) {
                    bf.append(" AND");
                }
                bf.append(" rowNumber <=  ");
                if (this.offset >= 0) {
                    bf.append(this.offset + this.limit);
                } else {
                    bf.append(this.limit);
                }
            }
            bf.append(" )");
        } else {
            bf.append(" ( ");
            for (int i = 0; i < sqlQueryObject.length; ++i) {
                if (((OracleQueryObject)sqlQueryObject[i]).selectForUpdate) {
                    try {
                        ((OracleQueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                    }
                    catch (Exception e) {
                        throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                    }
                }
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(((OracleQueryObject)sqlQueryObject[i]).createSQLQuery(true));
                bf.append(") ");
            }
            bf.append(") ");
            if (this.limit >= 0) {
                bf.append(" WHERE ");
                bf.append(" ( rownum <= ");
                bf.append(this.limit);
                bf.append(" ) ");
            }
            if (!this.getGroupByConditions().isEmpty()) {
                bf.append(" GROUP BY ");
                Iterator<String> it3 = this.getGroupByConditions().iterator();
                boolean first2 = true;
                while (it3.hasNext()) {
                    if (!first2) {
                        bf.append(",");
                    } else {
                        first2 = false;
                    }
                    bf.append(it3.next());
                }
            }
            if (!this.orderBy.isEmpty()) {
                bf.append(" ORDER BY ");
                Iterator it4 = this.orderBy.iterator();
                boolean first3 = true;
                while (it4.hasNext()) {
                    String column = (String)it4.next();
                    if (!first3) {
                        bf.append(",");
                    } else {
                        first3 = false;
                    }
                    bf.append(column);
                    boolean sortTypeAsc = this.sortTypeAsc;
                    if (this.orderBySortType.containsKey(column)) {
                        sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                    }
                    if (sortTypeAsc) {
                        bf.append(" ASC ");
                        continue;
                    }
                    bf.append(" DESC ");
                }
            }
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(true, sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT count(*) " + this.getDefaultAliasFieldKeyword() + " ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        bf.append(this.createSQLUnion(unionAll, sqlQueryObject));
        bf.append(") ");
        return bf.toString();
    }

    @Override
    public String createSQLUpdateEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true, false, false));
        return bf.toString();
    }

    @Override
    public String createSQLConditionsEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append(this.getSQL(false, false, true, false));
        return bf.toString();
    }
}

