/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.Case;
import org.openspcoop2.utils.sql.CastColumnType;
import org.openspcoop2.utils.sql.DateTimePartEnum;
import org.openspcoop2.utils.sql.DayFormatEnum;
import org.openspcoop2.utils.sql.EscapeSQLConfiguration;
import org.openspcoop2.utils.sql.EscapeSQLPattern;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectAlreadyExistsException;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public abstract class SQLQueryObjectCore
implements ISQLQueryObject {
    private static final String LA_COLONNA_PREFIX = "La colonna ";
    private static final String TABELLA_PREFIX = "Tabella ";
    private static final String WHERE_CONDITION_PREFIX = "Where Condition ";
    private static final String FIELD_NAME_PREFIX = "Field name ";
    private static final String ALIAS_TABELLA_INDICATO_NON_ESISTE = "L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella";
    private static final String NESSUN_FIELD_IMPOSTATO = "Nessun field impostato";
    private static final String GIA_ESISTENTE_TRA_CONDIZIONI_WHERE = " gia' esistente tra le condizioni di where";
    private static final String FIELD_NAME_IS_NULL_OR_EMPTY = "Field name is null or empty string";
    protected static final String CONDIZIONI_ORDER_BY_RICHESTE = "Condizioni di OrderBy richieste";
    protected static final String TABELLA_RICERCA_FROM_NON_DEFINITA = "Tabella di ricerca (... FROM Table ...) non definita";
    private static final String NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL = "nomeTabella non puo' essere null";
    protected static final String FIELD_DEVE_ESSERE_DIVERSO_NULL = "field non puo' essere null";
    private static final String IS_NULL_CONDITION_DEVE_ESSERE_DIVERSO_NULL = "IsNullCondition field non puo' essere null";
    private static final String LOWER_PREFIX = "( lower(";
    private static final String ESCAPE_SEPARATOR = " ESCAPE ";
    private static final String LIKE_SEPARATOR = " LIKE ";
    protected static final String FROM_SEPARATOR = " FROM ";
    protected static final String FROM_SEPARATOR_APERTURA = " FROM ( ";
    protected static final String WHERE_SEPARATOR = " WHERE ";
    protected static final String AND_SEPARATOR = " AND ";
    protected static final String OR_SEPARATOR = " OR ";
    protected static final String ASC_SEPARATOR = " ASC ";
    protected static final String DESC_SEPARATOR = " DESC ";
    protected static final String GROUP_BY_SEPARATOR = " GROUP BY ";
    protected static final String ORDER_BY_SEPARATOR = " ORDER BY ";
    protected static final String LIMIT_SEPARATOR = " LIMIT ";
    protected static final String NOT_SEPARATOR_APERTURA = " NOT ( ";
    protected static final String SELECT_SEPARATOR_CON_INIZIO_APERTURA = " ( SELECT ";
    protected static final String AS_SUBQUERY_SUFFIX = " ) as subquery";
    private static SecureRandom rndEngine = null;
    List<String> fields = new ArrayList<String>();
    List<String> fieldNames = new ArrayList<String>();
    Map<String, Boolean> fieldNameIsFunction = new HashMap<String, Boolean>();
    Map<String, String> alias = new HashMap<String, String>();
    List<String> tables = new ArrayList<String>();
    List<String> tableNames = new ArrayList<String>();
    List<String> tableAlias = new ArrayList<String>();
    List<String> conditions = new ArrayList<String>();
    List<String> forceIndexTableNames = new ArrayList<String>();
    boolean andLogicOperator = false;
    boolean notBeforeConditions = false;
    private List<String> groupBy = new ArrayList<String>();
    List<String> orderBy = new ArrayList<String>();
    Map<String, Boolean> orderBySortType = new HashMap<String, Boolean>();
    boolean sortTypeAsc = true;
    private volatile boolean distinct = false;
    volatile int limit = -1;
    volatile int offset = -1;
    volatile boolean selectForUpdate = false;
    List<String> updateFieldsName = new ArrayList<String>();
    List<String> updateFieldsValue = new ArrayList<String>();
    String updateTable = null;
    List<String> insertFieldsName = new ArrayList<String>();
    List<String> insertFieldsValue = new ArrayList<String>();
    String insertTable = null;
    private TipiDatabase tipoDatabase;
    private volatile boolean precheckQuery = true;
    private int serial = 0;
    private volatile boolean forceSelectForUpdateDisabledForNotQueryMethod = false;
    protected static final String DATE_PART_YEAR = "YEAR";
    protected static final String DATE_PART_MONTH = "MONTH";
    protected static final String DATE_PART_DAY = "DAY";
    protected static final String TIME_PART_HOUR = "HOUR";
    protected static final String TIME_PART_MINUTE = "MINUTE";
    protected static final String TIME_PART_SECOND = "SECOND";
    private static final String DAY_FORMAT_FULL_DAY_NAME = "DAY";
    private static final String DAY_FORMAT_SHORT_DAY_NAME = "DY";
    private static final String DAY_FORMAT_DAY_OF_YEAR = "DDD";
    private static final String DAY_FORMAT_DAY_OF_WEEK = "D";

    private static synchronized void initRandom() {
        if (rndEngine == null) {
            rndEngine = new SecureRandom();
        }
    }

    protected static Random getRandom() {
        if (rndEngine == null) {
            SQLQueryObjectCore.initRandom();
        }
        return rndEngine;
    }

    public int sizeConditions() {
        return this.conditions.size();
    }

    public void setPrecheckQuery(boolean precheckQuery) {
        this.precheckQuery = precheckQuery;
    }

    protected synchronized int getSerial() {
        ++this.serial;
        return this.serial;
    }

    public void setForceSelectForUpdateDisabledForNotQueryMethod(boolean forceSelectForUpdateDisabledForNotQueryMethod) {
        this.forceSelectForUpdateDisabledForNotQueryMethod = forceSelectForUpdateDisabledForNotQueryMethod;
    }

    protected SQLQueryObjectCore(TipiDatabase tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    protected void precheckBuildQuery() throws SQLQueryObjectException {
        if (!this.precheckQuery) {
            return;
        }
        if (this.offset >= 0 && this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException(CONDIZIONI_ORDER_BY_RICHESTE);
        }
        this.precheckBuildQueryGroupBy();
        if (this.selectForUpdate) {
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                throw new SQLQueryObjectException("Non \u00e8 possibile abilitare il comando 'selectForUpdate' se viene utilizzata la condizione di GROUP BY");
            }
            if (this.distinct) {
                throw new SQLQueryObjectException("Non \u00e8 possibile abilitare il comando 'selectForUpdate' se viene utilizzata la clausola DISTINCT");
            }
            if (this.limit >= 0) {
                throw new SQLQueryObjectException("Non \u00e8 possibile abilitare il comando 'selectForUpdate' se viene utilizzata la clausola LIMIT");
            }
            if (this.offset >= 0) {
                throw new SQLQueryObjectException("Non \u00e8 possibile abilitare il comando 'selectForUpdate' se viene utilizzata la clausola OFFSET");
            }
        }
    }

    private void precheckBuildQueryGroupBy() throws SQLQueryObjectException {
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            this.precheckBuildQueryGroupByOrderBy();
            for (String groupByCheck : this.groupBy) {
                boolean exists = false;
                for (String field : this.fields) {
                    if (!this.normalizeField(groupByCheck).equals(this.normalizeField(field))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                throw new SQLQueryObjectException(LA_COLONNA_PREFIX + groupByCheck + " utilizzata nella condizione di GROUP BY deve essere anche selezionato come select field");
            }
        }
    }

    private void precheckBuildQueryGroupByOrderBy() throws SQLQueryObjectException {
        if (!this.orderBy.isEmpty()) {
            for (String order : this.orderBy) {
                this.precheckBuildQueryGroupByOrderBy(order);
            }
        }
    }

    private void precheckBuildQueryGroupByOrderBy(String order) throws SQLQueryObjectException {
        boolean exists = false;
        for (String groupByCheck : this.groupBy) {
            if (!this.normalizeField(groupByCheck).equals(this.normalizeField(order))) continue;
            exists = true;
            break;
        }
        if (!exists) {
            String orderField = this.normalizeField(order);
            try {
                if (this.isFieldNameForFunction(orderField) == null || !this.isFieldNameForFunction(orderField).booleanValue()) {
                    throw new SQLQueryObjectException(LA_COLONNA_PREFIX + order + " utilizzata nella condizione di ORDER BY deve apparire anche in una condizione di GROUP BY");
                }
            }
            catch (SQLQueryObjectException sqlObject) {
                throw new SQLQueryObjectException(LA_COLONNA_PREFIX + order + " utilizzata nella condizione di ORDER BY deve apparire anche in una condizione di GROUP BY", sqlObject);
            }
        }
    }

    protected String normalizeField(String field) {
        return this.normalizeField(field, true);
    }

    protected String normalizeField(String field, boolean firstSearchFromAliasesField) {
        if (firstSearchFromAliasesField) {
            for (String fieldRicercaAliasa : this.fields) {
                List<String> aliases;
                String[] split = null;
                if (fieldRicercaAliasa.contains(" as ")) {
                    split = fieldRicercaAliasa.split(" as ");
                } else if (fieldRicercaAliasa.contains(" As ")) {
                    split = fieldRicercaAliasa.split(" As ");
                } else if (fieldRicercaAliasa.contains(" aS ")) {
                    split = fieldRicercaAliasa.split(" aS ");
                } else if (fieldRicercaAliasa.contains(" AS ")) {
                    split = fieldRicercaAliasa.split(" AS ");
                } else if (fieldRicercaAliasa.contains(" ")) {
                    split = fieldRicercaAliasa.split(" ");
                } else if (fieldRicercaAliasa.contains(this.getDefaultAliasFieldKeyword())) {
                    split = fieldRicercaAliasa.split(this.getDefaultAliasFieldKeyword());
                }
                if (split == null && (aliases = this.getSupportedAliasesField()) != null && !aliases.isEmpty()) {
                    for (String aliasCheck : aliases) {
                        if (!fieldRicercaAliasa.contains(aliasCheck)) continue;
                        split = fieldRicercaAliasa.split(aliasCheck);
                        break;
                    }
                }
                if (split == null || split.length != 2) continue;
                split[0] = split[0].trim();
                split[1] = split[1].trim();
                if (!field.equals(split[0])) continue;
                return split[1];
            }
        }
        if (!this.continueNormalizeField(field)) {
            return field;
        }
        int indexOf = field.indexOf(".");
        if (indexOf != -1 && indexOf + 1 < field.length()) {
            field = field.substring(indexOf + 1);
        }
        ArrayList<String> aliasModeSupportati = new ArrayList<String>();
        Iterator<String> iterator = this.getSupportedAliasesField().iterator();
        while (iterator.hasNext()) {
            aliasModeSupportati.add(iterator.next());
        }
        if (!aliasModeSupportati.contains(" ")) {
            aliasModeSupportati.add(" ");
        }
        if (!aliasModeSupportati.contains(" as ")) {
            aliasModeSupportati.add(" as ");
        }
        for (String aliasCheck : aliasModeSupportati) {
            int aliasLength = aliasCheck.length();
            String fLowerCase = field.toLowerCase();
            indexOf = fLowerCase.lastIndexOf(aliasCheck);
            if (indexOf == -1 || indexOf + aliasLength >= field.length()) continue;
            field = field.substring(indexOf + aliasLength);
            field = field.trim();
            break;
        }
        return field;
    }

    protected boolean continueNormalizeField(String normalizeField) {
        if (normalizeField != null) {
            // empty if block
        }
        return true;
    }

    protected String getCaseCondition(Case caseValue) throws SQLQueryObjectException {
        if (caseValue == null) {
            throw new SQLQueryObjectException("Field caseValue is null");
        }
        if (caseValue.getValori() == null || caseValue.getValori().isEmpty() || caseValue.getCondizioni() == null || caseValue.getCondizioni().isEmpty()) {
            throw new SQLQueryObjectException("Field caseValue non contiene condizioni");
        }
        if (caseValue.getValori().size() != caseValue.getCondizioni().size()) {
            throw new SQLQueryObjectException("Field caseValue contiene condizioni con  un numero di valori differenti dalle condizioni di where?");
        }
        if (caseValue.getTipoColonna() == null) {
            throw new SQLQueryObjectException("Field caseValue non contiene il tipo della colonna");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("CASE");
        for (int i = 0; i < caseValue.getValori().size(); ++i) {
            String valore = caseValue.getValori().get(i);
            String condizione = caseValue.getCondizioni().get(i);
            bf.append(" WHEN ").append(condizione);
            bf.append(" THEN ");
            bf.append(this.getPrefixCastValue(caseValue.getTipoColonna(), caseValue.getDimensioneColonna()));
            if (caseValue.isStringValueType()) {
                bf.append("'");
                bf.append(this.escapeStringValue(valore));
                bf.append("'");
            } else {
                bf.append(valore);
            }
            bf.append(this.getSuffixCastValue(caseValue.getTipoColonna(), caseValue.getDimensioneColonna()));
        }
        if (caseValue.getValoreDefault() != null) {
            bf.append(" ELSE ");
            bf.append(this.getPrefixCastValue(caseValue.getTipoColonna(), caseValue.getDimensioneColonna()));
            if (caseValue.isStringValueType()) {
                bf.append("'");
                bf.append(this.escapeStringValue(caseValue.getValoreDefault()));
                bf.append("'");
            } else {
                bf.append(caseValue.getValoreDefault());
            }
            bf.append(this.getSuffixCastValue(caseValue.getTipoColonna(), caseValue.getDimensioneColonna()));
        }
        bf.append(" END");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addSelectField(String nomeField) throws SQLQueryObjectException {
        return this.addSelectField(null, nomeField);
    }

    @Override
    public ISQLQueryObject addSelectField(String nomeTabella, String nomeField) throws SQLQueryObjectException {
        return this.engineAddSelectField(nomeTabella, nomeField, null, true, false);
    }

    @Override
    public ISQLQueryObject addSelectAliasField(String nomeField, String alias) throws SQLQueryObjectException {
        return this.engineAddSelectField(null, nomeField, alias, true, false);
    }

    @Override
    public ISQLQueryObject addSelectAliasField(String nomeTabella, String nomeField, String alias) throws SQLQueryObjectException {
        return this.engineAddSelectField(nomeTabella, nomeField, alias, true, false);
    }

    @Override
    public ISQLQueryObject addSelectCoalesceField(String nomeField, String alias, String valore) throws SQLQueryObjectException {
        return this.engineAddSelectField(null, nomeField, alias, true, "coalesce(", ",'" + this.escapeStringValue(valore) + "')", true);
    }

    @Override
    public ISQLQueryObject addSelectCoalesceField(String aliasTabella, String nomeField, String alias, String valore) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        return this.engineAddSelectField(aliasTabella, nomeField, alias, true, "coalesce(", ",'" + this.escapeStringValue(valore) + "')", true);
    }

    @Override
    public ISQLQueryObject addSelectCaseField(Case caseField, String alias) throws SQLQueryObjectException {
        if (alias == null || "".equals(alias)) {
            throw new SQLQueryObjectException("Alias is null or empty string");
        }
        String caseValue = this.getCaseCondition(caseField);
        String field = "(" + caseValue + ")" + this.getDefaultAliasFieldKeyword() + alias;
        this.fields.add(field);
        this.fieldNames.add(alias);
        this.fieldNameIsFunction.put(alias, false);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String alias) throws SQLQueryObjectException {
        Object fieldSQL = "count(*)";
        if (alias != null) {
            fieldSQL = (String)fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, (String)fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        this.fieldNameIsFunction.put(alias, true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String fieldCount, String alias) throws SQLQueryObjectException {
        if (fieldCount == null) {
            fieldCount = "*";
        }
        String fieldSQL = "count(" + fieldCount + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        this.fieldNameIsFunction.put(alias, true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (fieldCount == null && distinct) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare DISTINCT senza specificare un fieldCount");
        }
        if (distinct) {
            this.addSelectCountField("DISTINCT " + fieldCount, alias);
        } else {
            this.addSelectCountField(fieldCount, alias);
        }
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String aliasTabella, String fieldCount, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.addSelectCountField(aliasTabella + "." + fieldCount, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String aliasTabella, String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.addSelectCountField(aliasTabella + "." + fieldCount, alias, distinct);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        this.engineAddSelectField(null, field, alias, true, "avg(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException(NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.engineAddSelectField(aliasTabella, field, alias, true, "avg(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.addSelectAvgTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.engineAddSelectField(null, field, alias, true, "max(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException(NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.engineAddSelectField(aliasTabella, field, alias, true, "max(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.addSelectMaxTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.engineAddSelectField(null, field, alias, true, "min(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException(NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.engineAddSelectField(aliasTabella, field, alias, true, "min(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.addSelectMinTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.engineAddSelectField(null, field, alias, true, "sum(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException(NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.engineAddSelectField(aliasTabella, field, alias, true, "sum(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.addSelectSumTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    protected String getDateTimePart(DateTimePartEnum dateTimePart) throws SQLQueryObjectException {
        switch (dateTimePart) {
            case YEAR: {
                return DATE_PART_YEAR;
            }
            case MONTH: {
                return DATE_PART_MONTH;
            }
            case DAY: {
                return "DAY";
            }
            case HOUR: {
                return TIME_PART_HOUR;
            }
            case MINUTE: {
                return TIME_PART_MINUTE;
            }
            case SECOND: {
                return TIME_PART_SECOND;
            }
        }
        throw new SQLQueryObjectException("DateTimePartEnum '" + String.valueOf((Object)dateTimePart) + "' unknown");
    }

    public String getExtractDateTimePartFromTimestampFieldPrefix(DateTimePartEnum dateTimePart) throws SQLQueryObjectException {
        if (dateTimePart == null) {
            throw new SQLQueryObjectException("dateTimePart undefined");
        }
        String dateTimePartString = this.getDateTimePart(dateTimePart);
        return "EXTRACT(" + dateTimePartString + FROM_SEPARATOR;
    }

    public String getExtractDateTimePartFromTimestampFieldSuffix(DateTimePartEnum dateTimePart) throws SQLQueryObjectException {
        if (dateTimePart == null) {
            throw new SQLQueryObjectException("dateTimePart undefined");
        }
        return ")";
    }

    private ISQLQueryObject addSelectTimestampFieldEngine(String field, String alias, DateTimePartEnum dateTimePart) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.engineAddSelectField(null, field, alias, true, this.getExtractDateTimePartFromTimestampFieldPrefix(dateTimePart), this.getExtractDateTimePartFromTimestampFieldSuffix(dateTimePart), true);
        return this;
    }

    private ISQLQueryObject addSelectTimestampFieldEngine(String aliasTabella, String field, String alias, DateTimePartEnum dateTimePart) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException(NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.engineAddSelectField(aliasTabella, field, alias, true, this.getExtractDateTimePartFromTimestampFieldPrefix(dateTimePart), this.getExtractDateTimePartFromTimestampFieldSuffix(dateTimePart), true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectYearTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DateTimePartEnum.YEAR);
    }

    @Override
    public ISQLQueryObject addSelectYearTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DateTimePartEnum.YEAR);
    }

    @Override
    public ISQLQueryObject addSelectMonthTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DateTimePartEnum.MONTH);
    }

    @Override
    public ISQLQueryObject addSelectMonthTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DateTimePartEnum.MONTH);
    }

    @Override
    public ISQLQueryObject addSelectDayTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DateTimePartEnum.DAY);
    }

    @Override
    public ISQLQueryObject addSelectDayTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DateTimePartEnum.DAY);
    }

    @Override
    public ISQLQueryObject addSelectHourTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DateTimePartEnum.HOUR);
    }

    @Override
    public ISQLQueryObject addSelectHourTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DateTimePartEnum.HOUR);
    }

    @Override
    public ISQLQueryObject addSelectMinuteTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DateTimePartEnum.MINUTE);
    }

    @Override
    public ISQLQueryObject addSelectMinuteTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DateTimePartEnum.MINUTE);
    }

    @Override
    public ISQLQueryObject addSelectSecondTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DateTimePartEnum.SECOND);
    }

    @Override
    public ISQLQueryObject addSelectSecondTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DateTimePartEnum.SECOND);
    }

    protected String getDayFormat(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        switch (dayFormat) {
            case FULL_DAY_NAME: {
                return "DAY";
            }
            case SHORT_DAY_NAME: {
                return DAY_FORMAT_SHORT_DAY_NAME;
            }
            case DAY_OF_YEAR: {
                return DAY_FORMAT_DAY_OF_YEAR;
            }
            case DAY_OF_WEEK: {
                return DAY_FORMAT_DAY_OF_WEEK;
            }
        }
        throw new SQLQueryObjectException("DayFormatEnum '" + String.valueOf((Object)dayFormat) + "' unknown");
    }

    public String getExtractDayFormatFromTimestampFieldPrefix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        return "TO_CHAR(";
    }

    public String getExtractDayFormatFromTimestampFieldSuffix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        String dayFormatString = this.getDayFormat(dayFormat);
        return ", '" + dayFormatString + "')";
    }

    private ISQLQueryObject addSelectTimestampFieldEngine(String field, String alias, DayFormatEnum dayFormatEnum) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.engineAddSelectField(null, field, alias, true, this.getExtractDayFormatFromTimestampFieldPrefix(dayFormatEnum), this.getExtractDayFormatFromTimestampFieldSuffix(dayFormatEnum), true);
        return this;
    }

    private ISQLQueryObject addSelectTimestampFieldEngine(String aliasTabella, String field, String alias, DayFormatEnum dayFormatEnum) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException(NOME_TABELLA_DEVE_ESSERE_DIVERSO_NULL);
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException(ALIAS_TABELLA_INDICATO_NON_ESISTE);
        }
        this.engineAddSelectField(aliasTabella, field, alias, true, this.getExtractDayFormatFromTimestampFieldPrefix(dayFormatEnum), this.getExtractDayFormatFromTimestampFieldSuffix(dayFormatEnum), true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectFullDayNameTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DayFormatEnum.FULL_DAY_NAME);
    }

    @Override
    public ISQLQueryObject addSelectFullDayNameTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DayFormatEnum.FULL_DAY_NAME);
    }

    @Override
    public ISQLQueryObject addSelectShortDayNameTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DayFormatEnum.SHORT_DAY_NAME);
    }

    @Override
    public ISQLQueryObject addSelectShortDayNameTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DayFormatEnum.SHORT_DAY_NAME);
    }

    @Override
    public ISQLQueryObject addSelectDayOfYearTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DayFormatEnum.DAY_OF_YEAR);
    }

    @Override
    public ISQLQueryObject addSelectDayOfYearTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DayFormatEnum.DAY_OF_YEAR);
    }

    @Override
    public ISQLQueryObject addSelectDayOfWeekTimestampField(String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(field, alias, DayFormatEnum.DAY_OF_WEEK);
    }

    @Override
    public ISQLQueryObject addSelectDayOfWeekTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        return this.addSelectTimestampFieldEngine(aliasTabella, field, alias, DayFormatEnum.DAY_OF_WEEK);
    }

    @Override
    public ISQLQueryObject addSelectTimestampConstantField(Date date, String alias) throws SQLQueryObjectException {
        if (date == null) {
            throw new SQLQueryObjectException("Date non puo' essere null");
        }
        String constantValue = this.getSelectTimestampConstantField(date);
        return this.addSelectAliasField(constantValue, alias);
    }

    @Override
    public ISQLQueryObject addSelectForceIndex(String nomeTabella, String indexName) throws SQLQueryObjectException {
        return this;
    }

    @Override
    public void setSelectDistinct(boolean value) throws SQLQueryObjectException {
        this.distinct = value;
    }

    public boolean isSelectDistinct() throws SQLQueryObjectException {
        if (this.distinct && this.fields.isEmpty()) {
            throw new SQLQueryObjectException("Per usare la select distinct devono essere indicati dei select field");
        }
        return this.distinct;
    }

    @Override
    public List<String> getFieldsName() throws SQLQueryObjectException {
        if (this.fieldNames == null || this.fieldNames.isEmpty()) {
            throw new SQLQueryObjectException(NESSUN_FIELD_IMPOSTATO);
        }
        return this.fieldNames;
    }

    @Override
    public Boolean isFieldNameForFunction(String fieldName) throws SQLQueryObjectException {
        if (this.fieldNames == null || this.fieldNames.isEmpty()) {
            throw new SQLQueryObjectException(NESSUN_FIELD_IMPOSTATO);
        }
        if (!this.fieldNameIsFunction.containsKey(fieldName)) {
            throw new SQLQueryObjectException("Field [" + fieldName + "] non presente (se durante la definizione del field e' stato usato un 'alias' utilizzarlo come parametro di questo metodo)");
        }
        return this.fieldNameIsFunction.get(fieldName);
    }

    public List<String> getFields() throws SQLQueryObjectException {
        if (this.fields == null || this.fields.isEmpty()) {
            throw new SQLQueryObjectException(NESSUN_FIELD_IMPOSTATO);
        }
        return this.fields;
    }

    @Override
    public List<String> getTablesName() throws SQLQueryObjectException {
        if (this.tableNames == null || this.tableNames.isEmpty()) {
            throw new SQLQueryObjectException("Nessuna tabella impostata");
        }
        return this.tableNames;
    }

    public List<String> getTables() throws SQLQueryObjectException {
        if (this.tables == null || this.tables.isEmpty()) {
            throw new SQLQueryObjectException("Nessuna tabella impostata");
        }
        return this.tables;
    }

    @Override
    public String getDefaultAliasFieldKeyword() {
        return this.getSupportedAliasesField().get(0);
    }

    @Override
    public String getDefaultAliasTableKeyword() {
        return this.getSupportedAliasesTable().get(0);
    }

    @Override
    public List<String> getSupportedAliasesField() {
        return this.getSupportedAliasesEngine();
    }

    @Override
    public List<String> getSupportedAliasesTable() {
        return this.getSupportedAliasesEngine();
    }

    private List<String> getSupportedAliasesEngine() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(" as ");
        lista.add(" ");
        return lista;
    }

    protected ISQLQueryObject engineAddSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName, boolean isFunction) throws SQLQueryObjectException {
        return this.engineAddSelectField(nomeTabella, nomeField, alias, addFieldName, null, null, isFunction);
    }

    protected ISQLQueryObject engineAddSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName, String functionPrefix, String functionSuffix, boolean isFunction) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field is null or empty string");
        }
        this.checkEngineAddSelectField(nomeField, alias);
        if (nomeTabella != null && !"".equals(nomeTabella)) {
            this.engineAddSelectField(nomeTabella, nomeField, alias, functionPrefix, functionSuffix);
        } else {
            this.engineAddSelectField(nomeField, alias, functionPrefix, functionSuffix);
        }
        if (addFieldName) {
            if (alias != null) {
                this.fieldNames.add(alias);
                this.fieldNameIsFunction.put(alias, isFunction);
            } else {
                this.fieldNames.add(nomeField);
                this.fieldNameIsFunction.put(nomeField, isFunction);
            }
        }
        return this;
    }

    private void checkEngineAddSelectField(String nomeField, String alias) throws SQLQueryObjectException {
        if (alias != null) {
            if (this.fields.contains("*")) {
                throw new SQLQueryObjectException("Alias " + alias + " del field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fieldNames.contains(alias)) {
                throw new SQLQueryObjectAlreadyExistsException("Alias " + alias + " gia inserito tra i select fields");
            }
        } else {
            if (!"*".equals(nomeField) && this.fields.contains("*")) {
                throw new SQLQueryObjectException("Field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fields.contains(nomeField)) {
                throw new SQLQueryObjectAlreadyExistsException("Field " + nomeField + " gia inserito tra i select fields");
            }
        }
    }

    private void engineAddSelectField(String nomeTabella, String nomeField, String alias, String functionPrefix, String functionSuffix) throws SQLQueryObjectException {
        if (!this.tableNames.contains(nomeTabella)) {
            throw new SQLQueryObjectException(TABELLA_PREFIX + nomeTabella + " non esiste tra le tabelle su cui effettuare la ricerca (se nella addFromTable e' stato utilizzato l'alias per la tabella, utilizzarlo anche come parametro in questo metodo)");
        }
        String nomeTabellaConField = nomeTabella + "." + nomeField;
        if (functionPrefix != null) {
            nomeTabellaConField = functionPrefix + nomeTabellaConField;
        }
        if (functionSuffix != null) {
            nomeTabellaConField = nomeTabellaConField + functionSuffix;
        }
        if (alias != null) {
            this.fields.add(nomeTabellaConField + this.getDefaultAliasFieldKeyword() + alias);
            this.alias.put(alias, nomeTabellaConField);
        } else {
            this.fields.add(nomeTabellaConField);
        }
    }

    private void engineAddSelectField(String nomeField, String alias, String functionPrefix, String functionSuffix) {
        String tmp = nomeField;
        if (functionPrefix != null) {
            tmp = functionPrefix + tmp;
        }
        if (functionSuffix != null) {
            tmp = tmp + functionSuffix;
        }
        if (alias != null) {
            this.fields.add(tmp + this.getDefaultAliasFieldKeyword() + alias);
            this.alias.put(alias, tmp);
        } else {
            this.fields.add(tmp);
        }
    }

    @Override
    public ISQLQueryObject addFromTable(String tabella) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (this.tableNames.contains(tabella)) {
            throw new SQLQueryObjectAlreadyExistsException(TABELLA_PREFIX + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tableNames.add(tabella);
        this.tables.add(tabella);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(String tabella, String alias) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (alias == null || "".equals(alias)) {
            throw new SQLQueryObjectException("Alias tabella is null or empty string");
        }
        if (this.tableNames.contains(alias)) {
            throw new SQLQueryObjectAlreadyExistsException(TABELLA_PREFIX + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tableNames.add(alias);
        this.tables.add(tabella + this.getDefaultAliasTableKeyword() + alias);
        this.tableAlias.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(String condition) throws SQLQueryObjectException {
        if (condition == null || "".equals(condition)) {
            throw new SQLQueryObjectException("Where Condition is null or empty string");
        }
        String buildCondition = "( " + condition + " )";
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException(WHERE_CONDITION_PREFIX + condition + GIA_ESISTENTE_TRA_CONDIZIONI_WHERE);
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(boolean andLogicOperator, String ... conditions) throws SQLQueryObjectException {
        this.addWhereCondition(andLogicOperator, false, conditions);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(boolean andLogicOperator, boolean not, String ... conditions) throws SQLQueryObjectException {
        if (conditions == null || conditions.length <= 0) {
            throw new SQLQueryObjectException("Where Conditions non esistenti");
        }
        StringBuilder buildCondition = new StringBuilder();
        if (not) {
            buildCondition.append("( NOT ");
        }
        buildCondition.append("( ");
        this.addWhereCondition(buildCondition, andLogicOperator, conditions);
        buildCondition.append(" )");
        if (not) {
            buildCondition.append(")");
        }
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException(WHERE_CONDITION_PREFIX + buildCondition.toString() + GIA_ESISTENTE_TRA_CONDIZIONI_WHERE);
        }
        this.conditions.add(buildCondition.toString());
        return this;
    }

    private void addWhereCondition(StringBuilder buildCondition, boolean andLogicOperator, String ... conditions) throws SQLQueryObjectException {
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                if (andLogicOperator) {
                    buildCondition.append(AND_SEPARATOR);
                } else {
                    buildCondition.append(OR_SEPARATOR);
                }
            }
            if (conditions[i] == null || "".equals(conditions[i])) {
                throw new SQLQueryObjectException("Where Condition[" + i + "] is null or empty string");
            }
            buildCondition.append("(");
            buildCondition.append(conditions[i]);
            buildCondition.append(")");
        }
    }

    @Override
    public ISQLQueryObject addWhereIsNullCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException(IS_NULL_CONDITION_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.addWhereCondition(field + " is null");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsNotNullCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException(IS_NULL_CONDITION_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.addWhereCondition(field + " is not null");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsEmptyCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException(IS_NULL_CONDITION_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.addWhereCondition(field + " = ''");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsNotEmptyCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException(IS_NULL_CONDITION_DEVE_ESSERE_DIVERSO_NULL);
        }
        this.addWhereCondition(field + " <> ''");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereINCondition(String field, boolean stringValueType, String ... valore) throws SQLQueryObjectException {
        if (valore == null || valore.length < 1) {
            throw new SQLQueryObjectException("Deve essere fornito almeno un valore");
        }
        StringBuilder bf = new StringBuilder(field);
        bf.append(" IN ( ");
        for (int i = 0; i < valore.length; ++i) {
            if (i > 0) {
                bf.append(",");
            }
            if (stringValueType) {
                bf.append("'");
                bf.append(this.escapeStringValue(valore[i]));
                bf.append("'");
                continue;
            }
            bf.append(valore[i]);
        }
        bf.append(")");
        this.addWhereCondition(bf.toString());
        return this;
    }

    @Override
    public ISQLQueryObject addWhereBetweenCondition(String field, boolean stringValueType, String leftValue, String rightValue) throws SQLQueryObjectException {
        if (leftValue == null) {
            throw new SQLQueryObjectException("Deve essere fornito un valore per l'intervallo sinistro");
        }
        if (rightValue == null) {
            throw new SQLQueryObjectException("Deve essere fornito un valore per l'intervallo destro");
        }
        StringBuilder bf = new StringBuilder(field);
        bf.append(" BETWEEN ");
        if (stringValueType) {
            bf.append("'");
            bf.append(this.escapeStringValue(leftValue));
            bf.append("'");
        } else {
            bf.append(leftValue);
        }
        bf.append(AND_SEPARATOR);
        if (stringValueType) {
            bf.append("'");
            bf.append(this.escapeStringValue(rightValue));
            bf.append("'");
        } else {
            bf.append(rightValue);
        }
        this.addWhereCondition(bf.toString());
        return this;
    }

    private String createWhereLikeCondition(String columnName, String searchPattern, boolean escape) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String buildCondition = null;
        if (escape) {
            EscapeSQLPattern escapePattern = this.escapePatternValue(searchPattern);
            Object escapeClausole = "";
            if (escapePattern.isUseEscapeClausole()) {
                escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
            }
            buildCondition = "( " + columnName + " LIKE '" + escapePattern.getEscapeValue() + "'" + (String)escapeClausole + " )";
        } else {
            buildCondition = "( " + columnName + " LIKE '" + searchPattern + "' )";
        }
        return buildCondition;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereLikeCondition(columnName, searchPattern, true);
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean escape) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, escape);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException(WHERE_CONDITION_PREFIX + buildCondition + GIA_ESISTENTE_TRA_CONDIZIONI_WHERE);
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, true);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean escape) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, escape);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, LikeConfig c) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, c.isEscape(), c.isContains(), c.isStartsWith(), c.isEndsWith(), c.isCaseInsensitive());
    }

    private String createWhereLikeCondition(String columnName, String searchPattern, boolean escape, boolean contains, boolean startsWith, boolean endsWith, boolean caseInsensitive) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String buildCondition = null;
        buildCondition = escape ? this.createWhereLikeConditionEscapeEngine(columnName, searchPattern, contains, startsWith, endsWith, caseInsensitive) : this.createWhereLikeConditionNoEscapeEngine(columnName, searchPattern, contains, startsWith, endsWith, caseInsensitive);
        return buildCondition;
    }

    private String createWhereLikeConditionEscapeEngine(String columnName, String searchPattern, boolean contains, boolean startsWith, boolean endsWith, boolean caseInsensitive) throws SQLQueryObjectException {
        String buildCondition = null;
        buildCondition = caseInsensitive ? this.createWhereLikeConditionEscapeEngineCaseInsensitive(columnName, searchPattern, contains, startsWith, endsWith) : this.createWhereLikeConditionEscapeEngineCaseSensitive(columnName, searchPattern, contains, startsWith, endsWith);
        return buildCondition;
    }

    private String createWhereLikeConditionEscapeEngineCaseInsensitive(String columnName, String searchPattern, boolean contains, boolean startsWith, boolean endsWith) throws SQLQueryObjectException {
        String buildCondition = null;
        EscapeSQLPattern escapePattern = this.escapePatternValue(searchPattern);
        Object escapeClausole = "";
        if (escapePattern.isUseEscapeClausole()) {
            escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
        }
        buildCondition = contains ? LOWER_PREFIX + columnName + ") LIKE '%" + escapePattern.getEscapeValue().toLowerCase() + "%'" + (String)escapeClausole + " )" : (startsWith ? LOWER_PREFIX + columnName + ") LIKE '" + escapePattern.getEscapeValue().toLowerCase() + "%'" + (String)escapeClausole + " )" : (endsWith ? LOWER_PREFIX + columnName + ") LIKE '%" + escapePattern.getEscapeValue().toLowerCase() + "'" + (String)escapeClausole + " )" : LOWER_PREFIX + columnName + ") LIKE '" + escapePattern.getEscapeValue().toLowerCase() + "'" + (String)escapeClausole + " )"));
        return buildCondition;
    }

    private String createWhereLikeConditionEscapeEngineCaseSensitive(String columnName, String searchPattern, boolean contains, boolean startsWith, boolean endsWith) throws SQLQueryObjectException {
        String buildCondition = null;
        EscapeSQLPattern escapePattern = this.escapePatternValue(searchPattern);
        Object escapeClausole = "";
        if (escapePattern.isUseEscapeClausole()) {
            escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
        }
        buildCondition = contains ? "( " + columnName + " LIKE '%" + escapePattern.getEscapeValue() + "%'" + (String)escapeClausole + " )" : (startsWith ? "( " + columnName + " LIKE '" + escapePattern.getEscapeValue() + "%'" + (String)escapeClausole + " )" : (endsWith ? "( " + columnName + " LIKE '%" + escapePattern.getEscapeValue() + "'" + (String)escapeClausole + " )" : "( " + columnName + " LIKE '" + escapePattern.getEscapeValue() + "'" + (String)escapeClausole + " )"));
        return buildCondition;
    }

    private String createWhereLikeConditionNoEscapeEngine(String columnName, String searchPattern, boolean contains, boolean startsWith, boolean endsWith, boolean caseInsensitive) {
        String buildCondition = null;
        buildCondition = caseInsensitive ? this.createWhereLikeConditionNoEscapeEngineCaseInsensitive(columnName, searchPattern, contains, startsWith, endsWith) : this.createWhereLikeConditionNoEscapeEngineCaseSensitive(columnName, searchPattern, contains, startsWith, endsWith);
        return buildCondition;
    }

    private String createWhereLikeConditionNoEscapeEngineCaseInsensitive(String columnName, String searchPattern, boolean contains, boolean startsWith, boolean endsWith) {
        String buildCondition = null;
        buildCondition = contains ? LOWER_PREFIX + columnName + ") LIKE '%" + searchPattern.toLowerCase() + "%' )" : (startsWith ? LOWER_PREFIX + columnName + ") LIKE '" + searchPattern.toLowerCase() + "%' )" : (endsWith ? LOWER_PREFIX + columnName + ") LIKE '%" + searchPattern.toLowerCase() + "' )" : LOWER_PREFIX + columnName + ") LIKE '" + searchPattern.toLowerCase() + "' )"));
        return buildCondition;
    }

    private String createWhereLikeConditionNoEscapeEngineCaseSensitive(String columnName, String searchPattern, boolean contains, boolean startsWith, boolean endsWith) {
        String buildCondition = null;
        buildCondition = contains ? "( " + columnName + " LIKE '%" + searchPattern + "%' )" : (startsWith ? "( " + columnName + " LIKE '" + searchPattern + "%' )" : (endsWith ? "( " + columnName + " LIKE '%" + searchPattern + "' )" : "( " + columnName + " LIKE '" + searchPattern + "' )"));
        return buildCondition;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.addWhereLikeCondition(columnName, searchPattern, true, contains, caseInsensitive);
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean escape, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, escape, contains, false, false, caseInsensitive);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException(WHERE_CONDITION_PREFIX + buildCondition + GIA_ESISTENTE_TRA_CONDIZIONI_WHERE);
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, LikeConfig likeConfig) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, likeConfig.isEscape(), likeConfig.isContains(), likeConfig.isStartsWith(), likeConfig.isEndsWith(), likeConfig.isCaseInsensitive());
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException(WHERE_CONDITION_PREFIX + buildCondition + GIA_ESISTENTE_TRA_CONDIZIONI_WHERE);
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, true, contains, false, false, caseInsensitive);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean escape, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, escape, contains, false, false, caseInsensitive);
    }

    private ISQLQueryObject addWhereCondition(String columnName, String searchPattern, DateTimePartEnum dateTimePart) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        String field = this.getExtractDateTimePartFromTimestampFieldPrefix(dateTimePart) + columnName + this.getExtractDateTimePartFromTimestampFieldSuffix(dateTimePart);
        this.addWhereCondition(field + " = '" + searchPattern + "'");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereYearCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DateTimePartEnum.YEAR);
    }

    @Override
    public ISQLQueryObject addWhereMonthCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DateTimePartEnum.MONTH);
    }

    @Override
    public ISQLQueryObject addWhereDayCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DateTimePartEnum.DAY);
    }

    @Override
    public ISQLQueryObject addWhereHourCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DateTimePartEnum.HOUR);
    }

    @Override
    public ISQLQueryObject addWhereMinuteCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DateTimePartEnum.MINUTE);
    }

    @Override
    public ISQLQueryObject addWhereSecondCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DateTimePartEnum.SECOND);
    }

    private ISQLQueryObject addWhereCondition(String columnName, String searchPattern, DayFormatEnum dayFormatEnum) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException(FIELD_DEVE_ESSERE_DIVERSO_NULL);
        }
        String field = this.getExtractDayFormatFromTimestampFieldPrefix(dayFormatEnum) + columnName + this.getExtractDayFormatFromTimestampFieldSuffix(dayFormatEnum);
        this.addWhereCondition(field + " = '" + searchPattern + "'");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereFullDayNameCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DayFormatEnum.FULL_DAY_NAME);
    }

    @Override
    public ISQLQueryObject addWhereShortDayNameCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DayFormatEnum.SHORT_DAY_NAME);
    }

    @Override
    public ISQLQueryObject addWhereDayOfYearCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DayFormatEnum.DAY_OF_YEAR);
    }

    @Override
    public ISQLQueryObject addWhereDayOfWeekCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereCondition(columnName, searchPattern, DayFormatEnum.DAY_OF_WEEK);
    }

    private String createWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non fornito");
        }
        if (sqlQueryObject instanceof SQLQueryObjectCore) {
            SQLQueryObjectCore core = (SQLQueryObjectCore)sqlQueryObject;
            if (core.orderBy != null && !core.orderBy.isEmpty()) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere condizioni di order by");
            }
            if (core.offset >= 0) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere la condizione di OFFSET");
            }
        }
        StringBuilder bf = new StringBuilder();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append("EXISTS (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereExistsCondition(notExists, sqlQueryObject));
        return this;
    }

    @Override
    public String getWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        return this.createWhereExistsCondition(notExists, sqlQueryObject);
    }

    @Override
    public ISQLQueryObject addWhereSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, false, field, sqlQueryObject));
        return this;
    }

    @Override
    public ISQLQueryObject addWhereINSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, true, field, sqlQueryObject));
        return this;
    }

    private String createWhereSQLConditionCondition(boolean notExists, boolean in, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene costruita la ricerca, non fornito");
        }
        if (field == null) {
            throw new SQLQueryObjectException("Field non fornito");
        }
        if (sqlQueryObject instanceof SQLQueryObjectCore) {
            SQLQueryObjectCore core = (SQLQueryObjectCore)sqlQueryObject;
            this.checkWhereSqlConditionConditionLimitOffse(in, core);
        }
        StringBuilder bf = new StringBuilder();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append(field);
        if (in) {
            bf.append(" IN ");
        } else {
            bf.append(" = ");
        }
        bf.append(" (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    private void checkWhereSqlConditionConditionLimitOffse(boolean in, SQLQueryObjectCore core) throws SQLQueryObjectException {
        if (core.orderBy != null && !core.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere condizioni di order by");
        }
        if (core.offset >= 0) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere la condizione di OFFSET");
        }
        if (!in && core.limit > 1) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere la condizione di LIMIT o al massimo puo' essere definita con valore '1')");
        }
    }

    @Override
    public void setANDLogicOperator(boolean andLogicOperator) throws SQLQueryObjectException {
        this.andLogicOperator = andLogicOperator;
    }

    @Override
    public void setNOTBeforeConditions(boolean not) throws SQLQueryObjectException {
        this.notBeforeConditions = not;
    }

    @Override
    public String escapeStringValue(String value) throws SQLQueryObjectException {
        return SQLQueryObjectCore.getEscapeStringValue(value);
    }

    public static String getEscapeStringValue(String value) throws SQLQueryObjectException {
        if (value == null) {
            throw new SQLQueryObjectException("Valore non fornito per escape");
        }
        int index = value.indexOf(39);
        if (index >= 0) {
            StringBuilder str = new StringBuilder();
            char[] v = value.toCharArray();
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == '\'') {
                    str.append('\'');
                }
                str.append(v[i]);
            }
            return str.toString();
        }
        return value;
    }

    @Override
    public EscapeSQLPattern escapePatternValue(String pattern) throws SQLQueryObjectException {
        EscapeSQLPattern escapeSqlPattern = new EscapeSQLPattern();
        if (pattern == null) {
            throw new SQLQueryObjectException("Valore non fornito per escape");
        }
        EscapeSQLConfiguration escapeConfig = this.getEscapeSQLConfiguration();
        StringBuilder str = new StringBuilder();
        char[] v = pattern.toCharArray();
        for (int i = 0; i < v.length; ++i) {
            if (escapeConfig.isDefaultEscape(v[i])) {
                str.append(escapeConfig.getEscape());
                if (escapeConfig.isUseEscapeClausole()) {
                    escapeSqlPattern.setUseEscapeClausole(true);
                    escapeSqlPattern.setEscapeClausole(escapeConfig.getEscape());
                }
            } else if (escapeConfig.isOtherEscape(v[i])) {
                str.append(escapeConfig.getOtherEscapeCharacter(v[i]));
            }
            str.append(v[i]);
        }
        String returnStr = str.toString();
        escapeSqlPattern.setEscapeValue(returnStr);
        return escapeSqlPattern;
    }

    protected abstract EscapeSQLConfiguration getEscapeSQLConfiguration();

    @Override
    public ISQLQueryObject addGroupBy(String groupByNomeField) throws SQLQueryObjectException {
        if (groupByNomeField == null || "".equals(groupByNomeField)) {
            throw new SQLQueryObjectException("GroupBy Condition is null or empty string");
        }
        if (this.alias.containsKey(groupByNomeField)) {
            this.groupBy.add(this.alias.get(groupByNomeField));
        } else {
            this.groupBy.add(groupByNomeField);
        }
        return this;
    }

    public List<String> getGroupByConditions() throws SQLQueryObjectException {
        if (this.groupBy != null && !this.groupBy.isEmpty() && this.fields.isEmpty()) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field");
        }
        return this.groupBy;
    }

    @Override
    public ISQLQueryObject addOrderBy(String orderByNomeField) throws SQLQueryObjectException {
        if (orderByNomeField == null || "".equals(orderByNomeField)) {
            throw new SQLQueryObjectException("OrderBy Condition is null or empty string");
        }
        this.orderBy.add(orderByNomeField);
        return this;
    }

    @Override
    public ISQLQueryObject addOrderBy(String orderByNomeField, boolean asc) throws SQLQueryObjectException {
        this.addOrderBy(orderByNomeField);
        this.orderBySortType.put(orderByNomeField, asc);
        return this;
    }

    @Override
    public void setSortType(boolean sort) throws SQLQueryObjectException {
        if (this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("OrderBy Conditions non definite");
        }
        this.sortTypeAsc = sort;
    }

    @Override
    public void setLimit(int limit) throws SQLQueryObjectException {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setOffset(int offset) throws SQLQueryObjectException {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isSelectForUpdate() {
        return this.selectForUpdate;
    }

    @Override
    public void setSelectForUpdate(boolean selectForUpdate) throws SQLQueryObjectException {
        this.selectForUpdate = selectForUpdate;
    }

    protected void checkSelectForUpdate(boolean update, boolean delete, boolean union) throws SQLQueryObjectException {
        if (this.selectForUpdate) {
            String tipo = null;
            if (update) {
                tipo = "UPDATE";
            } else if (delete) {
                tipo = "DELETE";
            } else if (union) {
                tipo = "UNION";
            } else if (!this.getGroupByConditions().isEmpty()) {
                tipo = "GROUP BY";
            } else if (this.isSelectDistinct()) {
                tipo = "DISTINCT";
            } else if (this.limit >= 0) {
                tipo = "LIMIT";
            } else if (this.offset >= 0) {
                tipo = "OFFSET";
            }
            if (tipo != null) {
                throw new SQLQueryObjectException("Utilizzo dell'opzione 'FOR UPDATE' non permesso con il comando " + tipo);
            }
        }
    }

    public String toString() {
        try {
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    protected void checkUnionField(boolean count, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        if (count) {
            this.checkUnionFieldCount();
        }
        if (this.offset >= 0 && this.fields.isEmpty()) {
            throw new SQLQueryObjectException("Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
        }
        if (this.limit > 0 && this.fields.isEmpty()) {
            throw new SQLQueryObjectException("Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
        }
        if (this.distinct) {
            throw new SQLQueryObjectException("Non e' possibile usare distinct nella select piu' esterna della union (utilizza il parametro boolean unionAll)");
        }
        if (sqlQueryObject == null || sqlQueryObject.length <= 0) {
            throw new SQLQueryObjectException("Parametro is null");
        }
        if (sqlQueryObject.length == 1) {
            throw new SQLQueryObjectException("Parametro contiene un solo sqlQueryObject (minimo 2)");
        }
        this.checkUnionFieldExists(sqlQueryObject);
        this.checkUnionFieldNames(sqlQueryObject);
        this.checkUnionFieldOrderOffset(sqlQueryObject);
        if (this.selectForUpdate) {
            throw new SQLQueryObjectException("Non \u00e8 possibile abilitare il comando 'selectForUpdate' con la UNION");
        }
    }

    protected void checkUnionFieldCount() throws SQLQueryObjectException {
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("Non e' possibile usare order by in una count");
        }
        if (this.limit > 0) {
            throw new SQLQueryObjectException("Non e' possibile usare limit in una count");
        }
        if (this.offset >= 0) {
            throw new SQLQueryObjectException("Non e' possibile usare offset in una count");
        }
    }

    protected void checkUnionFieldExists(ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            ISQLQueryObject sqlQueryObjectDaVerificare = sqlQueryObject[i];
            List<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObjectDaVerificare.getFieldsName();
            if (nomiFieldSqlQueryObjectDaVerificare != null && !nomiFieldSqlQueryObjectDaVerificare.isEmpty()) continue;
            throw new SQLQueryObjectException("La select numero " + (i + 1) + " non possiede fields?");
        }
    }

    protected void checkUnionFieldNames(ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            List<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObject[i].getFieldsName();
            String[] nomi = nomiFieldSqlQueryObjectDaVerificare.toArray(new String[1]);
            for (int indiceField = 0; indiceField < nomi.length; ++indiceField) {
                String fieldDaVerificare = nomi[indiceField];
                for (int altriSqlObject = 0; altriSqlObject < sqlQueryObject.length; ++altriSqlObject) {
                    if (altriSqlObject == i || sqlQueryObject[altriSqlObject].getFieldsName().contains(fieldDaVerificare) || sqlQueryObject[altriSqlObject].getFieldsName().contains("*")) continue;
                    throw new SQLQueryObjectException("Field [" + fieldDaVerificare + "] trovato nella select numero " + (i + 1) + " non presente nella select numero " + (altriSqlObject + 1) + " (Se sono campi diversi usare lo stesso alias)");
                }
            }
        }
    }

    protected void checkUnionFieldOrderOffset(ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            SQLQueryObjectCore sqlQueryObjectDaVerificare = (SQLQueryObjectCore)sqlQueryObject[i];
            if (sqlQueryObjectDaVerificare.orderBy == null || sqlQueryObjectDaVerificare.orderBy.isEmpty() || sqlQueryObjectDaVerificare.offset >= 0) continue;
            sqlQueryObjectDaVerificare.setOffset(0);
        }
    }

    @Override
    public ISQLQueryObject addUpdateTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.updateTable = nomeTabella;
        return this;
    }

    @Override
    public ISQLQueryObject addUpdateField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException(FIELD_NAME_IS_NULL_OR_EMPTY);
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.updateFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException(FIELD_NAME_PREFIX + nomeField + " gia inserito tra gli update fields");
        }
        this.updateFieldsName.add(nomeField);
        this.updateFieldsValue.add(valueField);
        return this;
    }

    @Override
    public ISQLQueryObject addUpdateField(String nomeField, Case caseValue) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException(FIELD_NAME_IS_NULL_OR_EMPTY);
        }
        if (this.updateFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException(FIELD_NAME_PREFIX + nomeField + " gia inserito tra gli update fields");
        }
        String caseCondition = this.getCaseCondition(caseValue);
        this.updateFieldsName.add(nomeField);
        this.updateFieldsValue.add(caseCondition);
        return this;
    }

    protected String getPrefixCastValue(CastColumnType type, int length) {
        if (type == null || length > 0) {
            // empty if block
        }
        return "";
    }

    protected String getSuffixCastValue(CastColumnType type, int length) {
        if (type != null || length > 0) {
            // empty if block
        }
        return "";
    }

    @Override
    public String createSQLUpdate() throws SQLQueryObjectException {
        if (this.updateTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'aggiornamento non definito");
        }
        if (this.updateFieldsName.isEmpty()) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da aggiornare presente");
        }
        if (this.updateFieldsName.size() != this.updateFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size[" + this.updateFieldsName.size() + "] <> FieldsValue.size[" + this.updateFieldsValue.size() + "]");
        }
        if (this.forceSelectForUpdateDisabledForNotQueryMethod) {
            boolean oldValueSelectForUpdate = this.selectForUpdate;
            try {
                this.selectForUpdate = false;
                String string = this.createSQLUpdateEngine();
                return string;
            }
            finally {
                this.selectForUpdate = oldValueSelectForUpdate;
            }
        }
        return this.createSQLUpdateEngine();
    }

    protected abstract String createSQLUpdateEngine() throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addInsertTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.insertTable = nomeTabella;
        return this;
    }

    @Override
    public ISQLQueryObject addInsertField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException(FIELD_NAME_IS_NULL_OR_EMPTY);
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.insertFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException(FIELD_NAME_PREFIX + nomeField + " gia inserito tra gli insert fields");
        }
        this.insertFieldsName.add(nomeField);
        this.insertFieldsValue.add(valueField);
        return this;
    }

    @Override
    public String createSQLInsert() throws SQLQueryObjectException {
        if (this.insertTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'inserimento non definito");
        }
        if (this.insertFieldsName.isEmpty()) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da inserire presente");
        }
        if (this.insertFieldsName.size() != this.insertFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        if (this.forceSelectForUpdateDisabledForNotQueryMethod) {
            boolean oldValueSelectForUpdate = this.selectForUpdate;
            try {
                this.selectForUpdate = false;
                String string = this.createSQLInsertEngine();
                return string;
            }
            finally {
                this.selectForUpdate = oldValueSelectForUpdate;
            }
        }
        return this.createSQLInsertEngine();
    }

    private String createSQLInsertEngine() {
        int i;
        StringBuilder bf = new StringBuilder();
        bf.append("INSERT INTO ");
        bf.append(this.insertTable);
        bf.append(" (");
        for (i = 0; i < this.insertFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsName.get(i));
        }
        bf.append(") VALUES (");
        for (i = 0; i < this.insertFieldsValue.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsValue.get(i));
        }
        bf.append(")");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addDeleteTable(String tabella) throws SQLQueryObjectException {
        this.checkDeleteTable(tabella);
        this.addFromTable(tabella);
        return this;
    }

    @Override
    public String createSQLDelete() throws SQLQueryObjectException {
        if (this.tables.isEmpty()) {
            throw new SQLQueryObjectException("Non e' possibile creare un comando di delete senza aver definito le tabelle su cui apportare l'eliminazione dei dati");
        }
        for (String table : this.tables) {
            this.checkDeleteTable(table);
        }
        if (this.forceSelectForUpdateDisabledForNotQueryMethod) {
            boolean oldValueSelectForUpdate = this.selectForUpdate;
            try {
                this.selectForUpdate = false;
                String string = this.createSQLDeleteEngine();
                return string;
            }
            finally {
                this.selectForUpdate = oldValueSelectForUpdate;
            }
        }
        return this.createSQLDeleteEngine();
    }

    protected abstract String createSQLDeleteEngine() throws SQLQueryObjectException;

    private void checkDeleteTable(String tabella) throws SQLQueryObjectException {
        if (tabella.contains(" as ") || tabella.contains(" ")) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare tabelle definite tramite alias in caso di delete");
        }
        List<String> asModeSupportati = this.getSupportedAliasesTable();
        for (String aliasMode : asModeSupportati) {
            if (!tabella.contains(aliasMode)) continue;
            throw new SQLQueryObjectException("Non e' possibile utilizzare tabelle definite tramite alias in caso di delete");
        }
    }

    @Override
    public String createSQLConditions() throws SQLQueryObjectException {
        if (this.conditions == null) {
            throw new SQLQueryObjectException("Condizioni non definite");
        }
        if (this.conditions.isEmpty()) {
            throw new SQLQueryObjectException("Nessuna condizione presente");
        }
        if (this.forceSelectForUpdateDisabledForNotQueryMethod) {
            boolean oldValueSelectForUpdate = this.selectForUpdate;
            try {
                this.selectForUpdate = false;
                String string = this.createSQLConditionsEngine();
                return string;
            }
            finally {
                this.selectForUpdate = oldValueSelectForUpdate;
            }
        }
        return this.createSQLConditionsEngine();
    }

    protected abstract String createSQLConditionsEngine() throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject newSQLQueryObject() throws SQLQueryObjectException {
        return SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
    }

    @Override
    public String getTipoDatabase() throws SQLQueryObjectException {
        return this.tipoDatabase.toString();
    }

    @Override
    public TipiDatabase getTipoDatabaseOpenSPCoop2() throws SQLQueryObjectException {
        return this.tipoDatabase;
    }
}

