/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

public class HttpClientAddressSanitizer {
    private static final String FORWARDED_FOR_PREFIX = "for=";
    private static final int FORWARDED_FOR_PREFIX_LENGTH = "for=".length();

    private HttpClientAddressSanitizer() {
    }

    public static String sanitizeTransportAddressPort(String transportAddress) {
        if (transportAddress == null || "".equals(transportAddress)) {
            return transportAddress;
        }
        String[] addresses = transportAddress.split(",");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < addresses.length; ++i) {
            String addr = addresses[i].trim();
            if ("".equals(addr)) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            if (HttpClientAddressSanitizer.isForwardedHeaderFormat(addr)) {
                addr = HttpClientAddressSanitizer.parseForwardedHeaderValue(addr);
            }
            result.append(HttpClientAddressSanitizer.stripPort(addr));
        }
        return result.toString();
    }

    static String parseForwardedHeaderValue(String value) {
        String forValue = HttpClientAddressSanitizer.extractForParameter(value);
        if (forValue == null) {
            return value;
        }
        if (forValue.length() > 1 && forValue.startsWith("\"") && forValue.endsWith("\"")) {
            forValue = forValue.substring(1, forValue.length() - 1);
        }
        return forValue;
    }

    private static boolean isForwardedHeaderFormat(String value) {
        return value.length() > FORWARDED_FOR_PREFIX_LENGTH && value.substring(0, FORWARDED_FOR_PREFIX_LENGTH).equalsIgnoreCase(FORWARDED_FOR_PREFIX);
    }

    private static String extractForParameter(String value) {
        if (value.length() <= FORWARDED_FOR_PREFIX_LENGTH) {
            return null;
        }
        String[] params = value.split(";");
        for (int i = 0; i < params.length; ++i) {
            String param = params[i].trim();
            if (param.length() <= FORWARDED_FOR_PREFIX_LENGTH || !param.substring(0, FORWARDED_FOR_PREFIX_LENGTH).equalsIgnoreCase(FORWARDED_FOR_PREFIX)) continue;
            return param.substring(FORWARDED_FOR_PREFIX_LENGTH);
        }
        return null;
    }

    static String stripPort(String address) {
        if (address == null || "".equals(address)) {
            return address;
        }
        if (address.startsWith("[")) {
            int closeBracket = address.indexOf(93);
            if (closeBracket > 0) {
                return address.substring(1, closeBracket);
            }
            return address;
        }
        if (HttpClientAddressSanitizer.isIpv4WithPort(address)) {
            return address.substring(0, address.indexOf(58));
        }
        return address;
    }

    private static boolean isIpv4WithPort(String address) {
        int colonCount = 0;
        int lastColon = -1;
        for (int i = 0; i < address.length(); ++i) {
            if (address.charAt(i) != ':') continue;
            ++colonCount;
            lastColon = i;
        }
        if (colonCount != 1 || lastColon <= 0) {
            return false;
        }
        String afterColon = address.substring(lastColon + 1);
        if (afterColon.isEmpty()) {
            return false;
        }
        for (int i = 0; i < afterColon.length(); ++i) {
            if (Character.isDigit(afterColon.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

