/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;

public class HttpHeaderTypes {
    private Map<String, String> requestStandard = new HashMap<String, String>();
    private Map<String, String> requestNonStandard = new HashMap<String, String>();
    private Map<String, String> responseStandard = new HashMap<String, String>();
    private Map<String, String> responseNonStandard = new HashMap<String, String>();
    private static HttpHeaderTypes httpHeaderTypes = null;

    private HttpHeaderTypes() throws UtilsException {
        InputStream is = null;
        BufferedReader br = null;
        InputStreamReader ir = null;
        try {
            String line;
            String file = "/org/openspcoop2/utils/transport/http/httpheader.types";
            is = HttpHeaderTypes.class.getResourceAsStream(file);
            if (is == null) {
                throw new UtilsException("File [" + file + "] in classpath not found");
            }
            ir = new InputStreamReader(is);
            br = new BufferedReader(ir);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                String[] tmp = line.split(" ");
                if (tmp.length < 4) {
                    throw new UtilsException("Line [" + line + "] format wrong");
                }
                String property = tmp[0];
                String richiestaRisposta = tmp[1];
                String standardNonStandard = tmp[2];
                int length = property.length() + 1 + richiestaRisposta.length() + 1 + standardNonStandard.length() + 1;
                String descrizione = line.substring(length);
                if ("[request]".equalsIgnoreCase(richiestaRisposta)) {
                    if ("[standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.requestStandard.put(property, descrizione);
                        continue;
                    }
                    if ("[non-standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.requestNonStandard.put(property, descrizione);
                        continue;
                    }
                    throw new UtilsException("Line [" + line + "] with wrong value [" + standardNonStandard + "] in third parameter (expected: [standard] o [non-standard] )");
                }
                if ("[response]".equalsIgnoreCase(richiestaRisposta)) {
                    if ("[standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.responseStandard.put(property, descrizione);
                        continue;
                    }
                    if ("[non-standard]".equalsIgnoreCase(standardNonStandard)) {
                        this.responseNonStandard.put(property, descrizione);
                        continue;
                    }
                    throw new UtilsException("Line [" + line + "] with wrong value [" + standardNonStandard + "] in third parameter (expected: [standard] o [non-standard] )");
                }
                throw new UtilsException("Line [" + line + "] with wrong value [" + richiestaRisposta + "] in second parameter (expected: [request] o [response] )");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ir != null) {
                    ir.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> getHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getRequestHeaders());
        list.addAll(this.getResponseHeaders());
        return list;
    }

    public List<String> getRequestHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getRequestStandardHeaders());
        list.addAll(this.getRequestNonStandardHeaders());
        return list;
    }

    public List<String> getRequestStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.requestStandard.keySet());
        return list;
    }

    public List<String> getRequestNonStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.requestNonStandard.keySet());
        return list;
    }

    public List<String> getResponseHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getResponseStandardHeaders());
        list.addAll(this.getResponseNonStandardHeaders());
        return list;
    }

    public List<String> getResponseStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.responseStandard.keySet());
        return list;
    }

    public List<String> getResponseNonStandardHeaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.responseNonStandard.keySet());
        return list;
    }

    private static synchronized void init() throws UtilsException {
        if (httpHeaderTypes == null) {
            httpHeaderTypes = new HttpHeaderTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpHeaderTypes getInstance() throws UtilsException {
        if (httpHeaderTypes != null) return httpHeaderTypes;
        Class<HttpHeaderTypes> clazz = HttpHeaderTypes.class;
        synchronized (HttpHeaderTypes.class) {
            HttpHeaderTypes.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpHeaderTypes;
        }
    }
}

