/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import org.openspcoop2.utils.UtilsException;

public enum HttpLibrary {
    HTTP_URL_CONNECTION("java.net.HttpURLConnection"),
    HTTP_CORE5("org.apache.hc.client5");

    private final String name;

    private HttpLibrary(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static HttpLibrary fromName(String name) {
        HttpLibrary[] libs;
        for (HttpLibrary lib : libs = HttpLibrary.values()) {
            if (!lib.getName().equals(name)) continue;
            return lib;
        }
        return null;
    }

    public static HttpLibrary getHttpLibrarySafe(String value) {
        try {
            return HttpLibrary.getHttpLibrary(value);
        }
        catch (UtilsException utilsException) {
            return null;
        }
    }

    public static HttpLibrary getHttpLibrary(String value) throws UtilsException {
        if (HTTP_URL_CONNECTION.toString().equalsIgnoreCase(value)) {
            return HTTP_URL_CONNECTION;
        }
        if (HTTP_CORE5.toString().equalsIgnoreCase(value)) {
            return HTTP_CORE5;
        }
        throw new UtilsException("Unknown type '" + value + "' (supported values: " + HttpLibrary.stringValues() + "): " + value);
    }

    public static String stringValues() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        for (HttpLibrary tmp : HttpLibrary.values()) {
            if (i > 0) {
                res.append(",");
            }
            res.append(tmp.getName());
            ++i;
        }
        return res.toString();
    }

    public static String[] toStringArray() {
        String[] res = new String[HttpLibrary.values().length];
        int i = 0;
        for (HttpLibrary tmp : HttpLibrary.values()) {
            res[i] = tmp.getName();
            ++i;
        }
        return res;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(String tlm) {
        if (tlm == null) {
            return false;
        }
        return this.toString().equals(tlm);
    }
}

