/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.Credential;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.slf4j.Logger;

public class HttpServletTransportRequestContext
extends TransportRequestContext
implements Serializable {
    private transient HttpServletRequest httpServletRequest;
    private transient HttpServletResponse httpServletResponse;
    private static final long serialVersionUID = 1L;

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void updateHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public HttpServletTransportRequestContext() throws UtilsException {
    }

    public HttpServletTransportRequestContext(Logger log) throws UtilsException {
        super(log);
    }

    public HttpServletTransportRequestContext(HttpServletRequest req, Logger logCore) throws UtilsException {
        this(req, logCore, false);
    }

    public HttpServletTransportRequestContext(HttpServletRequest req, Logger logCore, boolean debug) throws UtilsException {
        super(logCore);
        try {
            this.httpServletRequest = req;
            this.parameters = new HashMap();
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String nomeProperty = (String)en.nextElement();
                String[] s = req.getParameterValues(nomeProperty);
                ArrayList<String> values = new ArrayList<String>();
                if (s != null && s.length > 0) {
                    for (int i = 0; i < s.length; ++i) {
                        String value = s[i];
                        values.add(value);
                    }
                } else {
                    values.add(req.getParameter(nomeProperty));
                }
                this.parameters.put(nomeProperty, values);
            }
            this.headers = new HashMap();
            Enumeration enTrasporto = req.getHeaderNames();
            while (enTrasporto.hasMoreElements()) {
                String nomeHeader = (String)enTrasporto.nextElement();
                Enumeration enValues = req.getHeaders(nomeHeader);
                ArrayList<String> values = new ArrayList<String>();
                if (enValues != null) {
                    int i = 0;
                    while (enValues.hasMoreElements()) {
                        String value = (String)enValues.nextElement();
                        values.add(value);
                        ++i;
                    }
                }
                if (values.isEmpty()) {
                    values.add(req.getHeader(nomeHeader));
                }
                this.headers.put(nomeHeader, values);
            }
            this.cookiesValue = new HashMap();
            this.cookiesMaxAge = new HashMap();
            Cookie[] cookies = req.getCookies();
            if (cookies != null && cookies.length > 0) {
                for (Cookie cookie : cookies) {
                    String cookieName = cookie.getName();
                    String value = URLDecoder.decode(cookie.getValue(), Charset.UTF_8.getValue());
                    this.cookiesValue.put(cookieName, value);
                    if (cookie.getMaxAge() <= 0) continue;
                    this.cookiesMaxAge.put(cookieName, cookie.getMaxAge());
                }
            }
            this.webContext = req.getContextPath();
            this.requestURI = req.getRequestURI();
            this.requestType = req.getMethod();
            this.credential = new HttpServletCredential(req, logCore, debug);
            this.source = HttpServletTransportRequestContext.buildSource(req, this.credential);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String buildSource(HttpServletRequest req, Credential credenziali) {
        String protocollo = "http";
        if (credenziali.getSubject() != null) {
            protocollo = "https";
        }
        String ip = req.getRemoteAddr();
        String port = "" + req.getRemotePort();
        Object user = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            user = ":";
            user = credenziali.getSubject() != null ? (String)user + credenziali.getSubject() : (String)user + credenziali.getUsername();
        }
        return protocollo + ":" + ip + ":" + port + (String)user;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(super.toString(prefix));
        if (this.httpServletRequest != null) {
            sb.append("\n").append(prefix).append("httpServletRequest: disponibile");
            if (this.httpServletRequest.getRequestURI() != null) {
                sb.append("\n").append(prefix).append("httpServletRequest.getRequestURI: ").append(this.httpServletRequest.getRequestURI());
            }
            if (this.httpServletRequest.getRequestURL() != null) {
                sb.append("\n").append(prefix).append("httpServletRequest.getRequestURL: ").append(this.httpServletRequest.getRequestURL());
            }
            if (this.httpServletRequest.getQueryString() != null) {
                sb.append("\n").append(prefix).append("httpServletRequest.getQueryString: ").append(this.httpServletRequest.getQueryString());
            }
        }
        return sb.toString();
    }
}

