/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openspcoop2.utils.transport.http.MockServletInputStream;

public class MockHttpServletRequest
extends HttpServletRequestWrapper {
    private AsyncContext asyncContext = null;
    private Map<String, Object> attributes = null;
    private Map<String, List<String>> headers = null;
    private String characterEncoding = null;
    private DispatcherType dispatcherType = null;
    private MockServletInputStream is = null;

    public MockHttpServletRequest(HttpServletRequest req) {
        super(req);
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public AsyncContext getAsyncContext() {
        if (this.asyncContext != null) {
            return this.asyncContext;
        }
        return this.getHttpServletRequest().getAsyncContext();
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    public Object getAttribute(String arg0) {
        if (this.attributes != null) {
            return this.attributes.get(arg0);
        }
        return this.getHttpServletRequest().getAttribute(arg0);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributes != null) {
            return Collections.enumeration(this.attributes.keySet());
        }
        return this.getHttpServletRequest().getAttributeNames();
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding;
        }
        return this.getHttpServletRequest().getCharacterEncoding();
    }

    public void setWrappedCharacterEncoding(String enc) {
        this.characterEncoding = enc;
    }

    public int getContentLength() {
        return this.getIntHeader("Content-Length");
    }

    public long getContentLengthLong() {
        return this.getIntHeader("Content-Length");
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public DispatcherType getDispatcherType() {
        if (this.dispatcherType != null) {
            return this.dispatcherType;
        }
        return this.getHttpServletRequest().getDispatcherType();
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        return this.getHttpServletRequest().getInputStream();
    }

    public String getLocalAddr() {
        return this.getHttpServletRequest().getLocalAddr();
    }

    public String getLocalName() {
        return this.getHttpServletRequest().getLocalName();
    }

    public int getLocalPort() {
        return this.getHttpServletRequest().getLocalPort();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.getHttpServletRequest().getLocales();
    }

    public String getParameter(String arg0) {
        return this.getHttpServletRequest().getParameter(arg0);
    }

    public Map<String, String[]> getParameterMap() {
        return this.getHttpServletRequest().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this.getHttpServletRequest().getParameterNames();
    }

    public String[] getParameterValues(String arg0) {
        return this.getHttpServletRequest().getParameterValues(arg0);
    }

    public String getProtocol() {
        return this.getHttpServletRequest().getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        if (this.is != null) {
            return new BufferedReader(new InputStreamReader((InputStream)((Object)this.is), StandardCharsets.UTF_8));
        }
        return this.getHttpServletRequest().getReader();
    }

    public String getRemoteAddr() {
        return this.getHttpServletRequest().getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.getHttpServletRequest().getRemoteHost();
    }

    public int getRemotePort() {
        return this.getHttpServletRequest().getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.getHttpServletRequest().getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this.getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this.getHttpServletRequest().getServerPort();
    }

    public ServletContext getServletContext() {
        return this.getHttpServletRequest().getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.getHttpServletRequest().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.getHttpServletRequest().isAsyncSupported();
    }

    public boolean isSecure() {
        return this.getHttpServletRequest().isSecure();
    }

    public void removeAttribute(String arg0) {
        this.getHttpServletRequest().removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.getHttpServletRequest().setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.getHttpServletRequest().setCharacterEncoding(arg0);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.getHttpServletRequest().startAsync();
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return this.getHttpServletRequest().startAsync(arg0, arg1);
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return this.getHttpServletRequest().authenticate(arg0);
    }

    public String changeSessionId() {
        return this.getHttpServletRequest().changeSessionId();
    }

    public String getAuthType() {
        return this.getHttpServletRequest().getAuthType();
    }

    public String getContextPath() {
        return this.getHttpServletRequest().getContextPath();
    }

    public Cookie[] getCookies() {
        return this.getHttpServletRequest().getCookies();
    }

    public long getDateHeader(String arg0) {
        return Long.valueOf(this.getHeader(arg0));
    }

    private String preProcessHeaderName(String name) {
        if (name != null) {
            return name.toLowerCase();
        }
        return name;
    }

    public String getHeader(String arg0) {
        List<String> v;
        arg0 = this.preProcessHeaderName(arg0);
        if (this.headers != null && this.headers.containsKey(arg0) && (v = this.headers.get(arg0)) != null && !v.isEmpty()) {
            return String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.headers.get(arg0));
        }
        return this.getHttpServletRequest().getHeader(arg0);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.headers != null) {
            names.addAll(this.headers.keySet());
        }
        if (this.getHttpServletRequest() != null) {
            this.getHttpServletRequest().getHeaderNames().asIterator().forEachRemaining(name -> names.add(this.preProcessHeaderName((String)name)));
        }
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String arg0) {
        arg0 = this.preProcessHeaderName(arg0);
        HashSet values = new HashSet();
        if (this.headers != null) {
            values.addAll(Objects.requireNonNullElse(this.headers.getOrDefault(arg0, List.of()), List.of()));
        }
        if (this.getHttpServletRequest() != null && values.isEmpty()) {
            this.getHttpServletRequest().getHeaders(arg0).asIterator().forEachRemaining(values::add);
        }
        return Collections.enumeration(values.stream().filter(o -> o != null).collect(Collectors.toList()));
    }

    public int getIntHeader(String arg0) {
        return Integer.valueOf(this.getHeader(arg0));
    }

    public String getMethod() {
        return this.getHttpServletRequest().getMethod();
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        return this.getHttpServletRequest().getPart(arg0);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getHttpServletRequest().getParts();
    }

    public String getPathInfo() {
        return this.getHttpServletRequest().getPathInfo();
    }

    public String getPathTranslated() {
        return this.getHttpServletRequest().getPathTranslated();
    }

    public String getQueryString() {
        return this.getHttpServletRequest().getQueryString();
    }

    public String getRemoteUser() {
        return this.getHttpServletRequest().getRemoteUser();
    }

    public String getRequestURI() {
        return this.getHttpServletRequest().getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.getHttpServletRequest().getRequestURL();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.getHttpServletRequest().getServletPath();
    }

    public HttpSession getSession() {
        return this.getHttpServletRequest().getSession();
    }

    public HttpSession getSession(boolean arg0) {
        return this.getHttpServletRequest().getSession(arg0);
    }

    public Principal getUserPrincipal() {
        return this.getHttpServletRequest().getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.getHttpServletRequest().isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return this.getHttpServletRequest().isUserInRole(arg0);
    }

    public void login(String arg0, String arg1) throws ServletException {
        this.getHttpServletRequest().login(arg0, arg1);
    }

    public void logout() throws ServletException {
        this.getHttpServletRequest().logout();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return (T)this.getHttpServletRequest().upgrade(arg0);
    }

    public String getProtocolRequestId() {
        return this.getHttpServletRequest().getProtocolRequestId();
    }

    public String getRequestId() {
        return this.getHttpServletRequest().getRequestId();
    }

    public ServletConnection getServletConnection() {
        return this.getHttpServletRequest().getServletConnection();
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.headers.put(this.preProcessHeaderName(entry.getKey()), entry.getValue());
        }
    }

    public void setHeader(String name, List<String> value) {
        name = this.preProcessHeaderName(name);
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        this.headers.put(name, value);
    }

    public void setInputStream(MockServletInputStream is) {
        this.is = is;
    }
}

