/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.SSLTrustAllManager;

public class OCSPTrustManager
implements X509TrustManager {
    private IOCSPValidator ocspValidator;
    private X509TrustManager tm;
    private X509Certificate[] chain;
    private boolean trustAll;

    public X509Certificate[] getPeerCertificates() {
        return this.chain;
    }

    public OCSPTrustManager(X509TrustManager tm, IOCSPValidator ocspValidator) {
        this.tm = tm;
        this.ocspValidator = ocspValidator;
        this.trustAll = tm instanceof SSLTrustAllManager;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.chain = chain;
        this.tm.checkServerTrusted(chain, authType);
        if (chain != null && chain.length > 0) {
            if (this.trustAll && this.ocspValidator.getTrustStore() == null) {
                try {
                    KeyStore ks = KeyStore.getInstance(KeystoreType.JKS.getNome());
                    ks.load(null, null);
                    org.openspcoop2.utils.certificate.KeyStore trustStore = new org.openspcoop2.utils.certificate.KeyStore(ks);
                    int index = 0;
                    for (X509Certificate x509Certificate : chain) {
                        trustStore.putCertificate("cert-" + index, x509Certificate, false);
                        ++index;
                    }
                    this.ocspValidator.setTrustStore(trustStore);
                }
                catch (Throwable t) {
                    throw new CertificateException(t.getMessage(), t);
                }
            }
            try {
                this.ocspValidator.valid(chain[0]);
            }
            catch (Throwable t) {
                throw new CertificateException(t.getMessage(), t);
            }
        }
    }

    public static TrustManager[] wrap(TrustManager[] tmArray, IOCSPValidator ocspValidator) {
        if (tmArray != null && tmArray.length > 0) {
            for (int i = 0; i < tmArray.length; ++i) {
                TrustManager tm = tmArray[i];
                if (tm == null || !(tm instanceof X509TrustManager)) continue;
                TrustManager[] cloned = new TrustManager[tmArray.length];
                for (int j = 0; j < tmArray.length; ++j) {
                    cloned[j] = j == i ? new OCSPTrustManager((X509TrustManager)tm, ocspValidator) : tmArray[j];
                }
                return cloned;
            }
        }
        return tmArray;
    }

    public static OCSPTrustManager read(TrustManager[] tmArray) {
        if (tmArray != null && tmArray.length > 0) {
            for (int i = 0; i < tmArray.length; ++i) {
                TrustManager tm = tmArray[i];
                if (tm == null || !(tm instanceof OCSPTrustManager)) continue;
                return (OCSPTrustManager)tm;
            }
        }
        return null;
    }
}

