/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http.credential;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Properties;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.slf4j.Logger;

public class IdentityHttpReader
implements IPrincipalReader {
    private transient Logger log = null;
    private static final long serialVersionUID = 1L;
    public static final String HEADER_NAME = "header";
    private String headerName = "GovWay-Console-Principal";

    public IdentityHttpReader(Logger log) {
        this.log = log;
        this.log.debug("IdentityHttpReader inizializzato.");
    }

    @Override
    public void init(Object ... parametri) throws PrincipalReaderException {
        Properties prop;
        String v;
        Object pObject;
        if (parametri != null && parametri.length > 0 && (pObject = parametri[0]) instanceof Properties && (v = (prop = (Properties)pObject).getProperty(HEADER_NAME)) != null && !"".equals(v.trim())) {
            this.headerName = v;
        }
    }

    @Override
    public String getPrincipal(HttpServletRequest request) throws PrincipalReaderException {
        this.log.debug("Estrazione principal in corso...");
        try {
            String username = request.getHeader(this.headerName);
            this.log.debug("Username trovato nell'header [{}]: [{}]", (Object)this.headerName, (Object)username);
            return username;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del principal: " + e.getMessage(), (Throwable)e);
            throw new PrincipalReaderException(e);
        }
    }
}

