/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public class ContentTypeTest {
    public static void main(String[] args) throws UtilsException {
        System.out.println("=== ContentTypeUtilities Test ===\n");
        System.out.println("Verifica equals");
        ContentTypeTest.testEqualsString();
        ContentTypeTest.testEqualsList();
        System.out.println("\nVerifica validateContentType");
        ContentTypeTest.testValidateContentType();
        System.out.println("\nVerifica readBaseTypeFromContentType");
        ContentTypeTest.testReadBaseType();
        System.out.println("\nVerifica readPrimaryTypeFromContentType");
        ContentTypeTest.testReadPrimaryType();
        System.out.println("\nVerifica readSubTypeFromContentType");
        ContentTypeTest.testReadSubType();
        System.out.println("\nVerifica readCharsetFromContentType");
        ContentTypeTest.testReadCharset();
        System.out.println("\nVerifica normalizeToRfc7230");
        ContentTypeTest.testNormalizeToRfc7230();
        System.out.println("\nVerifica buildContentType");
        ContentTypeTest.testBuildContentType();
        System.out.println("\nVerifica isMultipart*");
        ContentTypeTest.testIsMultipart();
        System.out.println("\nVerifica readMultipartBoundaryFromContentType");
        ContentTypeTest.testReadMultipartBoundary();
        System.out.println("\nVerifica isMatch");
        ContentTypeTest.testIsMatch();
        System.out.println("\n=== Tutti i test sono passati ===");
    }

    public static void testEqualsString() throws UtilsException {
        System.out.println("--- Test equals(String, String) ---\n");
        ContentTypeTest.assertEqualsTrue("application/json", "application/json", "Content-Type identici senza parametri");
        ContentTypeTest.assertEqualsFalse("application/json", "application/xml", "Content-Type diversi senza parametri");
        ContentTypeTest.assertEqualsFalse("application/json", "text/json", "Content-Type con stesso subtype ma type diverso");
        ContentTypeTest.assertEqualsTrue("application/json", "APPLICATION/JSON", "Content-Type case insensitive");
        ContentTypeTest.assertEqualsTrue("Application/Json", "application/json", "Content-Type mixed case");
        ContentTypeTest.assertEqualsTrue("application/json;charset=UTF-8", "application/json; charset=UTF-8", "Spazio dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json; charset=UTF-8", "application/json;charset=UTF-8", "Spazio dopo punto e virgola (invertito)");
        ContentTypeTest.assertEqualsTrue("application/json ; charset=UTF-8", "application/json;charset=UTF-8", "Spazio prima del punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json ; charset=UTF-8", "application/json;  charset=UTF-8", "Spazi multipli dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json  ;  charset=UTF-8", "application/json;charset=UTF-8", "Spazi multipli prima e dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json;\tcharset=UTF-8", "application/json;charset=UTF-8", "Tab dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json\t;\tcharset=UTF-8", "application/json;charset=UTF-8", "Tab prima e dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json\t\t;\t\tcharset=UTF-8", "application/json;charset=UTF-8", "Tab multipli prima e dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json;\t charset=UTF-8", "application/json;charset=UTF-8", "Tab e spazio dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json; \tcharset=UTF-8", "application/json;charset=UTF-8", "Spazio e tab dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json \t;\t charset=UTF-8", "application/json;charset=UTF-8", "Spazio-tab prima e tab-spazio dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json\t ;\t charset=UTF-8", "application/json; charset=UTF-8", "Tab-spazio prima e tab-spazio dopo punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json \t ; \t charset=UTF-8", "application/json;charset=UTF-8", "Mix spazi e tab multipli attorno al punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json; charset=UTF-8", "application/json; CHARSET=UTF-8", "Nome parametro case insensitive");
        ContentTypeTest.assertEqualsTrue("application/json; charset=utf-8", "application/json; charset=UTF-8", "Valore charset case insensitive");
        ContentTypeTest.assertEqualsTrue("application/json; charset=UTF-8; boundary=something", "application/json; charset=UTF-8; boundary=something", "Due parametri stesso ordine");
        ContentTypeTest.assertEqualsTrue("application/json;charset=UTF-8;boundary=something", "application/json; charset=UTF-8; boundary=something", "Due parametri stesso ordine con spazi differenti");
        ContentTypeTest.assertEqualsTrue("application/json; charset=UTF-8; boundary=something", "application/json; boundary=something; charset=UTF-8", "Due parametri ordine diverso");
        ContentTypeTest.assertEqualsTrue("text/xml; charset=UTF-8; action=test", "text/xml; action=test; charset=UTF-8", "Due parametri ordine diverso (xml)");
        ContentTypeTest.assertEqualsTrue("multipart/related; type=text; start=cid; boundary=abc", "multipart/related; boundary=abc; type=text; start=cid", "Tre parametri in ordine diverso");
        ContentTypeTest.assertEqualsTrue("multipart/related; type=text; start=cid; boundary=abc", "multipart/related; start=cid; boundary=abc; type=text", "Tre parametri in altro ordine diverso");
        ContentTypeTest.assertEqualsTrue("multipart/related; type=\"application/xop+xml\"; start=\"cid:root\"; boundary=abc", "multipart/related; boundary=abc; type=\"application/xop+xml\"; start=\"cid:root\"", "Tre parametri in ordine diverso con valori quotati");
        ContentTypeTest.assertEqualsTrue("application/json;\tcharset=UTF-8;\tboundary=abc", "application/json; charset=UTF-8; boundary=abc", "Due parametri con tab");
        ContentTypeTest.assertEqualsTrue("application/json\t;\tcharset=UTF-8\t;\tboundary=abc", "application/json;charset=UTF-8;boundary=abc", "Due parametri con tab prima e dopo ogni punto e virgola");
        ContentTypeTest.assertEqualsTrue("application/json; \tcharset=UTF-8;\t boundary=abc", "application/json; charset=UTF-8; boundary=abc", "Due parametri con mix spazi e tab");
        ContentTypeTest.assertEqualsTrue("text/xml\t; charset=UTF-8 ;\taction=test", "text/xml; action=test; charset=UTF-8", "Due parametri ordine diverso con mix spazi e tab");
        ContentTypeTest.assertEqualsTrue("multipart/related;\ttype=app \t;\t start=cid\t; boundary=abc", "multipart/related; boundary=abc; start=cid; type=app", "Tre parametri ordine diverso con mix spazi e tab");
        ContentTypeTest.assertEqualsTrue("text/xml; action=\"urn:test:action\"", "text/xml; action=\"urn:test:action\"", "Parametro con valore quotato");
        ContentTypeTest.assertEqualsTrue("multipart/related; type=\"application/xop+xml\"; start=\"<root>\"; boundary=\"----=_Part\"", "multipart/related; boundary=\"----=_Part\"; start=\"<root>\"; type=\"application/xop+xml\"", "Content-Type multipart con parametri in ordine diverso");
        ContentTypeTest.assertEqualsTrue("multipart/related;\ttype=\"application/xop+xml\";\tstart=\"<root>\";\tboundary=\"----=_Part\"", "multipart/related; boundary=\"----=_Part\"; start=\"<root>\"; type=\"application/xop+xml\"", "Content-Type multipart con tab e parametri in ordine diverso");
        ContentTypeTest.assertEqualsTrue("multipart/related \t;\t type=\"application/xop+xml\" \t;\t start=\"<root>\" \t;\t boundary=\"----=_Part\"", "multipart/related;boundary=\"----=_Part\";start=\"<root>\";type=\"application/xop+xml\"", "Content-Type multipart con mix spazi-tab e parametri in ordine diverso");
        ContentTypeTest.assertEqualsFalse("application/json; charset=UTF-8", "application/json; charset=ISO-8859-1", "Stesso tipo ma charset diverso");
        ContentTypeTest.assertEqualsFalse("application/json; charset=UTF-8", "application/json", "Uno con charset, l'altro senza");
        ContentTypeTest.assertEqualsFalse("application/json; charset=UTF-8; extra=value", "application/json; charset=UTF-8", "Numero diverso di parametri");
    }

    public static void testEqualsList() throws UtilsException {
        System.out.println("\n--- Test equals(List<String>, String) ---\n");
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("application/xml");
        list1.add("application/json; charset=UTF-8");
        list1.add("text/plain");
        ContentTypeTest.assertEqualsListTrue(list1, "application/json;charset=UTF-8", "Lista contiene content-type equivalente");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("application/xml");
        list2.add("text/plain");
        ContentTypeTest.assertEqualsListFalse(list2, "application/json", "Lista non contiene content-type");
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("text/xml; action=test; charset=UTF-8");
        ContentTypeTest.assertEqualsListTrue(list3, "text/xml; charset=UTF-8; action=test", "Lista con match parametri ordine diverso");
        ArrayList<String> list4 = new ArrayList<String>();
        list4.add("application/json;\tcharset=UTF-8");
        ContentTypeTest.assertEqualsListTrue(list4, "application/json; charset=UTF-8", "Lista con match e tab");
        ArrayList<String> list5 = new ArrayList<String>();
        list5.add("text/xml \t;\t action=test \t;\t charset=UTF-8");
        ContentTypeTest.assertEqualsListTrue(list5, "text/xml; charset=UTF-8; action=test", "Lista con match, mix spazi-tab e ordine parametri diverso");
        ArrayList<String> listEmpty = new ArrayList<String>();
        ContentTypeTest.assertEqualsListFalse(listEmpty, "application/json", "Lista vuota");
        ContentTypeTest.assertEqualsListFalse(null, "application/json", "Lista null");
        ArrayList<String> list6 = new ArrayList<String>();
        list6.add("application/json;charset=UTF-8");
        list6.add("application/json; charset=UTF-8");
        list6.add("APPLICATION/JSON; CHARSET=UTF-8");
        list6.add("application/json;\tcharset=UTF-8");
        list6.add("application/json \t; \tcharset=UTF-8");
        ContentTypeTest.assertEqualsListTrue(list6, "application/json; charset=UTF-8", "Lista con pi\u00f9 elementi equivalenti (spazi, tab, case)");
    }

    private static void assertEqualsTrue(String ct1, String ct2, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.equals(ct1, ct2);
        if (!result) {
            String msg = "[FAIL] " + description + "\n       '" + ct1 + "' == '" + ct2 + "' (atteso: true, ottenuto: false)";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    private static void assertEqualsFalse(String ct1, String ct2, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.equals(ct1, ct2);
        if (result) {
            String msg = "[FAIL] " + description + "\n       '" + ct1 + "' != '" + ct2 + "' (atteso: false, ottenuto: true)";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    private static void assertEqualsListTrue(List<String> list, String ct, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.equals(list, ct);
        if (!result) {
            String msg = "[FAIL] " + description + "\n       Lista: " + String.valueOf(list) + " contiene equivalente di '" + ct + "' (atteso: true, ottenuto: false)";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    private static void assertEqualsListFalse(List<String> list, String ct, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.equals(list, ct);
        if (result) {
            String msg = "[FAIL] " + description + "\n       Lista: " + String.valueOf(list) + " non contiene equivalente di '" + ct + "' (atteso: false, ottenuto: true)";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testValidateContentType() throws UtilsException {
        System.out.println("\n--- Test validateContentType ---\n");
        ContentTypeTest.assertValidContentType("application/json", "Content-Type semplice");
        ContentTypeTest.assertValidContentType("application/xml", "Content-Type XML");
        ContentTypeTest.assertValidContentType("text/plain", "Content-Type text/plain");
        ContentTypeTest.assertValidContentType("text/html", "Content-Type text/html");
        ContentTypeTest.assertValidContentType("application/json; charset=UTF-8", "Content-Type con charset");
        ContentTypeTest.assertValidContentType("application/json;charset=UTF-8", "Content-Type con charset senza spazio");
        ContentTypeTest.assertValidContentType("application/json;\tcharset=UTF-8", "Content-Type con charset e tab");
        ContentTypeTest.assertValidContentType("text/xml; charset=UTF-8; action=\"urn:test\"", "Content-Type con pi\u00f9 parametri");
        ContentTypeTest.assertValidContentType("APPLICATION/JSON", "Content-Type uppercase");
        ContentTypeTest.assertValidContentType("Application/Json", "Content-Type mixed case");
        ContentTypeTest.assertValidContentType("APPLICATION/JSON; CHARSET=UTF-8", "Content-Type e parametro uppercase");
        ContentTypeTest.assertValidContentType("multipart/related; boundary=abc", "Multipart related con boundary");
        ContentTypeTest.assertValidContentType("multipart/mixed; boundary=\"----=_Part_123\"", "Multipart mixed con boundary quotato");
        ContentTypeTest.assertValidContentType("multipart/form-data; boundary=----WebKitFormBoundary", "Multipart form-data");
        ContentTypeTest.assertValidContentType("multipart/alternative; boundary=frontier", "Multipart alternative");
        ContentTypeTest.assertValidContentType("multipart/related; type=\"application/xop+xml\"; start-info=\"text/xml\"; boundary=abc", "Multipart MTOM completo con start-info");
        ContentTypeTest.assertValidContentType("application/json ; charset=UTF-8", "Content-Type con spazio prima del ;");
        ContentTypeTest.assertValidContentType("application/json;  charset=UTF-8", "Content-Type con doppio spazio dopo ;");
        ContentTypeTest.assertValidContentType("application/json  ;  charset=UTF-8", "Content-Type con doppi spazi attorno al ;");
        ContentTypeTest.assertValidContentType("application/json\t;\tcharset=UTF-8", "Content-Type con tab attorno al ;");
        ContentTypeTest.assertValidContentType("application/json;\t\tcharset=UTF-8", "Content-Type con doppio tab dopo ;");
        ContentTypeTest.assertValidContentType("application/json\t\t;\t\tcharset=UTF-8", "Content-Type con doppi tab attorno al ;");
        ContentTypeTest.assertValidContentType("application/json \t;\t charset=UTF-8", "Content-Type con spazio-tab e tab-spazio");
        ContentTypeTest.assertValidContentType("application/json\t ;\t charset=UTF-8", "Content-Type con tab-spazio e tab-spazio");
        ContentTypeTest.assertValidContentType("application/json \t ; \t charset=UTF-8", "Content-Type con spazio-tab-spazio attorno al ;");
        ContentTypeTest.assertValidContentType("application/json\t \t;\t \tcharset=UTF-8", "Content-Type con tab-spazio-tab attorno al ;");
        ContentTypeTest.assertValidContentType("text/xml;\tcharset=UTF-8;\taction=\"test\"", "Due parametri con tab");
        ContentTypeTest.assertValidContentType("text/xml \t;\t charset=UTF-8 \t;\t action=\"test\"", "Due parametri con mix spazi-tab");
        ContentTypeTest.assertValidContentType("multipart/related; boundary=abc; type=\"text/plain\"", "Multipart con type valido");
        ContentTypeTest.assertValidContentType(null, "Content-Type null");
        ContentTypeTest.assertValidContentType("", "Content-Type vuoto");
        ContentTypeTest.assertInvalidContentType("application", "Content-Type senza subtype");
        ContentTypeTest.assertInvalidContentType("application/", "Content-Type con subtype vuoto");
        ContentTypeTest.assertInvalidContentType("/json", "Content-Type senza type");
        ContentTypeTest.assertInvalidContentType("applicationjson", "Content-Type senza /");
        ContentTypeTest.assertInvalidContentType("application/json; charset", "Parametro senza valore");
        ContentTypeTest.assertInvalidContentType("application/json; =UTF-8", "Parametro senza nome");
        ContentTypeTest.assertInvalidContentType("application//json", "Content-Type con doppio /");
        ContentTypeTest.assertInvalidContentType("text/xml; action=urn:test:action", "Valore parametro con : non quotato");
    }

    private static void assertValidContentType(String ct, String description) throws UtilsException {
        try {
            ContentTypeUtilities.validateContentType(ct);
            System.out.println("[PASS] " + description + " - valido");
        }
        catch (UtilsException e) {
            String msg = "[FAIL] " + description + "\n       Content-Type '" + ct + "' dovrebbe essere valido ma ha lanciato: " + e.getMessage();
            System.out.println(msg);
            throw new UtilsException(msg, e);
        }
    }

    private static void assertInvalidContentType(String ct, String description) throws UtilsException {
        try {
            ContentTypeUtilities.validateContentType(ct);
            String msg = "[FAIL] " + description + "\n       Content-Type '" + ct + "' dovrebbe essere invalido ma non ha lanciato eccezione";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        catch (UtilsException e) {
            System.out.println("[PASS] " + description + " - correttamente rifiutato: " + e.getMessage());
            return;
        }
    }

    public static void testReadBaseType() throws UtilsException {
        System.out.println("--- Test readBaseTypeFromContentType ---\n");
        ContentTypeTest.assertBaseType("application/json", "application/json", "Content-Type semplice");
        ContentTypeTest.assertBaseType("application/json; charset=UTF-8", "application/json", "Content-Type con parametro");
        ContentTypeTest.assertBaseType("application/json;\tcharset=UTF-8", "application/json", "Content-Type con tab");
        ContentTypeTest.assertBaseType("application/json \t; \t charset=UTF-8", "application/json", "Content-Type con mix spazi-tab");
        ContentTypeTest.assertBaseType("APPLICATION/JSON", "APPLICATION/JSON", "Content-Type uppercase");
        ContentTypeTest.assertBaseType("text/xml; charset=UTF-8; action=\"test\"", "text/xml", "Content-Type con pi\u00f9 parametri");
        ContentTypeTest.assertBaseType("multipart/related; boundary=abc", "multipart/related", "Multipart");
    }

    private static void assertBaseType(String ct, String expected, String description) throws UtilsException {
        String result = ContentTypeUtilities.readBaseTypeFromContentType(ct);
        if (!expected.equalsIgnoreCase(result)) {
            String msg = "[FAIL] " + description + "\n       Input: '" + ct + "' - Atteso: '" + expected + "', Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testReadPrimaryType() throws UtilsException {
        System.out.println("--- Test readPrimaryTypeFromContentType ---\n");
        ContentTypeTest.assertPrimaryType("application/json", "application", "Content-Type application");
        ContentTypeTest.assertPrimaryType("text/plain", "text", "Content-Type text");
        ContentTypeTest.assertPrimaryType("multipart/related", "multipart", "Content-Type multipart");
        ContentTypeTest.assertPrimaryType("image/png", "image", "Content-Type image");
        ContentTypeTest.assertPrimaryType("application/json; charset=UTF-8", "application", "Content-Type con parametro");
        ContentTypeTest.assertPrimaryType("APPLICATION/JSON", "APPLICATION", "Content-Type uppercase");
    }

    private static void assertPrimaryType(String ct, String expected, String description) throws UtilsException {
        String result = ContentTypeUtilities.readPrimaryTypeFromContentType(ct);
        if (!expected.equalsIgnoreCase(result)) {
            String msg = "[FAIL] " + description + "\n       Input: '" + ct + "' - Atteso: '" + expected + "', Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testReadSubType() throws UtilsException {
        System.out.println("--- Test readSubTypeFromContentType ---\n");
        ContentTypeTest.assertSubType("application/json", "json", "Content-Type json");
        ContentTypeTest.assertSubType("text/plain", "plain", "Content-Type plain");
        ContentTypeTest.assertSubType("multipart/related", "related", "Content-Type related");
        ContentTypeTest.assertSubType("application/xop+xml", "xop+xml", "Content-Type con +");
        ContentTypeTest.assertSubType("application/json; charset=UTF-8", "json", "Content-Type con parametro");
        ContentTypeTest.assertSubType("APPLICATION/JSON", "JSON", "Content-Type uppercase");
    }

    private static void assertSubType(String ct, String expected, String description) throws UtilsException {
        String result = ContentTypeUtilities.readSubTypeFromContentType(ct);
        if (!expected.equalsIgnoreCase(result)) {
            String msg = "[FAIL] " + description + "\n       Input: '" + ct + "' - Atteso: '" + expected + "', Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testReadCharset() throws UtilsException {
        System.out.println("--- Test readCharsetFromContentType ---\n");
        ContentTypeTest.assertCharset("application/json; charset=UTF-8", "UTF-8", "Charset UTF-8");
        ContentTypeTest.assertCharset("application/json; charset=ISO-8859-1", "ISO-8859-1", "Charset ISO-8859-1");
        ContentTypeTest.assertCharset("application/json;charset=UTF-8", "UTF-8", "Charset senza spazio");
        ContentTypeTest.assertCharset("application/json;\tcharset=UTF-8", "UTF-8", "Charset con tab");
        ContentTypeTest.assertCharset("application/json; CHARSET=UTF-8", "UTF-8", "Charset uppercase");
        ContentTypeTest.assertCharset("text/xml; charset=UTF-8; action=\"test\"", "UTF-8", "Charset con altri parametri");
        ContentTypeTest.assertCharset("application/json", null, "Senza charset");
        ContentTypeTest.assertCharset("application/json; boundary=abc", null, "Con altro parametro ma senza charset");
    }

    private static void assertCharset(String ct, String expected, String description) throws UtilsException {
        boolean match;
        String result = ContentTypeUtilities.readCharsetFromContentType(ct);
        boolean bl = match = expected == null && result == null || expected != null && expected.equalsIgnoreCase(result);
        if (!match) {
            String msg = "[FAIL] " + description + "\n       Input: '" + ct + "' - Atteso: '" + expected + "', Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testNormalizeToRfc7230() throws UtilsException {
        System.out.println("--- Test normalizeToRfc7230 ---\n");
        ContentTypeTest.assertNormalize("application/json;\tcharset=UTF-8", "application/json; charset=UTF-8", "Tab singolo");
        ContentTypeTest.assertNormalize("application/json;\t\tcharset=UTF-8", "application/json;  charset=UTF-8", "Tab doppio");
        ContentTypeTest.assertNormalize("application/json\t;\tcharset=UTF-8", "application/json ; charset=UTF-8", "Tab attorno al ;");
        ContentTypeTest.assertNormalize("application/json;\r\ncharset=UTF-8", "application/json; charset=UTF-8", "CRLF");
        ContentTypeTest.assertNormalize("application/json;\ncharset=UTF-8", "application/json; charset=UTF-8", "LF");
        ContentTypeTest.assertNormalize("application/json;\rcharset=UTF-8", "application/json; charset=UTF-8", "CR");
        ContentTypeTest.assertNormalize("application/json\t;\r\n\tcharset=UTF-8", "application/json ;  charset=UTF-8", "Mix tab e CRLF");
        ContentTypeTest.assertNormalize("  application/json  ", "application/json", "Trim spazi");
        ContentTypeTest.assertNormalize("\tapplication/json\t", "application/json", "Trim tab");
    }

    private static void assertNormalize(String input, String expected, String description) throws UtilsException {
        String result = ContentTypeUtilities.normalizeToRfc7230(input);
        if (!expected.equals(result)) {
            String msg = "[FAIL] " + description + "\n       Input: '" + ContentTypeTest.escape(input) + "' - Atteso: '" + ContentTypeTest.escape(expected) + "', Ottenuto: '" + ContentTypeTest.escape(result) + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    private static String escape(String s) {
        return s.replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n");
    }

    public static void testBuildContentType() throws UtilsException {
        System.out.println("--- Test buildContentType ---\n");
        ContentTypeTest.assertBuildContentType("application/json", null, "application/json", "Senza parametri");
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("charset", "UTF-8");
        ContentTypeTest.assertBuildContentType("application/json", params1, "application/json; charset=UTF-8", "Con charset");
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("charset", "UTF-8");
        params2.put("boundary", "abc");
        String result = ContentTypeUtilities.buildContentType("multipart/related", params2);
        if (!(result.contains("charset=UTF-8") && result.contains("boundary=abc") && result.startsWith("multipart/related"))) {
            String msg = "[FAIL] Con pi\u00f9 parametri\n       Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] Con pi\u00f9 parametri");
        ContentTypeTest.assertBuildContentType("text/plain", new HashMap<String, String>(), "text/plain", "Con mappa vuota");
    }

    private static void assertBuildContentType(String baseType, Map<String, String> params, String expected, String description) throws UtilsException {
        String result = ContentTypeUtilities.buildContentType(baseType, params);
        if (!expected.equals(result)) {
            String msg = "[FAIL] " + description + "\n       Atteso: '" + expected + "', Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testIsMultipart() throws UtilsException {
        System.out.println("--- Test isMultipart* ---\n");
        ContentTypeTest.assertIsMultipartType("multipart/related; boundary=abc", true, "multipart/related");
        ContentTypeTest.assertIsMultipartType("multipart/mixed; boundary=abc", true, "multipart/mixed");
        ContentTypeTest.assertIsMultipartType("multipart/form-data; boundary=abc", true, "multipart/form-data");
        ContentTypeTest.assertIsMultipartType("multipart/alternative; boundary=abc", true, "multipart/alternative");
        ContentTypeTest.assertIsMultipartType("application/json", false, "application/json");
        ContentTypeTest.assertIsMultipartType("text/plain", false, "text/plain");
        ContentTypeTest.assertIsMultipartRelated("multipart/related; boundary=abc", true, "multipart/related");
        ContentTypeTest.assertIsMultipartRelated("multipart/mixed; boundary=abc", false, "multipart/mixed non \u00e8 related");
        ContentTypeTest.assertIsMultipartRelated("MULTIPART/RELATED; boundary=abc", true, "multipart/related uppercase");
        ContentTypeTest.assertIsMultipartMixed("multipart/mixed; boundary=abc", true, "multipart/mixed");
        ContentTypeTest.assertIsMultipartMixed("multipart/related; boundary=abc", false, "multipart/related non \u00e8 mixed");
        ContentTypeTest.assertIsMultipartFormData("multipart/form-data; boundary=abc", true, "multipart/form-data");
        ContentTypeTest.assertIsMultipartFormData("multipart/related; boundary=abc", false, "multipart/related non \u00e8 form-data");
        ContentTypeTest.assertIsMultipartAlternative("multipart/alternative; boundary=abc", true, "multipart/alternative");
        ContentTypeTest.assertIsMultipartAlternative("multipart/related; boundary=abc", false, "multipart/related non \u00e8 alternative");
        ContentTypeTest.assertIsMultipartContentType("multipart/anything; boundary=abc", true, "multipart/anything");
        ContentTypeTest.assertIsMultipartContentType("application/json", false, "application/json");
    }

    private static void assertIsMultipartType(String ct, boolean expected, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMultipartType(ct);
        if (result != expected) {
            String msg = "[FAIL] isMultipartType: " + description + "\n       Input: '" + ct + "' - Atteso: " + expected + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] isMultipartType: " + description);
    }

    private static void assertIsMultipartRelated(String ct, boolean expected, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMultipartRelated(ct);
        if (result != expected) {
            String msg = "[FAIL] isMultipartRelated: " + description + "\n       Input: '" + ct + "' - Atteso: " + expected + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] isMultipartRelated: " + description);
    }

    private static void assertIsMultipartMixed(String ct, boolean expected, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMultipartMixed(ct);
        if (result != expected) {
            String msg = "[FAIL] isMultipartMixed: " + description + "\n       Input: '" + ct + "' - Atteso: " + expected + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] isMultipartMixed: " + description);
    }

    private static void assertIsMultipartFormData(String ct, boolean expected, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMultipartFormData(ct);
        if (result != expected) {
            String msg = "[FAIL] isMultipartFormData: " + description + "\n       Input: '" + ct + "' - Atteso: " + expected + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] isMultipartFormData: " + description);
    }

    private static void assertIsMultipartAlternative(String ct, boolean expected, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMultipartAlternative(ct);
        if (result != expected) {
            String msg = "[FAIL] isMultipartAlternative: " + description + "\n       Input: '" + ct + "' - Atteso: " + expected + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] isMultipartAlternative: " + description);
    }

    private static void assertIsMultipartContentType(String ct, boolean expected, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMultipartContentType(ct);
        if (result != expected) {
            String msg = "[FAIL] isMultipartContentType: " + description + "\n       Input: '" + ct + "' - Atteso: " + expected + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] isMultipartContentType: " + description);
    }

    public static void testReadMultipartBoundary() throws UtilsException {
        System.out.println("--- Test readMultipartBoundaryFromContentType ---\n");
        ContentTypeTest.assertMultipartBoundary("multipart/related; boundary=abc", "abc", "Boundary semplice");
        ContentTypeTest.assertMultipartBoundary("multipart/related; boundary=\"----=_Part_123\"", "----=_Part_123", "Boundary quotato");
        ContentTypeTest.assertMultipartBoundary("multipart/related; type=\"text/xml\"; boundary=xyz", "xyz", "Boundary con altri parametri");
        ContentTypeTest.assertMultipartBoundary("multipart/related; BOUNDARY=abc", "abc", "Boundary uppercase");
        ContentTypeTest.assertMultipartBoundary("multipart/related; boundary=abc123-_.", "abc123-_.", "Boundary con caratteri speciali");
        ContentTypeTest.assertMultipartBoundary("application/json", null, "Content-Type senza boundary");
        ContentTypeTest.assertMultipartBoundary("multipart/related", null, "Multipart senza boundary");
    }

    private static void assertMultipartBoundary(String ct, String expected, String description) throws UtilsException {
        boolean match;
        String result = ContentTypeUtilities.readMultipartBoundaryFromContentType(ct);
        boolean bl = match = expected == null && result == null || expected != null && expected.equals(result);
        if (!match) {
            String msg = "[FAIL] " + description + "\n       Input: '" + ct + "' - Atteso: '" + expected + "', Ottenuto: '" + result + "'";
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    public static void testIsMatch() throws UtilsException {
        System.out.println("--- Test isMatch ---\n");
        ContentTypeTest.assertIsMatch("application/json", "application/json", true, "Match esatto");
        ContentTypeTest.assertIsMatch("application/json; charset=UTF-8", "application/json", true, "Match base type con parametri");
        ContentTypeTest.assertIsMatch("application/json", "application/*", true, "Wildcard subtype");
        ContentTypeTest.assertIsMatch("application/json", "*/*", true, "Wildcard completo");
        ContentTypeTest.assertIsMatch("application/soap+xml", "application/*+xml", true, "Wildcard con suffisso +xml");
        ContentTypeTest.assertIsMatch("text/plain", "application/*", false, "Wildcard subtype non match");
        ContentTypeTest.assertIsMatch("APPLICATION/JSON", "application/json", true, "Case insensitive");
        ContentTypeTest.assertIsMatch("application/json", "APPLICATION/JSON", true, "Case insensitive inverso");
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("application/xml");
        list1.add("application/json");
        ContentTypeTest.assertIsMatchList("application/json", list1, true, "Match in lista");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("application/xml");
        list2.add("text/plain");
        ContentTypeTest.assertIsMatchList("application/json", list2, false, "No match in lista");
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("text/*");
        list3.add("application/json");
        ContentTypeTest.assertIsMatchList("text/html", list3, true, "Match wildcard in lista");
        ArrayList<String> list4 = new ArrayList<String>();
        list4.add("empty");
        ContentTypeTest.assertIsMatchList(null, list4, true, "Match empty con null");
        ContentTypeTest.assertIsMatchList("", list4, true, "Match empty con stringa vuota");
        ContentTypeTest.assertIsMatchList("application/json", new ArrayList<String>(), true, "Lista vuota sempre true");
        ContentTypeTest.assertIsMatchList("application/json", null, true, "Lista null sempre true");
    }

    private static void assertIsMatch(String contentType, String expected, boolean expectedResult, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMatch(null, contentType, expected);
        if (result != expectedResult) {
            String msg = "[FAIL] " + description + "\n       ContentType: '" + contentType + "', Expected: '" + expected + "' - Atteso: " + expectedResult + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }

    private static void assertIsMatchList(String contentType, List<String> expectedList, boolean expectedResult, String description) throws UtilsException {
        boolean result = ContentTypeUtilities.isMatch(null, contentType, expectedList);
        if (result != expectedResult) {
            String msg = "[FAIL] " + description + "\n       ContentType: '" + contentType + "', Lista: " + String.valueOf(expectedList) + " - Atteso: " + expectedResult + ", Ottenuto: " + result;
            System.out.println(msg);
            throw new UtilsException(msg);
        }
        System.out.println("[PASS] " + description);
    }
}

