/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http.test;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpFilterChain;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.bouncycastle.util.encoders.Base64;
import org.openspcoop2.utils.Utilities;

public class HttpServerTest
implements Closeable {
    private static final String LOCALHOST = "localhost";
    private final HttpServer server;
    private final String username;
    private final String password;
    private final boolean httpsEnabled;

    public HttpServerTest() throws IOException {
        this(null);
    }

    public HttpServerTest(SSLContext ctx) throws IOException {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofSeconds((long)15L)).setTcpNoDelay(true).setSoReuseAddress(true).build();
        this.username = new Random().ints(10L, 97, 122).mapToObj(v -> String.valueOf((char)v)).collect(Collectors.joining());
        this.password = new Random().ints(10L, 97, 122).mapToObj(v -> String.valueOf((char)v)).collect(Collectors.joining());
        ServerBootstrap serverBuilder = ServerBootstrap.bootstrap().setListenerPort(-1).setSocketConfig(socketConfig).addFilterFirst("auth", this::handleAuth).register(LOCALHOST, "/headers", this::handleTestHeaders).register(LOCALHOST, "/redirect", this::handleTestRedirect).register(LOCALHOST, "/readTimeout", this::handleTestReadTimeout).register(LOCALHOST, "/connectTimeout", this::handleTestHeaders).register(LOCALHOST, "/params", this::handleTestParams).register(LOCALHOST, "/methods/*", this::handleTestMethods).register(LOCALHOST, "/proxy", this::handleTestProxy).register(LOCALHOST, "/throttling", this::handleTestThrottling).register(LOCALHOST, "/print", this::printRequest);
        if (ctx != null) {
            serverBuilder.setSslContext(ctx).setSslSetupHandler(params -> params.setWantClientAuth(true));
        }
        this.httpsEnabled = ctx != null;
        this.server = serverBuilder.create();
        this.server.start();
    }

    @Override
    public void close() {
        this.server.stop();
        this.server.close(CloseMode.GRACEFUL);
        this.server.initiateShutdown();
        try {
            this.server.awaitTermination(TimeValue.MAX_VALUE);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    public String getUrl() {
        return "http://127.0.0.1:" + this.getPort();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void handleTestMethods(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        String[] segments = req.getRequestUri().split("/");
        String responseContent = segments[segments.length - 1].toLowerCase();
        if (req.getMethod().toLowerCase().equals(responseContent)) {
            StringEntity out = new StringEntity(responseContent);
            res.setEntity((HttpEntity)out);
            res.setCode(200);
        } else {
            res.setCode(400);
        }
        res.close();
    }

    public void handleAuth(ClassicHttpRequest req, HttpFilterChain.ResponseTrigger trigger, HttpContext ctx, HttpFilterChain chain) throws HttpException, IOException {
        Header auth = req.getHeader("Authorization");
        String rawCredential = auth.getValue().replace("Basic ", "");
        String[] credential = new String(Base64.decode((String)rawCredential)).split(":");
        String usernameReq = credential[0];
        String passwordReq = credential[1];
        if (usernameReq.equals(this.getUsername()) && passwordReq.equals(this.getPassword())) {
            chain.proceed(req, trigger, ctx);
        } else {
            trigger.sendInformation((ClassicHttpResponse)new BasicClassicHttpResponse(401));
        }
    }

    public void handleTestHeaders(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        StringEntity out = new StringEntity("out");
        res.setEntity((HttpEntity)out);
        res.setCode(200);
        for (Header hdr : req.getHeaders()) {
            if (!hdr.getName().startsWith("testsuite-") && !hdr.getName().equals("Transfer-Encoding")) continue;
            res.setHeader("out-" + hdr.getName(), (Object)hdr.getValue());
        }
        res.close();
    }

    public void handleTestReadTimeout(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        try {
            Utilities.sleep(Integer.valueOf(req.getHeader("sleep").getValue()).intValue());
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        StringEntity out = new StringEntity("out");
        res.setEntity((HttpEntity)out);
        res.setCode(200);
        res.close();
    }

    public void handleTestRedirect(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(req.getUri());
            Map<String, String> params = uriBuilder.getQueryParams().stream().collect(Collectors.toMap(e -> e.getName(), e -> e.getValue()));
            Integer hop = Integer.valueOf(Objects.requireNonNullElse(params.get("hop"), "0"));
            Integer maxHop = Integer.valueOf(Objects.requireNonNullElse(params.get("maxHop"), "-1"));
            String redirectType = params.get("redirectType");
            if (hop.equals(maxHop)) {
                res.setEntity((HttpEntity)new StringEntity(hop.toString()));
                res.setCode(200);
            } else {
                uriBuilder.setParameter("hop", String.valueOf(hop + 1));
                res.setEntity(null);
                res.setHeader((Header)new BasicHeader("Location", (Object)uriBuilder.build()));
                res.setCode(Integer.valueOf(redirectType).intValue());
            }
        }
        catch (URISyntaxException e2) {
            throw new IOException(e2);
        }
        res.close();
    }

    public void handleTestParams(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        StringEntity out = new StringEntity("out");
        res.setEntity((HttpEntity)out);
        res.setCode(200);
        try {
            String[] query;
            for (String param : query = req.getUri().getQuery().split("&")) {
                String[] entry = param.split("=");
                if (entry.length != 2 || !entry[0].startsWith("testsuite-")) continue;
                res.setHeader((Header)new BasicHeader(entry[0], (Object)entry[1]));
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        res.close();
    }

    public void handleTestProxy(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        try {
            Header proxied = req.getHeader("Proxied");
            if (proxied != null && proxied.getValue() != null && proxied.getValue().equals("true")) {
                StringEntity out = new StringEntity("proxied");
                res.setEntity((HttpEntity)out);
                res.setCode(200);
                res.close();
            } else {
                StringEntity out = new StringEntity("no proxy header present");
                res.setEntity((HttpEntity)out);
                res.setCode(400);
                res.close();
            }
        }
        catch (ProtocolException e) {
            throw new IOException(e);
        }
    }

    public void handleTestThrottling(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        try {
            Header transferEncoding = req.getHeader("Transfer-Encoding");
            if (transferEncoding != null && !transferEncoding.getValue().equals("chunked")) {
                throw new IOException("Errore, il transfer encoding dovrebbe esssere di tipo chunked per i throttled stream");
            }
            try (InputStream is = req.getEntity().getContent();){
                is.readAllBytes();
            }
            StringEntity entity = new StringEntity("");
            res.setCode(200);
            res.setEntity((HttpEntity)entity);
            res.close();
        }
        catch (ProtocolException e) {
            throw new IOException(e);
        }
    }

    public void printRequest(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        if (this.httpsEnabled) {
            HttpCoreContext core = HttpCoreContext.cast((HttpContext)ctx);
            SSLSession ssl = core.getSSLSession();
            try {
                ssl.getPeerPrincipal();
                res.addHeader("verified", (Object)true);
            }
            catch (SSLPeerUnverifiedException e) {
                res.addHeader("verified", (Object)false);
            }
        }
        StringEntity out = new StringEntity("blah");
        res.setEntity((HttpEntity)out);
        res.setCode(200);
        res.close();
    }
}

