/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.net.URIBuilder;
import org.bouncycastle.util.Arrays;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.test.HttpProxyTest;
import org.openspcoop2.utils.transport.http.test.HttpServerTest;

public class HttpTest {
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServers() throws IOException {
        Class<HttpTest> clazz = HttpTest.class;
        synchronized (HttpTest.class) {
            if (Holder.server != null) {
                Holder.server.close();
                Holder.proxy.close();
            }
            Holder.server = new HttpServerTest();
            Holder.proxy = new HttpProxyTest(Holder.server);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServers() {
        Class<HttpTest> clazz = HttpTest.class;
        synchronized (HttpTest.class) {
            if (Holder.server != null) {
                Holder.server.close();
                Holder.proxy.close();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws IOException, UtilsException, URISyntaxException {
        HttpTest test = new HttpTest();
        try {
            Object[][] params;
            HttpTest.startServers();
            test.testFile(HttpLibrary.HTTP_CORE5);
            test.testFile(HttpLibrary.HTTP_URL_CONNECTION);
            for (Object[] param : params = test.methodsHttpDataProvider()) {
                test.check((HttpRequest)param[0], (HttpResponse)param[1]);
            }
            for (Object[] param : params = test.headersHttpDataProvider()) {
                test.check((HttpRequest)param[0], (HttpResponse)param[1]);
            }
            for (Object[] param : params = test.paramsHttpDataProvider()) {
                test.check((HttpRequest)param[0], (HttpResponse)param[1]);
            }
            test.testReadTimeout(HttpLibrary.HTTP_CORE5);
            test.testReadTimeout(HttpLibrary.HTTP_URL_CONNECTION);
            test.testRedirect(HttpLibrary.HTTP_URL_CONNECTION, 307);
            test.testRedirect(HttpLibrary.HTTP_CORE5, 307);
            test.testRedirect(HttpLibrary.HTTP_URL_CONNECTION, 301);
            test.testRedirect(HttpLibrary.HTTP_CORE5, 301);
            test.testHttpProxy(HttpLibrary.HTTP_URL_CONNECTION);
            test.testHttpProxy(HttpLibrary.HTTP_CORE5);
            test.testThrottling(HttpLibrary.HTTP_URL_CONNECTION, 100, 100);
            test.testThrottling(HttpLibrary.HTTP_CORE5, 100, 100);
        }
        finally {
            HttpTest.stopServers();
        }
    }

    private String createServerEndpoint(String path) {
        return String.format("http://localhost:%d%s", Holder.server.getPort(), path);
    }

    protected HttpRequest createBaseRequest(HttpLibrary library) {
        HttpRequest req = new HttpRequest();
        req.setHttpLibrary(library);
        req.setUrl(this.createServerEndpoint("/print"));
        req.addHeader("User-Agent", "Java");
        req.addHeader("Accept-Encoding", "gzip, x-gzip, deflate");
        req.addHeader("Accept", "*/*");
        req.addHeader("Host", "localhost:" + Holder.server.getPort());
        req.setUsername(Holder.server.getUsername());
        req.setPassword(Holder.server.getPassword());
        req.setMethod(HttpRequestMethod.GET);
        return req;
    }

    public void testFile(HttpLibrary library) throws IOException, UtilsException {
        HttpRequest req = this.createBaseRequest(library);
        Path path = Files.createTempFile("test_http_utils", "_temp_file", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-rw-rw-")));
        File file = path.toFile();
        String testContent = "contenuto di prova";
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(testContent.getBytes());
        }
        req.setUrl(path.toUri().toString());
        HttpResponse res = HttpUtilities.httpInvoke(req);
        if (!testContent.equals(new String(res.getContent()))) {
            throw new UtilsException("not expected response");
        }
    }

    public Object[][] methodsHttpDataProvider() {
        HttpLibrary[] httpLibraries = new HttpLibrary[]{HttpLibrary.HTTP_CORE5, HttpLibrary.HTTP_URL_CONNECTION};
        Object[][] configs = new Object[][]{{HttpRequestMethod.GET, null, "get"}, {HttpRequestMethod.POST, null, "post"}, {HttpRequestMethod.DELETE, null, "delete"}, {HttpRequestMethod.PUT, null, "put"}};
        Object[][] data = new Object[httpLibraries.length * configs.length][];
        int i = 0;
        for (HttpLibrary lib : httpLibraries) {
            for (Object[] conf : configs) {
                HttpRequest req = this.createBaseRequest(lib);
                req.setMethod((HttpRequestMethod)conf[0]);
                req.setUrl(this.createServerEndpoint("/methods/" + req.getMethod().toString()));
                if (conf[1] != null) {
                    req.setContent(((String)conf[1]).getBytes());
                }
                HttpResponse res = new HttpResponse();
                res.setResultHTTPOperation(200);
                if (conf[2] != null) {
                    res.setContent(((String)conf[2]).getBytes());
                }
                data[i] = new Object[]{req, res};
                ++i;
            }
        }
        return data;
    }

    public Object[][] headersHttpDataProvider() {
        HttpLibrary[] httpLibraries = new HttpLibrary[]{HttpLibrary.HTTP_CORE5, HttpLibrary.HTTP_URL_CONNECTION};
        List<Map<String, String>> headers = List.of(Map.of("testsuite-hdr1", "val1"), Map.of("testsuite-hdr2", "val1,val2,val3"));
        Object[][] data = new Object[httpLibraries.length * (headers.size() + 1)][];
        int i = 0;
        for (HttpLibrary lib : httpLibraries) {
            for (Map<String, String> header : headers) {
                HttpRequest req = this.createBaseRequest(lib);
                req.setMethod(HttpRequestMethod.POST);
                req.setUrl(this.createServerEndpoint("/headers"));
                req.setContent("".getBytes());
                req.setContentType("text/plain");
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    req.addHeader(entry.getKey(), entry.getValue());
                }
                HttpResponse res = new HttpResponse();
                res.setResultHTTPOperation(200);
                res.setContent("out".getBytes());
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    res.addHeader("out-" + entry.getKey(), entry.getValue());
                }
                data[i++] = new Object[]{req, res};
            }
            HttpRequest req = this.createBaseRequest(lib);
            req.setMethod(HttpRequestMethod.POST);
            req.setUrl(this.createServerEndpoint("/headers"));
            req.setContent("in".getBytes());
            req.setContentType("text/plain");
            req.setForceTransferEncodingChunked(true);
            HttpResponse res = new HttpResponse();
            res.setResultHTTPOperation(200);
            res.setContent("out".getBytes());
            res.addHeader("out-Transfer-Encoding", "chunked");
            data[i++] = new Object[]{req, res};
        }
        return data;
    }

    public Object[][] paramsHttpDataProvider() {
        HttpLibrary[] httpLibraries = new HttpLibrary[]{HttpLibrary.HTTP_CORE5, HttpLibrary.HTTP_URL_CONNECTION};
        List<Map<String, String>> params = List.of(Map.of("testsuite-param1", "val1"), Map.of("testsuite-param2", "val1,val2,val3"));
        Object[][] data = new Object[httpLibraries.length * params.size()][];
        int i = 0;
        for (HttpLibrary lib : httpLibraries) {
            for (Map<String, String> param : params) {
                HttpRequest req = this.createBaseRequest(lib);
                req.setMethod(HttpRequestMethod.GET);
                req.setUrl(this.createServerEndpoint("/params"));
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    req.addParam(entry.getKey(), entry.getValue());
                }
                HttpResponse res = new HttpResponse();
                res.setResultHTTPOperation(200);
                res.setContent("out".getBytes());
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    res.addHeader(entry.getKey(), entry.getValue());
                }
                data[i] = new Object[]{req, res};
                ++i;
            }
        }
        return data;
    }

    public void testReadTimeout(HttpLibrary lib) throws UtilsException {
        block2: {
            HttpRequest req = this.createBaseRequest(lib);
            req.setUrl(this.createServerEndpoint("/readTimeout"));
            req.addHeader("sleep", "100");
            req.setReadTimeout(1000);
            HttpResponse res = new HttpResponse();
            res.setContent("out".getBytes());
            res.setResultHTTPOperation(200);
            this.check(req, res);
            req = this.createBaseRequest(lib);
            req.setUrl(this.createServerEndpoint("/readTimeout"));
            req.addHeader("sleep", "1000");
            req.setReadTimeout(1000);
            res = new HttpResponse();
            res.setContent("out".getBytes());
            res.setResultHTTPOperation(200);
            try {
                this.check(req, res);
            }
            catch (UtilsException e) {
                if (e.getCause() instanceof SocketTimeoutException) break block2;
                throw new UtilsException("Aspettavo un eccezione di tipo: " + SocketTimeoutException.class.getCanonicalName() + ", ottenuta eccezione di tipo: " + e.getClass().getCanonicalName());
            }
        }
    }

    public void testRedirect(HttpLibrary lib, Integer redirectType) throws UtilsException, URISyntaxException {
        String REDIRECT_FORMAT = this.createServerEndpoint("/redirect?maxHop=%d&redirectType=%d");
        Integer maxHop = 10;
        HttpRequest req = this.createBaseRequest(lib);
        req.setUrl(String.format(REDIRECT_FORMAT, maxHop, redirectType));
        HttpResponse res = new HttpResponse();
        URIBuilder resUri = new URIBuilder(req.getUrl());
        res.setContent("".getBytes());
        res.setResultHTTPOperation(redirectType);
        res.addHeader("Location", resUri.setParameter("hop", "1").build().toString());
        this.check(req, res);
        req = this.createBaseRequest(lib);
        req.setUrl(String.format(REDIRECT_FORMAT, maxHop, redirectType));
        req.setFollowRedirects(true);
        res = new HttpResponse();
        res.setContent(String.valueOf(maxHop).getBytes());
        res.setResultHTTPOperation(200);
        this.check(req, res);
        req = this.createBaseRequest(lib);
        maxHop = 50;
        req.setUrl(String.format(REDIRECT_FORMAT, maxHop, redirectType));
        req.setFollowRedirects(true);
        res = new HttpResponse();
        res.setContent(String.valueOf(maxHop).getBytes());
        res.setResultHTTPOperation(200);
        try {
            this.check(req, res);
        }
        catch (UtilsException e) {
            if (e.getCause() != null && (e.getCause() instanceof ClientProtocolException || e.getCause() instanceof ProtocolException)) {
                String message = e.getCause().getMessage();
                if (!message.matches("Maximum redirects \\(\\d+\\) exceeded") && !message.matches("Server redirected too many times \\(\\d+\\)")) {
                    throw new UtilsException("Eccezione non attesa nell'esecuzione della richiesta: " + message, e);
                }
            }
            throw new UtilsException("Eccezione non attesa nell'esecuzione della richiesta: " + String.valueOf(e.getCause()), e);
        }
    }

    public void testHttpProxy(HttpLibrary httpLibrary) throws UtilsException {
        HttpRequest req = this.createBaseRequest(httpLibrary);
        req.setProxyHostname("127.0.0.1");
        req.setProxyPort(Holder.proxy.getPort());
        req.setProxyType(Proxy.Type.HTTP);
        req.setProxyUsername(Holder.proxy.getUsername());
        req.setProxyPassword(Holder.proxy.getPassword());
        HttpResponse res = new HttpResponse();
        res.setContent("proxied".getBytes());
        res.setResultHTTPOperation(200);
        this.check(req, res);
    }

    public void testThrottling(HttpLibrary httpLibrary, int throttlingSize, int throttlingMs) throws UtilsException {
        HttpRequest req = this.createBaseRequest(httpLibrary);
        req.setUrl("http://localhost:" + Holder.server.getPort() + "/throttling");
        req.setMethod(HttpRequestMethod.POST);
        byte[] content = new byte[10000];
        for (int i = 0; i < content.length; ++i) {
            content[i] = (byte)(97 + this.rnd.nextInt(26));
        }
        req.setContent(content);
        req.setContentType("text/plain");
        req.setThrottlingSendByte(throttlingSize);
        req.setThrottlingSendMs(throttlingMs);
        HttpResponse res = new HttpResponse();
        res.setContent("".getBytes());
        res.setResultHTTPOperation(200);
        long t0 = System.currentTimeMillis();
        this.check(req, res);
        long t1 = System.currentTimeMillis();
        long actualTime = t1 - t0;
        long expectTime = throttlingSize * throttlingMs;
        if ((double)actualTime <= 1.0 * (double)expectTime || (double)actualTime >= 1.5 * (double)expectTime) {
            throw new UtilsException();
        }
    }

    private void checkUri(String expected, String actual) throws UtilsException {
        try {
            URIBuilder expectedUri = new URIBuilder(expected);
            URIBuilder actualUri = new URIBuilder(actual);
            if (!expectedUri.build().equals(actualUri.build())) {
                throw new UtilsException();
            }
        }
        catch (URISyntaxException e) {
            throw new UtilsException(e);
        }
    }

    public void check(HttpRequest req, HttpResponse expectedResponse) throws UtilsException {
        byte[] expectedContent;
        String[] ignoreHeaders;
        HttpResponse actualResponse = HttpUtilities.httpInvoke(req);
        for (String ignoreHeader : ignoreHeaders = new String[]{"Server", "ReturnCode", "Connection", "Content-Length", "Content-Type", "Date"}) {
            if (actualResponse.getHeaderFirstValue(ignoreHeader) == null) continue;
            expectedResponse.addHeader(ignoreHeader, actualResponse.getHeaderFirstValue(ignoreHeader));
        }
        if (actualResponse.getResultHTTPOperation() != expectedResponse.getResultHTTPOperation()) {
            throw new UtilsException();
        }
        Map<String, List<String>> expectedHeaders = expectedResponse.getHeadersValues();
        Map<String, List<String>> actualHeaders = actualResponse.getHeadersValues();
        if (expectedHeaders.size() != actualHeaders.size()) {
            throw new UtilsException("numero header attesi: " + expectedHeaders.size() + ", diverso dal numero di header ottenuti: " + actualHeaders.size());
        }
        for (Map.Entry<String, List<String>> header : expectedHeaders.entrySet()) {
            if (header.getKey().equals("Location")) {
                String first = !header.getValue().isEmpty() ? header.getValue().get(0) : null;
                String actualFirst = !actualHeaders.get(header.getKey()).isEmpty() ? actualHeaders.get(header.getKey()).get(0) : null;
                this.checkUri(first, actualFirst);
                continue;
            }
            if (actualHeaders.get(header.getKey()).equals(header.getValue())) continue;
            throw new UtilsException("header: " + header.getKey() + " atteso diverso da quello ottenuto");
        }
        byte[] actualContent = actualResponse.getContent();
        if (!Arrays.areEqual((byte[])actualContent, (byte[])(expectedContent = expectedResponse.getContent()))) {
            throw new UtilsException("Il contenuto della risposta: \"" + new String(actualContent) + "\" risulta diverso da quello atteso: \"" + new String(expectedContent) + "\"");
        }
    }

    private static class Holder {
        private static HttpServerTest server = null;
        private static HttpProxyTest proxy = null;

        private Holder() {
        }
    }
}

